/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SimpleCache<K, V> {
    private final Map<K, ExpirableValue<V>> cache = new HashMap<K, ExpirableValue<V>>();
    private final long timeoutMs;

    public SimpleCache(ScheduledExecutorService scheduler, long timeoutMs, long frequencyMs) {
        this.timeoutMs = timeoutMs;
        scheduler.scheduleAtFixedRate(() -> {
            SimpleCache simpleCache = this;
            synchronized (simpleCache) {
                HashSet keys = new HashSet();
                this.cache.forEach((key, value) -> {
                    if (value.tryExpire()) {
                        keys.add(key);
                    }
                });
                this.cache.keySet().removeAll(keys);
            }
        }, frequencyMs, frequencyMs, TimeUnit.MILLISECONDS);
    }

    public synchronized V get(K key, Supplier<V> valueSupplier, Consumer<V> expireCallback) {
        ExpirableValue<V> value = this.cache.get(key);
        if (value != null) {
            value.updateDeadline();
            return value.value;
        }
        ExpirableValue<V> newValue = new ExpirableValue<V>(valueSupplier.get(), expireCallback);
        newValue.updateDeadline();
        this.cache.put(key, newValue);
        return newValue.value;
    }

    private class ExpirableValue<V> {
        private final V value;
        private final Consumer<V> expireCallback;
        private long deadlineMs;

        boolean tryExpire() {
            if (System.currentTimeMillis() >= this.deadlineMs) {
                this.expireCallback.accept(this.value);
                return true;
            }
            return false;
        }

        void updateDeadline() {
            this.deadlineMs = System.currentTimeMillis() + SimpleCache.this.timeoutMs;
        }

        public ExpirableValue(V value, Consumer<V> expireCallback) {
            this.value = value;
            this.expireCallback = expireCallback;
        }
    }
}

