/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.pendingack;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class PendingAckHandleAttributes {
    private final Attributes commitSuccessAttributes;
    private final Attributes commitFailureAttributes;
    private final Attributes abortSuccessAttributes;
    private final Attributes abortFailureAttributes;

    public PendingAckHandleAttributes(String topic, String subscription) {
        TopicName topicName = TopicName.get((String)topic);
        this.commitSuccessAttributes = PendingAckHandleAttributes.getAttributes(topicName, subscription, OpenTelemetryAttributes.TransactionStatus.COMMITTED, OpenTelemetryAttributes.TransactionPendingAckOperationStatus.SUCCESS);
        this.commitFailureAttributes = PendingAckHandleAttributes.getAttributes(topicName, subscription, OpenTelemetryAttributes.TransactionStatus.COMMITTED, OpenTelemetryAttributes.TransactionPendingAckOperationStatus.FAILURE);
        this.abortSuccessAttributes = PendingAckHandleAttributes.getAttributes(topicName, subscription, OpenTelemetryAttributes.TransactionStatus.ABORTED, OpenTelemetryAttributes.TransactionPendingAckOperationStatus.SUCCESS);
        this.abortFailureAttributes = PendingAckHandleAttributes.getAttributes(topicName, subscription, OpenTelemetryAttributes.TransactionStatus.ABORTED, OpenTelemetryAttributes.TransactionPendingAckOperationStatus.FAILURE);
    }

    private static Attributes getAttributes(TopicName topicName, String subscriptionName, OpenTelemetryAttributes.TransactionStatus txStatus, OpenTelemetryAttributes.TransactionPendingAckOperationStatus txAckStoreStatus) {
        AttributesBuilder builder = Attributes.builder().put(OpenTelemetryAttributes.PULSAR_SUBSCRIPTION_NAME, (Object)subscriptionName).put(OpenTelemetryAttributes.PULSAR_TENANT, (Object)topicName.getTenant()).put(OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)topicName.getNamespace()).put(OpenTelemetryAttributes.PULSAR_TOPIC, (Object)topicName.getPartitionedTopicName()).putAll(txStatus.attributes).putAll(txAckStoreStatus.attributes);
        if (topicName.isPartitioned()) {
            builder.put(OpenTelemetryAttributes.PULSAR_PARTITION_INDEX, topicName.getPartitionIndex());
        }
        return builder.build();
    }

    public Attributes getCommitSuccessAttributes() {
        return this.commitSuccessAttributes;
    }

    public Attributes getCommitFailureAttributes() {
        return this.commitFailureAttributes;
    }

    public Attributes getAbortSuccessAttributes() {
        return this.abortSuccessAttributes;
    }

    public Attributes getAbortFailureAttributes() {
        return this.abortFailureAttributes;
    }
}

