/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.systopic;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.service.SystemTopicTxnBufferSnapshotService;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.systopic.SystemTopicClientBase;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.naming.TopicName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionBufferSnapshotBaseSystemTopicClient<T>
extends SystemTopicClientBase<T> {
    private static final Logger log = LoggerFactory.getLogger(TransactionBufferSnapshotBaseSystemTopicClient.class);
    protected final SystemTopicTxnBufferSnapshotService<T> systemTopicTxnBufferSnapshotService;
    protected final Class<T> schemaType;

    public TransactionBufferSnapshotBaseSystemTopicClient(PulsarClient client, TopicName topicName, SystemTopicTxnBufferSnapshotService<T> systemTopicTxnBufferSnapshotService, Class<T> schemaType) {
        super(client, topicName);
        this.systemTopicTxnBufferSnapshotService = systemTopicTxnBufferSnapshotService;
        this.schemaType = schemaType;
    }

    protected void removeWriter(SystemTopicClient.Writer<T> writer) {
        this.writers.remove(writer);
        this.systemTopicTxnBufferSnapshotService.removeClient(this.topicName, this);
    }

    protected void removeReader(SystemTopicClient.Reader<T> reader) {
        this.readers.remove(reader);
        this.systemTopicTxnBufferSnapshotService.removeClient(this.topicName, this);
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Writer<T>> newWriterAsyncInternal() {
        return this.client.newProducer(Schema.AVRO(this.schemaType)).topic(this.topicName.toString()).enableBatching(false).createAsync().thenApply(producer -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new {} writer is created", (Object)this.topicName, (Object)this.schemaType.getName());
            }
            return new TransactionBufferSnapshotWriter(producer, this);
        });
    }

    @Override
    protected CompletableFuture<SystemTopicClient.Reader<T>> newReaderAsyncInternal() {
        return this.client.newReader(Schema.AVRO(this.schemaType)).topic(this.topicName.toString()).subscriptionRolePrefix("__system_reader").startMessageId(MessageId.earliest).readCompacted(true).createAsync().thenApply(reader -> {
            if (log.isDebugEnabled()) {
                log.debug("[{}] A new {} reader is created", (Object)this.topicName, (Object)this.schemaType.getName());
            }
            return new TransactionBufferSnapshotReader(reader, this);
        });
    }

    protected static class TransactionBufferSnapshotReader<T>
    implements SystemTopicClient.Reader<T> {
        private final Reader<T> reader;
        private final TransactionBufferSnapshotBaseSystemTopicClient<T> transactionBufferSnapshotBaseSystemTopicClient;

        protected TransactionBufferSnapshotReader(Reader<T> reader, TransactionBufferSnapshotBaseSystemTopicClient<T> transactionBufferSnapshotBaseSystemTopicClient) {
            this.reader = reader;
            this.transactionBufferSnapshotBaseSystemTopicClient = transactionBufferSnapshotBaseSystemTopicClient;
        }

        @Override
        public Message<T> readNext() throws PulsarClientException {
            return this.reader.readNext();
        }

        @Override
        public CompletableFuture<Message<T>> readNextAsync() {
            return this.reader.readNextAsync();
        }

        @Override
        public boolean hasMoreEvents() throws PulsarClientException {
            return this.reader.hasMessageAvailable();
        }

        @Override
        public CompletableFuture<Boolean> hasMoreEventsAsync() {
            return this.reader.hasMessageAvailableAsync();
        }

        @Override
        public void close() throws IOException {
            this.closeAsync().join();
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            this.reader.closeAsync().whenComplete((v, e) -> {
                this.transactionBufferSnapshotBaseSystemTopicClient.removeReader(this);
                if (e != null) {
                    completableFuture.completeExceptionally((Throwable)e);
                    return;
                }
                completableFuture.complete(null);
            });
            return completableFuture;
        }

        @Override
        public SystemTopicClient<T> getSystemTopic() {
            return this.transactionBufferSnapshotBaseSystemTopicClient;
        }
    }

    protected static class TransactionBufferSnapshotWriter<T>
    implements SystemTopicClient.Writer<T> {
        protected final Producer<T> producer;
        protected final TransactionBufferSnapshotBaseSystemTopicClient<T> transactionBufferSnapshotBaseSystemTopicClient;

        protected TransactionBufferSnapshotWriter(Producer<T> producer, TransactionBufferSnapshotBaseSystemTopicClient<T> transactionBufferSnapshotBaseSystemTopicClient) {
            this.producer = producer;
            this.transactionBufferSnapshotBaseSystemTopicClient = transactionBufferSnapshotBaseSystemTopicClient;
        }

        @Override
        public MessageId write(String key, T t) throws PulsarClientException {
            return this.producer.newMessage().key(key).value(t).send();
        }

        @Override
        public CompletableFuture<MessageId> writeAsync(String key, T t) {
            return this.producer.newMessage().key(key).value(t).sendAsync();
        }

        @Override
        public MessageId delete(String key, T t) throws PulsarClientException {
            return this.producer.newMessage().key(key).value(null).send();
        }

        @Override
        public CompletableFuture<MessageId> deleteAsync(String key, T t) {
            return this.producer.newMessage().key(key).value(null).sendAsync();
        }

        @Override
        public void close() throws IOException {
            this.closeAsync().join();
        }

        @Override
        public CompletableFuture<Void> closeAsync() {
            CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
            this.producer.closeAsync().whenComplete((v, e) -> {
                this.transactionBufferSnapshotBaseSystemTopicClient.removeWriter(this);
                if (e != null) {
                    completableFuture.completeExceptionally((Throwable)e);
                    return;
                }
                completableFuture.complete(null);
            });
            return completableFuture;
        }

        @Override
        public SystemTopicClient<T> getSystemTopicClient() {
            return this.transactionBufferSnapshotBaseSystemTopicClient;
        }
    }
}

