/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import io.opentelemetry.api.common.Attributes;
import org.apache.pulsar.broker.service.TopicAttributes;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class PersistentTopicAttributes
extends TopicAttributes {
    private final Attributes timeBasedQuotaAttributes;
    private final Attributes sizeBasedQuotaAttributes;
    private final Attributes compactionSuccessAttributes;
    private final Attributes compactionFailureAttributes;
    private final Attributes transactionActiveAttributes;
    private final Attributes transactionCommittedAttributes;
    private final Attributes transactionAbortedAttributes;
    private final Attributes transactionBufferClientCommitSucceededAttributes;
    private final Attributes transactionBufferClientCommitFailedAttributes;
    private final Attributes transactionBufferClientAbortSucceededAttributes;
    private final Attributes transactionBufferClientAbortFailedAttributes;

    public PersistentTopicAttributes(TopicName topicName) {
        super(topicName);
        this.timeBasedQuotaAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.BacklogQuotaType.TIME.attributes).build();
        this.sizeBasedQuotaAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.BacklogQuotaType.SIZE.attributes).build();
        this.transactionActiveAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.ACTIVE.attributes).build();
        this.transactionCommittedAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.COMMITTED.attributes).build();
        this.transactionAbortedAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.TransactionStatus.ABORTED.attributes).build();
        this.transactionBufferClientCommitSucceededAttributes = Attributes.builder().putAll(this.commonAttributes).remove(OpenTelemetryAttributes.PULSAR_DOMAIN).putAll(OpenTelemetryAttributes.TransactionStatus.COMMITTED.attributes).putAll(OpenTelemetryAttributes.TransactionBufferClientOperationStatus.SUCCESS.attributes).build();
        this.transactionBufferClientCommitFailedAttributes = Attributes.builder().putAll(this.commonAttributes).remove(OpenTelemetryAttributes.PULSAR_DOMAIN).putAll(OpenTelemetryAttributes.TransactionStatus.COMMITTED.attributes).putAll(OpenTelemetryAttributes.TransactionBufferClientOperationStatus.FAILURE.attributes).build();
        this.transactionBufferClientAbortSucceededAttributes = Attributes.builder().putAll(this.commonAttributes).remove(OpenTelemetryAttributes.PULSAR_DOMAIN).putAll(OpenTelemetryAttributes.TransactionStatus.ABORTED.attributes).putAll(OpenTelemetryAttributes.TransactionBufferClientOperationStatus.SUCCESS.attributes).build();
        this.transactionBufferClientAbortFailedAttributes = Attributes.builder().putAll(this.commonAttributes).remove(OpenTelemetryAttributes.PULSAR_DOMAIN).putAll(OpenTelemetryAttributes.TransactionStatus.ABORTED.attributes).putAll(OpenTelemetryAttributes.TransactionBufferClientOperationStatus.FAILURE.attributes).build();
        this.compactionSuccessAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.CompactionStatus.SUCCESS.attributes).build();
        this.compactionFailureAttributes = Attributes.builder().putAll(this.commonAttributes).putAll(OpenTelemetryAttributes.CompactionStatus.FAILURE.attributes).build();
    }

    public Attributes getTimeBasedQuotaAttributes() {
        return this.timeBasedQuotaAttributes;
    }

    public Attributes getSizeBasedQuotaAttributes() {
        return this.sizeBasedQuotaAttributes;
    }

    public Attributes getCompactionSuccessAttributes() {
        return this.compactionSuccessAttributes;
    }

    public Attributes getCompactionFailureAttributes() {
        return this.compactionFailureAttributes;
    }

    public Attributes getTransactionActiveAttributes() {
        return this.transactionActiveAttributes;
    }

    public Attributes getTransactionCommittedAttributes() {
        return this.transactionCommittedAttributes;
    }

    public Attributes getTransactionAbortedAttributes() {
        return this.transactionAbortedAttributes;
    }

    public Attributes getTransactionBufferClientCommitSucceededAttributes() {
        return this.transactionBufferClientCommitSucceededAttributes;
    }

    public Attributes getTransactionBufferClientCommitFailedAttributes() {
        return this.transactionBufferClientCommitFailedAttributes;
    }

    public Attributes getTransactionBufferClientAbortSucceededAttributes() {
        return this.transactionBufferClientAbortSucceededAttributes;
    }

    public Attributes getTransactionBufferClientAbortFailedAttributes() {
        return this.transactionBufferClientAbortFailedAttributes;
    }
}

