/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.namespace;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LookupOptions {
    private final boolean authoritative;
    private final boolean readOnly;
    private final boolean loadTopicsInBundle;
    private final boolean requestHttps;
    private final String advertisedListenerName;
    private final Map<String, String> properties;

    public boolean hasAdvertisedListenerName() {
        return StringUtils.isNotBlank((CharSequence)this.advertisedListenerName);
    }

    LookupOptions(boolean authoritative, boolean readOnly, boolean loadTopicsInBundle, boolean requestHttps, String advertisedListenerName, Map<String, String> properties) {
        this.authoritative = authoritative;
        this.readOnly = readOnly;
        this.loadTopicsInBundle = loadTopicsInBundle;
        this.requestHttps = requestHttps;
        this.advertisedListenerName = advertisedListenerName;
        this.properties = properties;
    }

    public static LookupOptionsBuilder builder() {
        return new LookupOptionsBuilder();
    }

    public boolean isAuthoritative() {
        return this.authoritative;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isLoadTopicsInBundle() {
        return this.loadTopicsInBundle;
    }

    public boolean isRequestHttps() {
        return this.requestHttps;
    }

    public String getAdvertisedListenerName() {
        return this.advertisedListenerName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookupOptions)) {
            return false;
        }
        LookupOptions other = (LookupOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAuthoritative() != other.isAuthoritative()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        if (this.isLoadTopicsInBundle() != other.isLoadTopicsInBundle()) {
            return false;
        }
        if (this.isRequestHttps() != other.isRequestHttps()) {
            return false;
        }
        String this$advertisedListenerName = this.getAdvertisedListenerName();
        String other$advertisedListenerName = other.getAdvertisedListenerName();
        if (this$advertisedListenerName == null ? other$advertisedListenerName != null : !this$advertisedListenerName.equals(other$advertisedListenerName)) {
            return false;
        }
        Map<String, String> this$properties = this.getProperties();
        Map<String, String> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LookupOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAuthoritative() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        result = result * 59 + (this.isLoadTopicsInBundle() ? 79 : 97);
        result = result * 59 + (this.isRequestHttps() ? 79 : 97);
        String $advertisedListenerName = this.getAdvertisedListenerName();
        result = result * 59 + ($advertisedListenerName == null ? 43 : $advertisedListenerName.hashCode());
        Map<String, String> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "LookupOptions(authoritative=" + this.isAuthoritative() + ", readOnly=" + this.isReadOnly() + ", loadTopicsInBundle=" + this.isLoadTopicsInBundle() + ", requestHttps=" + this.isRequestHttps() + ", advertisedListenerName=" + this.getAdvertisedListenerName() + ", properties=" + String.valueOf(this.getProperties()) + ")";
    }

    public static class LookupOptionsBuilder {
        private boolean authoritative;
        private boolean readOnly;
        private boolean loadTopicsInBundle;
        private boolean requestHttps;
        private String advertisedListenerName;
        private Map<String, String> properties;

        LookupOptionsBuilder() {
        }

        public LookupOptionsBuilder authoritative(boolean authoritative) {
            this.authoritative = authoritative;
            return this;
        }

        public LookupOptionsBuilder readOnly(boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public LookupOptionsBuilder loadTopicsInBundle(boolean loadTopicsInBundle) {
            this.loadTopicsInBundle = loadTopicsInBundle;
            return this;
        }

        public LookupOptionsBuilder requestHttps(boolean requestHttps) {
            this.requestHttps = requestHttps;
            return this;
        }

        public LookupOptionsBuilder advertisedListenerName(String advertisedListenerName) {
            this.advertisedListenerName = advertisedListenerName;
            return this;
        }

        public LookupOptionsBuilder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public LookupOptions build() {
            return new LookupOptions(this.authoritative, this.readOnly, this.loadTopicsInBundle, this.requestHttps, this.advertisedListenerName, this.properties);
        }

        public String toString() {
            return "LookupOptions.LookupOptionsBuilder(authoritative=" + this.authoritative + ", readOnly=" + this.readOnly + ", loadTopicsInBundle=" + this.loadTopicsInBundle + ", requestHttps=" + this.requestHttps + ", advertisedListenerName=" + this.advertisedListenerName + ", properties=" + String.valueOf(this.properties) + ")";
        }
    }
}

