/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import com.google.protobuf.InvalidProtocolBufferException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.constraints.NotNull;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.mledger.impl.LedgerMetadataUtils;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.bucket.BucketNotExistException;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotPersistenceException;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotSerializationException;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.proto.SnapshotMetadata;
import org.apache.pulsar.broker.delayed.proto.SnapshotSegment;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookkeeperBucketSnapshotStorage
implements BucketSnapshotStorage {
    private static final Logger log = LoggerFactory.getLogger(BookkeeperBucketSnapshotStorage.class);
    private static final byte[] LedgerPassword = "".getBytes();
    private final PulsarService pulsar;
    private final ServiceConfiguration config;
    private BookKeeper bookKeeper;
    private final Map<Long, CompletableFuture<LedgerHandle>> ledgerHandleFutureCache = new ConcurrentHashMap<Long, CompletableFuture<LedgerHandle>>();

    public BookkeeperBucketSnapshotStorage(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.config = pulsar.getConfig();
    }

    @Override
    public CompletableFuture<Long> createBucketSnapshot(SnapshotMetadata snapshotMetadata, List<SnapshotSegment> bucketSnapshotSegments, String bucketKey, String topicName, String cursorName) {
        ByteBuf metadataByteBuf = Unpooled.wrappedBuffer((byte[])snapshotMetadata.toByteArray());
        return this.createLedger(bucketKey, topicName, cursorName).thenCompose(ledgerHandle -> ((CompletableFuture)((CompletableFuture)this.addEntry((LedgerHandle)ledgerHandle, metadataByteBuf).thenCompose(__ -> this.addSnapshotSegments((LedgerHandle)ledgerHandle, bucketSnapshotSegments))).thenCompose(__ -> this.closeLedger((LedgerHandle)ledgerHandle))).thenApply(__ -> ledgerHandle.getId()));
    }

    @Override
    public CompletableFuture<SnapshotMetadata> getBucketSnapshotMetadata(long bucketId) {
        return this.getLedgerHandle(bucketId).thenCompose(ledgerHandle -> this.getLedgerEntry((LedgerHandle)ledgerHandle, 0L, 0L).thenApply(entryEnumeration -> this.parseSnapshotMetadataEntry((LedgerEntry)entryEnumeration.nextElement())));
    }

    @Override
    public CompletableFuture<List<SnapshotSegment>> getBucketSnapshotSegment(long bucketId, long firstSegmentEntryId, long lastSegmentEntryId) {
        return this.getLedgerHandle(bucketId).thenCompose(ledgerHandle -> this.getLedgerEntry((LedgerHandle)ledgerHandle, firstSegmentEntryId, lastSegmentEntryId).thenApply(this::parseSnapshotSegmentEntries));
    }

    @Override
    public CompletableFuture<Long> getBucketSnapshotLength(long bucketId) {
        return this.getLedgerHandle(bucketId).thenCompose(ledgerHandle -> CompletableFuture.completedFuture(ledgerHandle.getLength()));
    }

    @Override
    public CompletableFuture<Void> deleteBucketSnapshot(long bucketId) {
        CompletableFuture<LedgerHandle> ledgerHandleFuture = this.ledgerHandleFutureCache.remove(bucketId);
        if (ledgerHandleFuture != null) {
            ledgerHandleFuture.whenComplete((lh, ex) -> this.closeLedger((LedgerHandle)lh));
        }
        return this.deleteLedger(bucketId);
    }

    @Override
    public void start() throws Exception {
        this.bookKeeper = this.pulsar.getBookKeeperClientFactory().create(this.pulsar.getConfiguration(), this.pulsar.getLocalMetadataStore(), this.pulsar.getIoEventLoopGroup(), Optional.empty(), null).get();
    }

    @Override
    public void close() throws Exception {
        if (this.bookKeeper != null) {
            this.bookKeeper.close();
        }
    }

    private CompletableFuture<Void> addSnapshotSegments(LedgerHandle ledgerHandle, List<SnapshotSegment> bucketSnapshotSegments) {
        ArrayList<CompletableFuture<Void>> addFutures = new ArrayList<CompletableFuture<Void>>();
        for (SnapshotSegment bucketSnapshotSegment : bucketSnapshotSegments) {
            ByteBuf byteBuf = PulsarByteBufAllocator.DEFAULT.directBuffer(bucketSnapshotSegment.getSerializedSize());
            try {
                bucketSnapshotSegment.writeTo(byteBuf);
            }
            catch (Exception e) {
                byteBuf.release();
                throw e;
            }
            addFutures.add(this.addEntry(ledgerHandle, byteBuf));
        }
        return FutureUtil.waitForAll(addFutures);
    }

    private SnapshotMetadata parseSnapshotMetadataEntry(LedgerEntry ledgerEntry) {
        ByteBuf entryBuffer = null;
        try {
            entryBuffer = ledgerEntry.getEntryBuffer();
            SnapshotMetadata snapshotMetadata = SnapshotMetadata.parseFrom(entryBuffer.nioBuffer());
            return snapshotMetadata;
        }
        catch (InvalidProtocolBufferException e) {
            throw new BucketSnapshotSerializationException(e);
        }
        finally {
            if (entryBuffer != null) {
                entryBuffer.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SnapshotSegment> parseSnapshotSegmentEntries(Enumeration<LedgerEntry> entryEnumeration) {
        ArrayList<SnapshotSegment> snapshotMetadataList = new ArrayList<SnapshotSegment>();
        while (entryEnumeration.hasMoreElements()) {
            LedgerEntry ledgerEntry = entryEnumeration.nextElement();
            SnapshotSegment snapshotSegment = new SnapshotSegment();
            ByteBuf entryBuffer = ledgerEntry.getEntryBuffer();
            try {
                snapshotSegment.parseFrom(entryBuffer, entryBuffer.readableBytes());
            }
            finally {
                entryBuffer.release();
            }
            snapshotMetadataList.add(snapshotSegment);
        }
        return snapshotMetadataList;
    }

    @NotNull
    private CompletableFuture<LedgerHandle> createLedger(String bucketKey, String topicName, String cursorName) {
        CompletableFuture<LedgerHandle> future = new CompletableFuture<LedgerHandle>();
        Map metadata = LedgerMetadataUtils.buildMetadataForDelayedIndexBucket((String)bucketKey, (String)topicName, (String)cursorName);
        this.bookKeeper.asyncCreateLedger(this.config.getManagedLedgerDefaultEnsembleSize(), this.config.getManagedLedgerDefaultWriteQuorum(), this.config.getManagedLedgerDefaultAckQuorum(), BookKeeper.DigestType.fromApiDigestType((DigestType)this.config.getManagedLedgerDigestType()), LedgerPassword, (rc, handle, ctx) -> {
            if (rc != 0) {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Create ledger", rc, -1L));
            } else {
                future.complete(handle);
            }
        }, null, metadata);
        return future;
    }

    private CompletableFuture<LedgerHandle> getLedgerHandle(Long ledgerId) {
        CompletableFuture ledgerHandleCompletableFuture = this.ledgerHandleFutureCache.computeIfAbsent(ledgerId, k -> this.openLedger(ledgerId));
        ledgerHandleCompletableFuture.whenComplete((__, ex) -> {
            if (ex != null) {
                this.ledgerHandleFutureCache.remove(ledgerId, ledgerHandleCompletableFuture);
            }
        });
        return ledgerHandleCompletableFuture;
    }

    private CompletableFuture<LedgerHandle> openLedger(Long ledgerId) {
        CompletableFuture<LedgerHandle> future = new CompletableFuture<LedgerHandle>();
        this.bookKeeper.asyncOpenLedger(ledgerId.longValue(), BookKeeper.DigestType.fromApiDigestType((DigestType)this.config.getManagedLedgerDigestType()), LedgerPassword, (rc, handle, ctx) -> {
            if (rc == -7) {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.noSuchLedgerException("Open ledger", ledgerId));
            } else if (rc != 0) {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Open ledger", rc, ledgerId));
            } else {
                future.complete(handle);
            }
        }, null);
        return future;
    }

    private CompletableFuture<Void> closeLedger(LedgerHandle ledgerHandle) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        ledgerHandle.asyncClose((rc, handle, ctx) -> {
            if (rc != 0) {
                log.warn("Failed to close a Ledger Handle: {}", (Object)ledgerHandle.getId());
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Close ledger", rc, ledgerHandle.getId()));
            } else {
                future.complete(null);
            }
        }, null);
        return future;
    }

    private CompletableFuture<Void> addEntry(LedgerHandle ledgerHandle, ByteBuf data) {
        CompletableFuture future = new CompletableFuture();
        ledgerHandle.asyncAddEntry(data, (rc, handle, entryId, ctx) -> {
            if (rc != 0) {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Add entry", rc, ledgerHandle.getId()));
            } else {
                future.complete(null);
            }
        }, null);
        return future.whenComplete((__, ex) -> {
            if (ex != null) {
                this.deleteLedger(ledgerHandle.getId());
            }
        });
    }

    CompletableFuture<Enumeration<LedgerEntry>> getLedgerEntry(LedgerHandle ledger, long firstEntryId, long lastEntryId) {
        CompletableFuture<Enumeration<LedgerEntry>> future = new CompletableFuture<Enumeration<LedgerEntry>>();
        ledger.asyncReadEntries(firstEntryId, lastEntryId, (rc, handle, entries, ctx) -> {
            if (rc != 0) {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Read entry", rc, ledger.getId()));
            } else {
                future.complete(entries);
            }
        }, null);
        return future;
    }

    private CompletableFuture<Void> deleteLedger(long ledgerId) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.bookKeeper.asyncDeleteLedger(ledgerId, (rc, cnx) -> {
            if (rc == -7 || rc == 0) {
                future.complete(null);
            } else {
                future.completeExceptionally(BookkeeperBucketSnapshotStorage.bkException("Delete ledger", rc, ledgerId));
            }
        }, null);
        return future;
    }

    private static BucketSnapshotPersistenceException bkException(String operation, int rc, long ledgerId) {
        String message = BKException.getMessage((int)rc) + " -  ledger=" + ledgerId + " - operation=" + operation;
        return new BucketSnapshotPersistenceException(message);
    }

    private static BucketNotExistException noSuchLedgerException(String operation, long ledgerId) {
        String message = BKException.getMessage((int)-7) + " - ledger=" + ledgerId + " - operation=" + operation;
        return new BucketNotExistException(message);
    }
}

