/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authorization;

import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationParameters;
import org.apache.pulsar.broker.authorization.AuthorizationProvider;
import org.apache.pulsar.broker.resources.PulsarResources;
import org.apache.pulsar.client.admin.GrantTopicPermissionOptions;
import org.apache.pulsar.client.admin.RevokeTopicPermissionOptions;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BrokerOperation;
import org.apache.pulsar.common.policies.data.NamespaceOperation;
import org.apache.pulsar.common.policies.data.PolicyName;
import org.apache.pulsar.common.policies.data.PolicyOperation;
import org.apache.pulsar.common.policies.data.TenantInfo;
import org.apache.pulsar.common.policies.data.TenantOperation;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.util.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationService {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationService.class);
    private final PulsarResources resources;
    private final AuthorizationProvider provider;
    private final ServiceConfiguration conf;

    public AuthorizationService(ServiceConfiguration conf, PulsarResources pulsarResources) throws PulsarServerException {
        this.conf = conf;
        try {
            String providerClassname = conf.getAuthorizationProvider();
            if (!StringUtils.isNotBlank((CharSequence)providerClassname)) {
                throw new PulsarServerException("No authorization providers are present.");
            }
            this.provider = (AuthorizationProvider)Class.forName(providerClassname).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.provider.initialize(conf, pulsarResources);
            this.resources = pulsarResources;
            log.info("{} has been loaded.", (Object)providerClassname);
        }
        catch (PulsarServerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PulsarServerException("Failed to load an authorization provider.", e);
        }
    }

    public CompletableFuture<Boolean> isSuperUser(AuthenticationParameters authParams) {
        if (!this.isValidOriginalPrincipal(authParams)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(authParams.getClientRole())) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.isSuperUser(authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.isSuperUser(authParams.getOriginalPrincipal(), authParams.getClientAuthenticationDataSource());
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.isSuperUser(authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
    }

    public CompletableFuture<Boolean> isSuperUser(String user, AuthenticationDataSource authenticationData) {
        return this.provider.isSuperUser(user, authenticationData, this.conf);
    }

    public CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, TenantInfo tenantInfo, AuthenticationDataSource authenticationData) {
        return this.provider.isTenantAdmin(tenant, role, tenantInfo, authenticationData);
    }

    public CompletableFuture<Void> grantPermissionAsync(NamespaceName namespace, Set<AuthAction> actions, String role, String authDataJson) {
        return this.provider.grantPermissionAsync(namespace, actions, role, authDataJson);
    }

    public CompletableFuture<Void> revokePermissionAsync(NamespaceName namespace, String role) {
        return this.provider.revokePermissionAsync(namespace, role);
    }

    public CompletableFuture<Void> grantSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, Set<String> roles, String authDataJson) {
        return this.provider.grantSubscriptionPermissionAsync(namespace, subscriptionName, roles, authDataJson);
    }

    public CompletableFuture<Void> revokeSubscriptionPermissionAsync(NamespaceName namespace, String subscriptionName, String role, String authDataJson) {
        return this.provider.revokeSubscriptionPermissionAsync(namespace, subscriptionName, role, authDataJson);
    }

    public CompletableFuture<Void> grantPermissionAsync(TopicName topicName, Set<AuthAction> actions, String role, String authDataJson) {
        return this.provider.grantPermissionAsync(topicName, actions, role, authDataJson);
    }

    public CompletableFuture<Void> grantPermissionAsync(List<GrantTopicPermissionOptions> options) {
        return this.provider.grantPermissionAsync(options);
    }

    public CompletableFuture<Void> revokePermissionAsync(List<RevokeTopicPermissionOptions> options) {
        return this.provider.revokePermissionAsync(options);
    }

    public CompletableFuture<Void> revokePermissionAsync(TopicName topicName, String role) {
        return this.provider.revokePermissionAsync(topicName, role);
    }

    public CompletableFuture<Boolean> canProduceAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canProduceAsync(topicName, role, authenticationData);
        });
    }

    public CompletableFuture<Boolean> canConsumeAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canConsumeAsync(topicName, role, authenticationData, subscription);
        });
    }

    public boolean canProduce(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canProduceAsync(topicName, role, authenticationData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Producer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canConsume(TopicName topicName, String role, AuthenticationDataSource authenticationData, String subscription) throws Exception {
        try {
            return this.canConsumeAsync(topicName, role, authenticationData, subscription).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Consumer-client  with Role - {} failed to get permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public boolean canLookup(TopicName topicName, String role, AuthenticationDataSource authenticationData) throws Exception {
        try {
            return this.canLookupAsync(topicName, role, authenticationData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.warn("Time-out {} sec while checking authorization on {} ", (Object)this.conf.getMetadataStoreOperationTimeoutSeconds(), (Object)topicName);
            throw e;
        }
        catch (Exception e) {
            log.warn("Role - {} failed to get lookup permissions for topic - {}. {}", new Object[]{role, topicName, e.getMessage()});
            throw e;
        }
    }

    public CompletableFuture<Boolean> canLookupAsync(TopicName topicName, String role, AuthenticationDataSource authenticationData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.isSuperUser(role, authenticationData, this.conf).thenComposeAsync(isSuperUser -> {
            if (isSuperUser.booleanValue()) {
                return CompletableFuture.completedFuture(true);
            }
            return this.provider.canLookupAsync(topicName, role, authenticationData);
        });
    }

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.isSuperUserOrAdmin(namespaceName, role, authenticationData).thenCompose(isSuperUserOrAdmin -> isSuperUserOrAdmin != false ? CompletableFuture.completedFuture(true) : this.provider.allowFunctionOpsAsync(namespaceName, role, authenticationData));
    }

    public CompletableFuture<Boolean> allowFunctionOpsAsync(NamespaceName namespaceName, AuthenticationParameters authParams) {
        if (!this.isValidOriginalPrincipal(authParams)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(authParams.getClientRole())) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowFunctionOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowFunctionOpsAsync(namespaceName, authParams.getOriginalPrincipal(), authParams.getClientAuthenticationDataSource());
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowFunctionOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
    }

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.isSuperUserOrAdmin(namespaceName, role, authenticationData).thenCompose(isSuperUserOrAdmin -> isSuperUserOrAdmin != false ? CompletableFuture.completedFuture(true) : this.provider.allowSourceOpsAsync(namespaceName, role, authenticationData));
    }

    public CompletableFuture<Boolean> allowSourceOpsAsync(NamespaceName namespaceName, AuthenticationParameters authParams) {
        if (!this.isValidOriginalPrincipal(authParams)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(authParams.getClientRole())) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowSourceOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowSourceOpsAsync(namespaceName, authParams.getOriginalPrincipal(), authParams.getClientAuthenticationDataSource());
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowSourceOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
    }

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.isSuperUserOrAdmin(namespaceName, role, authenticationData).thenCompose(isSuperUserOrAdmin -> isSuperUserOrAdmin != false ? CompletableFuture.completedFuture(true) : this.provider.allowSinkOpsAsync(namespaceName, role, authenticationData));
    }

    public CompletableFuture<Boolean> allowSinkOpsAsync(NamespaceName namespaceName, AuthenticationParameters authParams) {
        if (!this.isValidOriginalPrincipal(authParams)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(authParams.getClientRole())) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowSinkOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowSinkOpsAsync(namespaceName, authParams.getOriginalPrincipal(), authParams.getClientAuthenticationDataSource());
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowSinkOpsAsync(namespaceName, authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
    }

    private CompletableFuture<Boolean> isSuperUserOrAdmin(NamespaceName namespaceName, String role, AuthenticationDataSource authenticationData) {
        return this.isSuperUser(role, authenticationData).thenCompose(isSuperUserOrAdmin -> isSuperUserOrAdmin != false ? CompletableFuture.completedFuture(true) : this.isTenantAdmin(namespaceName.getTenant(), role, authenticationData));
    }

    private CompletableFuture<Boolean> isTenantAdmin(String tenant, String role, AuthenticationDataSource authData) {
        return this.resources.getTenantResources().getTenantAsync(tenant).thenCompose(op -> {
            if (op.isPresent()) {
                return this.isTenantAdmin(tenant, role, (TenantInfo)op.get(), authData);
            }
            return CompletableFuture.failedFuture((Throwable)new RestException(Response.Status.NOT_FOUND, "Tenant does not exist"));
        });
    }

    private boolean isValidOriginalPrincipal(AuthenticationParameters authParams) {
        return this.isValidOriginalPrincipal(authParams.getClientRole(), authParams.getOriginalPrincipal(), authParams.getClientAuthenticationDataSource());
    }

    public boolean isValidOriginalPrincipal(String authenticatedPrincipal, String originalPrincipal, AuthenticationDataSource authDataSource) {
        SocketAddress remoteAddress = authDataSource != null ? authDataSource.getPeerAddress() : null;
        return this.isValidOriginalPrincipal(authenticatedPrincipal, originalPrincipal, remoteAddress, true);
    }

    public boolean isValidOriginalPrincipal(String authenticatedPrincipal, String originalPrincipal, SocketAddress remoteAddress, boolean allowNonProxyPrincipalsToBeEqual) {
        String errorMsg = null;
        if (this.conf.getProxyRoles().contains(authenticatedPrincipal)) {
            if (StringUtils.isBlank((CharSequence)originalPrincipal)) {
                errorMsg = "originalPrincipal must be provided when connecting with a proxy role.";
            } else if (this.conf.getProxyRoles().contains(originalPrincipal)) {
                errorMsg = "originalPrincipal cannot be a proxy role.";
            }
        } else if (!(!StringUtils.isNotBlank((CharSequence)originalPrincipal) || allowNonProxyPrincipalsToBeEqual && originalPrincipal.equals(authenticatedPrincipal))) {
            errorMsg = "cannot specify originalPrincipal when connecting without valid proxy role.";
        }
        if (errorMsg != null) {
            log.warn("[{}] Illegal combination of role [{}] and originalPrincipal [{}]: {}", new Object[]{remoteAddress, authenticatedPrincipal, originalPrincipal, errorMsg});
            return false;
        }
        return true;
    }

    public boolean isProxyRole(String role) {
        return role != null && this.conf.getProxyRoles().contains(role);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowTenantOperationAsync(tenantName, role, operation, authData);
    }

    public CompletableFuture<Boolean> allowTenantOperationAsync(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTenantOperationAsync(tenantName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTenantOperationAsync(tenantName, operation, role, authData);
    }

    public CompletableFuture<Boolean> allowBrokerOperationAsync(String clusterName, String brokerId, BrokerOperation brokerOperation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.provider.allowBrokerOperationAsync(clusterName, brokerId, brokerOperation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.provider.allowBrokerOperationAsync(clusterName, brokerId, brokerOperation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.provider.allowBrokerOperationAsync(clusterName, brokerId, brokerOperation, role, authData);
    }

    @Deprecated
    public boolean allowTenantOperation(String tenantName, TenantOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTenantOperationAsync(tenantName, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowNamespaceOperationAsync(namespaceName, role, operation, authData);
    }

    public CompletableFuture<Boolean> allowNamespaceOperationAsync(NamespaceName namespaceName, NamespaceOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespaceOperationAsync(namespaceName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespaceOperationAsync(namespaceName, operation, role, authData);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
    }

    public CompletableFuture<Boolean> allowNamespacePolicyOperationAsync(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, role, authData);
    }

    @Deprecated
    public boolean allowNamespacePolicyOperation(NamespaceName namespaceName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowNamespacePolicyOperationAsync(namespaceName, policy, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, PolicyName policy, PolicyOperation operation, String role, AuthenticationDataSource authData) {
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.provider.allowTopicPolicyOperationAsync(topicName, role, policy, operation, authData);
    }

    public CompletableFuture<Boolean> allowTopicPolicyOperationAsync(TopicName topicName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTopicPolicyOperationAsync(topicName, policy, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTopicPolicyOperationAsync(topicName, policy, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTopicPolicyOperationAsync(topicName, policy, operation, role, authData);
    }

    @Deprecated
    public Boolean allowTopicPolicyOperation(TopicName topicName, PolicyName policy, PolicyOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTopicPolicyOperationAsync(topicName, policy, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, String role, AuthenticationDataSource authData) {
        if (log.isDebugEnabled()) {
            log.debug("Check if role {} is allowed to execute topic operation {} on topic {}", new Object[]{role, operation, topicName});
        }
        if (!this.conf.isAuthorizationEnabled()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> allowFuture = this.provider.allowTopicOperationAsync(topicName, role, operation, authData);
        if (log.isDebugEnabled()) {
            return allowFuture.whenComplete((allowed, exception) -> {
                if (exception == null) {
                    if (allowed.booleanValue()) {
                        log.debug("Topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role});
                    } else {
                        log.debug("Topic operation {} on topic {} is NOT allowed: role = {}", new Object[]{operation, topicName, role});
                    }
                } else {
                    log.debug("Failed to check if topic operation {} on topic {} is allowed: role = {}", new Object[]{operation, topicName, role, exception});
                }
            });
        }
        return allowFuture;
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, AuthenticationParameters authParams) {
        return this.allowTopicOperationAsync(topicName, operation, authParams.getOriginalPrincipal(), authParams.getClientRole(), authParams.getClientAuthenticationDataSource());
    }

    public CompletableFuture<Boolean> allowTopicOperationAsync(TopicName topicName, TopicOperation operation, String originalRole, String role, AuthenticationDataSource authData) {
        if (!this.isValidOriginalPrincipal(role, originalRole, authData)) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.isProxyRole(role)) {
            CompletableFuture<Boolean> isRoleAuthorizedFuture = this.allowTopicOperationAsync(topicName, operation, role, authData);
            CompletableFuture<Boolean> isOriginalAuthorizedFuture = this.allowTopicOperationAsync(topicName, operation, originalRole, authData);
            return isRoleAuthorizedFuture.thenCombine(isOriginalAuthorizedFuture, (isRoleAuthorized, isOriginalAuthorized) -> isRoleAuthorized != false && isOriginalAuthorized != false);
        }
        return this.allowTopicOperationAsync(topicName, operation, role, authData);
    }

    @Deprecated
    public Boolean allowTopicOperation(TopicName topicName, TopicOperation operation, String originalRole, String role, AuthenticationDataSource authData) throws Exception {
        try {
            return this.allowTopicOperationAsync(topicName, operation, originalRole, role, authData).get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RestException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new RestException(e.getCause());
        }
    }

    public CompletableFuture<Void> removePermissionsAsync(TopicName topicName) {
        return this.provider.removePermissionsAsync(topicName);
    }

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(TopicName topicName) {
        return this.provider.getPermissionsAsync(topicName);
    }

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(NamespaceName namespaceName) {
        return this.provider.getPermissionsAsync(namespaceName);
    }

    public CompletableFuture<Map<String, Set<String>>> getSubscriptionPermissionsAsync(NamespaceName namespaceName) {
        return this.provider.getSubscriptionPermissionsAsync(namespaceName);
    }
}

