/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.net.SocketAddress;
import java.security.cert.Certificate;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationDataSubscription
implements AuthenticationDataSource {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationDataSubscription.class);
    private final AuthenticationDataSource authData;
    private final String subscription;

    public AuthenticationDataSubscription(AuthenticationDataSource authData, String subscription) {
        this.authData = authData;
        this.subscription = subscription;
    }

    @Override
    public boolean hasDataFromCommand() {
        return this.authData.hasDataFromCommand();
    }

    @Override
    public String getCommandData() {
        return this.authData.getCommandData();
    }

    @Override
    public boolean hasDataFromPeer() {
        return this.authData.hasDataFromPeer();
    }

    @Override
    public SocketAddress getPeerAddress() {
        return this.authData.getPeerAddress();
    }

    @Override
    public boolean hasDataFromTls() {
        return this.authData.hasDataFromTls();
    }

    @Override
    public Certificate[] getTlsCertificates() {
        return this.authData.getTlsCertificates();
    }

    @Override
    public boolean hasSubscription() {
        return this.subscription != null;
    }

    @Override
    public String getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean hasDataFromHttp() {
        return this.authData.hasDataFromHttp();
    }

    @Override
    public String getHttpAuthType() {
        return this.authData.getHttpAuthType();
    }

    @Override
    public String getHttpHeader(String name) {
        return this.authData.getHttpHeader(name);
    }

    public AuthenticationDataSource getAuthData() {
        return this.authData;
    }
}

