/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.allocator;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorBuilder;
import org.apache.bookkeeper.common.allocator.LeakDetectionPolicy;
import org.apache.bookkeeper.common.allocator.OutOfMemoryPolicy;
import org.apache.bookkeeper.common.allocator.PoolingPolicy;
import org.apache.pulsar.common.util.ShutdownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PulsarByteBufAllocator {
    private static final Logger log = LoggerFactory.getLogger(PulsarByteBufAllocator.class);
    public static final String PULSAR_ALLOCATOR_POOLED = "pulsar.allocator.pooled";
    public static final String PULSAR_ALLOCATOR_EXIT_ON_OOM = "pulsar.allocator.exit_on_oom";
    public static final String PULSAR_ALLOCATOR_LEAK_DETECTION = "pulsar.allocator.leak_detection";
    public static final String PULSAR_ALLOCATOR_OUT_OF_MEMORY_POLICY = "pulsar.allocator.out_of_memory_policy";
    private static final String[] LEAK_DETECTION_PROPERTY_NAMES = new String[]{"pulsar.allocator.leak_detection", "io.netty.leakDetection.level", "io.netty.leakDetectionLevel"};
    public static final ByteBufAllocator DEFAULT;
    private static final List<Consumer<OutOfMemoryError>> LISTENERS;

    public static void registerOOMListener(Consumer<OutOfMemoryError> listener) {
        LISTENERS.add(listener);
    }

    @VisibleForTesting
    static ByteBufAllocator createByteBufAllocator() {
        boolean isPooled = "true".equalsIgnoreCase(System.getProperty(PULSAR_ALLOCATOR_POOLED, "true"));
        boolean isExitOnOutOfMemory = "true".equalsIgnoreCase(System.getProperty(PULSAR_ALLOCATOR_EXIT_ON_OOM, "false"));
        OutOfMemoryPolicy outOfMemoryPolicy = OutOfMemoryPolicy.valueOf((String)System.getProperty(PULSAR_ALLOCATOR_OUT_OF_MEMORY_POLICY, "FallbackToHeap"));
        LeakDetectionPolicy leakDetectionPolicy = PulsarByteBufAllocator.resolveLeakDetectionPolicyWithHighestLevel(System::getProperty);
        if (log.isDebugEnabled()) {
            log.debug("Is Pooled: {} -- Exit on OOM: {}", (Object)isPooled, (Object)isExitOnOutOfMemory);
        }
        ByteBufAllocatorBuilder builder = ByteBufAllocatorBuilder.create().leakDetectionPolicy(leakDetectionPolicy).pooledAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT).outOfMemoryListener(oomException -> {
            LISTENERS.forEach(c -> {
                try {
                    c.accept(oomException);
                }
                catch (Throwable t) {
                    log.warn("Exception during OOM listener: {}", (Object)t.getMessage(), (Object)t);
                }
            });
            if (isExitOnOutOfMemory) {
                log.info("Exiting JVM process for OOM error: {}", (Object)oomException.getMessage(), oomException);
                ShutdownUtil.triggerImmediateForcefulShutdown();
            }
        });
        if (isPooled) {
            builder.poolingPolicy(PoolingPolicy.PooledDirect);
        } else {
            builder.poolingPolicy(PoolingPolicy.UnpooledHeap);
        }
        builder.outOfMemoryPolicy(outOfMemoryPolicy);
        return builder.build();
    }

    @VisibleForTesting
    static LeakDetectionPolicy resolveLeakDetectionPolicyWithHighestLevel(Function<String, String> propertyResolver) {
        return Arrays.stream(LEAK_DETECTION_PROPERTY_NAMES).map(propertyResolver).filter(Objects::nonNull).map(LeakDetectionPolicy::parseLevel).max(Comparator.comparingInt(Enum::ordinal)).orElse(LeakDetectionPolicy.Disabled);
    }

    private PulsarByteBufAllocator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        LISTENERS = new CopyOnWriteArrayList<Consumer<OutOfMemoryError>>();
        DEFAULT = PulsarByteBufAllocator.createByteBufAllocator();
    }
}

