/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.cli.converters;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ByteUnitUtil {
    private static Set<Character> sizeUnit = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('k'), Character.valueOf('K'), Character.valueOf('m'), Character.valueOf('M'), Character.valueOf('g'), Character.valueOf('G'), Character.valueOf('t'), Character.valueOf('T'))));

    public static long validateSizeString(String byteStr) {
        long size;
        if (byteStr.isEmpty()) {
            throw new IllegalArgumentException("byte string cannot be empty");
        }
        char last = byteStr.charAt(byteStr.length() - 1);
        String subStr = byteStr.substring(0, byteStr.length() - 1);
        try {
            size = sizeUnit.contains(Character.valueOf(last)) ? Long.parseLong(subStr) : Long.parseLong(byteStr);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid size '%s'. Valid formats are: %s", byteStr, "(4096, 100K, 10M, 16G, 2T)"));
        }
        switch (last) {
            case 'K': 
            case 'k': {
                return size * 1024L;
            }
            case 'M': 
            case 'm': {
                return size * 1024L * 1024L;
            }
            case 'G': 
            case 'g': {
                return size * 1024L * 1024L * 1024L;
            }
            case 'T': 
            case 't': {
                return size * 1024L * 1024L * 1024L * 1024L;
            }
        }
        return size;
    }

    private ByteUnitUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

