/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.TreeMap;
import org.apache.pulsar.client.impl.schema.SchemaInfoImpl;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.Schema;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.schema.SchemaInfo;

public final class SchemaInfoUtil {
    public static SchemaInfo newSchemaInfo(String name, SchemaData data) {
        return SchemaInfoImpl.builder().name(name).schema(data.getData()).type(data.getType()).properties(data.getProps()).build();
    }

    public static SchemaInfo newSchemaInfo(Schema schema) {
        SchemaInfoImpl.SchemaInfoImplBuilder si = SchemaInfoImpl.builder().name(schema.getName()).schema(schema.getSchemaData()).type(Commands.getSchemaType((Schema.Type)schema.getType()));
        if (schema.getPropertiesCount() == 0) {
            si.properties(Collections.emptyMap());
        } else {
            TreeMap<String, String> properties = new TreeMap<String, String>();
            for (int i = 0; i < schema.getPropertiesCount(); ++i) {
                KeyValue kv = schema.getPropertyAt(i);
                properties.put(kv.getKey(), kv.getValue());
            }
            si.properties(properties);
        }
        return si.build();
    }

    public static SchemaInfo newSchemaInfo(String name, GetSchemaResponse schema) {
        return SchemaInfoImpl.builder().name(name).schema(schema.getData().getBytes(StandardCharsets.UTF_8)).type(schema.getType()).properties(schema.getProperties()).build();
    }

    private SchemaInfoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

