/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data.stats;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.apache.pulsar.common.policies.data.ReplicatorStats;

public class ReplicatorStatsImpl
implements ReplicatorStats {
    public double msgRateIn;
    @JsonIgnore
    private final LongAdder msgInCount = new LongAdder();
    public double msgThroughputIn;
    @JsonIgnore
    private final LongAdder bytesInCount = new LongAdder();
    public double msgRateOut;
    @JsonIgnore
    private final LongAdder msgOutCount = new LongAdder();
    public double msgThroughputOut;
    @JsonIgnore
    private final LongAdder bytesOutCount = new LongAdder();
    public double msgRateExpired;
    public long replicationBacklog;
    public boolean connected;
    public long replicationDelayInSeconds;
    public String inboundConnection;
    public String inboundConnectedSince;
    public String outboundConnection;
    public String outboundConnectedSince;

    public ReplicatorStatsImpl add(ReplicatorStatsImpl stats) {
        Objects.requireNonNull(stats);
        this.msgRateIn += stats.msgRateIn;
        this.msgThroughputIn += stats.msgThroughputIn;
        this.msgRateOut += stats.msgRateOut;
        this.msgThroughputOut += stats.msgThroughputOut;
        this.msgRateExpired += stats.msgRateExpired;
        this.replicationBacklog += stats.replicationBacklog;
        this.connected &= stats.connected;
        this.replicationDelayInSeconds = Math.max(this.replicationDelayInSeconds, stats.replicationDelayInSeconds);
        return this;
    }

    @JsonProperty
    public long getMsgInCount() {
        return this.msgInCount.sum();
    }

    @JsonProperty
    public long getBytesInCount() {
        return this.bytesInCount.sum();
    }

    public void incrementPublishCount(int numOfMessages, long msgSizeInBytes) {
        this.msgInCount.add(numOfMessages);
        this.bytesInCount.add(msgSizeInBytes);
    }

    @JsonProperty
    public long getMsgOutCount() {
        return this.msgOutCount.sum();
    }

    public void incrementMsgOutCounter() {
        this.msgOutCount.increment();
    }

    @JsonProperty
    public long getBytesOutCount() {
        return this.bytesOutCount.sum();
    }

    public void incrementBytesOutCounter(long bytes) {
        this.bytesOutCount.add(bytes);
    }

    @JsonProperty
    public long getMsgExpiredCount() {
        return 0L;
    }

    public double getMsgRateIn() {
        return this.msgRateIn;
    }

    public double getMsgThroughputIn() {
        return this.msgThroughputIn;
    }

    public double getMsgRateOut() {
        return this.msgRateOut;
    }

    public double getMsgThroughputOut() {
        return this.msgThroughputOut;
    }

    public double getMsgRateExpired() {
        return this.msgRateExpired;
    }

    public long getReplicationBacklog() {
        return this.replicationBacklog;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public long getReplicationDelayInSeconds() {
        return this.replicationDelayInSeconds;
    }

    public String getInboundConnection() {
        return this.inboundConnection;
    }

    public String getInboundConnectedSince() {
        return this.inboundConnectedSince;
    }

    public String getOutboundConnection() {
        return this.outboundConnection;
    }

    public String getOutboundConnectedSince() {
        return this.outboundConnectedSince;
    }

    public void setMsgRateIn(double msgRateIn) {
        this.msgRateIn = msgRateIn;
    }

    public void setMsgThroughputIn(double msgThroughputIn) {
        this.msgThroughputIn = msgThroughputIn;
    }

    public void setMsgRateOut(double msgRateOut) {
        this.msgRateOut = msgRateOut;
    }

    public void setMsgThroughputOut(double msgThroughputOut) {
        this.msgThroughputOut = msgThroughputOut;
    }

    public void setMsgRateExpired(double msgRateExpired) {
        this.msgRateExpired = msgRateExpired;
    }

    public void setReplicationBacklog(long replicationBacklog) {
        this.replicationBacklog = replicationBacklog;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public void setReplicationDelayInSeconds(long replicationDelayInSeconds) {
        this.replicationDelayInSeconds = replicationDelayInSeconds;
    }

    public void setInboundConnection(String inboundConnection) {
        this.inboundConnection = inboundConnection;
    }

    public void setInboundConnectedSince(String inboundConnectedSince) {
        this.inboundConnectedSince = inboundConnectedSince;
    }

    public void setOutboundConnection(String outboundConnection) {
        this.outboundConnection = outboundConnection;
    }

    public void setOutboundConnectedSince(String outboundConnectedSince) {
        this.outboundConnectedSince = outboundConnectedSince;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplicatorStatsImpl)) {
            return false;
        }
        ReplicatorStatsImpl other = (ReplicatorStatsImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getMsgRateIn(), other.getMsgRateIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputIn(), other.getMsgThroughputIn()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateOut(), other.getMsgRateOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgThroughputOut(), other.getMsgThroughputOut()) != 0) {
            return false;
        }
        if (Double.compare(this.getMsgRateExpired(), other.getMsgRateExpired()) != 0) {
            return false;
        }
        if (this.getReplicationBacklog() != other.getReplicationBacklog()) {
            return false;
        }
        if (this.isConnected() != other.isConnected()) {
            return false;
        }
        if (this.getReplicationDelayInSeconds() != other.getReplicationDelayInSeconds()) {
            return false;
        }
        if (this.getMsgInCount() != other.getMsgInCount()) {
            return false;
        }
        if (this.getBytesInCount() != other.getBytesInCount()) {
            return false;
        }
        if (this.getMsgOutCount() != other.getMsgOutCount()) {
            return false;
        }
        if (this.getBytesOutCount() != other.getBytesOutCount()) {
            return false;
        }
        String this$inboundConnection = this.getInboundConnection();
        String other$inboundConnection = other.getInboundConnection();
        if (this$inboundConnection == null ? other$inboundConnection != null : !this$inboundConnection.equals(other$inboundConnection)) {
            return false;
        }
        String this$inboundConnectedSince = this.getInboundConnectedSince();
        String other$inboundConnectedSince = other.getInboundConnectedSince();
        if (this$inboundConnectedSince == null ? other$inboundConnectedSince != null : !this$inboundConnectedSince.equals(other$inboundConnectedSince)) {
            return false;
        }
        String this$outboundConnection = this.getOutboundConnection();
        String other$outboundConnection = other.getOutboundConnection();
        if (this$outboundConnection == null ? other$outboundConnection != null : !this$outboundConnection.equals(other$outboundConnection)) {
            return false;
        }
        String this$outboundConnectedSince = this.getOutboundConnectedSince();
        String other$outboundConnectedSince = other.getOutboundConnectedSince();
        return !(this$outboundConnectedSince == null ? other$outboundConnectedSince != null : !this$outboundConnectedSince.equals(other$outboundConnectedSince));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplicatorStatsImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $msgRateIn = Double.doubleToLongBits(this.getMsgRateIn());
        result = result * 59 + (int)($msgRateIn >>> 32 ^ $msgRateIn);
        long $msgThroughputIn = Double.doubleToLongBits(this.getMsgThroughputIn());
        result = result * 59 + (int)($msgThroughputIn >>> 32 ^ $msgThroughputIn);
        long $msgRateOut = Double.doubleToLongBits(this.getMsgRateOut());
        result = result * 59 + (int)($msgRateOut >>> 32 ^ $msgRateOut);
        long $msgThroughputOut = Double.doubleToLongBits(this.getMsgThroughputOut());
        result = result * 59 + (int)($msgThroughputOut >>> 32 ^ $msgThroughputOut);
        long $msgRateExpired = Double.doubleToLongBits(this.getMsgRateExpired());
        result = result * 59 + (int)($msgRateExpired >>> 32 ^ $msgRateExpired);
        long $replicationBacklog = this.getReplicationBacklog();
        result = result * 59 + (int)($replicationBacklog >>> 32 ^ $replicationBacklog);
        result = result * 59 + (this.isConnected() ? 79 : 97);
        long $replicationDelayInSeconds = this.getReplicationDelayInSeconds();
        result = result * 59 + (int)($replicationDelayInSeconds >>> 32 ^ $replicationDelayInSeconds);
        long $msgInCount = this.getMsgInCount();
        result = result * 59 + (int)($msgInCount >>> 32 ^ $msgInCount);
        long $bytesInCount = this.getBytesInCount();
        result = result * 59 + (int)($bytesInCount >>> 32 ^ $bytesInCount);
        long $msgOutCount = this.getMsgOutCount();
        result = result * 59 + (int)($msgOutCount >>> 32 ^ $msgOutCount);
        long $bytesOutCount = this.getBytesOutCount();
        result = result * 59 + (int)($bytesOutCount >>> 32 ^ $bytesOutCount);
        String $inboundConnection = this.getInboundConnection();
        result = result * 59 + ($inboundConnection == null ? 43 : $inboundConnection.hashCode());
        String $inboundConnectedSince = this.getInboundConnectedSince();
        result = result * 59 + ($inboundConnectedSince == null ? 43 : $inboundConnectedSince.hashCode());
        String $outboundConnection = this.getOutboundConnection();
        result = result * 59 + ($outboundConnection == null ? 43 : $outboundConnection.hashCode());
        String $outboundConnectedSince = this.getOutboundConnectedSince();
        result = result * 59 + ($outboundConnectedSince == null ? 43 : $outboundConnectedSince.hashCode());
        return result;
    }

    public String toString() {
        return "ReplicatorStatsImpl(msgRateIn=" + this.getMsgRateIn() + ", msgInCount=" + this.getMsgInCount() + ", msgThroughputIn=" + this.getMsgThroughputIn() + ", bytesInCount=" + this.getBytesInCount() + ", msgRateOut=" + this.getMsgRateOut() + ", msgOutCount=" + this.getMsgOutCount() + ", msgThroughputOut=" + this.getMsgThroughputOut() + ", bytesOutCount=" + this.getBytesOutCount() + ", msgRateExpired=" + this.getMsgRateExpired() + ", replicationBacklog=" + this.getReplicationBacklog() + ", connected=" + this.isConnected() + ", replicationDelayInSeconds=" + this.getReplicationDelayInSeconds() + ", inboundConnection=" + this.getInboundConnection() + ", inboundConnectedSince=" + this.getInboundConnectedSince() + ", outboundConnection=" + this.getOutboundConnection() + ", outboundConnectedSince=" + this.getOutboundConnectedSince() + ")";
    }
}

