/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.grpc;

import com.google.common.base.Throwables;
import io.grpc.CallCredentials;
import io.grpc.Channel;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.TlsChannelCredentials;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.MetadataUtils;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.batch.WriteStreamWrapper;
import io.streamnative.oxia.client.grpc.OxiaBackoffProvider;
import io.streamnative.oxia.proto.OxiaClientGrpc;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxiaStub
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(OxiaStub.class);
    private final ManagedChannel channel;
    private final String namespace;
    @NonNull
    private final OxiaClientGrpc.OxiaClientStub asyncStub;
    private final Map<Long, WriteStreamWrapper> writeStreams = new ConcurrentHashMap<Long, WriteStreamWrapper>();
    private static final Metadata.Key<String> NAMESPACE_KEY = Metadata.Key.of((String)"namespace", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private static final Metadata.Key<String> SHARD_ID_KEY = Metadata.Key.of((String)"shard-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    public OxiaStub(String address, String namespace, @Nullable Authentication authentication, boolean enableTls, @Nullable BackoffPolicy.Provider backoffProvider) {
        this(Grpc.newChannelBuilder((String)address, (ChannelCredentials)(enableTls ? TlsChannelCredentials.newBuilder().build() : InsecureChannelCredentials.create())).directExecutor().build(), namespace, authentication, backoffProvider);
    }

    public OxiaStub(ManagedChannel channel, String namespace) {
        this(channel, namespace, null, OxiaBackoffProvider.DEFAULT);
    }

    public OxiaStub(ManagedChannel channel, String namespace, final @Nullable Authentication authentication, @Nullable BackoffPolicy.Provider oxiaBackoffPolicyProvider) {
        if (oxiaBackoffPolicyProvider != null) {
            this.configureBackoffPolicyIfPossible(channel, oxiaBackoffPolicyProvider);
        }
        this.namespace = namespace;
        this.channel = channel;
        this.asyncStub = authentication != null ? (OxiaClientGrpc.OxiaClientStub)OxiaClientGrpc.newStub((Channel)channel).withCallCredentials(new CallCredentials(){

            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor appExecutor, CallCredentials.MetadataApplier applier) {
                applier.apply(authentication.generateCredentials());
            }

            public void thisUsesUnstableApi() {
            }
        }) : OxiaClientGrpc.newStub((Channel)channel);
    }

    private void configureBackoffPolicyIfPossible(ManagedChannel channel, BackoffPolicy.Provider oxiaBackoffPolicyProvider) {
        try {
            Class<?> mcl = Class.forName("io.grpc.internal.ForwardingManagedChannel");
            Field delegate = mcl.getDeclaredField("delegate");
            delegate.setAccessible(true);
            Object mclInstance = delegate.get(channel);
            Class<?> mclInstanceKlass = Class.forName("io.grpc.internal.ManagedChannelImpl");
            Field backOffField = mclInstanceKlass.getDeclaredField("backoffPolicyProvider");
            backOffField.setAccessible(true);
            backOffField.set(mclInstance, oxiaBackoffPolicyProvider);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException ex) {
            log.warn("Auto replace GRPC default backoff policy failed. fallback to the GRPC default implementation.", Throwables.getRootCause((Throwable)ex));
        }
    }

    public OxiaClientGrpc.OxiaClientStub async() {
        return this.asyncStub;
    }

    public WriteStreamWrapper writeStream(long streamId) {
        return this.writeStreams.compute(streamId, (key, stream) -> {
            if (stream == null || !stream.isValid()) {
                Metadata headers = new Metadata();
                headers.put(NAMESPACE_KEY, (Object)this.namespace);
                headers.put(SHARD_ID_KEY, (Object)String.format("%d", streamId));
                OxiaClientGrpc.OxiaClientStub stub = (OxiaClientGrpc.OxiaClientStub)this.asyncStub.withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)headers)});
                return new WriteStreamWrapper(stub);
            }
            return stream;
        });
    }

    @Override
    public void close() throws Exception {
        this.channel.shutdown();
        try {
            if (!this.channel.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.channel.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.channel.shutdownNow();
        }
    }
}

