/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.batch;

import io.grpc.stub.StreamObserver;
import io.streamnative.oxia.proto.OxiaClientGrpc;
import io.streamnative.oxia.proto.WriteRequest;
import io.streamnative.oxia.proto.WriteResponse;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteStreamWrapper
implements StreamObserver<WriteResponse> {
    private static final Logger log = LoggerFactory.getLogger(WriteStreamWrapper.class);
    private final StreamObserver<WriteRequest> clientStream;
    private final Deque<CompletableFuture<WriteResponse>> pendingWrites = new ArrayDeque<CompletableFuture<WriteResponse>>();
    private volatile Throwable failed = null;

    public WriteStreamWrapper(OxiaClientGrpc.OxiaClientStub stub) {
        this.clientStream = stub.writeStream(this);
    }

    public boolean isValid() {
        return this.failed == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(WriteResponse value) {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            CompletableFuture<WriteResponse> future = this.pendingWrites.poll();
            if (future != null) {
                future.complete(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Throwable t) {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            if (!this.pendingWrites.isEmpty()) {
                log.warn("Got Error", t);
            }
            this.pendingWrites.forEach(f -> f.completeExceptionally(t));
            this.pendingWrites.clear();
            this.failed = t;
        }
    }

    public void onCompleted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<WriteResponse> send(WriteRequest request) {
        WriteStreamWrapper writeStreamWrapper = this;
        synchronized (writeStreamWrapper) {
            if (this.failed != null) {
                return CompletableFuture.failedFuture(this.failed);
            }
            CompletableFuture<WriteResponse> future = new CompletableFuture<WriteResponse>();
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Sending request {}", (Object)request);
                }
                this.clientStream.onNext((Object)request);
                this.pendingWrites.add(future);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }
    }
}

