/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import com.google.common.collect.Range;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionBound;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.bookkeeper.mledger.ReadOnlyCursor;
import org.apache.bookkeeper.mledger.impl.ManagedCursorImpl;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadOnlyCursorImpl
extends ManagedCursorImpl
implements ReadOnlyCursor {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyCursorImpl.class);

    public ReadOnlyCursorImpl(BookKeeper bookkeeper, ManagedLedgerImpl ledger, Position startPosition, String cursorName) {
        super(bookkeeper, ledger, cursorName);
        this.readPosition = startPosition.equals(PositionFactory.EARLIEST) ? ledger.getFirstPosition().getNext() : startPosition;
        this.messagesConsumedCounter = ledger.getLastPosition().compareTo(this.readPosition) <= 0 ? 0L : -this.getNumberOfEntries((Range<Position>)Range.closed((Comparable)this.readPosition, (Comparable)ledger.getLastPosition()));
        this.state = ManagedCursorImpl.State.NoLedger;
    }

    @Override
    public void skipEntries(int numEntriesToSkip) {
        log.info("[{}] Skipping {} entries on read-only cursor {}", new Object[]{this.ledger.getName(), numEntriesToSkip, this.getName()});
        READ_POSITION_UPDATER.getAndUpdate(this, lastRead -> this.ledger.getPositionAfterN((Position)lastRead, numEntriesToSkip, PositionBound.startIncluded).getNext());
    }

    @Override
    public void asyncClose(AsyncCallbacks.CloseCallback callback, Object ctx) {
        this.state = ManagedCursorImpl.State.Closed;
        callback.closeComplete(ctx);
    }

    public MLDataFormats.ManagedLedgerInfo.LedgerInfo getCurrentLedgerInfo() {
        return (MLDataFormats.ManagedLedgerInfo.LedgerInfo)this.ledger.getLedgersInfo().get(this.readPosition.getLedgerId());
    }

    @Override
    public long getNumberOfEntries(Range<Position> range) {
        return this.ledger.getNumberOfEntries(range);
    }

    @Override
    public boolean isMessageDeleted(Position position) {
        return false;
    }
}

