/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import org.apache.bookkeeper.mledger.proto.MLDataFormats;
import org.apache.commons.lang.StringUtils;

public class MetadataCompressionConfig {
    MLDataFormats.CompressionType compressionType;
    long compressSizeThresholdInBytes;
    public static MetadataCompressionConfig noCompression = new MetadataCompressionConfig(MLDataFormats.CompressionType.NONE, 0L);

    public MetadataCompressionConfig(String compressionType) throws IllegalArgumentException {
        this(compressionType, 0L);
    }

    public MetadataCompressionConfig(String compressionType, long compressThreshold) throws IllegalArgumentException {
        this.compressionType = this.parseCompressionType(compressionType);
        this.compressSizeThresholdInBytes = compressThreshold;
    }

    private MLDataFormats.CompressionType parseCompressionType(String value) throws IllegalArgumentException {
        if (StringUtils.isEmpty((String)value)) {
            return MLDataFormats.CompressionType.NONE;
        }
        MLDataFormats.CompressionType compressionType = MLDataFormats.CompressionType.valueOf(value);
        return compressionType;
    }

    public MLDataFormats.CompressionType getCompressionType() {
        return this.compressionType;
    }

    public long getCompressSizeThresholdInBytes() {
        return this.compressSizeThresholdInBytes;
    }

    public void setCompressionType(MLDataFormats.CompressionType compressionType) {
        this.compressionType = compressionType;
    }

    public void setCompressSizeThresholdInBytes(long compressSizeThresholdInBytes) {
        this.compressSizeThresholdInBytes = compressSizeThresholdInBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataCompressionConfig)) {
            return false;
        }
        MetadataCompressionConfig other = (MetadataCompressionConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCompressSizeThresholdInBytes() != other.getCompressSizeThresholdInBytes()) {
            return false;
        }
        MLDataFormats.CompressionType this$compressionType = this.getCompressionType();
        MLDataFormats.CompressionType other$compressionType = other.getCompressionType();
        return !(this$compressionType == null ? other$compressionType != null : !((Object)((Object)this$compressionType)).equals((Object)other$compressionType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetadataCompressionConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $compressSizeThresholdInBytes = this.getCompressSizeThresholdInBytes();
        result = result * 59 + (int)($compressSizeThresholdInBytes >>> 32 ^ $compressSizeThresholdInBytes);
        MLDataFormats.CompressionType $compressionType = this.getCompressionType();
        result = result * 59 + ($compressionType == null ? 43 : ((Object)((Object)$compressionType)).hashCode());
        return result;
    }

    public MetadataCompressionConfig(MLDataFormats.CompressionType compressionType, long compressSizeThresholdInBytes) {
        this.compressionType = compressionType;
        this.compressSizeThresholdInBytes = compressSizeThresholdInBytes;
    }

    public String toString() {
        return "MetadataCompressionConfig(compressionType=" + String.valueOf((Object)this.getCompressionType()) + ", compressSizeThresholdInBytes=" + this.getCompressSizeThresholdInBytes() + ")";
    }
}

