/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import org.apache.bookkeeper.mledger.ManagedLedger;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class ManagedLedgerAttributes {
    private final Attributes attributes;
    private final Attributes attributesOperationSucceed;
    private final Attributes attributesOperationFailure;

    public ManagedLedgerAttributes(ManagedLedger ml) {
        String mlName = ml.getName();
        this.attributes = Attributes.of((AttributeKey)OpenTelemetryAttributes.ML_NAME, (Object)mlName, (AttributeKey)OpenTelemetryAttributes.PULSAR_NAMESPACE, (Object)ManagedLedgerAttributes.getNamespace(mlName));
        this.attributesOperationSucceed = Attributes.builder().putAll(this.attributes).putAll(OpenTelemetryAttributes.ManagedLedgerOperationStatus.SUCCESS.attributes).build();
        this.attributesOperationFailure = Attributes.builder().putAll(this.attributes).putAll(OpenTelemetryAttributes.ManagedLedgerOperationStatus.FAILURE.attributes).build();
    }

    private static String getNamespace(String mlName) {
        try {
            return TopicName.get((String)TopicName.fromPersistenceNamingEncoding((String)mlName)).getNamespace();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public Attributes getAttributesOperationSucceed() {
        return this.attributesOperationSucceed;
    }

    public Attributes getAttributesOperationFailure() {
        return this.attributesOperationFailure;
    }
}

