/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.util.Optional;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaImpl;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.functions.api.KVRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.functions.source.PulsarRecord;

public abstract class AbstractSinkRecord<T>
implements Record<T> {
    private final Record<?> sourceRecord;

    protected AbstractSinkRecord(Record<?> sourceRecord) {
        this.sourceRecord = sourceRecord;
    }

    public abstract boolean shouldAlwaysSetMessageProperties();

    public abstract boolean shouldSetSchema();

    public Record<?> getSourceRecord() {
        return this.sourceRecord;
    }

    public Optional<String> getTopicName() {
        return this.sourceRecord.getTopicName();
    }

    public void ack() {
        this.sourceRecord.ack();
    }

    public void cumulativeAck() {
        if (!(this.sourceRecord instanceof PulsarRecord)) {
            throw new RuntimeException("SourceRecord class type must be PulsarRecord");
        }
        PulsarRecord pulsarRecord = (PulsarRecord)this.sourceRecord;
        pulsarRecord.cumulativeAck();
    }

    public void individualAck() {
        if (!(this.sourceRecord instanceof PulsarRecord)) {
            throw new RuntimeException("SourceRecord class type must be PulsarRecord");
        }
        PulsarRecord pulsarRecord = (PulsarRecord)this.sourceRecord;
        pulsarRecord.individualAck();
    }

    public void fail() {
        this.sourceRecord.fail();
    }

    protected static <T> Schema<T> getRecordSchema(Record<T> record) {
        if (record == null) {
            return null;
        }
        if (record.getSchema() != null) {
            Schema schema = record.getSchema();
            if (schema instanceof AutoConsumeSchema) {
                schema = record.getMessage().isPresent() && ((Message)record.getMessage().get()).getReaderSchema().isPresent() ? (Schema)((Message)record.getMessage().get()).getReaderSchema().get() : ((AutoConsumeSchema)schema).getInternalSchema();
            }
            return schema;
        }
        if (record instanceof KVRecord) {
            KVRecord kvRecord = (KVRecord)record;
            return KeyValueSchemaImpl.of((Schema)kvRecord.getKeySchema(), (Schema)kvRecord.getValueSchema(), (KeyValueEncodingType)kvRecord.getKeyValueEncodingType());
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractSinkRecord)) {
            return false;
        }
        AbstractSinkRecord other = (AbstractSinkRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Record<?> this$sourceRecord = this.getSourceRecord();
        Record<?> other$sourceRecord = other.getSourceRecord();
        return !(this$sourceRecord == null ? other$sourceRecord != null : !this$sourceRecord.equals(other$sourceRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AbstractSinkRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Record<?> $sourceRecord = this.getSourceRecord();
        result = result * 59 + ($sourceRecord == null ? 43 : $sourceRecord.hashCode());
        return result;
    }

    public String toString() {
        return "AbstractSinkRecord(sourceRecord=" + String.valueOf(this.getSourceRecord()) + ")";
    }
}

