/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.web;

import java.net.InetSocketAddress;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.ProxyConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyRequestLogFactory {
    private static final String TIME_FORMAT = String.format(" %%{%s|%s}t ", "dd/MMM/yyyy:HH:mm:ss Z", TimeZone.getDefault().getID());
    private static final String LOG_FORMAT = "%{client}a - %u" + TIME_FORMAT + "\"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" %{ms}T";

    public static RequestLog createRequestLogger() {
        return JettyRequestLogFactory.createRequestLogger(false, null);
    }

    public static RequestLog createRequestLogger(boolean showDetailedAddresses, Server server) {
        if (!showDetailedAddresses) {
            return new CustomRequestLog((RequestLog.Writer)new Slf4jRequestLogWriter(), LOG_FORMAT);
        }
        return new OriginalClientIPRequestLog(server);
    }

    private static class OriginalClientIPRequestLog
    extends ContainerLifeCycle
    implements RequestLog {
        private static final Logger log = LoggerFactory.getLogger(OriginalClientIPRequestLog.class);
        private final ThreadLocal<StringBuilder> requestLogStringBuilder = ThreadLocal.withInitial(StringBuilder::new);
        private final CustomRequestLog delegate;
        private final Slf4jRequestLogWriter delegateLogWriter;
        private final Connection.Listener proxyProtocolOriginalEndpointListener = new ProxyProtocolOriginalEndpointListener();
        private final ConcurrentHashMap<AddressKey, AddressEntry> proxyProtocolRealAddressMapping = new ConcurrentHashMap();

        OriginalClientIPRequestLog(Server server) {
            this.delegate = new CustomRequestLog(this::write, LOG_FORMAT);
            this.addBean(this.delegate);
            this.delegateLogWriter = new Slf4jRequestLogWriter();
            this.addBean(this.delegateLogWriter);
            if (server != null) {
                for (Connector connector : server.getConnectors()) {
                    if (!(connector.getDefaultConnectionFactory() instanceof ProxyConnectionFactory)) continue;
                    connector.addBean((Object)this.proxyProtocolOriginalEndpointListener);
                }
            }
        }

        void write(String requestEntry) {
            StringBuilder sb = this.requestLogStringBuilder.get();
            sb.setLength(0);
            sb.append(requestEntry);
        }

        public void log(Request request, Response response) {
            this.delegate.log(request, response);
            StringBuilder sb = this.requestLogStringBuilder.get();
            sb.append(" [R:");
            sb.append(request.getRemoteHost());
            sb.append(':');
            sb.append(request.getRemotePort());
            InetSocketAddress realRemoteAddress = this.lookupRealAddress(request.getHttpChannel().getRemoteAddress());
            if (realRemoteAddress != null) {
                String realRemoteHost = HostPort.normalizeHost((String)realRemoteAddress.getHostString());
                int realRemotePort = realRemoteAddress.getPort();
                if (!realRemoteHost.equals(request.getRemoteHost()) || realRemotePort != request.getRemotePort()) {
                    sb.append(" via ");
                    sb.append(realRemoteHost);
                    sb.append(':');
                    sb.append(realRemotePort);
                }
            }
            sb.append("]->[L:");
            InetSocketAddress realLocalAddress = this.lookupRealAddress(request.getHttpChannel().getLocalAddress());
            if (realLocalAddress != null) {
                String realLocalHost = HostPort.normalizeHost((String)realLocalAddress.getHostString());
                int realLocalPort = realLocalAddress.getPort();
                sb.append(realLocalHost);
                sb.append(':');
                sb.append(realLocalPort);
                if (!realLocalHost.equals(request.getLocalAddr()) || realLocalPort != request.getLocalPort()) {
                    sb.append(" dst ");
                    sb.append(request.getLocalAddr());
                    sb.append(':');
                    sb.append(request.getLocalPort());
                }
            } else {
                sb.append(request.getLocalAddr());
                sb.append(':');
                sb.append(request.getLocalPort());
            }
            sb.append(']');
            try {
                this.delegateLogWriter.write(sb.toString());
            }
            catch (Exception e) {
                log.warn("Failed to write request log", (Throwable)e);
            }
        }

        private InetSocketAddress lookupRealAddress(InetSocketAddress socketAddress) {
            if (socketAddress == null) {
                return null;
            }
            if (this.proxyProtocolRealAddressMapping.isEmpty()) {
                return socketAddress;
            }
            AddressEntry entry = this.proxyProtocolRealAddressMapping.get(new AddressKey(socketAddress.getHostString(), socketAddress.getPort()));
            if (entry != null) {
                return entry.realAddress;
            }
            return socketAddress;
        }

        class ProxyProtocolOriginalEndpointListener
        implements Connection.Listener {
            ProxyProtocolOriginalEndpointListener() {
            }

            public void onOpened(Connection connection) {
                this.handleConnection(connection, true);
            }

            public void onClosed(Connection connection) {
                this.handleConnection(connection, false);
            }

            private void handleConnection(Connection connection, boolean increment) {
                if (connection.getEndPoint() instanceof ProxyConnectionFactory.ProxyEndPoint) {
                    ProxyConnectionFactory.ProxyEndPoint proxyEndPoint = (ProxyConnectionFactory.ProxyEndPoint)connection.getEndPoint();
                    EndPoint originalEndpoint = proxyEndPoint.unwrap();
                    this.mapAddress(proxyEndPoint.getLocalAddress(), originalEndpoint.getLocalAddress(), increment);
                    this.mapAddress(proxyEndPoint.getRemoteAddress(), originalEndpoint.getRemoteAddress(), increment);
                }
            }

            private void mapAddress(InetSocketAddress current, InetSocketAddress real, boolean increment) {
                if (real != null && current != null && current.equals(real)) {
                    return;
                }
                AddressKey key = new AddressKey(current.getHostString(), current.getPort());
                OriginalClientIPRequestLog.this.proxyProtocolRealAddressMapping.compute(key, (__, entry) -> {
                    if (entry == null) {
                        if (increment) {
                            entry = new AddressEntry(real, new AtomicInteger(1));
                        }
                    } else if (increment) {
                        entry.referenceCount.incrementAndGet();
                    } else if (entry.referenceCount.decrementAndGet() == 0) {
                        entry = null;
                    }
                    return entry;
                });
            }
        }

        record AddressKey(String hostString, int port) {
        }

        record AddressEntry(InetSocketAddress realAddress, AtomicInteger referenceCount) {
        }
    }
}

