/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication.utils;

import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.DecodingException;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;

public final class AuthTokenUtils {
    public static SecretKey createSecretKey(SignatureAlgorithm signatureAlgorithm) {
        return Keys.secretKeyFor((SignatureAlgorithm)signatureAlgorithm);
    }

    public static SecretKey decodeSecretKey(byte[] secretKey) {
        return Keys.hmacShaKeyFor((byte[])secretKey);
    }

    public static PrivateKey decodePrivateKey(byte[] key, SignatureAlgorithm algType) throws IOException {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance(AuthTokenUtils.keyTypeForSignatureAlgorithm(algType));
            return kf.generatePrivate(spec);
        }
        catch (Exception e) {
            throw new IOException("Failed to decode private key", e);
        }
    }

    public static PublicKey decodePublicKey(byte[] key, SignatureAlgorithm algType) throws IOException {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory kf = KeyFactory.getInstance(AuthTokenUtils.keyTypeForSignatureAlgorithm(algType));
            return kf.generatePublic(spec);
        }
        catch (Exception e) {
            throw new IOException("Failed to decode public key", e);
        }
    }

    private static String keyTypeForSignatureAlgorithm(SignatureAlgorithm alg) {
        if (alg.getFamilyName().equals("RSA")) {
            return "RSA";
        }
        if (alg.getFamilyName().equals("ECDSA")) {
            return "EC";
        }
        String msg = "The " + alg.name() + " algorithm does not support Key Pairs.";
        throw new IllegalArgumentException(msg);
    }

    public static String encodeKeyBase64(Key key) {
        return (String)Encoders.BASE64.encode((Object)key.getEncoded());
    }

    public static String createToken(Key signingKey, String subject, Optional<Date> expiryTime, Optional<Map<String, Object>> headers) {
        JwtBuilder builder = Jwts.builder().setSubject(subject).signWith(signingKey);
        expiryTime.ifPresent(arg_0 -> ((JwtBuilder)builder).setExpiration(arg_0));
        headers.ifPresent(arg_0 -> ((JwtBuilder)builder).setHeaderParams(arg_0));
        return builder.compact();
    }

    public static String createToken(Key signingKey, String subject, Optional<Date> expiryTime) {
        return AuthTokenUtils.createToken(signingKey, subject, expiryTime, Optional.empty());
    }

    public static byte[] readKeyFromUrl(String keyConfUrl) throws IOException {
        if (keyConfUrl.startsWith("data:") || keyConfUrl.startsWith("file:")) {
            try {
                if (keyConfUrl.startsWith("file:")) {
                    keyConfUrl = keyConfUrl.trim();
                }
                return IOUtils.toByteArray((URL)org.apache.pulsar.client.api.url.URL.createURL((String)keyConfUrl));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        if (Files.exists(Paths.get(keyConfUrl, new String[0]), new LinkOption[0])) {
            return Files.readAllBytes(Paths.get(keyConfUrl, new String[0]));
        }
        if (Base64.isBase64((byte[])keyConfUrl.getBytes())) {
            try {
                return (byte[])Decoders.BASE64.decode((Object)keyConfUrl);
            }
            catch (DecodingException e) {
                String msg = "Illegal base64 character or Key file " + keyConfUrl + " doesn't exist";
                throw new IOException(msg, e);
            }
        }
        String msg = "Secret/Public Key file " + keyConfUrl + " doesn't exist";
        throw new IllegalArgumentException(msg);
    }

    private AuthTokenUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

