/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import io.opentelemetry.api.OpenTelemetry;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.OneStageAuthenticationState;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.broker.web.AuthenticationFilter;
import org.apache.pulsar.common.api.AuthData;
import org.apache.pulsar.common.util.FutureUtil;

public interface AuthenticationProvider
extends Closeable {
    @Deprecated(since="3.4.0")
    public void initialize(ServiceConfiguration var1) throws IOException;

    default public void initialize(Context context) throws IOException {
        this.initialize(context.getConfig());
    }

    public String getAuthMethodName();

    default public CompletableFuture<String> authenticateAsync(AuthenticationDataSource authData) {
        try {
            return CompletableFuture.completedFuture(this.authenticate(authData));
        }
        catch (AuthenticationException e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    @Deprecated
    default public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        throw new AuthenticationException("Not supported");
    }

    default public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        return new OneStageAuthenticationState(authData, remoteAddress, sslSession, this);
    }

    @Deprecated(since="3.0.0")
    default public AuthenticationState newHttpAuthState(HttpServletRequest request) throws AuthenticationException {
        return new OneStageAuthenticationState(request, this);
    }

    default public CompletableFuture<Boolean> authenticateHttpRequestAsync(HttpServletRequest request, HttpServletResponse response) {
        try {
            return CompletableFuture.completedFuture(this.authenticateHttpRequest(request, response));
        }
        catch (Exception e) {
            return FutureUtil.failedFuture((Throwable)e);
        }
    }

    default public void incrementFailureMetric(Enum<?> errorCode) {
        AuthenticationMetrics.authenticateFailure(this.getClass().getSimpleName(), this.getAuthMethodName(), errorCode);
    }

    @Deprecated
    default public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AuthenticationState authenticationState = this.newHttpAuthState(request);
            String role = this.authenticateAsync(authenticationState.getAuthDataSource()).get();
            request.setAttribute(AuthenticationFilter.AuthenticatedRoleAttributeName, (Object)role);
            request.setAttribute(AuthenticationFilter.AuthenticatedDataAttributeName, (Object)authenticationState.getAuthDataSource());
            return true;
        }
        catch (AuthenticationException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof ExecutionException && e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            throw new AuthenticationException("Failed to authentication http request");
        }
    }

    public static final class Context {
        private final ServiceConfiguration config;
        private final OpenTelemetry openTelemetry;

        private static OpenTelemetry $default$openTelemetry() {
            return OpenTelemetry.noop();
        }

        Context(ServiceConfiguration config, OpenTelemetry openTelemetry) {
            this.config = config;
            this.openTelemetry = openTelemetry;
        }

        public static ContextBuilder builder() {
            return new ContextBuilder();
        }

        public ServiceConfiguration getConfig() {
            return this.config;
        }

        public OpenTelemetry getOpenTelemetry() {
            return this.openTelemetry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Context)) {
                return false;
            }
            Context other = (Context)o;
            ServiceConfiguration this$config = this.getConfig();
            ServiceConfiguration other$config = other.getConfig();
            if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
                return false;
            }
            OpenTelemetry this$openTelemetry = this.getOpenTelemetry();
            OpenTelemetry other$openTelemetry = other.getOpenTelemetry();
            return !(this$openTelemetry == null ? other$openTelemetry != null : !this$openTelemetry.equals(other$openTelemetry));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServiceConfiguration $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            OpenTelemetry $openTelemetry = this.getOpenTelemetry();
            result = result * 59 + ($openTelemetry == null ? 43 : $openTelemetry.hashCode());
            return result;
        }

        public String toString() {
            return "AuthenticationProvider.Context(config=" + String.valueOf(this.getConfig()) + ", openTelemetry=" + String.valueOf(this.getOpenTelemetry()) + ")";
        }

        public static class ContextBuilder {
            private ServiceConfiguration config;
            private boolean openTelemetry$set;
            private OpenTelemetry openTelemetry$value;

            ContextBuilder() {
            }

            public ContextBuilder config(ServiceConfiguration config) {
                this.config = config;
                return this;
            }

            public ContextBuilder openTelemetry(OpenTelemetry openTelemetry) {
                this.openTelemetry$value = openTelemetry;
                this.openTelemetry$set = true;
                return this;
            }

            public Context build() {
                OpenTelemetry openTelemetry$value = this.openTelemetry$value;
                if (!this.openTelemetry$set) {
                    openTelemetry$value = Context.$default$openTelemetry();
                }
                return new Context(this.config, openTelemetry$value);
            }

            public String toString() {
                return "AuthenticationProvider.Context.ContextBuilder(config=" + String.valueOf(this.config) + ", openTelemetry$value=" + String.valueOf(this.openTelemetry$value) + ")";
            }
        }
    }
}

