/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import org.apache.pulsar.broker.authentication.AuthenticationDataSource;

public final class AuthenticationParameters {
    private final String originalPrincipal;
    private final String clientRole;
    private final AuthenticationDataSource clientAuthenticationDataSource;

    AuthenticationParameters(String originalPrincipal, String clientRole, AuthenticationDataSource clientAuthenticationDataSource) {
        this.originalPrincipal = originalPrincipal;
        this.clientRole = clientRole;
        this.clientAuthenticationDataSource = clientAuthenticationDataSource;
    }

    public static AuthenticationParametersBuilder builder() {
        return new AuthenticationParametersBuilder();
    }

    public String getOriginalPrincipal() {
        return this.originalPrincipal;
    }

    public String getClientRole() {
        return this.clientRole;
    }

    public AuthenticationDataSource getClientAuthenticationDataSource() {
        return this.clientAuthenticationDataSource;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthenticationParameters)) {
            return false;
        }
        AuthenticationParameters other = (AuthenticationParameters)o;
        String this$originalPrincipal = this.getOriginalPrincipal();
        String other$originalPrincipal = other.getOriginalPrincipal();
        if (this$originalPrincipal == null ? other$originalPrincipal != null : !this$originalPrincipal.equals(other$originalPrincipal)) {
            return false;
        }
        String this$clientRole = this.getClientRole();
        String other$clientRole = other.getClientRole();
        if (this$clientRole == null ? other$clientRole != null : !this$clientRole.equals(other$clientRole)) {
            return false;
        }
        AuthenticationDataSource this$clientAuthenticationDataSource = this.getClientAuthenticationDataSource();
        AuthenticationDataSource other$clientAuthenticationDataSource = other.getClientAuthenticationDataSource();
        return !(this$clientAuthenticationDataSource == null ? other$clientAuthenticationDataSource != null : !this$clientAuthenticationDataSource.equals(other$clientAuthenticationDataSource));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $originalPrincipal = this.getOriginalPrincipal();
        result = result * 59 + ($originalPrincipal == null ? 43 : $originalPrincipal.hashCode());
        String $clientRole = this.getClientRole();
        result = result * 59 + ($clientRole == null ? 43 : $clientRole.hashCode());
        AuthenticationDataSource $clientAuthenticationDataSource = this.getClientAuthenticationDataSource();
        result = result * 59 + ($clientAuthenticationDataSource == null ? 43 : $clientAuthenticationDataSource.hashCode());
        return result;
    }

    public String toString() {
        return "AuthenticationParameters(originalPrincipal=" + this.getOriginalPrincipal() + ", clientRole=" + this.getClientRole() + ", clientAuthenticationDataSource=" + String.valueOf(this.getClientAuthenticationDataSource()) + ")";
    }

    public static class AuthenticationParametersBuilder {
        private String originalPrincipal;
        private String clientRole;
        private AuthenticationDataSource clientAuthenticationDataSource;

        AuthenticationParametersBuilder() {
        }

        public AuthenticationParametersBuilder originalPrincipal(String originalPrincipal) {
            this.originalPrincipal = originalPrincipal;
            return this;
        }

        public AuthenticationParametersBuilder clientRole(String clientRole) {
            this.clientRole = clientRole;
            return this;
        }

        public AuthenticationParametersBuilder clientAuthenticationDataSource(AuthenticationDataSource clientAuthenticationDataSource) {
            this.clientAuthenticationDataSource = clientAuthenticationDataSource;
            return this;
        }

        public AuthenticationParameters build() {
            return new AuthenticationParameters(this.originalPrincipal, this.clientRole, this.clientAuthenticationDataSource);
        }

        public String toString() {
            return "AuthenticationParameters.AuthenticationParametersBuilder(originalPrincipal=" + this.originalPrincipal + ", clientRole=" + this.clientRole + ", clientAuthenticationDataSource=" + String.valueOf(this.clientAuthenticationDataSource) + ")";
        }
    }
}

