/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils;

import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.pulsar.common.util.collections.LongPairSet;
import org.roaringbitmap.RoaringBitmap;

public class ConcurrentBitmapSortedLongPairSet {
    private final NavigableMap<Long, RoaringBitmap> map = new TreeMap<Long, RoaringBitmap>();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long item1, long item2) {
        this.lock.writeLock().lock();
        try {
            RoaringBitmap bitSet = this.map.computeIfAbsent(item1, k -> new RoaringBitmap());
            bitSet.add(item2, item2 + 1L);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long item1, long item2) {
        this.lock.writeLock().lock();
        try {
            RoaringBitmap bitSet = (RoaringBitmap)this.map.get(item1);
            if (bitSet != null) {
                bitSet.remove(item2, item2 + 1L);
                if (bitSet.isEmpty()) {
                    this.map.remove(item1, bitSet);
                }
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(long item1, long item2) {
        this.lock.readLock().lock();
        try {
            RoaringBitmap bitSet = (RoaringBitmap)this.map.get(item1);
            boolean bl = bitSet != null && bitSet.contains(item2, item2 + 1L);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeUpTo(long item1, long item2) {
        boolean bitsCleared = false;
        this.lock.writeLock().lock();
        try {
            Map.Entry<Long, RoaringBitmap> firstEntry = this.map.firstEntry();
            while (firstEntry != null && firstEntry.getKey() <= item1) {
                if (firstEntry.getKey() >= item1) {
                    RoaringBitmap bitSet = firstEntry.getValue();
                    if (bitSet != null) {
                        bitsCleared |= bitSet.contains(0L, item2);
                        bitSet.remove(0L, item2);
                        if (bitSet.isEmpty()) {
                            this.map.remove(firstEntry.getKey(), bitSet);
                            bitsCleared = true;
                        }
                    }
                    break;
                }
                this.map.remove(firstEntry.getKey(), firstEntry.getValue());
                bitsCleared = true;
                firstEntry = this.map.firstEntry();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return bitsCleared;
    }

    public <T extends Comparable<T>> Optional<T> first(LongPairSet.LongPairFunction<T> longPairConverter) {
        MutableObject result = new MutableObject(Optional.empty());
        this.processItems(longPairConverter, item -> {
            result.setValue(Optional.of(item));
            return false;
        });
        return (Optional)result.getValue();
    }

    public <T extends Comparable<T>> NavigableSet<T> items(int numberOfItems, LongPairSet.LongPairFunction<T> longPairConverter) {
        TreeSet items = new TreeSet();
        this.processItems(longPairConverter, item -> {
            items.add(item);
            return items.size() < numberOfItems;
        });
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Comparable<T>> void processItems(LongPairSet.LongPairFunction<T> longPairConverter, ItemProcessor<T> itemProcessor) {
        this.lock.readLock().lock();
        try {
            for (Map.Entry entry : this.map.entrySet()) {
                PrimitiveIterator.OfInt iterator = ((RoaringBitmap)entry.getValue()).stream().iterator();
                boolean continueProcessing = true;
                while (continueProcessing && iterator.hasNext()) {
                    Comparable item = (Comparable)longPairConverter.apply(((Long)entry.getKey()).longValue(), (long)((Integer)iterator.next()).intValue());
                    continueProcessing = itemProcessor.process(item);
                }
                if (continueProcessing) continue;
                break;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.map.isEmpty() || this.map.values().stream().allMatch(RoaringBitmap::isEmpty);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = this.map.isEmpty() ? 0 : this.map.values().stream().mapToInt(RoaringBitmap::getCardinality).sum();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public static interface ItemProcessor<T extends Comparable<T>> {
        public boolean process(T var1);
    }
}

