/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.PositionFactory;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.delayed.BucketDelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.DelayedDeliveryTrackerFactory;
import org.apache.pulsar.broker.delayed.InMemoryDelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.bucket.BucketDelayedDeliveryTracker;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.EntryAndMetadata;
import org.apache.pulsar.broker.service.EntryBatchIndexesAcks;
import org.apache.pulsar.broker.service.EntryBatchSizes;
import org.apache.pulsar.broker.service.InMemoryRedeliveryTracker;
import org.apache.pulsar.broker.service.RedeliveryTracker;
import org.apache.pulsar.broker.service.RedeliveryTrackerDisabled;
import org.apache.pulsar.broker.service.SendMessageInfo;
import org.apache.pulsar.broker.service.SharedConsumerAssignor;
import org.apache.pulsar.broker.service.Subscription;
import org.apache.pulsar.broker.service.persistent.AbstractPersistentDispatcherMultipleConsumers;
import org.apache.pulsar.broker.service.persistent.DispatchRateLimiter;
import org.apache.pulsar.broker.service.persistent.MessageRedeliveryController;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.transaction.exception.TransactionException;
import org.apache.pulsar.common.api.proto.CommandSubscribe;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.stats.TopicMetricBean;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.util.Backoff;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.FutureUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentDispatcherMultipleConsumers
extends AbstractPersistentDispatcherMultipleConsumers {
    protected final PersistentTopic topic;
    protected final ManagedCursor cursor;
    protected volatile Range<Position> lastIndividualDeletedRangeFromCursorRecovery;
    private CompletableFuture<Void> closeFuture = null;
    protected final MessageRedeliveryController redeliveryMessages;
    protected final RedeliveryTracker redeliveryTracker;
    private Optional<DelayedDeliveryTracker> delayedDeliveryTracker = Optional.empty();
    protected volatile boolean havePendingRead = false;
    protected volatile boolean havePendingReplayRead = false;
    protected volatile Position minReplayedPosition = null;
    protected boolean shouldRewindBeforeReadingOrReplaying = false;
    protected final String name;
    private boolean sendInProgress = false;
    protected static final AtomicIntegerFieldUpdater<PersistentDispatcherMultipleConsumers> TOTAL_AVAILABLE_PERMITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentDispatcherMultipleConsumers.class, "totalAvailablePermits");
    protected volatile int totalAvailablePermits = 0;
    protected volatile int readBatchSize;
    protected final Backoff readFailureBackoff;
    private static final AtomicIntegerFieldUpdater<PersistentDispatcherMultipleConsumers> TOTAL_UNACKED_MESSAGES_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentDispatcherMultipleConsumers.class, "totalUnackedMessages");
    protected volatile int totalUnackedMessages = 0;
    protected static final AtomicIntegerFieldUpdater<PersistentDispatcherMultipleConsumers> BLOCKED_DISPATCHER_ON_CURSOR_DATA_CAN_NOT_FULLY_PERSIST_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentDispatcherMultipleConsumers.class, "blockedDispatcherOnCursorDataCanNotFullyPersist");
    private volatile int blockedDispatcherOnCursorDataCanNotFullyPersist = 0;
    private volatile int blockedDispatcherOnUnackedMsgs = 0;
    protected static final AtomicIntegerFieldUpdater<PersistentDispatcherMultipleConsumers> BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PersistentDispatcherMultipleConsumers.class, "blockedDispatcherOnUnackedMsgs");
    protected Optional<DispatchRateLimiter> dispatchRateLimiter = Optional.empty();
    private AtomicBoolean isRescheduleReadInProgress = new AtomicBoolean(false);
    private final AtomicBoolean readMoreEntriesAsyncRequested = new AtomicBoolean(false);
    protected final ExecutorService dispatchMessagesThread;
    private final SharedConsumerAssignor assignor;
    protected int lastNumberOfEntriesProcessed;
    protected boolean skipNextBackoff;
    private final Backoff retryBackoff;
    private Position lastMarkDeletePositionBeforeReadMoreEntries;
    private volatile long readMoreEntriesCallCount;
    private static final Logger log = LoggerFactory.getLogger(PersistentDispatcherMultipleConsumers.class);

    public PersistentDispatcherMultipleConsumers(PersistentTopic topic, ManagedCursor cursor, Subscription subscription) {
        this(topic, cursor, subscription, true);
    }

    public PersistentDispatcherMultipleConsumers(PersistentTopic topic, ManagedCursor cursor, Subscription subscription, boolean allowOutOfOrderDelivery) {
        super(subscription, topic.getBrokerService().pulsar().getConfiguration());
        this.cursor = cursor;
        this.lastIndividualDeletedRangeFromCursorRecovery = cursor.getLastIndividualDeletedRange();
        this.name = topic.getName() + " / " + Codec.decode((String)cursor.getName());
        this.topic = topic;
        this.dispatchMessagesThread = topic.getBrokerService().getTopicOrderedExecutor().chooseThread();
        this.redeliveryMessages = new MessageRedeliveryController(allowOutOfOrderDelivery, false);
        this.redeliveryTracker = this.serviceConfig.isSubscriptionRedeliveryTrackerEnabled() ? new InMemoryRedeliveryTracker() : RedeliveryTrackerDisabled.REDELIVERY_TRACKER_DISABLED;
        this.readBatchSize = this.serviceConfig.getDispatcherMaxReadBatchSize();
        this.initializeDispatchRateLimiterIfNeeded();
        this.assignor = new SharedConsumerAssignor(this::getNextConsumer, this::addEntryToReplay);
        ServiceConfiguration serviceConfiguration = topic.getBrokerService().pulsar().getConfiguration();
        this.readFailureBackoff = new Backoff((long)serviceConfiguration.getDispatcherReadFailureBackoffInitialTimeInMs(), TimeUnit.MILLISECONDS, 1L, TimeUnit.MINUTES, 0L, TimeUnit.MILLISECONDS);
        this.retryBackoff = new Backoff((long)serviceConfiguration.getDispatcherRetryBackoffInitialTimeInMs(), TimeUnit.MILLISECONDS, (long)serviceConfiguration.getDispatcherRetryBackoffMaxTimeInMs(), TimeUnit.MILLISECONDS, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized CompletableFuture<Void> addConsumer(Consumer consumer) {
        if (IS_CLOSED_UPDATER.get(this) == 1) {
            log.warn("[{}] Dispatcher is already closed. Closing consumer {}", (Object)this.name, (Object)consumer);
            consumer.disconnect();
            return CompletableFuture.completedFuture(null);
        }
        if (this.consumerList.isEmpty()) {
            if (this.havePendingRead || this.havePendingReplayRead) {
                this.shouldRewindBeforeReadingOrReplaying = true;
            } else {
                this.cursor.rewind();
                this.shouldRewindBeforeReadingOrReplaying = false;
            }
            this.redeliveryMessages.clear();
            this.delayedDeliveryTracker.ifPresent(tracker -> {
                if (tracker instanceof InMemoryDelayedDeliveryTracker) {
                    tracker.clear();
                }
            });
        }
        if (this.isConsumersExceededOnSubscription()) {
            log.warn("[{}] Attempting to add consumer to subscription which reached max consumers limit {}", (Object)this.name, (Object)consumer);
            return FutureUtil.failedFuture((Throwable)new BrokerServiceException.ConsumerBusyException("Subscription reached max consumers limit"));
        }
        if (this.consumerSet.contains((Object)consumer)) {
            log.warn("[{}] Attempting to add a consumer that already registered {}", (Object)this.name, (Object)consumer);
        }
        this.consumerList.add(consumer);
        if (this.consumerList.size() > 1 && consumer.getPriorityLevel() < ((Consumer)this.consumerList.get(this.consumerList.size() - 2)).getPriorityLevel()) {
            this.consumerList.sort(Comparator.comparingInt(Consumer::getPriorityLevel));
        }
        this.consumerSet.add((Object)consumer);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected boolean isConsumersExceededOnSubscription() {
        return this.isConsumersExceededOnSubscription(this.topic, this.consumerList.size());
    }

    @Override
    public synchronized void removeConsumer(Consumer consumer) throws BrokerServiceException {
        this.addUnAckedMessages(-consumer.getUnackedMessages());
        if (this.consumerSet.removeAll((Object)consumer) == 1) {
            this.consumerList.remove(consumer);
            log.info("Removed consumer {} with pending {} acks", (Object)consumer, (Object)consumer.getPendingAcks().size());
            if (this.consumerList.isEmpty()) {
                this.clearComponentsAfterRemovedAllConsumers();
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Consumer are left, reading more entries", (Object)this.name);
                }
                MutableBoolean notifyAddedToReplay = new MutableBoolean(false);
                consumer.getPendingAcks().forEachAndClose((ledgerId, entryId, batchSize, stickyKeyHash) -> {
                    boolean addedToReplay = this.addMessageToReplay(ledgerId, entryId, stickyKeyHash);
                    if (addedToReplay) {
                        notifyAddedToReplay.setTrue();
                    }
                });
                this.totalAvailablePermits -= consumer.getAvailablePermits();
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Decreased totalAvailablePermits by {} in PersistentDispatcherMultipleConsumers. New dispatcher permit count is {}", new Object[]{this.name, consumer.getAvailablePermits(), this.totalAvailablePermits});
                }
                if (notifyAddedToReplay.booleanValue()) {
                    this.notifyRedeliveryMessageAdded();
                }
            }
        } else {
            log.error("[{}] Trying to remove a non-connected consumer: {}", (Object)this.name, (Object)consumer);
            this.consumerList.removeIf(c -> consumer.equals(c));
            if (this.consumerList.isEmpty()) {
                this.clearComponentsAfterRemovedAllConsumers();
            }
        }
    }

    protected synchronized void internalRemoveConsumer(Consumer consumer) {
        this.consumerSet.removeAll((Object)consumer);
        this.consumerList.remove(consumer);
    }

    protected synchronized void clearComponentsAfterRemovedAllConsumers() {
        this.cancelPendingRead();
        this.redeliveryMessages.clear();
        this.redeliveryTracker.clear();
        if (this.closeFuture != null) {
            log.info("[{}] All consumers removed. Subscription is disconnected", (Object)this.name);
            this.closeFuture.complete(null);
        }
        this.totalAvailablePermits = 0;
    }

    @Override
    public void consumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        this.topic.getBrokerService().executor().execute(() -> this.internalConsumerFlow(consumer, additionalNumberOfMessages));
    }

    private synchronized void internalConsumerFlow(Consumer consumer, int additionalNumberOfMessages) {
        if (!this.consumerSet.contains((Object)consumer)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Ignoring flow control from disconnected consumer {}", (Object)this.name, (Object)consumer);
            }
            return;
        }
        this.totalAvailablePermits += additionalNumberOfMessages;
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Trigger new read after receiving flow control message with permits {} after adding {} permits", new Object[]{this.name, consumer, this.totalAvailablePermits, additionalNumberOfMessages});
        }
        this.readMoreEntriesAsync();
    }

    @Override
    public void readMoreEntriesAsync() {
        if (this.readMoreEntriesAsyncRequested.compareAndSet(false, true)) {
            this.topic.getBrokerService().executor().execute(() -> {
                this.readMoreEntriesAsyncRequested.set(false);
                this.readMoreEntries();
            });
        }
    }

    public synchronized void readMoreEntries() {
        int firstAvailableConsumerPermits;
        int currentTotalAvailablePermits;
        if (this.cursor.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Cursor is already closed, skipping read more entries.", (Object)this.cursor.getName());
            }
            return;
        }
        if (this.isSendInProgress()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Skipping read for the topic, Due to sending in-progress.", (Object)this.topic.getName(), (Object)this.getSubscriptionName());
            }
            return;
        }
        if (this.shouldPauseDeliveryForDelayTracker()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Skipping read for the topic, Due to pause delivery for delay tracker.", (Object)this.topic.getName(), (Object)this.getSubscriptionName());
            }
            return;
        }
        if (this.topic.isTransferring()) {
            return;
        }
        ++this.readMoreEntriesCallCount;
        Position markDeletePosition = this.cursor.getMarkDeletedPosition();
        if (this.lastMarkDeletePositionBeforeReadMoreEntries != markDeletePosition) {
            this.redeliveryMessages.removeAllUpTo(markDeletePosition.getLedgerId(), markDeletePosition.getEntryId());
            for (Consumer consumer : this.consumerList) {
                consumer.getPendingAcks().removeAllUpTo(markDeletePosition.getLedgerId(), markDeletePosition.getEntryId());
            }
            this.lastMarkDeletePositionBeforeReadMoreEntries = markDeletePosition;
        }
        if ((currentTotalAvailablePermits = Math.max(this.totalAvailablePermits, firstAvailableConsumerPermits = this.getFirstAvailableConsumerPermits())) > 0 && firstAvailableConsumerPermits > 0) {
            Set messagesToReplayNow;
            Pair<Integer, Long> calculateResult = this.calculateToRead(currentTotalAvailablePermits);
            int messagesToRead = (Integer)calculateResult.getLeft();
            long bytesToRead = (Long)calculateResult.getRight();
            if (messagesToRead == -1 || bytesToRead == -1L) {
                return;
            }
            Set<Object> set = messagesToReplayNow = this.canReplayMessages() ? this.getMessagesToReplayNow(messagesToRead) : Collections.emptySet();
            if (!messagesToReplayNow.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Schedule replay of {} messages for {} consumers", new Object[]{this.name, messagesToReplayNow.size(), this.consumerList.size()});
                }
                this.havePendingReplayRead = true;
                this.updateMinReplayedPosition();
                Set<? extends Position> deletedMessages = this.topic.isDelayedDeliveryEnabled() ? this.asyncReplayEntriesInOrder(messagesToReplayNow) : this.asyncReplayEntries(messagesToReplayNow);
                deletedMessages.forEach(position -> this.redeliveryMessages.remove(position.getLedgerId(), position.getEntryId()));
                if (messagesToReplayNow.size() - deletedMessages.size() == 0) {
                    this.havePendingReplayRead = false;
                    this.readMoreEntriesAsync();
                }
            } else if (BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER.get(this) == 1) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Dispatcher read is blocked due to unackMessages {} reached to max {}", new Object[]{this.name, this.totalUnackedMessages, this.topic.getMaxUnackedMessagesOnSubscription()});
                }
            } else if (this.doesntHavePendingRead()) {
                if (!this.isNormalReadAllowed()) {
                    this.handleNormalReadNotAllowed();
                    return;
                }
                if (this.shouldPauseOnAckStatePersist(ReadType.Normal)) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Skipping read for the topic, Due to blocked on ack state persistent.", (Object)this.topic.getName(), (Object)this.getSubscriptionName());
                    }
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("[{}] Schedule read of {} messages for {} consumers", new Object[]{this.name, messagesToRead, this.consumerList.size()});
                }
                this.havePendingRead = true;
                this.updateMinReplayedPosition();
                messagesToRead = Math.min(messagesToRead, this.getMaxEntriesReadLimit());
                this.cursor.asyncReadEntriesWithSkipOrWait(messagesToRead, bytesToRead, (AsyncCallbacks.ReadEntriesCallback)this, (Object)ReadType.Normal, this.topic.getMaxReadPosition(), this.createReadEntriesSkipConditionForNormalRead());
            } else if (log.isDebugEnabled()) {
                log.debug("[{}] Cannot schedule next read until previous one is done", (Object)this.name);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Consumer buffer is full, pause reading", (Object)this.name);
        }
    }

    protected Predicate<Position> createReadEntriesSkipConditionForNormalRead() {
        DelayedDeliveryTracker deliveryTracker;
        Predicate<Position> skipCondition = null;
        if (this.delayedDeliveryTracker.isPresent() && (deliveryTracker = this.delayedDeliveryTracker.get()) instanceof BucketDelayedDeliveryTracker) {
            skipCondition = position -> ((BucketDelayedDeliveryTracker)deliveryTracker).containsMessage(position.getLedgerId(), position.getEntryId());
        }
        return skipCondition;
    }

    protected int getMaxEntriesReadLimit() {
        return Integer.MAX_VALUE;
    }

    protected boolean doesntHavePendingRead() {
        return !this.havePendingRead;
    }

    protected void handleNormalReadNotAllowed() {
    }

    protected long getReadMoreEntriesCallCount() {
        return this.readMoreEntriesCallCount;
    }

    protected boolean canReplayMessages() {
        return true;
    }

    private void updateMinReplayedPosition() {
        this.minReplayedPosition = this.getFirstPositionInReplay().orElse(null);
    }

    private boolean shouldPauseOnAckStatePersist(ReadType readType) {
        if (readType != ReadType.Normal) {
            return false;
        }
        if (!((PersistentTopic)this.subscription.getTopic()).isDispatcherPauseOnAckStatePersistentEnabled()) {
            return false;
        }
        if (this.cursor == null) {
            return true;
        }
        return this.blockedDispatcherOnCursorDataCanNotFullyPersist == 1;
    }

    @Override
    protected void reScheduleRead() {
        this.reScheduleReadInMs(1000L);
    }

    protected synchronized void reScheduleReadWithBackoff() {
        this.reScheduleReadInMs(this.retryBackoff.next());
    }

    protected void reScheduleReadInMs(long readAfterMs) {
        if (this.isRescheduleReadInProgress.compareAndSet(false, true)) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Reschedule message read in {} ms", new Object[]{this.topic.getName(), this.name, readAfterMs});
            }
            Runnable runnable = () -> {
                this.isRescheduleReadInProgress.set(false);
                this.readMoreEntries();
            };
            if (readAfterMs > 0L) {
                this.topic.getBrokerService().executor().schedule(runnable, readAfterMs, TimeUnit.MILLISECONDS);
            } else {
                this.topic.getBrokerService().executor().execute(runnable);
            }
        }
    }

    protected Pair<Integer, Long> calculateToRead(int currentTotalAvailablePermits) {
        int messagesToRead = Math.min(currentTotalAvailablePermits, this.readBatchSize);
        long bytesToRead = this.serviceConfig.getDispatcherMaxReadSizeBytes();
        Consumer c = this.getRandomConsumer();
        if (c != null && c.isPreciseDispatcherFlowControl()) {
            int avgMessagesPerEntry = Math.max(1, c.getAvgMessagesPerEntry());
            messagesToRead = Math.min((int)Math.ceil((double)currentTotalAvailablePermits * 1.0 / (double)avgMessagesPerEntry), this.readBatchSize);
        }
        if (!this.isConsumerWritable()) {
            messagesToRead = 1;
        }
        if (this.serviceConfig.isDispatchThrottlingOnNonBacklogConsumerEnabled() || !this.cursor.isActive()) {
            Pair<Integer, Long> calculateToRead;
            if (this.topic.getBrokerDispatchRateLimiter().isPresent()) {
                DispatchRateLimiter brokerRateLimiter = this.topic.getBrokerDispatchRateLimiter().get();
                calculateToRead = this.updateMessagesToRead(brokerRateLimiter, messagesToRead, bytesToRead);
                messagesToRead = (Integer)calculateToRead.getLeft();
                bytesToRead = (Long)calculateToRead.getRight();
                if (messagesToRead == 0 || bytesToRead == 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] message-read exceeded broker message-rate {}/{}, schedule after a {}", new Object[]{this.name, brokerRateLimiter.getDispatchRateOnMsg(), brokerRateLimiter.getDispatchRateOnByte(), 1000});
                    }
                    this.reScheduleRead();
                    return Pair.of((Object)-1, (Object)-1L);
                }
            }
            if (this.topic.getDispatchRateLimiter().isPresent()) {
                DispatchRateLimiter topicRateLimiter = this.topic.getDispatchRateLimiter().get();
                calculateToRead = this.updateMessagesToRead(topicRateLimiter, messagesToRead, bytesToRead);
                messagesToRead = (Integer)calculateToRead.getLeft();
                bytesToRead = (Long)calculateToRead.getRight();
                if (messagesToRead == 0 || bytesToRead == 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] message-read exceeded topic message-rate {}/{}, schedule after a {}", new Object[]{this.name, topicRateLimiter.getDispatchRateOnMsg(), topicRateLimiter.getDispatchRateOnByte(), 1000});
                    }
                    this.reScheduleRead();
                    return Pair.of((Object)-1, (Object)-1L);
                }
            }
            if (this.dispatchRateLimiter.isPresent()) {
                Pair<Integer, Long> calculateToRead2 = this.updateMessagesToRead(this.dispatchRateLimiter.get(), messagesToRead, bytesToRead);
                messagesToRead = (Integer)calculateToRead2.getLeft();
                bytesToRead = (Long)calculateToRead2.getRight();
                if (messagesToRead == 0 || bytesToRead == 0L) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] message-read exceeded subscription message-rate {}/{}, schedule after a {}", new Object[]{this.name, this.dispatchRateLimiter.get().getDispatchRateOnMsg(), this.dispatchRateLimiter.get().getDispatchRateOnByte(), 1000});
                    }
                    this.reScheduleRead();
                    return Pair.of((Object)-1, (Object)-1L);
                }
            }
        }
        if (this.havePendingReplayRead) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Skipping replay while awaiting previous read to complete", (Object)this.name);
            }
            return Pair.of((Object)-1, (Object)-1L);
        }
        messagesToRead = Math.max(messagesToRead, 1);
        bytesToRead = Math.max(bytesToRead, 1L);
        return Pair.of((Object)messagesToRead, (Object)bytesToRead);
    }

    protected Set<? extends Position> asyncReplayEntries(Set<? extends Position> positions) {
        return this.cursor.asyncReplayEntries(positions, (AsyncCallbacks.ReadEntriesCallback)this, (Object)ReadType.Replay);
    }

    protected Set<? extends Position> asyncReplayEntriesInOrder(Set<? extends Position> positions) {
        return this.cursor.asyncReplayEntries(positions, (AsyncCallbacks.ReadEntriesCallback)this, (Object)ReadType.Replay, true);
    }

    @Override
    public boolean isConsumerConnected() {
        return !this.consumerList.isEmpty();
    }

    @Override
    public CopyOnWriteArrayList<Consumer> getConsumers() {
        return this.consumerList;
    }

    @Override
    public synchronized boolean canUnsubscribe(Consumer consumer) {
        return this.consumerList.size() == 1 && this.consumerSet.contains((Object)consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close(boolean disconnectConsumers, Optional<BrokerLookupData> assignedBrokerLookupData) {
        Optional<DelayedDeliveryTracker> delayedDeliveryTracker;
        IS_CLOSED_UPDATER.set(this, 1);
        PersistentDispatcherMultipleConsumers persistentDispatcherMultipleConsumers = this;
        synchronized (persistentDispatcherMultipleConsumers) {
            delayedDeliveryTracker = this.delayedDeliveryTracker;
            this.delayedDeliveryTracker = Optional.empty();
        }
        delayedDeliveryTracker.ifPresent(DelayedDeliveryTracker::close);
        this.dispatchRateLimiter.ifPresent(DispatchRateLimiter::close);
        return disconnectConsumers ? this.disconnectAllConsumers(false, assignedBrokerLookupData) : CompletableFuture.completedFuture(null);
    }

    @Override
    public synchronized CompletableFuture<Void> disconnectAllConsumers(boolean isResetCursor, Optional<BrokerLookupData> assignedBrokerLookupData) {
        this.closeFuture = new CompletableFuture();
        if (this.consumerList.isEmpty()) {
            this.closeFuture.complete(null);
        } else {
            this.consumerList.forEach(consumer -> consumer.disconnect(isResetCursor, assignedBrokerLookupData));
            this.cancelPendingRead();
        }
        return this.closeFuture;
    }

    @Override
    protected void cancelPendingRead() {
        if ((this.havePendingRead || this.havePendingReplayRead) && this.cursor.cancelPendingReadRequest()) {
            this.havePendingRead = false;
            this.havePendingReplayRead = false;
        }
    }

    @Override
    public CompletableFuture<Void> disconnectActiveConsumers(boolean isResetCursor) {
        return this.disconnectAllConsumers(isResetCursor);
    }

    @Override
    public synchronized void resetCloseFuture() {
        this.closeFuture = null;
    }

    @Override
    public void reset() {
        this.resetCloseFuture();
        IS_CLOSED_UPDATER.set(this, 0);
    }

    @Override
    public CommandSubscribe.SubType getType() {
        return CommandSubscribe.SubType.Shared;
    }

    public final synchronized void readEntriesComplete(List<Entry> entries, Object ctx) {
        ReadType readType = (ReadType)((Object)ctx);
        if (readType == ReadType.Normal) {
            this.havePendingRead = false;
        } else {
            this.havePendingReplayRead = false;
        }
        if (this.readBatchSize < this.serviceConfig.getDispatcherMaxReadBatchSize()) {
            int newReadBatchSize = Math.min(this.readBatchSize * 2, this.serviceConfig.getDispatcherMaxReadBatchSize());
            if (log.isDebugEnabled()) {
                log.debug("[{}] Increasing read batch size from {} to {}", new Object[]{this.name, this.readBatchSize, newReadBatchSize});
            }
            this.readBatchSize = newReadBatchSize;
        }
        this.readFailureBackoff.reduceToHalf();
        if (this.shouldRewindBeforeReadingOrReplaying && readType == ReadType.Normal) {
            entries.forEach(Entry::release);
            this.cursor.rewind();
            this.shouldRewindBeforeReadingOrReplaying = false;
            this.readMoreEntriesAsync();
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] Distributing {} messages to {} consumers", new Object[]{this.name, entries.size(), this.consumerList.size()});
        }
        long totalBytesSize = entries.stream().mapToLong(Entry::getLength).sum();
        this.updatePendingBytesToDispatch(totalBytesSize);
        if (this.serviceConfig.isDispatcherDispatchMessagesInSubscriptionThread()) {
            this.acquireSendInProgress();
            this.dispatchMessagesThread.execute(() -> this.handleSendingMessagesAndReadingMore(readType, entries, false, totalBytesSize));
        } else {
            this.handleSendingMessagesAndReadingMore(readType, entries, true, totalBytesSize);
        }
    }

    private synchronized void handleSendingMessagesAndReadingMore(ReadType readType, List<Entry> entries, boolean needAcquireSendInProgress, long totalBytesSize) {
        boolean triggerReadingMore = this.sendMessagesToConsumers(readType, entries, needAcquireSendInProgress);
        int entriesProcessed = this.lastNumberOfEntriesProcessed;
        this.updatePendingBytesToDispatch(-totalBytesSize);
        boolean canReadMoreImmediately = false;
        if (entriesProcessed > 0 || this.skipNextBackoff) {
            this.retryBackoff.reset();
            this.skipNextBackoff = false;
            canReadMoreImmediately = true;
        }
        if (triggerReadingMore) {
            if (canReadMoreImmediately) {
                this.readMoreEntries();
            } else {
                this.reScheduleReadWithBackoff();
            }
        }
    }

    protected synchronized void acquireSendInProgress() {
        this.sendInProgress = true;
    }

    protected synchronized void releaseSendInProgress() {
        this.sendInProgress = false;
    }

    protected synchronized boolean isSendInProgress() {
        return this.sendInProgress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final synchronized boolean sendMessagesToConsumers(ReadType readType, List<Entry> entries, boolean needAcquireSendInProgress) {
        if (needAcquireSendInProgress) {
            this.acquireSendInProgress();
        }
        try {
            boolean bl = this.trySendMessagesToConsumers(readType, entries);
            return bl;
        }
        finally {
            this.releaseSendInProgress();
        }
    }

    protected synchronized boolean trySendMessagesToConsumers(ReadType readType, List<Entry> entries) {
        int avgBatchSizePerMsg;
        if (this.needTrimAckedMessages()) {
            this.cursor.trimDeletedEntries(entries);
        }
        this.lastNumberOfEntriesProcessed = 0;
        int entriesToDispatch = entries.size();
        if (entriesToDispatch == 0) {
            return true;
        }
        MessageMetadata[] metadataArray = new MessageMetadata[entries.size()];
        int remainingMessages = 0;
        boolean hasChunk = false;
        for (int i = 0; i < metadataArray.length; ++i) {
            MessageMetadata metadata;
            Entry entry2 = entries.get(i);
            if (entry2 instanceof EntryAndMetadata) {
                metadata = ((EntryAndMetadata)entry2).getMetadata();
            } else {
                metadata = Commands.peekAndCopyMessageMetadata((ByteBuf)entry2.getDataBuffer(), (String)this.subscription.toString(), (long)-1L);
                entries.set(i, EntryAndMetadata.create(entry2, metadata));
            }
            if (metadata != null) {
                remainingMessages += metadata.getNumMessagesInBatch();
                if (!hasChunk && metadata.hasUuid()) {
                    hasChunk = true;
                }
            }
            metadataArray[i] = metadata;
        }
        if (hasChunk) {
            return this.sendChunkedMessagesToConsumers(readType, entries, metadataArray);
        }
        int start = 0;
        long totalMessagesSent = 0L;
        long totalBytesSent = 0L;
        long totalEntries = 0L;
        long totalEntriesProcessed = 0L;
        int n = avgBatchSizePerMsg = remainingMessages > 0 ? Math.max(remainingMessages / entries.size(), 1) : 1;
        while (entriesToDispatch > 0 && this.isAtleastOneConsumerAvailable()) {
            int availablePermits;
            Consumer c = this.getNextConsumer();
            if (c == null) {
                log.info("[{}] rewind because no available consumer found from total {}", (Object)this.name, (Object)this.consumerList.size());
                entries.subList(start, entries.size()).forEach(Entry::release);
                this.cursor.rewind();
                this.lastNumberOfEntriesProcessed = (int)totalEntriesProcessed;
                return false;
            }
            int n2 = availablePermits = c.isWritable() ? c.getAvailablePermits() : 1;
            if (log.isDebugEnabled() && !c.isWritable()) {
                log.debug("[{}-{}] consumer is not writable. dispatching only 1 message to {}; availablePermits are {}", new Object[]{this.topic.getName(), this.name, c, c.getAvailablePermits()});
            }
            int maxMessagesInThisBatch = Math.max(remainingMessages, this.serviceConfig.getDispatcherMaxRoundRobinBatchSize());
            if (c.getMaxUnackedMessages() > 0) {
                int maxAdditionalUnackedMessages = Math.max(c.getMaxUnackedMessages() - c.getUnackedMessages(), 0);
                maxMessagesInThisBatch = Math.min(maxMessagesInThisBatch, maxAdditionalUnackedMessages);
            }
            int maxEntriesInThisBatch = Math.min(availablePermits, (maxMessagesInThisBatch + avgBatchSizePerMsg - 1) / avgBatchSizePerMsg);
            maxEntriesInThisBatch = Math.max(maxEntriesInThisBatch, 1);
            int end = Math.min(start + maxEntriesInThisBatch, entries.size());
            List<Entry> entriesForThisConsumer = entries.subList(start, end);
            if (readType == ReadType.Replay) {
                entriesForThisConsumer.forEach(entry -> this.redeliveryMessages.remove(entry.getLedgerId(), entry.getEntryId()));
            }
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(entriesForThisConsumer.size());
            EntryBatchIndexesAcks batchIndexesAcks = EntryBatchIndexesAcks.get(entriesForThisConsumer.size());
            totalEntries += (long)this.filterEntriesForConsumer(metadataArray, start, entriesForThisConsumer, batchSizes, sendMessageInfo, batchIndexesAcks, this.cursor, readType == ReadType.Replay, c);
            totalEntriesProcessed += (long)entriesForThisConsumer.size();
            c.sendMessages(entriesForThisConsumer, batchSizes, batchIndexesAcks, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.redeliveryTracker);
            int msgSent = sendMessageInfo.getTotalMessages();
            remainingMessages -= msgSent;
            start += maxEntriesInThisBatch;
            entriesToDispatch -= maxEntriesInThisBatch;
            TOTAL_AVAILABLE_PERMITS_UPDATER.addAndGet(this, -(msgSent - batchIndexesAcks.getTotalAckedIndexCount()));
            if (log.isDebugEnabled()) {
                log.debug("[{}] Added -({} minus {}) permits to TOTAL_AVAILABLE_PERMITS_UPDATER in PersistentDispatcherMultipleConsumers", new Object[]{this.name, msgSent, batchIndexesAcks.getTotalAckedIndexCount()});
            }
            totalMessagesSent += (long)sendMessageInfo.getTotalMessages();
            totalBytesSent += sendMessageInfo.getTotalBytes();
        }
        this.lastNumberOfEntriesProcessed = (int)totalEntriesProcessed;
        this.acquirePermitsForDeliveredMessages(this.topic, this.cursor, totalEntries, totalMessagesSent, totalBytesSent);
        if (entriesToDispatch > 0) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] No consumers found with available permits, storing {} positions for later replay", (Object)this.name, (Object)(entries.size() - start));
            }
            entries.subList(start, entries.size()).forEach(this::addEntryToReplay);
        }
        return true;
    }

    protected boolean addEntryToReplay(Entry entry) {
        long stickyKeyHash = this.getStickyKeyHash(entry);
        boolean addedToReplay = this.addMessageToReplay(entry.getLedgerId(), entry.getEntryId(), stickyKeyHash);
        entry.release();
        return addedToReplay;
    }

    private boolean sendChunkedMessagesToConsumers(ReadType readType, List<Entry> entries, MessageMetadata[] metadataArray) {
        ArrayList<EntryAndMetadata> originalEntryAndMetadataList = new ArrayList<EntryAndMetadata>(metadataArray.length);
        for (int i = 0; i < metadataArray.length; ++i) {
            originalEntryAndMetadataList.add(EntryAndMetadata.create(entries.get(i), metadataArray[i]));
        }
        Map<Consumer, List<EntryAndMetadata>> assignResult = this.assignor.assign(originalEntryAndMetadataList, this.consumerList.size());
        long totalMessagesSent = 0L;
        long totalBytesSent = 0L;
        long totalEntries = 0L;
        long totalEntriesProcessed = 0L;
        AtomicInteger numConsumers = new AtomicInteger(assignResult.size());
        boolean notifyAddedToReplay = false;
        for (Map.Entry<Consumer, List<EntryAndMetadata>> current : assignResult.entrySet()) {
            Consumer consumer = current.getKey();
            List<EntryAndMetadata> entryAndMetadataList = current.getValue();
            int messagesForC = Math.min(consumer.getAvailablePermits(), entryAndMetadataList.size());
            if (log.isDebugEnabled()) {
                log.debug("[{}] select consumer {} with messages num {}, read type is {}", new Object[]{this.name, consumer.consumerName(), messagesForC, readType});
            }
            if (messagesForC < entryAndMetadataList.size()) {
                for (int i = messagesForC; i < entryAndMetadataList.size(); ++i) {
                    EntryAndMetadata entry = entryAndMetadataList.get(i);
                    notifyAddedToReplay |= this.addEntryToReplay(entry);
                    entryAndMetadataList.set(i, null);
                }
            }
            if (messagesForC == 0) {
                numConsumers.decrementAndGet();
                continue;
            }
            if (readType == ReadType.Replay) {
                entryAndMetadataList.stream().limit(messagesForC).forEach(e -> this.redeliveryMessages.remove(e.getLedgerId(), e.getEntryId()));
            }
            SendMessageInfo sendMessageInfo = SendMessageInfo.getThreadLocal();
            EntryBatchSizes batchSizes = EntryBatchSizes.get(messagesForC);
            EntryBatchIndexesAcks batchIndexesAcks = EntryBatchIndexesAcks.get(messagesForC);
            totalEntries += (long)this.filterEntriesForConsumer(entryAndMetadataList, batchSizes, sendMessageInfo, batchIndexesAcks, this.cursor, readType == ReadType.Replay, consumer);
            totalEntriesProcessed += (long)entryAndMetadataList.size();
            consumer.sendMessages(entryAndMetadataList, batchSizes, batchIndexesAcks, sendMessageInfo.getTotalMessages(), sendMessageInfo.getTotalBytes(), sendMessageInfo.getTotalChunkedMessages(), this.getRedeliveryTracker()).addListener(future -> {
                if (future.isDone() && numConsumers.decrementAndGet() == 0) {
                    this.readMoreEntriesAsync();
                }
            });
            TOTAL_AVAILABLE_PERMITS_UPDATER.getAndAdd(this, -(sendMessageInfo.getTotalMessages() - batchIndexesAcks.getTotalAckedIndexCount()));
            totalMessagesSent += (long)sendMessageInfo.getTotalMessages();
            totalBytesSent += sendMessageInfo.getTotalBytes();
        }
        this.lastNumberOfEntriesProcessed = (int)totalEntriesProcessed;
        this.acquirePermitsForDeliveredMessages(this.topic, this.cursor, totalEntries, totalMessagesSent, totalBytesSent);
        return numConsumers.get() == 0 || notifyAddedToReplay;
    }

    public synchronized void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
        ReadType readType = (ReadType)((Object)ctx);
        long waitTimeMillis = this.readFailureBackoff.next();
        if (exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Cursor is already closed, skipping read more entries", (Object)this.cursor.getName());
            }
            waitTimeMillis = -1L;
        } else if (exception instanceof ManagedLedgerException.NoMoreEntriesToReadException) {
            if (this.cursor.getNumberOfEntriesInBacklog(false) == 0L) {
                this.checkAndApplyReachedEndOfTopicOrTopicMigration(this.consumerList);
            }
        } else if (exception.getCause() instanceof TransactionException.TransactionNotSealedException || exception.getCause() instanceof ManagedLedgerException.OffloadReadHandleClosedException) {
            waitTimeMillis = 1L;
            if (log.isDebugEnabled()) {
                log.debug("[{}] Error reading transaction entries : {}, Read Type {} - Retrying to read in {} seconds", new Object[]{this.name, exception.getMessage(), readType, (double)waitTimeMillis / 1000.0});
            }
        } else if (!(exception instanceof ManagedLedgerException.TooManyRequestsException)) {
            log.error("[{}] Error reading entries at {} : {}, Read Type {} - Retrying to read in {} seconds", new Object[]{this.name, this.cursor.getReadPosition(), exception.getMessage(), readType, (double)waitTimeMillis / 1000.0});
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Error reading entries at {} : {}, Read Type {} - Retrying to read in {} seconds", new Object[]{this.name, this.cursor.getReadPosition(), exception.getMessage(), readType, (double)waitTimeMillis / 1000.0});
        }
        if (this.shouldRewindBeforeReadingOrReplaying) {
            this.shouldRewindBeforeReadingOrReplaying = false;
            this.cursor.rewind();
        }
        if (readType == ReadType.Normal) {
            this.havePendingRead = false;
        } else {
            this.havePendingReplayRead = false;
            if (exception instanceof ManagedLedgerException.InvalidReplayPositionException) {
                Position markDeletePosition = this.cursor.getMarkDeletedPosition();
                this.redeliveryMessages.removeAllUpTo(markDeletePosition.getLedgerId(), markDeletePosition.getEntryId());
            }
        }
        this.readBatchSize = this.serviceConfig.getDispatcherMinReadBatchSize();
        if (waitTimeMillis >= 0L) {
            this.scheduleReadEntriesWithDelay((Exception)((Object)exception), readType, waitTimeMillis);
        }
    }

    @VisibleForTesting
    void scheduleReadEntriesWithDelay(Exception e, ReadType readType, long waitTimeMillis) {
        this.topic.getBrokerService().executor().schedule(() -> {
            PersistentDispatcherMultipleConsumers persistentDispatcherMultipleConsumers = this;
            synchronized (persistentDispatcherMultipleConsumers) {
                if (!this.havePendingRead || readType == ReadType.Replay) {
                    log.info("[{}] Retrying read operation", (Object)this.name);
                    this.readMoreEntries();
                } else {
                    log.info("[{}] Skipping read retry: havePendingRead {}", new Object[]{this.name, this.havePendingRead, e});
                }
            }
        }, waitTimeMillis, TimeUnit.MILLISECONDS);
    }

    private boolean needTrimAckedMessages() {
        if (this.lastIndividualDeletedRangeFromCursorRecovery == null) {
            return false;
        }
        return ((Position)this.lastIndividualDeletedRangeFromCursorRecovery.upperEndpoint()).compareTo(this.cursor.getReadPosition()) > 0;
    }

    protected boolean isAtleastOneConsumerAvailable() {
        return this.getFirstAvailableConsumerPermits() > 0;
    }

    protected int getFirstAvailableConsumerPermits() {
        if (this.consumerList.isEmpty() || IS_CLOSED_UPDATER.get(this) == 1) {
            return 0;
        }
        for (Consumer consumer : this.consumerList) {
            int availablePermits;
            if (consumer == null || consumer.isBlocked() || !consumer.cnx().isActive() || (availablePermits = consumer.getAvailablePermits()) <= 0) continue;
            return availablePermits;
        }
        return 0;
    }

    private boolean isConsumerWritable() {
        for (Consumer consumer : this.consumerList) {
            if (!consumer.isWritable()) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] consumer is not writable", (Object)this.topic.getName(), (Object)this.name);
        }
        return false;
    }

    @Override
    public boolean isConsumerAvailable(Consumer consumer) {
        return consumer != null && !consumer.isBlocked() && consumer.cnx().isActive() && consumer.getAvailablePermits() > 0;
    }

    @Override
    public synchronized void redeliverUnacknowledgedMessages(Consumer consumer, long consumerEpoch) {
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Redelivering unacknowledged messages for consumer {}", new Object[]{this.name, consumer, this.redeliveryMessages});
        }
        MutableBoolean addedToReplay = new MutableBoolean(false);
        consumer.getPendingAcks().forEach((ledgerId, entryId, batchSize, stickyKeyHash) -> {
            if (this.addMessageToReplay(ledgerId, entryId, stickyKeyHash)) {
                this.redeliveryTracker.incrementAndGetRedeliveryCount(PositionFactory.create((long)ledgerId, (long)entryId));
                addedToReplay.setTrue();
            }
        });
        if (addedToReplay.booleanValue()) {
            this.notifyRedeliveryMessageAdded();
        }
    }

    @Override
    public synchronized void redeliverUnacknowledgedMessages(Consumer consumer, List<Position> positions) {
        if (log.isDebugEnabled()) {
            log.debug("[{}-{}] Redelivering unacknowledged messages for consumer {}", new Object[]{this.name, consumer, positions});
        }
        MutableBoolean addedToReplay = new MutableBoolean(false);
        positions.forEach(position -> {
            if (this.addMessageToReplay(position.getLedgerId(), position.getEntryId())) {
                this.redeliveryTracker.incrementAndGetRedeliveryCount((Position)position);
                addedToReplay.setTrue();
            }
        });
        if (addedToReplay.booleanValue()) {
            this.notifyRedeliveryMessageAdded();
        }
    }

    @Override
    public void addUnAckedMessages(int numberOfMessages) {
        int unAckedMessages;
        int maxUnackedMessages = this.topic.getMaxUnackedMessagesOnSubscription();
        if (maxUnackedMessages <= 0 && this.blockedDispatcherOnUnackedMsgs == 1 && BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER.compareAndSet(this, 1, 0)) {
            log.info("[{}] Dispatcher is unblocked, since maxUnackedMessagesPerSubscription=0", (Object)this.name);
            this.readMoreEntriesAsync();
        }
        if ((unAckedMessages = TOTAL_UNACKED_MESSAGES_UPDATER.addAndGet(this, numberOfMessages)) >= maxUnackedMessages && maxUnackedMessages > 0 && BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER.compareAndSet(this, 0, 1)) {
            log.debug("[{}] Dispatcher is blocked due to unackMessages {} reached to max {}", new Object[]{this.name, unAckedMessages, maxUnackedMessages});
        } else if (this.topic.getBrokerService().isBrokerDispatchingBlocked() && this.blockedDispatcherOnUnackedMsgs == 1) {
            if (this.totalUnackedMessages < this.topic.getBrokerService().maxUnackedMsgsPerDispatcher / 2 && BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER.compareAndSet(this, 1, 0)) {
                this.topic.getBrokerService().unblockDispatchersOnUnAckMessages(Lists.newArrayList((Object[])new AbstractPersistentDispatcherMultipleConsumers[]{this}));
            }
        } else if (this.blockedDispatcherOnUnackedMsgs == 1 && unAckedMessages < maxUnackedMessages / 2 && BLOCKED_DISPATCHER_ON_UNACKMSG_UPDATER.compareAndSet(this, 1, 0)) {
            log.debug("[{}] Dispatcher is unblocked", (Object)this.name);
            this.readMoreEntriesAsync();
        }
        this.topic.getBrokerService().addUnAckedMessages(this, numberOfMessages);
    }

    @Override
    public void afterAckMessages(Throwable exOfDeletion, Object ctxOfDeletion) {
        boolean shouldPauseNow;
        boolean unPaused = this.blockedDispatcherOnCursorDataCanNotFullyPersist == 0;
        boolean bl = shouldPauseNow = !this.checkAndResumeIfPaused();
        if (unPaused && shouldPauseNow && !BLOCKED_DISPATCHER_ON_CURSOR_DATA_CAN_NOT_FULLY_PERSIST_UPDATER.compareAndSet(this, 0, 1)) {
            this.afterAckMessages(exOfDeletion, ctxOfDeletion);
        }
    }

    @Override
    public boolean checkAndResumeIfPaused() {
        boolean shouldPauseNow;
        boolean paused;
        boolean bl = paused = this.blockedDispatcherOnCursorDataCanNotFullyPersist == 1;
        if (!paused && !this.topic.isDispatcherPauseOnAckStatePersistentEnabled()) {
            return true;
        }
        boolean bl2 = shouldPauseNow = !this.cursor.isCursorDataFullyPersistable() && this.topic.isDispatcherPauseOnAckStatePersistentEnabled();
        if (paused == shouldPauseNow) {
            return !shouldPauseNow;
        }
        if (paused && !shouldPauseNow) {
            if (BLOCKED_DISPATCHER_ON_CURSOR_DATA_CAN_NOT_FULLY_PERSIST_UPDATER.compareAndSet(this, 1, 0)) {
                this.readMoreEntriesAsync();
            } else {
                this.checkAndResumeIfPaused();
            }
        }
        return !shouldPauseNow;
    }

    @Override
    public boolean isBlockedDispatcherOnUnackedMsgs() {
        return this.blockedDispatcherOnUnackedMsgs == 1;
    }

    @Override
    public void blockDispatcherOnUnackedMsgs() {
        this.blockedDispatcherOnUnackedMsgs = 1;
    }

    @Override
    public void unBlockDispatcherOnUnackedMsgs() {
        this.blockedDispatcherOnUnackedMsgs = 0;
    }

    @Override
    public int getTotalUnackedMessages() {
        return this.totalUnackedMessages;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RedeliveryTracker getRedeliveryTracker() {
        return this.redeliveryTracker;
    }

    @Override
    public Optional<DispatchRateLimiter> getRateLimiter() {
        return this.dispatchRateLimiter;
    }

    @Override
    public boolean initializeDispatchRateLimiterIfNeeded() {
        if (!this.dispatchRateLimiter.isPresent() && DispatchRateLimiter.isDispatchRateEnabled((DispatchRate)this.topic.getSubscriptionDispatchRate(this.getSubscriptionName()))) {
            this.dispatchRateLimiter = Optional.of(new DispatchRateLimiter(this.topic, this.getSubscriptionName(), DispatchRateLimiter.Type.SUBSCRIPTION));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trackDelayedDelivery(long ledgerId, long entryId, MessageMetadata msgMetadata) {
        if (!this.topic.isDelayedDeliveryEnabled()) {
            return false;
        }
        PersistentDispatcherMultipleConsumers persistentDispatcherMultipleConsumers = this;
        synchronized (persistentDispatcherMultipleConsumers) {
            if (this.delayedDeliveryTracker.isEmpty()) {
                if (!msgMetadata.hasDeliverAtTime()) {
                    return false;
                }
                this.delayedDeliveryTracker = Optional.of(this.topic.getBrokerService().getDelayedDeliveryTrackerFactory().newTracker(this));
            }
            this.delayedDeliveryTracker.get().resetTickTime(this.topic.getDelayedDeliveryTickTimeMillis());
            long deliverAtTime = msgMetadata.hasDeliverAtTime() ? msgMetadata.getDeliverAtTime() : -1L;
            return this.delayedDeliveryTracker.get().addMessage(ledgerId, entryId, deliverAtTime);
        }
    }

    protected synchronized NavigableSet<Position> getMessagesToReplayNow(int maxMessagesToRead) {
        if (this.delayedDeliveryTracker.isPresent() && this.delayedDeliveryTracker.get().hasMessageAvailable()) {
            this.delayedDeliveryTracker.get().resetTickTime(this.topic.getDelayedDeliveryTickTimeMillis());
            NavigableSet<Position> messagesAvailableNow = this.delayedDeliveryTracker.get().getScheduledMessages(maxMessagesToRead);
            messagesAvailableNow.forEach(p -> this.redeliveryMessages.add(p.getLedgerId(), p.getEntryId()));
        }
        if (!this.redeliveryMessages.isEmpty()) {
            return this.redeliveryMessages.getMessagesToReplayNow(maxMessagesToRead, this.createFilterForReplay());
        }
        return Collections.emptyNavigableSet();
    }

    protected Optional<Position> getFirstPositionInReplay() {
        return this.redeliveryMessages.getFirstPositionInReplay();
    }

    protected Predicate<Position> createFilterForReplay() {
        return position -> true;
    }

    protected boolean isNormalReadAllowed() {
        return true;
    }

    protected synchronized boolean shouldPauseDeliveryForDelayTracker() {
        return this.delayedDeliveryTracker.isPresent() && this.delayedDeliveryTracker.get().shouldPauseAllDeliveries();
    }

    @Override
    public long getNumberOfDelayedMessages() {
        return this.delayedDeliveryTracker.map(DelayedDeliveryTracker::getNumberOfDelayedMessages).orElse(0L);
    }

    @Override
    public CompletableFuture<Void> clearDelayedMessages() {
        if (!this.topic.isDelayedDeliveryEnabled()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.delayedDeliveryTracker.isPresent()) {
            return this.delayedDeliveryTracker.get().clear();
        }
        DelayedDeliveryTrackerFactory delayedDeliveryTrackerFactory = this.topic.getBrokerService().getDelayedDeliveryTrackerFactory();
        if (delayedDeliveryTrackerFactory instanceof BucketDelayedDeliveryTrackerFactory) {
            BucketDelayedDeliveryTrackerFactory bucketDelayedDeliveryTrackerFactory = (BucketDelayedDeliveryTrackerFactory)delayedDeliveryTrackerFactory;
            return bucketDelayedDeliveryTrackerFactory.cleanResidualSnapshots(this.cursor);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void cursorIsReset() {
        if (this.lastIndividualDeletedRangeFromCursorRecovery != null) {
            this.lastIndividualDeletedRangeFromCursorRecovery = null;
        }
    }

    protected boolean addMessageToReplay(long ledgerId, long entryId, long stickyKeyHash) {
        if (this.checkIfMessageIsUnacked(ledgerId, entryId)) {
            this.redeliveryMessages.add(ledgerId, entryId, stickyKeyHash);
            return true;
        }
        return false;
    }

    private void notifyRedeliveryMessageAdded() {
        this.readMoreEntriesAsync();
    }

    protected boolean addMessageToReplay(long ledgerId, long entryId) {
        if (this.checkIfMessageIsUnacked(ledgerId, entryId)) {
            this.redeliveryMessages.add(ledgerId, entryId);
            return true;
        }
        return false;
    }

    private boolean checkIfMessageIsUnacked(long ledgerId, long entryId) {
        Position markDeletePosition = this.cursor.getMarkDeletedPosition();
        return markDeletePosition == null || ledgerId > markDeletePosition.getLedgerId() || ledgerId == markDeletePosition.getLedgerId() && entryId > markDeletePosition.getEntryId();
    }

    @Override
    public boolean checkAndUnblockIfStuck() {
        if (this.cursor.checkAndUpdateReadPositionChanged()) {
            return false;
        }
        if (this.totalAvailablePermits > 0 && !this.havePendingReplayRead && !this.havePendingRead && this.cursor.getNumberOfEntriesInBacklog(false) > 0L) {
            log.warn("{}-{} Dispatcher is stuck and unblocking by issuing reads", (Object)this.topic.getName(), (Object)this.name);
            this.readMoreEntriesAsync();
            return true;
        }
        return false;
    }

    @Override
    public PersistentTopic getTopic() {
        return this.topic;
    }

    @Override
    public long getDelayedTrackerMemoryUsage() {
        return this.delayedDeliveryTracker.map(DelayedDeliveryTracker::getBufferMemoryUsage).orElse(0L);
    }

    @Override
    public Map<String, TopicMetricBean> getBucketDelayedIndexStats() {
        if (this.delayedDeliveryTracker.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.delayedDeliveryTracker.get() instanceof BucketDelayedDeliveryTracker) {
            return ((BucketDelayedDeliveryTracker)this.delayedDeliveryTracker.get()).genTopicMetricMap();
        }
        return Collections.emptyMap();
    }

    @Override
    public boolean isClassic() {
        return false;
    }

    @Override
    public ManagedCursor getCursor() {
        return this.cursor;
    }

    protected int getStickyKeyHash(Entry entry) {
        return 0;
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public long getNumberOfMessagesInReplay() {
        return this.redeliveryMessages.size();
    }

    @Override
    public boolean isHavePendingRead() {
        return this.havePendingRead;
    }

    @Override
    public boolean isHavePendingReplayRead() {
        return this.havePendingReplayRead;
    }

    protected static enum ReadType {
        Normal,
        Replay;

    }
}

