/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.service.TopicPolicyListener;
import org.apache.pulsar.common.classification.InterfaceAudience;
import org.apache.pulsar.common.classification.InterfaceStability;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.TopicPolicies;
import org.apache.pulsar.common.util.FutureUtil;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Stable
public interface TopicPoliciesService
extends AutoCloseable {
    public static final TopicPoliciesService DISABLED = new TopicPoliciesServiceDisabled();

    public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName var1);

    public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName var1, TopicPolicies var2);

    public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(TopicName var1, GetType var2);

    default public void start(PulsarService pulsar) {
    }

    @Override
    default public void close() throws Exception {
    }

    public boolean registerListener(TopicName var1, TopicPolicyListener var2);

    public void unregisterListener(TopicName var1, TopicPolicyListener var2);

    public static class TopicPoliciesServiceDisabled
    implements TopicPoliciesService {
        @Override
        public CompletableFuture<Void> deleteTopicPoliciesAsync(TopicName topicName) {
            return CompletableFuture.completedFuture(null);
        }

        @Override
        public CompletableFuture<Void> updateTopicPoliciesAsync(TopicName topicName, TopicPolicies policies) {
            return FutureUtil.failedFuture((Throwable)new UnsupportedOperationException("Topic policies service is disabled."));
        }

        @Override
        public CompletableFuture<Optional<TopicPolicies>> getTopicPoliciesAsync(TopicName topicName, GetType type) {
            return CompletableFuture.completedFuture(Optional.empty());
        }

        @Override
        public boolean registerListener(TopicName topicName, TopicPolicyListener listener) {
            return false;
        }

        @Override
        public void unregisterListener(TopicName topicName, TopicPolicyListener listener) {
        }
    }

    public static enum GetType {
        DEFAULT,
        GLOBAL_ONLY,
        LOCAL_ONLY;

    }
}

