/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Arrays;
import java.util.List;
import org.apache.pulsar.client.api.Range;

public class RemovedHashRanges {
    private final Range[] sortedRanges;

    private RemovedHashRanges(List<Range> ranges) {
        this.sortedRanges = ranges.toArray(new Range[0]);
        this.validateSortedRanges();
    }

    private void validateSortedRanges() {
        for (int i = 0; i < this.sortedRanges.length - 1; ++i) {
            if (this.sortedRanges[i].getStart() >= this.sortedRanges[i + 1].getStart()) {
                throw new IllegalArgumentException("Ranges must be sorted: " + String.valueOf(this.sortedRanges[i]) + " and " + String.valueOf(this.sortedRanges[i + 1]));
            }
            if (this.sortedRanges[i].getEnd() < this.sortedRanges[i + 1].getStart()) continue;
            throw new IllegalArgumentException("Ranges must not overlap: " + String.valueOf(this.sortedRanges[i]) + " and " + String.valueOf(this.sortedRanges[i + 1]));
        }
    }

    public static RemovedHashRanges of(List<Range> ranges) {
        return new RemovedHashRanges(ranges);
    }

    public boolean containsStickyKey(int stickyKeyHash) {
        for (Range range : this.sortedRanges) {
            if (range.contains(stickyKeyHash)) {
                return true;
            }
            if (range.getStart() <= stickyKeyHash) continue;
            return false;
        }
        return false;
    }

    public boolean isFullyContainedInRanges(List<Range> otherRanges) {
        return Arrays.stream(this.sortedRanges).allMatch(range -> otherRanges.stream().anyMatch(otherRange -> otherRange.contains(range)));
    }

    public List<Range> asRanges() {
        return Arrays.asList(this.sortedRanges);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemovedHashRanges)) {
            return false;
        }
        RemovedHashRanges other = (RemovedHashRanges)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.sortedRanges, other.sortedRanges);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RemovedHashRanges;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.sortedRanges);
        return result;
    }

    public String toString() {
        return "RemovedHashRanges(sortedRanges=" + Arrays.deepToString(this.sortedRanges) + ")";
    }
}

