/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerIdentityWrapper;
import org.apache.pulsar.common.policies.data.stats.ConsumerStatsImpl;
import org.apache.pulsar.common.policies.data.stats.DrainingHashImpl;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrainingHashesTracker {
    private static final Logger log = LoggerFactory.getLogger(DrainingHashesTracker.class);
    private final String dispatcherName;
    private final UnblockingHandler unblockingHandler;
    private final Int2ObjectOpenHashMap<DrainingHashEntry> drainingHashes = new Int2ObjectOpenHashMap();
    int batchLevel;
    boolean unblockedWhileBatching;
    private final Map<ConsumerIdentityWrapper, ConsumerDrainingHashesStats> consumerDrainingHashesStatsMap = new ConcurrentHashMap<ConsumerIdentityWrapper, ConsumerDrainingHashesStats>();

    public DrainingHashesTracker(String dispatcherName, UnblockingHandler unblockingHandler) {
        this.dispatcherName = dispatcherName;
        this.unblockingHandler = unblockingHandler;
    }

    public synchronized void addEntry(Consumer consumer, int stickyHash) {
        if (stickyHash == 0) {
            throw new IllegalArgumentException("Sticky hash cannot be 0");
        }
        DrainingHashEntry entry = (DrainingHashEntry)this.drainingHashes.get(stickyHash);
        if (entry == null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Adding and incrementing draining hash {} for consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, consumer.consumerId(), consumer.consumerName()});
            }
            entry = new DrainingHashEntry(consumer);
            this.drainingHashes.put(stickyHash, (Object)entry);
            this.consumerDrainingHashesStatsMap.computeIfAbsent(new ConsumerIdentityWrapper(consumer), k -> new ConsumerDrainingHashesStats()).addHash(stickyHash);
        } else {
            if (entry.getConsumer() != consumer) {
                throw new IllegalStateException("Consumer " + String.valueOf(entry.getConsumer()) + " is already draining hash " + stickyHash + " in dispatcher " + this.dispatcherName + ". Same hash being used for consumer " + String.valueOf(consumer) + ".");
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] Draining hash {} incrementing {} consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, entry.refCount + 1, consumer.consumerId(), consumer.consumerName()});
            }
        }
        entry.incrementRefCount();
    }

    public synchronized void startBatch() {
        ++this.batchLevel;
    }

    public synchronized void endBatch() {
        if (--this.batchLevel == 0 && this.unblockedWhileBatching) {
            this.unblockedWhileBatching = false;
            this.unblockingHandler.stickyKeyHashUnblocked(-1);
        }
    }

    public synchronized void reduceRefCount(Consumer consumer, int stickyHash, boolean closing) {
        if (stickyHash == 0) {
            return;
        }
        DrainingHashEntry entry = (DrainingHashEntry)this.drainingHashes.get(stickyHash);
        if (entry == null) {
            return;
        }
        if (entry.getConsumer() != consumer) {
            throw new IllegalStateException("Consumer " + String.valueOf(entry.getConsumer()) + " is already draining hash " + stickyHash + " in dispatcher " + this.dispatcherName + ". Same hash being used for consumer " + String.valueOf(consumer) + ".");
        }
        if (entry.decrementRefCount()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Draining hash {} removing consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, consumer.consumerId(), consumer.consumerName()});
            }
            DrainingHashEntry removed = (DrainingHashEntry)this.drainingHashes.remove(stickyHash);
            ConsumerDrainingHashesStats drainingHashesStats = this.consumerDrainingHashesStatsMap.get(new ConsumerIdentityWrapper(consumer));
            if (drainingHashesStats != null) {
                drainingHashesStats.clearHash(stickyHash);
            }
            if (!closing && removed.isBlocking()) {
                if (this.batchLevel > 0) {
                    this.unblockedWhileBatching = true;
                } else {
                    this.unblockingHandler.stickyKeyHashUnblocked(stickyHash);
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug("[{}] Draining hash {} decrementing {} consumer id:{} name:{}", new Object[]{this.dispatcherName, stickyHash, entry.refCount, consumer.consumerId(), consumer.consumerName()});
        }
    }

    public synchronized boolean shouldBlockStickyKeyHash(Consumer consumer, int stickyKeyHash) {
        if (stickyKeyHash == 0) {
            log.warn("[{}] Sticky key hash is not set. Allowing dispatching", (Object)this.dispatcherName);
            return false;
        }
        DrainingHashEntry entry = (DrainingHashEntry)this.drainingHashes.get(stickyKeyHash);
        if (entry == null) {
            return false;
        }
        if (entry.getConsumer() == consumer) {
            log.info("[{}] Hash {} has been reassigned consumer {}. The draining hash entry with refCount={} will be removed.", new Object[]{this.dispatcherName, stickyKeyHash, entry.getConsumer(), entry.refCount});
            this.drainingHashes.remove(stickyKeyHash, (Object)entry);
            return false;
        }
        entry.incrementBlockedCount();
        return true;
    }

    public synchronized DrainingHashEntry getEntry(int stickyKeyHash) {
        return stickyKeyHash != 0 ? (DrainingHashEntry)this.drainingHashes.get(stickyKeyHash) : null;
    }

    public synchronized void clear() {
        this.drainingHashes.clear();
        this.consumerDrainingHashesStatsMap.clear();
    }

    public void updateConsumerStats(Consumer consumer, ConsumerStatsImpl consumerStats) {
        consumerStats.drainingHashesCount = 0;
        consumerStats.drainingHashesClearedTotal = 0L;
        consumerStats.drainingHashesUnackedMessages = 0;
        consumerStats.drainingHashes = Collections.emptyList();
        ConsumerDrainingHashesStats consumerDrainingHashesStats = this.consumerDrainingHashesStatsMap.get(new ConsumerIdentityWrapper(consumer));
        if (consumerDrainingHashesStats != null) {
            consumerDrainingHashesStats.updateConsumerStats(consumer, consumerStats);
        }
    }

    public void consumerRemoved(Consumer consumer) {
        this.consumerDrainingHashesStatsMap.remove(new ConsumerIdentityWrapper(consumer));
    }

    public static interface UnblockingHandler {
        public void stickyKeyHashUnblocked(int var1);
    }

    public static class DrainingHashEntry {
        private final Consumer consumer;
        private int refCount;
        private int blockedCount;

        DrainingHashEntry(Consumer consumer) {
            this.consumer = consumer;
        }

        public Consumer getConsumer() {
            return this.consumer;
        }

        void incrementRefCount() {
            ++this.refCount;
        }

        boolean decrementRefCount() {
            return --this.refCount == 0;
        }

        void incrementBlockedCount() {
            ++this.blockedCount;
        }

        boolean isBlocking() {
            return this.blockedCount > 0;
        }

        public String toString() {
            return "DrainingHashesTracker.DrainingHashEntry(consumer=" + String.valueOf(this.getConsumer()) + ", refCount=" + this.refCount + ", blockedCount=" + this.blockedCount + ")";
        }
    }

    private class ConsumerDrainingHashesStats {
        private final RoaringBitmap drainingHashes = new RoaringBitmap();
        long drainingHashesClearedTotal;

        private ConsumerDrainingHashesStats() {
        }

        public synchronized void addHash(int stickyHash) {
            this.drainingHashes.add(stickyHash);
        }

        public synchronized boolean clearHash(int hash) {
            this.drainingHashes.remove(hash);
            ++this.drainingHashesClearedTotal;
            boolean empty = this.drainingHashes.isEmpty();
            if (log.isDebugEnabled()) {
                log.debug("[{}] Cleared hash {} in stats. empty={} totalCleared={} hashes={}", new Object[]{DrainingHashesTracker.this.dispatcherName, hash, empty, this.drainingHashesClearedTotal, this.drainingHashes.getCardinality()});
            }
            return empty;
        }

        public synchronized void updateConsumerStats(Consumer consumer, ConsumerStatsImpl consumerStats) {
            int drainingHashesUnackedMessages = 0;
            ArrayList<DrainingHashImpl> drainingHashesStats = new ArrayList<DrainingHashImpl>();
            PrimitiveIterator.OfInt hashIterator = this.drainingHashes.stream().iterator();
            while (hashIterator.hasNext()) {
                int hash = hashIterator.nextInt();
                DrainingHashEntry entry = DrainingHashesTracker.this.getEntry(hash);
                if (entry == null) {
                    log.warn("[{}] Draining hash {} not found in the tracker for consumer {}", new Object[]{DrainingHashesTracker.this.dispatcherName, hash, consumer});
                    continue;
                }
                int unackedMessages = entry.refCount;
                DrainingHashImpl drainingHash = new DrainingHashImpl();
                drainingHash.hash = hash;
                drainingHash.unackMsgs = unackedMessages;
                drainingHash.blockedAttempts = entry.blockedCount;
                drainingHashesStats.add(drainingHash);
                drainingHashesUnackedMessages += unackedMessages;
            }
            consumerStats.drainingHashesCount = drainingHashesStats.size();
            consumerStats.drainingHashesClearedTotal = this.drainingHashesClearedTotal;
            consumerStats.drainingHashesUnackedMessages = drainingHashesUnackedMessages;
            consumerStats.drainingHashes = drainingHashesStats;
        }
    }
}

