/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pulsar.broker.service.Consumer;
import org.apache.pulsar.broker.service.ConsumerHashAssignmentsSnapshot;
import org.apache.pulsar.broker.service.ConsumerIdentityWrapper;
import org.apache.pulsar.broker.service.ConsumerNameIndexTracker;
import org.apache.pulsar.broker.service.HashRangeAssignment;
import org.apache.pulsar.broker.service.ImpactedConsumersResult;
import org.apache.pulsar.broker.service.StickyKeyConsumerSelector;
import org.apache.pulsar.client.api.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistentHashingStickyKeyConsumerSelector
implements StickyKeyConsumerSelector {
    private static final Logger log = LoggerFactory.getLogger(ConsistentHashingStickyKeyConsumerSelector.class);
    private static final String KEY_SEPARATOR = "\u0000";
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final NavigableMap<Integer, HashRingPointEntry> hashRing;
    private final ConsumerNameIndexTracker consumerNameIndexTracker = new ConsumerNameIndexTracker();
    private final int numberOfPoints;
    private final Range keyHashRange;
    private final boolean addOrRemoveReturnsImpactedConsumersResult;
    private ConsumerHashAssignmentsSnapshot consumerHashAssignmentsSnapshot;

    public ConsistentHashingStickyKeyConsumerSelector(int numberOfPoints) {
        this(numberOfPoints, false);
    }

    public ConsistentHashingStickyKeyConsumerSelector(int numberOfPoints, boolean addOrRemoveReturnsImpactedConsumersResult) {
        this(numberOfPoints, addOrRemoveReturnsImpactedConsumersResult, 65535);
    }

    public ConsistentHashingStickyKeyConsumerSelector(int numberOfPoints, boolean addOrRemoveReturnsImpactedConsumersResult, int rangeMaxValue) {
        this.addOrRemoveReturnsImpactedConsumersResult = addOrRemoveReturnsImpactedConsumersResult;
        this.hashRing = new TreeMap<Integer, HashRingPointEntry>();
        this.numberOfPoints = numberOfPoints;
        this.keyHashRange = Range.of((int)1, (int)rangeMaxValue);
        this.consumerHashAssignmentsSnapshot = addOrRemoveReturnsImpactedConsumersResult ? ConsumerHashAssignmentsSnapshot.empty() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<ImpactedConsumersResult>> addConsumer(Consumer consumer) {
        this.rwLock.writeLock().lock();
        try {
            ConsumerIdentityWrapper consumerIdentityWrapper = new ConsumerIdentityWrapper(consumer);
            int hashPointsAdded = 0;
            int hashPointCollisions = 0;
            for (int i = 0; i < this.numberOfPoints; ++i) {
                int consumerNameIndex = this.consumerNameIndexTracker.increaseConsumerRefCountAndReturnIndex(consumerIdentityWrapper);
                int hash = this.calculateHashForConsumerAndIndex(consumer, consumerNameIndex, i);
                HashRingPointEntry existing = this.hashRing.putIfAbsent(hash, new HashRingPointEntry(consumer));
                if (existing != null) {
                    ++hashPointCollisions;
                    existing.addCollidingConsumer(consumer);
                    continue;
                }
                ++hashPointsAdded;
            }
            if (hashPointsAdded == 0) {
                log.error("Failed to add consumer '{}' to the hash ring. There were {} collisions. Consider increasing the number of points ({}) per consumer by setting subscriptionKeySharedConsistentHashingReplicaPoints={}", new Object[]{consumer, hashPointCollisions, this.numberOfPoints, Math.max((int)((double)this.numberOfPoints * 1.5), this.numberOfPoints + 1)});
            }
            if (log.isDebugEnabled()) {
                log.debug("Added consumer '{}' with {} points, {} collisions", new Object[]{consumer, hashPointsAdded, hashPointCollisions});
            }
            if (!this.addOrRemoveReturnsImpactedConsumersResult) {
                CompletableFuture<Optional<ImpactedConsumersResult>> i = CompletableFuture.completedFuture(Optional.empty());
                return i;
            }
            ConsumerHashAssignmentsSnapshot assignmentsAfter = this.internalGetConsumerHashAssignmentsSnapshot();
            ImpactedConsumersResult impactedConsumers = this.consumerHashAssignmentsSnapshot.resolveImpactedConsumers(assignmentsAfter);
            this.consumerHashAssignmentsSnapshot = assignmentsAfter;
            CompletableFuture<Optional<ImpactedConsumersResult>> completableFuture = CompletableFuture.completedFuture(Optional.of(impactedConsumers));
            return completableFuture;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private int calculateHashForConsumerAndIndex(Consumer consumer, int consumerNameIndex, int hashRingPointIndex) {
        String key = consumer.consumerName() + KEY_SEPARATOR + consumerNameIndex + KEY_SEPARATOR + hashRingPointIndex;
        return this.makeStickyKeyHash(key.getBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ImpactedConsumersResult> removeConsumer(Consumer consumer) {
        this.rwLock.writeLock().lock();
        try {
            ConsumerIdentityWrapper consumerIdentityWrapper = new ConsumerIdentityWrapper(consumer);
            int consumerNameIndex = this.consumerNameIndexTracker.getTrackedIndex(consumerIdentityWrapper);
            if (consumerNameIndex > -1) {
                for (int i = 0; i < this.numberOfPoints; ++i) {
                    int hash = this.calculateHashForConsumerAndIndex(consumer, consumerNameIndex, i);
                    this.hashRing.compute(hash, (k, hashRingPointEntry) -> {
                        assert (hashRingPointEntry != null) : "hash ring entry wasn't found for hash " + hash;
                        if (hashRingPointEntry.removeConsumer(consumer)) {
                            return null;
                        }
                        return hashRingPointEntry;
                    });
                    this.consumerNameIndexTracker.decreaseConsumerRefCount(consumerIdentityWrapper);
                }
            }
            if (!this.addOrRemoveReturnsImpactedConsumersResult) {
                Optional<ImpactedConsumersResult> i = Optional.empty();
                return i;
            }
            ConsumerHashAssignmentsSnapshot assignmentsAfter = this.internalGetConsumerHashAssignmentsSnapshot();
            ImpactedConsumersResult impactedConsumers = this.consumerHashAssignmentsSnapshot.resolveImpactedConsumers(assignmentsAfter);
            this.consumerHashAssignmentsSnapshot = assignmentsAfter;
            Optional<ImpactedConsumersResult> optional = Optional.of(impactedConsumers);
            return optional;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Consumer select(int hash) {
        this.rwLock.readLock().lock();
        try {
            if (this.hashRing.isEmpty()) {
                Consumer consumer = null;
                return consumer;
            }
            Map.Entry<Integer, HashRingPointEntry> ceilingEntry = this.hashRing.ceilingEntry(hash);
            if (ceilingEntry != null) {
                Consumer consumer = ceilingEntry.getValue().selectedConsumer;
                return consumer;
            }
            Consumer consumer = this.hashRing.firstEntry().getValue().selectedConsumer;
            return consumer;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    @Override
    public Range getKeyHashRange() {
        return this.keyHashRange;
    }

    @Override
    public ConsumerHashAssignmentsSnapshot getConsumerHashAssignmentsSnapshot() {
        this.rwLock.readLock().lock();
        try {
            ConsumerHashAssignmentsSnapshot consumerHashAssignmentsSnapshot = this.consumerHashAssignmentsSnapshot != null ? this.consumerHashAssignmentsSnapshot : this.internalGetConsumerHashAssignmentsSnapshot();
            return consumerHashAssignmentsSnapshot;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private ConsumerHashAssignmentsSnapshot internalGetConsumerHashAssignmentsSnapshot() {
        if (this.hashRing.isEmpty()) {
            return ConsumerHashAssignmentsSnapshot.empty();
        }
        ArrayList<HashRangeAssignment> result = new ArrayList<HashRangeAssignment>();
        int start = this.getKeyHashRange().getStart();
        int lastKey = -1;
        Consumer previousConsumer = null;
        Range previousRange = null;
        for (Map.Entry entry : this.hashRing.entrySet()) {
            Range range;
            Consumer consumer = ((HashRingPointEntry)entry.getValue()).selectedConsumer;
            if (consumer == previousConsumer) {
                result.remove(result.size() - 1);
                range = Range.of((int)previousRange.getStart(), (int)((Integer)entry.getKey()));
            } else {
                range = Range.of((int)start, (int)((Integer)entry.getKey()));
            }
            result.add(new HashRangeAssignment(range, consumer));
            lastKey = (Integer)entry.getKey();
            start = lastKey + 1;
            previousConsumer = consumer;
            previousRange = range;
        }
        Consumer firstConsumer = this.hashRing.firstEntry().getValue().selectedConsumer;
        if (lastKey != this.getKeyHashRange().getEnd()) {
            Range range;
            if (firstConsumer == previousConsumer && previousRange.getEnd() == lastKey) {
                result.remove(result.size() - 1);
                range = Range.of((int)previousRange.getStart(), (int)this.getKeyHashRange().getEnd());
            } else {
                range = Range.of((int)(lastKey + 1), (int)this.getKeyHashRange().getEnd());
            }
            result.add(new HashRangeAssignment(range, firstConsumer));
        }
        return ConsumerHashAssignmentsSnapshot.of(result);
    }

    private static class HashRingPointEntry {
        Consumer selectedConsumer;
        private List<Consumer> collidingConsumers;

        HashRingPointEntry(Consumer selectedConsumer) {
            this.selectedConsumer = selectedConsumer;
            this.collidingConsumers = null;
        }

        void addCollidingConsumer(Consumer consumer) {
            if (this.collidingConsumers == null) {
                this.collidingConsumers = new LinkedList<Consumer>();
            }
            this.collidingConsumers.add(consumer);
        }

        boolean removeConsumer(Consumer consumer) {
            if (this.selectedConsumer == consumer) {
                if (this.collidingConsumers != null) {
                    this.selectedConsumer = this.collidingConsumers.remove(0);
                    if (this.collidingConsumers.isEmpty()) {
                        this.collidingConsumers = null;
                    }
                } else {
                    this.selectedConsumer = null;
                }
            } else if (this.collidingConsumers != null) {
                this.collidingConsumers.removeIf(c -> c == consumer);
                if (this.collidingConsumers.isEmpty()) {
                    this.collidingConsumers = null;
                }
            }
            return this.selectedConsumer == null;
        }

        public String toString() {
            return "ConsistentHashingStickyKeyConsumerSelector.HashRingPointEntry(selectedConsumer=" + String.valueOf(this.selectedConsumer) + ", collidingConsumers=" + String.valueOf(this.collidingConsumers) + ")";
        }
    }
}

