/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateTableView;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class ServiceUnitStateTableViewBase
implements ServiceUnitStateTableView {
    private static final Logger log = LoggerFactory.getLogger(ServiceUnitStateTableViewBase.class);
    protected static final String INVALID_STATE_ERROR_MSG = "The tableview has not been started.";
    private final Map<NamespaceBundle, Boolean> ownedServiceUnitsMap = new ConcurrentHashMap<NamespaceBundle, Boolean>();
    private final Set<NamespaceBundle> ownedServiceUnits = Collections.unmodifiableSet(this.ownedServiceUnitsMap.keySet());
    private String brokerId;
    private PulsarService pulsar;

    ServiceUnitStateTableViewBase() {
    }

    protected void init(PulsarService pulsar) throws MetadataStoreException {
        this.pulsar = pulsar;
        this.brokerId = pulsar.getBrokerId();
        NamespaceName heartbeatNamespace = NamespaceService.getHeartbeatNamespace(this.brokerId, pulsar.getConfiguration());
        NamespaceName heartbeatNamespaceV2 = NamespaceService.getHeartbeatNamespaceV2(this.brokerId, pulsar.getConfiguration());
        NamespaceName slaMonitorNamespace = NamespaceService.getSLAMonitorNamespace(this.brokerId, pulsar.getConfiguration());
        try {
            ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(heartbeatNamespace).thenAccept(fullBundle -> this.ownedServiceUnitsMap.put((NamespaceBundle)fullBundle, true))).thenCompose(__ -> pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(heartbeatNamespaceV2))).thenAccept(fullBundle -> this.ownedServiceUnitsMap.put((NamespaceBundle)fullBundle, true))).thenCompose(__ -> pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(slaMonitorNamespace))).thenAccept(fullBundle -> this.ownedServiceUnitsMap.put((NamespaceBundle)fullBundle, true))).thenApply(__ -> null)).get(pulsar.getConfiguration().getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new MetadataStoreException((Throwable)e);
        }
    }

    @Override
    public Set<NamespaceBundle> ownedServiceUnits() {
        return this.ownedServiceUnits;
    }

    protected void updateOwnedServiceUnits(String key, ServiceUnitStateData val) {
        NamespaceBundle namespaceBundle = LoadManagerShared.getNamespaceBundle(this.pulsar, key);
        ServiceUnitState state = ServiceUnitStateData.state(val);
        this.ownedServiceUnitsMap.compute(namespaceBundle, (k, v) -> {
            if (state == ServiceUnitState.Owned && this.brokerId.equals(val.dstBroker())) {
                return true;
            }
            if (state == ServiceUnitState.Splitting && this.brokerId.equals(val.sourceBroker())) {
                return true;
            }
            return null;
        });
    }
}

