/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.channel;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.NonNull;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateDataConflictResolver;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateTableViewBase;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreTableView;
import org.apache.pulsar.metadata.tableview.impl.MetadataStoreTableViewImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceUnitStateMetadataStoreTableViewImpl
extends ServiceUnitStateTableViewBase {
    private static final Logger log = LoggerFactory.getLogger(ServiceUnitStateMetadataStoreTableViewImpl.class);
    public static final String PATH_PREFIX = "/service_unit_state";
    private static final String VALID_PATH_REG_EX = "^\\/service_unit_state\\/.*\\/0x[0-9a-fA-F]{8}_0x[0-9a-fA-F]{8}$";
    private static final Pattern VALID_PATH_PATTERN;
    private ServiceUnitStateDataConflictResolver conflictResolver;
    private volatile MetadataStoreTableView<ServiceUnitStateData> tableview;

    @Override
    public void start(PulsarService pulsar, BiConsumer<String, ServiceUnitStateData> tailItemListener, BiConsumer<String, ServiceUnitStateData> existingItemListener) throws MetadataStoreException {
        this.init(pulsar);
        this.conflictResolver = new ServiceUnitStateDataConflictResolver();
        this.conflictResolver.setStorageType(ServiceUnitState.StorageType.MetadataStore);
        this.tableview = new MetadataStoreTableViewImpl(ServiceUnitStateData.class, pulsar.getBrokerId(), (MetadataStore)pulsar.getLocalMetadataStore(), PATH_PREFIX, this::resolveConflict, this::validateServiceUnitPath, List.of(this::updateOwnedServiceUnits, tailItemListener), List.of(this::updateOwnedServiceUnits, existingItemListener), TimeUnit.SECONDS.toMillis(pulsar.getConfiguration().getMetadataStoreOperationTimeoutSeconds()));
        this.tableview.start();
    }

    protected boolean resolveConflict(ServiceUnitStateData prev, ServiceUnitStateData cur) {
        return !this.conflictResolver.shouldKeepLeft(prev, cur);
    }

    protected boolean validateServiceUnitPath(String path) {
        try {
            Matcher matcher = VALID_PATH_PATTERN.matcher(path);
            return matcher.matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tableview != null) {
            this.tableview = null;
            log.info("Successfully closed the channel tableview.");
        }
    }

    private boolean isValidState() {
        return this.tableview != null;
    }

    @Override
    public ServiceUnitStateData get(String key) {
        if (!this.isValidState()) {
            throw new IllegalStateException("The tableview has not been started.");
        }
        return (ServiceUnitStateData)this.tableview.get(key);
    }

    @Override
    public CompletableFuture<Void> put(String key, @NonNull ServiceUnitStateData value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (!this.isValidState()) {
            return CompletableFuture.failedFuture(new IllegalStateException("The tableview has not been started."));
        }
        return this.tableview.put(key, (Object)value).exceptionally(e -> {
            if (e.getCause() instanceof MetadataStoreTableView.ConflictException) {
                return null;
            }
            throw FutureUtil.wrapToCompletionException((Throwable)e);
        });
    }

    @Override
    public void flush(long waitDurationInMillis) {
    }

    @Override
    public CompletableFuture<Void> delete(String key) {
        if (!this.isValidState()) {
            return CompletableFuture.failedFuture(new IllegalStateException("The tableview has not been started."));
        }
        return this.tableview.delete(key).exceptionally(e -> {
            if (e.getCause() instanceof MetadataStoreException.NotFoundException) {
                return null;
            }
            throw FutureUtil.wrapToCompletionException((Throwable)e);
        });
    }

    @Override
    public Set<Map.Entry<String, ServiceUnitStateData>> entrySet() {
        if (!this.isValidState()) {
            throw new IllegalStateException("The tableview has not been started.");
        }
        return this.tableview.entrySet();
    }

    static {
        try {
            VALID_PATH_PATTERN = Pattern.compile(VALID_PATH_REG_EX);
        }
        catch (PatternSyntaxException error) {
            log.error("Invalid regular expression {}", (Object)VALID_PATH_REG_EX, (Object)error);
            throw new IllegalArgumentException(error);
        }
    }
}

