/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.admin.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.broker.admin.AdminResource;
import org.apache.pulsar.broker.service.schema.BookkeeperSchemaStorage;
import org.apache.pulsar.broker.service.schema.SchemaRegistry;
import org.apache.pulsar.broker.service.schema.SchemaRegistryService;
import org.apache.pulsar.broker.web.RestException;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.internal.DefaultImplementation;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.SchemaCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SchemaMetadata;
import org.apache.pulsar.common.policies.data.TopicOperation;
import org.apache.pulsar.common.protocol.schema.GetAllVersionsSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.protocol.schema.SchemaData;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.LongSchemaVersion;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemasResourceBase
extends AdminResource {
    private final Clock clock;
    private static final Logger log = LoggerFactory.getLogger(SchemasResourceBase.class);

    public SchemasResourceBase() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    public SchemasResourceBase(Clock clock) {
        this.clock = clock;
    }

    protected static long getLongSchemaVersion(SchemaVersion schemaVersion) {
        if (schemaVersion instanceof LongSchemaVersion) {
            return ((LongSchemaVersion)schemaVersion).getVersion();
        }
        return -1L;
    }

    private String getSchemaId() {
        if (this.topicName.isPartitioned()) {
            return TopicName.get((String)this.topicName.getPartitionedTopicName()).getSchemaName();
        }
        return this.topicName.getSchemaName();
    }

    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchemaAsync(boolean authoritative) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenApply(__ -> this.getSchemaId())).thenCompose(schemaId -> this.pulsar().getSchemaRegistryService().getSchema((String)schemaId));
    }

    public CompletableFuture<SchemaRegistry.SchemaAndMetadata> getSchemaAsync(boolean authoritative, String version) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenApply(__ -> this.getSchemaId())).thenCompose(schemaId -> {
            ByteBuffer bbVersion = ByteBuffer.allocate(8);
            bbVersion.putLong(Long.parseLong(version));
            SchemaRegistryService schemaRegistryService = this.pulsar().getSchemaRegistryService();
            SchemaVersion schemaVersion = schemaRegistryService.versionFromBytes(bbVersion.array());
            return schemaRegistryService.getSchema((String)schemaId, schemaVersion);
        });
    }

    public CompletableFuture<List<SchemaRegistry.SchemaAndMetadata>> getAllSchemasAsync(boolean authoritative) {
        return this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().trimDeletedSchemaAndGetList(schemaId);
        });
    }

    public CompletableFuture<SchemaMetadata> getSchemaMetadataAsync(boolean authoritative) {
        String schemaId = this.getSchemaId();
        BookkeeperSchemaStorage storage = (BookkeeperSchemaStorage)this.pulsar().getSchemaStorage();
        return this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenCompose(__ -> storage.getSchemaMetadata(schemaId));
    }

    public CompletableFuture<SchemaVersion> deleteSchemaAsync(boolean authoritative, boolean force) {
        return this.validateDestinationAndAdminOperationAsync(authoritative).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            return this.pulsar().getSchemaRegistryService().deleteSchema(schemaId, StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)""), force);
        });
    }

    public CompletableFuture<SchemaVersion> postSchemaAsync(PostSchemaPayload payload, boolean authoritative) {
        return ((CompletableFuture)this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.PRODUCE).thenCompose(__ -> this.getSchemaCompatibilityStrategyAsyncWithoutAuth())).thenCompose(schemaCompatibilityStrategy -> {
            byte[] data;
            if (SchemaType.KEY_VALUE.name().equals(payload.getType())) {
                try {
                    data = DefaultImplementation.getDefaultImplementation().convertKeyValueDataStringToSchemaInfoSchema(payload.getSchema().getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException conversionError) {
                    throw new RestException(conversionError);
                }
            } else {
                data = payload.getSchema().getBytes(StandardCharsets.UTF_8);
            }
            return this.pulsar().getSchemaRegistryService().putSchemaIfAbsent(this.getSchemaId(), SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)schemaCompatibilityStrategy);
        });
    }

    public CompletableFuture<Pair<Boolean, SchemaCompatibilityStrategy>> testCompatibilityAsync(PostSchemaPayload payload, boolean authoritative) {
        return ((CompletableFuture)this.validateDestinationAndAdminOperationAsync(authoritative).thenCompose(__ -> this.getSchemaCompatibilityStrategyAsync())).thenCompose(strategy -> {
            String schemaId = this.getSchemaId();
            SchemaType schemaType = SchemaType.valueOf((String)payload.getType());
            byte[] data = payload.getSchema().getBytes(StandardCharsets.UTF_8);
            if (schemaType.getValue() == SchemaType.KEY_VALUE.getValue()) {
                data = SchemaUtils.convertKeyValueDataStringToSchemaInfoSchema((byte[])data);
            }
            return this.pulsar().getSchemaRegistryService().isCompatible(schemaId, SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build(), (SchemaCompatibilityStrategy)strategy).thenApply(v -> Pair.of((Object)v, (Object)strategy));
        });
    }

    public CompletableFuture<Long> getVersionBySchemaAsync(PostSchemaPayload payload, boolean authoritative) {
        return this.validateOwnershipAndOperationAsync(authoritative, TopicOperation.GET_METADATA).thenCompose(__ -> {
            String schemaId = this.getSchemaId();
            SchemaType schemaType = SchemaType.valueOf((String)payload.getType());
            byte[] data = payload.getSchema().getBytes(StandardCharsets.UTF_8);
            if (schemaType.getValue() == SchemaType.KEY_VALUE.getValue()) {
                data = SchemaUtils.convertKeyValueDataStringToSchemaInfoSchema((byte[])data);
            }
            return this.pulsar().getSchemaRegistryService().findSchemaVersion(schemaId, SchemaData.builder().data(data).isDeleted(false).timestamp(this.clock.millis()).type(SchemaType.valueOf((String)payload.getType())).user(StringUtils.defaultIfEmpty((String)this.clientAppId(), (String)"")).props(payload.getProperties()).build());
        });
    }

    @Override
    protected String domain() {
        return "persistent";
    }

    private static GetSchemaResponse convertSchemaAndMetadataToGetSchemaResponse(SchemaRegistry.SchemaAndMetadata schemaAndMetadata) {
        try {
            String schemaData = schemaAndMetadata.schema.getType() == SchemaType.KEY_VALUE ? DefaultImplementation.getDefaultImplementation().convertKeyValueSchemaInfoDataToString(DefaultImplementation.getDefaultImplementation().decodeKeyValueSchemaInfo(schemaAndMetadata.schema.toSchemaInfo())) : new String(schemaAndMetadata.schema.getData(), StandardCharsets.UTF_8);
            return GetSchemaResponse.builder().version(SchemasResourceBase.getLongSchemaVersion(schemaAndMetadata.version)).type(schemaAndMetadata.schema.getType()).timestamp(schemaAndMetadata.schema.getTimestamp()).data(schemaData).properties(schemaAndMetadata.schema.getProps()).build();
        }
        catch (IOException conversionError) {
            throw new RuntimeException(conversionError);
        }
    }

    protected GetSchemaResponse convertToSchemaResponse(SchemaRegistry.SchemaAndMetadata schema) {
        if (Objects.isNull(schema)) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schema not found");
        }
        if (schema.schema.isDeleted()) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schema is deleted");
        }
        return SchemasResourceBase.convertSchemaAndMetadataToGetSchemaResponse(schema);
    }

    protected GetAllVersionsSchemaResponse convertToAllVersionsSchemaResponse(List<SchemaRegistry.SchemaAndMetadata> schemas) {
        if (Objects.isNull(schemas)) {
            throw new RestException(Response.Status.NOT_FOUND.getStatusCode(), "Schemas not found");
        }
        return GetAllVersionsSchemaResponse.builder().getSchemaResponses(schemas.stream().map(SchemasResourceBase::convertSchemaAndMetadataToGetSchemaResponse).collect(Collectors.toList())).build();
    }

    private CompletableFuture<Void> validateDestinationAndAdminOperationAsync(boolean authoritative) {
        return this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateAdminAccessForTenantAsync(this.topicName.getTenant()));
    }

    private CompletableFuture<Void> validateOwnershipAndOperationAsync(boolean authoritative, TopicOperation operation) {
        return this.validateTopicOwnershipAsync(this.topicName, authoritative).thenCompose(__ -> this.validateTopicOperationAsync(this.topicName, operation));
    }

    protected boolean shouldPrintErrorLog(Throwable ex) {
        return SchemasResourceBase.isNot307And404Exception(ex);
    }
}

