/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.oxia.client.api;

import io.opentelemetry.api.OpenTelemetry;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.Authentication;
import io.streamnative.oxia.client.api.SyncOxiaClient;
import io.streamnative.oxia.client.api.exceptions.OxiaException;
import io.streamnative.oxia.client.api.exceptions.UnsupportedAuthenticationException;
import io.streamnative.oxia.client.internal.DefaultImplementation;
import java.io.File;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface OxiaClientBuilder {
    public static OxiaClientBuilder create(String serviceAddress) {
        return DefaultImplementation.getDefaultImplementation(serviceAddress);
    }

    public SyncOxiaClient syncClient() throws OxiaException;

    public CompletableFuture<AsyncOxiaClient> asyncClient();

    public OxiaClientBuilder requestTimeout(Duration var1);

    public OxiaClientBuilder batchLinger(Duration var1);

    public OxiaClientBuilder maxRequestsPerBatch(int var1);

    public OxiaClientBuilder namespace(String var1);

    public OxiaClientBuilder sessionTimeout(Duration var1);

    public OxiaClientBuilder clientIdentifier(String var1);

    public OxiaClientBuilder clientIdentifier(Supplier<String> var1);

    public OxiaClientBuilder openTelemetry(OpenTelemetry var1);

    public OxiaClientBuilder authentication(Authentication var1);

    public OxiaClientBuilder connectionBackoff(Duration var1, Duration var2);

    public OxiaClientBuilder authentication(String var1, String var2) throws UnsupportedAuthenticationException;

    public OxiaClientBuilder enableTls(boolean var1);

    public OxiaClientBuilder loadConfig(String var1);

    public OxiaClientBuilder loadConfig(File var1);

    public OxiaClientBuilder loadConfig(Properties var1);
}

