/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.cli.converters;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.concurrent.TimeUnit;

public final class RelativeTimeUtil {
    public static long parseRelativeTimeInSeconds(String relativeTime) {
        int timeUnit;
        if (relativeTime.isEmpty()) {
            throw new IllegalArgumentException("time cannot be empty");
        }
        int lastIndex = relativeTime.length() - 1;
        char lastChar = relativeTime.charAt(lastIndex);
        if (!Character.isAlphabetic(lastChar)) {
            timeUnit = 115;
            lastIndex = relativeTime.length();
        } else {
            timeUnit = Character.toLowerCase(lastChar);
        }
        long duration = Long.parseLong(relativeTime.substring(0, lastIndex));
        switch (timeUnit) {
            case 115: {
                return duration;
            }
            case 109: {
                return TimeUnit.MINUTES.toSeconds(duration);
            }
            case 104: {
                return TimeUnit.HOURS.toSeconds(duration);
            }
            case 100: {
                return TimeUnit.DAYS.toSeconds(duration);
            }
            case 119: {
                return 7L * TimeUnit.DAYS.toSeconds(duration);
            }
            case 121: {
                return 365L * TimeUnit.DAYS.toSeconds(duration);
            }
        }
        throw new IllegalArgumentException("Invalid time unit '" + lastChar + "'");
    }

    public static double nsToSeconds(long ns) {
        double seconds = (double)ns / 1.0E9;
        BigDecimal bd = new BigDecimal(seconds);
        return bd.setScale(3, RoundingMode.HALF_UP).doubleValue();
    }

    private RelativeTimeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

