/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.tableview.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.NonNull;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.CacheGetResult;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataCacheConfig;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.MetadataStoreTableView;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataStoreTableViewImpl<T>
implements MetadataStoreTableView<T> {
    private static final Logger log = LoggerFactory.getLogger(MetadataStoreTableViewImpl.class);
    private static final int FILL_TIMEOUT_IN_MILLIS = 300000;
    private static final int MAX_CONCURRENT_METADATA_OPS_DURING_FILL = 50;
    private static final long CACHE_REFRESH_FREQUENCY_IN_MILLIS = 600000L;
    private final ConcurrentMap<String, T> data;
    private final Map<String, T> immutableData;
    private final String name;
    private final MetadataStore store;
    private final MetadataCache<T> cache;
    private final Predicate<String> listenPathValidator;
    private final BiPredicate<T, T> conflictResolver;
    private final List<BiConsumer<String, T>> tailItemListeners;
    private final List<BiConsumer<String, T>> existingItemListeners;
    private final long timeoutInMillis;
    private final String pathPrefix;

    public MetadataStoreTableViewImpl(@NonNull Class<T> clazz, @NonNull String name, @NonNull MetadataStore store, @NonNull String pathPrefix, @NonNull BiPredicate<T, T> conflictResolver, Predicate<String> listenPathValidator, List<BiConsumer<String, T>> tailItemListeners, List<BiConsumer<String, T>> existingItemListeners, long timeoutInMillis) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (store == null) {
            throw new NullPointerException("store is marked non-null but is null");
        }
        if (pathPrefix == null) {
            throw new NullPointerException("pathPrefix is marked non-null but is null");
        }
        if (conflictResolver == null) {
            throw new NullPointerException("conflictResolver is marked non-null but is null");
        }
        this.name = name;
        this.data = new ConcurrentHashMap<String, T>();
        this.immutableData = Collections.unmodifiableMap(this.data);
        this.pathPrefix = pathPrefix;
        this.conflictResolver = conflictResolver;
        this.listenPathValidator = listenPathValidator;
        this.tailItemListeners = new ArrayList<BiConsumer<String, T>>();
        if (tailItemListeners != null) {
            this.tailItemListeners.addAll(tailItemListeners);
        }
        this.existingItemListeners = new ArrayList<BiConsumer<String, T>>();
        if (existingItemListeners != null) {
            this.existingItemListeners.addAll(existingItemListeners);
        }
        this.timeoutInMillis = timeoutInMillis;
        this.store = store;
        this.cache = store.getMetadataCache(clazz, MetadataCacheConfig.builder().expireAfterWriteMillis(-1L).refreshAfterWriteMillis(600000L).asyncReloadConsumer(this::consumeAsyncReload).build());
        store.registerListener(this::handleNotification);
    }

    @Override
    public void start() throws MetadataStoreException {
        this.fill();
    }

    private void consumeAsyncReload(String path, Optional<CacheGetResult<T>> cached) {
        if (!this.isValidPath(path)) {
            return;
        }
        String key = this.getKey(path);
        T val = this.getValue(cached);
        this.handleTailItem(key, val);
    }

    private boolean isValidPath(String path) {
        return this.listenPathValidator == null || this.listenPathValidator.test(path);
    }

    private T getValue(Optional<CacheGetResult<T>> cached) {
        return cached.map(CacheGetResult::getValue).orElse(null);
    }

    boolean updateData(String key, T cur) {
        MutableBoolean updated = new MutableBoolean();
        this.data.compute(key, (k, prev) -> {
            if (Objects.equals(prev, cur)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} skipped item key={} value={} prev={}", new Object[]{this.name, key, cur, prev});
                }
                updated.setValue(false);
                return prev;
            }
            updated.setValue(true);
            return cur;
        });
        return updated.booleanValue();
    }

    private void handleTailItem(String key, T val) {
        if (this.updateData(key, val)) {
            if (log.isDebugEnabled()) {
                log.debug("{} applying item key={} value={}", new Object[]{this.name, key, val});
            }
            for (BiConsumer<String, String> biConsumer : this.tailItemListeners) {
                try {
                    biConsumer.accept(key, (String)val);
                }
                catch (Throwable e) {
                    log.error("{} failed to listen tail item key:{}, val:{}", new Object[]{this.name, key, val, e});
                }
            }
        }
    }

    private CompletableFuture<Void> doHandleNotification(String path) {
        if (!this.isValidPath(path)) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.cache.get(path).thenAccept(valOpt -> {
            String key = this.getKey(path);
            T val = valOpt.orElse(null);
            this.handleTailItem(key, val);
        })).exceptionally(e -> {
            log.error("{} failed to handle notification for path:{}", new Object[]{this.name, path, e});
            return null;
        });
    }

    private void handleNotification(Notification notification) {
        if (notification.getType() == NotificationType.ChildrenChanged) {
            return;
        }
        String path = notification.getPath();
        this.doHandleNotification(path);
    }

    private CompletableFuture<Void> handleExisting(String path) {
        if (!this.isValidPath(path)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.cache.get(path).thenAccept(valOpt -> valOpt.ifPresent(val -> {
            String key = this.getKey(path);
            this.updateData(key, val);
            if (log.isDebugEnabled()) {
                log.debug("{} applying existing item key={} value={}", new Object[]{this.name, key, val});
            }
            for (BiConsumer<String, String> biConsumer : this.existingItemListeners) {
                try {
                    biConsumer.accept(key, (String)val);
                }
                catch (Throwable e) {
                    log.error("{} failed to listen existing item key:{}, val:{}", new Object[]{this.name, key, val, e});
                    throw e;
                }
            }
        }));
    }

    private void fill() throws MetadataStoreException {
        long deadline = System.currentTimeMillis() + 300000L;
        log.info("{} start filling existing items under the pathPrefix:{}", (Object)this.name, (Object)this.pathPrefix);
        ConcurrentLinkedDeque<String> q = new ConcurrentLinkedDeque<String>();
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        q.add(this.pathPrefix);
        LongAdder count = new LongAdder();
        while (!q.isEmpty()) {
            long now = System.currentTimeMillis();
            if (now >= deadline) {
                String err = this.name + " failed to fill existing items in " + TimeUnit.MILLISECONDS.toSeconds(300000L) + " secs. Filled count:" + count.sum();
                log.error(err);
                throw new MetadataStoreException(err);
            }
            int size = Math.min(50, q.size());
            for (int i = 0; i < size; ++i) {
                String path = (String)q.poll();
                futures.add(this.store.getChildren(path).thenCompose(children -> {
                    if (children.isEmpty()) {
                        count.increment();
                        return this.handleExisting(path);
                    }
                    for (String child : children) {
                        q.add(path + "/" + child);
                    }
                    return CompletableFuture.completedFuture(null);
                }));
            }
            try {
                FutureUtil.waitForAll(futures).get(Math.min(this.timeoutInMillis, deadline - now), TimeUnit.MILLISECONDS);
            }
            catch (Throwable e) {
                Throwable c = FutureUtil.unwrapCompletionException((Throwable)e);
                log.error("{} failed to fill existing items", (Object)this.name, (Object)c);
                throw new MetadataStoreException(c);
            }
            futures.clear();
        }
        log.info("{} completed filling existing items with size:{}", (Object)this.name, (Object)count.sum());
    }

    private String getPath(String key) {
        return this.pathPrefix + "/" + key;
    }

    private String getKey(String path) {
        return path.replaceFirst(this.pathPrefix + "/", "");
    }

    public boolean exists(String key) {
        return this.immutableData.containsKey(key);
    }

    @Override
    public T get(String key) {
        return (T)this.data.get(key);
    }

    @Override
    public CompletableFuture<Void> put(String key, T value) {
        String path = this.getPath(key);
        return this.cache.readModifyUpdateOrCreate(path, old -> {
            if (this.conflictResolver.test(old.orElse(null), value)) {
                return value;
            }
            throw new MetadataStoreTableView.ConflictException(String.format("Failed to update from old:%s to value:%s", old, value));
        }).thenCompose(__ -> this.doHandleNotification(path));
    }

    @Override
    public CompletableFuture<Void> delete(String key) {
        String path = this.getPath(key);
        return this.cache.delete(path).thenCompose(__ -> this.doHandleNotification(path));
    }

    public int size() {
        return this.immutableData.size();
    }

    public boolean isEmpty() {
        return this.immutableData.isEmpty();
    }

    @Override
    public Set<Map.Entry<String, T>> entrySet() {
        return this.immutableData.entrySet();
    }

    public Set<String> keySet() {
        return this.immutableData.keySet();
    }

    public Collection<T> values() {
        return this.immutableData.values();
    }

    public void forEach(BiConsumer<String, T> action) {
        this.immutableData.forEach(action);
    }

    public static <T> MetadataStoreTableViewImplBuilder<T> builder() {
        return new MetadataStoreTableViewImplBuilder();
    }

    public static class MetadataStoreTableViewImplBuilder<T> {
        private Class<T> clazz;
        private String name;
        private MetadataStore store;
        private String pathPrefix;
        private BiPredicate<T, T> conflictResolver;
        private Predicate<String> listenPathValidator;
        private List<BiConsumer<String, T>> tailItemListeners;
        private List<BiConsumer<String, T>> existingItemListeners;
        private long timeoutInMillis;

        MetadataStoreTableViewImplBuilder() {
        }

        public MetadataStoreTableViewImplBuilder<T> clazz(@NonNull Class<T> clazz) {
            if (clazz == null) {
                throw new NullPointerException("clazz is marked non-null but is null");
            }
            this.clazz = clazz;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> store(@NonNull MetadataStore store) {
            if (store == null) {
                throw new NullPointerException("store is marked non-null but is null");
            }
            this.store = store;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> pathPrefix(@NonNull String pathPrefix) {
            if (pathPrefix == null) {
                throw new NullPointerException("pathPrefix is marked non-null but is null");
            }
            this.pathPrefix = pathPrefix;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> conflictResolver(@NonNull BiPredicate<T, T> conflictResolver) {
            if (conflictResolver == null) {
                throw new NullPointerException("conflictResolver is marked non-null but is null");
            }
            this.conflictResolver = conflictResolver;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> listenPathValidator(Predicate<String> listenPathValidator) {
            this.listenPathValidator = listenPathValidator;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> tailItemListeners(List<BiConsumer<String, T>> tailItemListeners) {
            this.tailItemListeners = tailItemListeners;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> existingItemListeners(List<BiConsumer<String, T>> existingItemListeners) {
            this.existingItemListeners = existingItemListeners;
            return this;
        }

        public MetadataStoreTableViewImplBuilder<T> timeoutInMillis(long timeoutInMillis) {
            this.timeoutInMillis = timeoutInMillis;
            return this;
        }

        public MetadataStoreTableViewImpl<T> build() {
            return new MetadataStoreTableViewImpl<T>(this.clazz, this.name, this.store, this.pathPrefix, this.conflictResolver, this.listenPathValidator, this.tailItemListeners, this.existingItemListeners, this.timeoutInMillis);
        }

        public String toString() {
            return "MetadataStoreTableViewImpl.MetadataStoreTableViewImplBuilder(clazz=" + String.valueOf(this.clazz) + ", name=" + this.name + ", store=" + String.valueOf(this.store) + ", pathPrefix=" + this.pathPrefix + ", conflictResolver=" + String.valueOf(this.conflictResolver) + ", listenPathValidator=" + String.valueOf(this.listenPathValidator) + ", tailItemListeners=" + String.valueOf(this.tailItemListeners) + ", existingItemListeners=" + String.valueOf(this.existingItemListeners) + ", timeoutInMillis=" + this.timeoutInMillis + ")";
        }
    }
}

