/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl.oxia;

import io.opentelemetry.api.OpenTelemetry;
import io.streamnative.oxia.client.api.AsyncOxiaClient;
import io.streamnative.oxia.client.api.DeleteOption;
import io.streamnative.oxia.client.api.GetResult;
import io.streamnative.oxia.client.api.Notification;
import io.streamnative.oxia.client.api.OxiaClientBuilder;
import io.streamnative.oxia.client.api.PutOption;
import io.streamnative.oxia.client.api.PutResult;
import io.streamnative.oxia.client.api.Version;
import io.streamnative.oxia.client.api.exceptions.KeyAlreadyExistsException;
import io.streamnative.oxia.client.api.exceptions.UnexpectedVersionIdException;
import java.time.Duration;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OxiaMetadataStore
extends AbstractMetadataStore {
    private static final Logger log = LoggerFactory.getLogger(OxiaMetadataStore.class);
    private final AsyncOxiaClient client;
    private final String identity;
    private Optional<MetadataEventSynchronizer> synchronizer;
    private static final byte[] EMPTY_VALUE = new byte[0];
    private static final Set<PutOption> IF_RECORD_DOES_NOT_EXIST = Collections.singleton(PutOption.IfRecordDoesNotExist);

    public OxiaMetadataStore(AsyncOxiaClient oxia, String identity) {
        super("oxia-metadata", OpenTelemetry.noop());
        this.client = oxia;
        this.identity = identity;
        this.synchronizer = Optional.empty();
        this.init();
    }

    public OxiaMetadataStore(@NonNull String serviceAddress, @NonNull String namespace, MetadataStoreConfig metadataStoreConfig, boolean enableSessionWatcher) throws Exception {
        super("oxia-metadata", Objects.requireNonNull(metadataStoreConfig).getOpenTelemetry());
        if (serviceAddress == null) {
            throw new NullPointerException("serviceAddress is marked non-null but is null");
        }
        if (namespace == null) {
            throw new NullPointerException("namespace is marked non-null but is null");
        }
        int linger = metadataStoreConfig.getBatchingMaxDelayMillis();
        if (!metadataStoreConfig.isBatchingEnabled()) {
            linger = 0;
        }
        this.synchronizer = Optional.ofNullable(metadataStoreConfig.getSynchronizer());
        this.identity = UUID.randomUUID().toString();
        OxiaClientBuilder oxiaClientBuilder = OxiaClientBuilder.create((String)serviceAddress).clientIdentifier(this.identity).namespace(namespace).sessionTimeout(Duration.ofMillis(metadataStoreConfig.getSessionTimeoutMillis())).batchLinger(Duration.ofMillis(linger)).maxRequestsPerBatch(metadataStoreConfig.getBatchingMaxOperations());
        if (StringUtils.isNotBlank((CharSequence)metadataStoreConfig.getConfigFilePath())) {
            oxiaClientBuilder.loadConfig(metadataStoreConfig.getConfigFilePath());
        }
        this.client = (AsyncOxiaClient)oxiaClientBuilder.asyncClient().get();
        this.init();
    }

    private void init() {
        this.updateMetadataEventSynchronizer(this.synchronizer.orElse(null));
        this.client.notifications(this::notificationCallback);
        super.registerSyncListener(this.synchronizer);
    }

    private void notificationCallback(Notification notification) {
        if (notification instanceof Notification.KeyCreated) {
            Notification.KeyCreated keyCreated = (Notification.KeyCreated)notification;
            this.receivedNotification(new org.apache.pulsar.metadata.api.Notification(NotificationType.Created, keyCreated.key()));
            this.notifyParentChildrenChanged(keyCreated.key());
        } else if (notification instanceof Notification.KeyModified) {
            Notification.KeyModified keyModified = (Notification.KeyModified)notification;
            this.receivedNotification(new org.apache.pulsar.metadata.api.Notification(NotificationType.Modified, keyModified.key()));
        } else if (notification instanceof Notification.KeyDeleted) {
            Notification.KeyDeleted keyDeleted = (Notification.KeyDeleted)notification;
            this.receivedNotification(new org.apache.pulsar.metadata.api.Notification(NotificationType.Deleted, keyDeleted.key()));
            this.notifyParentChildrenChanged(keyDeleted.key());
        } else {
            log.error("Unknown notification type {}", (Object)notification);
        }
    }

    Optional<org.apache.pulsar.metadata.api.GetResult> convertGetResult(String path, GetResult result) {
        if (result == null) {
            return Optional.empty();
        }
        return Optional.of(result).map(oxiaResult -> new org.apache.pulsar.metadata.api.GetResult(oxiaResult.getValue(), this.convertStat(path, oxiaResult.getVersion())));
    }

    Stat convertStat(String path, Version version) {
        return new Stat(path, version.versionId(), version.createdTimestamp(), version.modifiedTimestamp(), version.sessionId().isPresent(), version.clientIdentifier().stream().anyMatch(this.identity::equals), version.modificationsCount() == 0L);
    }

    @Override
    protected CompletableFuture<List<String>> getChildrenFromStore(String path) {
        String pathWithSlash = path + "/";
        return ((CompletableFuture)this.client.list(pathWithSlash, pathWithSlash + "/").thenApply(children -> children.stream().map(child -> child.substring(pathWithSlash.length())).toList())).exceptionallyCompose(this::convertException);
    }

    @Override
    protected CompletableFuture<Boolean> existsFromStore(String path) {
        return ((CompletableFuture)this.client.get(path).thenApply(Objects::nonNull)).exceptionallyCompose(this::convertException);
    }

    @Override
    protected CompletableFuture<Optional<org.apache.pulsar.metadata.api.GetResult>> storeGet(String path) {
        return ((CompletableFuture)this.client.get(path).thenApply(res -> this.convertGetResult(path, (GetResult)res))).exceptionallyCompose(this::convertException);
    }

    @Override
    protected CompletableFuture<Void> storeDelete(String path, Optional<Long> expectedVersion) {
        return this.getChildrenFromStore(path).thenCompose(children -> {
            if (!children.isEmpty()) {
                return CompletableFuture.failedFuture(new MetadataStoreException("Key '" + path + "' has children"));
            }
            Set delOption = expectedVersion.map(v -> Collections.singleton(DeleteOption.IfVersionIdEquals((long)v))).orElse(Collections.emptySet());
            CompletableFuture result = this.client.delete(path, delOption);
            return ((CompletableFuture)result.thenCompose(exists -> {
                if (!exists.booleanValue()) {
                    return CompletableFuture.failedFuture(new MetadataStoreException.NotFoundException("Key '" + path + "' does not exist"));
                }
                return CompletableFuture.completedFuture(null);
            })).exceptionallyCompose(this::convertException);
        });
    }

    @Override
    protected CompletableFuture<Stat> storePut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
        CompletableFuture<Void> parentsCreated = this.createParents(path);
        return parentsCreated.thenCompose(__ -> {
            CompletionStage<String> actualPath;
            Optional<Long> expectedVersion = optExpectedVersion;
            if (expectedVersion.isPresent() && (Long)expectedVersion.get() != -1L && options.contains((Object)CreateOption.Sequential)) {
                return CompletableFuture.failedFuture(new MetadataStoreException("Can't have expectedVersion and Sequential at the same time"));
            }
            if (options.contains((Object)CreateOption.Sequential)) {
                String parent = OxiaMetadataStore.parent(path);
                String parentPath = parent == null ? "/" : parent;
                actualPath = this.client.put(parentPath, new byte[0]).thenApply(r -> String.format("%s%010d", path, r.version().modificationsCount()));
                expectedVersion = Optional.of(-1L);
            } else {
                actualPath = CompletableFuture.completedFuture(path);
            }
            HashSet<PutOption> putOptions = new HashSet<PutOption>();
            expectedVersion.map(ver -> {
                if (ver == -1L) {
                    return PutOption.IfRecordDoesNotExist;
                }
                return PutOption.IfVersionIdEquals((long)ver);
            }).ifPresent(putOptions::add);
            if (options.contains((Object)CreateOption.Ephemeral)) {
                putOptions.add(PutOption.AsEphemeralRecord);
            }
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)actualPath).thenCompose(aPath -> this.client.put(aPath, data, putOptions).thenApply(res -> new PathWithPutResult((String)aPath, (PutResult)res)))).thenApply(res -> this.convertStat(res.path(), res.result().version()))).exceptionallyCompose(this::convertException);
        });
    }

    private <T> CompletionStage<T> convertException(Throwable ex) {
        Throwable actEx = FutureUtil.unwrapCompletionException((Throwable)ex);
        if (actEx instanceof UnexpectedVersionIdException || actEx instanceof KeyAlreadyExistsException) {
            return CompletableFuture.failedFuture(new MetadataStoreException.BadVersionException(actEx));
        }
        if (actEx instanceof IllegalStateException) {
            return CompletableFuture.failedFuture(new MetadataStoreException.AlreadyClosedException(actEx));
        }
        if (actEx instanceof MetadataStoreException) {
            return CompletableFuture.failedFuture(actEx);
        }
        return CompletableFuture.failedFuture(new MetadataStoreException(actEx));
    }

    private CompletableFuture<Void> createParents(String path) {
        String parent = OxiaMetadataStore.parent(path);
        if (parent == null || parent.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return ((CompletableFuture)this.exists(parent).thenCompose(exists -> {
            if (exists.booleanValue()) {
                return CompletableFuture.completedFuture(null);
            }
            return this.client.put(parent, EMPTY_VALUE, IF_RECORD_DOES_NOT_EXIST).thenCompose(__ -> this.createParents(parent));
        })).exceptionallyCompose(ex -> {
            if (ex.getCause() instanceof KeyAlreadyExistsException) {
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.failedFuture(ex.getCause());
        });
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
        super.close();
    }

    @Override
    public Optional<MetadataEventSynchronizer> getMetadataEventSynchronizer() {
        return this.synchronizer;
    }

    @Override
    public void updateMetadataEventSynchronizer(MetadataEventSynchronizer synchronizer) {
        this.synchronizer = Optional.ofNullable(synchronizer);
        this.registerSyncListener(this.synchronizer);
    }

    private record PathWithPutResult(String path, PutResult result) {
    }
}

