/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.impl;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.GetResult;
import org.apache.pulsar.metadata.api.MetadataEventSynchronizer;
import org.apache.pulsar.metadata.api.MetadataStoreConfig;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.NotificationType;
import org.apache.pulsar.metadata.api.Stat;
import org.apache.pulsar.metadata.api.extended.CreateOption;
import org.apache.pulsar.metadata.api.extended.MetadataStoreExtended;
import org.apache.pulsar.metadata.impl.AbstractMetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMemoryMetadataStore
extends AbstractMetadataStore
implements MetadataStoreExtended {
    private static final Logger log = LoggerFactory.getLogger(LocalMemoryMetadataStore.class);
    static final String MEMORY_SCHEME = "memory";
    static final String MEMORY_SCHEME_IDENTIFIER = "memory:";
    private final NavigableMap<String, Value> map;
    private final AtomicLong sequentialIdGenerator;
    private MetadataEventSynchronizer synchronizer;
    private static final Map<String, NavigableMap<String, Value>> STATIC_MAPS = new MapMaker().weakValues().makeMap();
    private static final Map<String, Set<AbstractMetadataStore>> STATIC_INSTANCE = new MapMaker().weakValues().makeMap();
    private static final Map<String, AtomicLong> STATIC_ID_GEN_MAP = new MapMaker().weakValues().makeMap();

    public LocalMemoryMetadataStore(String metadataURL, MetadataStoreConfig metadataStoreConfig) throws MetadataStoreException {
        super(metadataStoreConfig.getMetadataStoreName(), metadataStoreConfig.getOpenTelemetry());
        String name = metadataURL.substring(MEMORY_SCHEME_IDENTIFIER.length());
        this.updateMetadataEventSynchronizer(metadataStoreConfig.getSynchronizer());
        if ("local".equals(name)) {
            this.map = new TreeMap<String, Value>();
            this.sequentialIdGenerator = new AtomicLong();
        } else {
            this.map = STATIC_MAPS.computeIfAbsent(name, __ -> new TreeMap());
            STATIC_INSTANCE.compute(name, (key, value) -> {
                if (value == null) {
                    value = new HashSet<LocalMemoryMetadataStore>();
                }
                value.forEach(v -> {
                    this.registerListener((Consumer<Notification>)v);
                    v.registerListener(this);
                });
                value.add(this);
                return value;
            });
            this.sequentialIdGenerator = STATIC_ID_GEN_MAP.computeIfAbsent(name, __ -> new AtomicLong());
            log.info("Created LocalMemoryDataStore for '{}'", (Object)name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Optional<GetResult>> storeGet(String path) {
        NavigableMap<String, Value> navigableMap = this.map;
        synchronized (navigableMap) {
            Value v = (Value)this.map.get(path);
            if (v != null) {
                return FutureUtils.value(Optional.of(new GetResult(v.data, new Stat(path, v.version, v.createdTimestamp, v.modifiedTimestamp, v.isEphemeral(), true))));
            }
            return FutureUtils.value(Optional.empty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<List<String>> getChildrenFromStore(String path) {
        if (!LocalMemoryMetadataStore.isValidPath(path)) {
            return FutureUtil.failedFuture((Throwable)new MetadataStoreException.InvalidPathException(path));
        }
        NavigableMap<String, Value> navigableMap = this.map;
        synchronized (navigableMap) {
            Object firstKey = path.equals("/") ? path : path + "/";
            Object lastKey = path.equals("/") ? "0" : path + "0";
            TreeSet children = new TreeSet();
            this.map.subMap((String)firstKey, false, (String)lastKey, false).forEach((arg_0, arg_1) -> LocalMemoryMetadataStore.lambda$getChildrenFromStore$4((String)firstKey, children, arg_0, arg_1));
            return FutureUtils.value(new ArrayList(children));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> existsFromStore(String path) {
        if (!LocalMemoryMetadataStore.isValidPath(path)) {
            return FutureUtil.failedFuture((Throwable)new MetadataStoreException.InvalidPathException(path));
        }
        NavigableMap<String, Value> navigableMap = this.map;
        synchronized (navigableMap) {
            Value v = (Value)this.map.get(path);
            return FutureUtils.value((Object)(v != null ? 1 : 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Stat> storePut(String path, byte[] data, Optional<Long> optExpectedVersion, EnumSet<CreateOption> options) {
        if (!LocalMemoryMetadataStore.isValidPath((String)path)) {
            return FutureUtil.failedFuture((Throwable)new MetadataStoreException.InvalidPathException((String)path));
        }
        NavigableMap<String, Value> navigableMap = this.map;
        synchronized (navigableMap) {
            long existingVersion;
            boolean hasVersion = optExpectedVersion.isPresent();
            int expectedVersion = optExpectedVersion.orElse(-1L).intValue();
            if (options.contains((Object)CreateOption.Sequential)) {
                path = (String)path + Long.toString(this.sequentialIdGenerator.getAndIncrement());
            }
            long now = System.currentTimeMillis();
            if (hasVersion && expectedVersion == -1) {
                Value newValue = new Value(0L, data, now, now, options.contains((Object)CreateOption.Ephemeral));
                Value existingValue = this.map.putIfAbsent((String)path, newValue);
                if (existingValue != null) {
                    return FutureUtils.exception((Throwable)new MetadataStoreException.BadVersionException(""));
                }
                this.receivedNotification(new Notification(NotificationType.Created, (String)path));
                this.notifyParentChildrenChanged((String)path);
                return FutureUtils.value((Object)new Stat((String)path, 0L, now, now, newValue.isEphemeral(), true));
            }
            Value existingValue = (Value)this.map.get(path);
            long l = existingVersion = existingValue != null ? existingValue.version : -1L;
            if (hasVersion && (long)expectedVersion != existingVersion) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.BadVersionException(""));
            }
            long newVersion = existingValue != null ? existingValue.version + 1L : 0L;
            long createdTimestamp = existingValue != null ? existingValue.createdTimestamp : now;
            Value newValue = new Value(newVersion, data, createdTimestamp, now, options.contains((Object)CreateOption.Ephemeral));
            this.map.put((String)path, newValue);
            NotificationType type = existingValue == null ? NotificationType.Created : NotificationType.Modified;
            this.receivedNotification(new Notification(type, (String)path));
            if (type == NotificationType.Created) {
                this.notifyParentChildrenChanged((String)path);
            }
            return FutureUtils.value((Object)new Stat((String)path, newValue.version, newValue.createdTimestamp, newValue.modifiedTimestamp, false, true));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> storeDelete(String path, Optional<Long> optExpectedVersion) {
        if (!LocalMemoryMetadataStore.isValidPath(path)) {
            return FutureUtil.failedFuture((Throwable)new MetadataStoreException.InvalidPathException(path));
        }
        NavigableMap<String, Value> navigableMap = this.map;
        synchronized (navigableMap) {
            Value value = (Value)this.map.get(path);
            if (value == null) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.NotFoundException(""));
            }
            if (optExpectedVersion.isPresent() && optExpectedVersion.get() != value.version) {
                return FutureUtils.exception((Throwable)new MetadataStoreException.BadVersionException(""));
            }
            this.map.remove(path);
            this.receivedNotification(new Notification(NotificationType.Deleted, path));
            this.notifyParentChildrenChanged(path);
            return FutureUtils.value(null);
        }
    }

    @Override
    public Optional<MetadataEventSynchronizer> getMetadataEventSynchronizer() {
        return Optional.ofNullable(this.synchronizer);
    }

    @Override
    public void updateMetadataEventSynchronizer(MetadataEventSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
        this.registerSyncListener(Optional.ofNullable(synchronizer));
    }

    @Override
    public void close() throws Exception {
        if (this.isClosed.compareAndSet(false, true)) {
            super.close();
        }
    }

    private static /* synthetic */ void lambda$getChildrenFromStore$4(String firstKey, Set children, String key, Value value) {
        String relativePath = key.replaceFirst(firstKey, "");
        String child = relativePath.split("/", 2)[0];
        children.add(child);
    }

    private static class Value {
        final long version;
        final byte[] data;
        final long createdTimestamp;
        final long modifiedTimestamp;
        final boolean ephemeral;

        public Value(long version, byte[] data, long createdTimestamp, long modifiedTimestamp, boolean ephemeral) {
            this.version = version;
            this.data = data;
            this.createdTimestamp = createdTimestamp;
            this.modifiedTimestamp = modifiedTimestamp;
            this.ephemeral = ephemeral;
        }

        public long getVersion() {
            return this.version;
        }

        public byte[] getData() {
            return this.data;
        }

        public long getCreatedTimestamp() {
            return this.createdTimestamp;
        }

        public long getModifiedTimestamp() {
            return this.modifiedTimestamp;
        }

        public boolean isEphemeral() {
            return this.ephemeral;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Value)) {
                return false;
            }
            Value other = (Value)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getVersion() != other.getVersion()) {
                return false;
            }
            if (this.getCreatedTimestamp() != other.getCreatedTimestamp()) {
                return false;
            }
            if (this.getModifiedTimestamp() != other.getModifiedTimestamp()) {
                return false;
            }
            if (this.isEphemeral() != other.isEphemeral()) {
                return false;
            }
            return Arrays.equals(this.getData(), other.getData());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Value;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $version = this.getVersion();
            result = result * 59 + (int)($version >>> 32 ^ $version);
            long $createdTimestamp = this.getCreatedTimestamp();
            result = result * 59 + (int)($createdTimestamp >>> 32 ^ $createdTimestamp);
            long $modifiedTimestamp = this.getModifiedTimestamp();
            result = result * 59 + (int)($modifiedTimestamp >>> 32 ^ $modifiedTimestamp);
            result = result * 59 + (this.isEphemeral() ? 79 : 97);
            result = result * 59 + Arrays.hashCode(this.getData());
            return result;
        }

        public String toString() {
            return "LocalMemoryMetadataStore.Value(version=" + this.getVersion() + ", data=" + Arrays.toString(this.getData()) + ", createdTimestamp=" + this.getCreatedTimestamp() + ", modifiedTimestamp=" + this.getModifiedTimestamp() + ", ephemeral=" + this.isEphemeral() + ")";
        }
    }
}

