/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.api;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.apache.pulsar.metadata.api.CacheGetResult;

public class MetadataCacheConfig<T> {
    private static final long DEFAULT_CACHE_REFRESH_TIME_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private final long refreshAfterWriteMillis;
    private final long expireAfterWriteMillis;
    private final BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer;

    private static <T> long $default$refreshAfterWriteMillis() {
        return DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    private static <T> long $default$expireAfterWriteMillis() {
        return 2L * DEFAULT_CACHE_REFRESH_TIME_MILLIS;
    }

    private static <T> BiConsumer<String, Optional<CacheGetResult<T>>> $default$asyncReloadConsumer() {
        return null;
    }

    MetadataCacheConfig(long refreshAfterWriteMillis, long expireAfterWriteMillis, BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer) {
        this.refreshAfterWriteMillis = refreshAfterWriteMillis;
        this.expireAfterWriteMillis = expireAfterWriteMillis;
        this.asyncReloadConsumer = asyncReloadConsumer;
    }

    public static <T> MetadataCacheConfigBuilder<T> builder() {
        return new MetadataCacheConfigBuilder();
    }

    public long getRefreshAfterWriteMillis() {
        return this.refreshAfterWriteMillis;
    }

    public long getExpireAfterWriteMillis() {
        return this.expireAfterWriteMillis;
    }

    public BiConsumer<String, Optional<CacheGetResult<T>>> getAsyncReloadConsumer() {
        return this.asyncReloadConsumer;
    }

    public String toString() {
        return "MetadataCacheConfig(refreshAfterWriteMillis=" + this.getRefreshAfterWriteMillis() + ", expireAfterWriteMillis=" + this.getExpireAfterWriteMillis() + ", asyncReloadConsumer=" + String.valueOf(this.getAsyncReloadConsumer()) + ")";
    }

    public static class MetadataCacheConfigBuilder<T> {
        private boolean refreshAfterWriteMillis$set;
        private long refreshAfterWriteMillis$value;
        private boolean expireAfterWriteMillis$set;
        private long expireAfterWriteMillis$value;
        private boolean asyncReloadConsumer$set;
        private BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer$value;

        MetadataCacheConfigBuilder() {
        }

        public MetadataCacheConfigBuilder<T> refreshAfterWriteMillis(long refreshAfterWriteMillis) {
            this.refreshAfterWriteMillis$value = refreshAfterWriteMillis;
            this.refreshAfterWriteMillis$set = true;
            return this;
        }

        public MetadataCacheConfigBuilder<T> expireAfterWriteMillis(long expireAfterWriteMillis) {
            this.expireAfterWriteMillis$value = expireAfterWriteMillis;
            this.expireAfterWriteMillis$set = true;
            return this;
        }

        public MetadataCacheConfigBuilder<T> asyncReloadConsumer(BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer) {
            this.asyncReloadConsumer$value = asyncReloadConsumer;
            this.asyncReloadConsumer$set = true;
            return this;
        }

        public MetadataCacheConfig<T> build() {
            long refreshAfterWriteMillis$value = this.refreshAfterWriteMillis$value;
            if (!this.refreshAfterWriteMillis$set) {
                refreshAfterWriteMillis$value = MetadataCacheConfig.$default$refreshAfterWriteMillis();
            }
            long expireAfterWriteMillis$value = this.expireAfterWriteMillis$value;
            if (!this.expireAfterWriteMillis$set) {
                expireAfterWriteMillis$value = MetadataCacheConfig.$default$expireAfterWriteMillis();
            }
            BiConsumer<String, Optional<CacheGetResult<T>>> asyncReloadConsumer$value = this.asyncReloadConsumer$value;
            if (!this.asyncReloadConsumer$set) {
                asyncReloadConsumer$value = MetadataCacheConfig.$default$asyncReloadConsumer();
            }
            return new MetadataCacheConfig<T>(refreshAfterWriteMillis$value, expireAfterWriteMillis$value, asyncReloadConsumer$value);
        }

        public String toString() {
            return "MetadataCacheConfig.MetadataCacheConfigBuilder(refreshAfterWriteMillis$value=" + this.refreshAfterWriteMillis$value + ", expireAfterWriteMillis$value=" + this.expireAfterWriteMillis$value + ", asyncReloadConsumer$value=" + String.valueOf(this.asyncReloadConsumer$value) + ")";
        }
    }
}

