/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.bookie.rackawareness;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.netty.util.HashedWheelTimer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.net.BookieId;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.proto.BookieAddressResolver;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pulsar.bookie.rackawareness.BookieRackAffinityMapping;
import org.apache.pulsar.bookie.rackawareness.ConfigurationStringUtil;
import org.apache.pulsar.common.policies.data.BookiesRackConfiguration;
import org.apache.pulsar.common.policies.data.EnsemblePlacementPolicyConfig;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedBookieEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IsolatedBookieEnsemblePlacementPolicy.class);
    public static final String ISOLATION_BOOKIE_GROUPS = "isolationBookieGroups";
    public static final String SECONDARY_ISOLATION_BOOKIE_GROUPS = "secondaryIsolationBookieGroups";
    private ImmutablePair<Set<String>, Set<String>> defaultIsolationGroups;
    private MetadataCache<BookiesRackConfiguration> bookieMappingCache;
    private static final String PULSAR_SYSTEM_TOPIC_ISOLATION_GROUP = "*";
    private volatile BookiesRackConfiguration cachedRackConfiguration = null;

    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger, BookieAddressResolver bookieAddressResolver) {
        String secondaryIsolationGroupsString;
        MetadataStore store;
        try {
            store = BookieRackAffinityMapping.getMetadataStore((Configuration)conf);
        }
        catch (MetadataException e2) {
            throw new RuntimeException("METADATA_STORE_INSTANCE failed initialized");
        }
        HashSet primaryIsolationGroups = new HashSet();
        HashSet secondaryIsolationGroups = new HashSet();
        if (conf.getProperty(ISOLATION_BOOKIE_GROUPS) != null) {
            String isolationGroupsString = ConfigurationStringUtil.castToString(conf.getProperty(ISOLATION_BOOKIE_GROUPS));
            if (!isolationGroupsString.isEmpty()) {
                Collections.addAll(primaryIsolationGroups, isolationGroupsString.split(","));
            }
            this.bookieMappingCache = store.getMetadataCache(BookiesRackConfiguration.class);
            ((CompletableFuture)this.bookieMappingCache.get("/bookies").thenAccept(opt -> opt.ifPresent(bookiesRackConfiguration -> {
                this.cachedRackConfiguration = bookiesRackConfiguration;
            }))).exceptionally(e -> {
                log.warn("Failed to load bookies rack configuration while initialize the PlacementPolicy.");
                return null;
            });
        }
        if (conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS) != null && !(secondaryIsolationGroupsString = ConfigurationStringUtil.castToString(conf.getProperty(SECONDARY_ISOLATION_BOOKIE_GROUPS))).isEmpty()) {
            Collections.addAll(secondaryIsolationGroups, secondaryIsolationGroupsString.split(","));
        }
        this.defaultIsolationGroups = ImmutablePair.of(primaryIsolationGroups, secondaryIsolationGroups);
        return super.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger, bookieAddressResolver);
    }

    public EnsemblePlacementPolicy.PlacementResult<List<BookieId>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(this.getExcludedBookies(ensembleSize, customMetadata));
        return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
    }

    public EnsemblePlacementPolicy.PlacementResult<BookieId> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieId> currentEnsemble, BookieId bookieToReplace, Set<BookieId> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        if (excludeBookies == null) {
            excludeBookies = new HashSet<BookieId>();
        }
        excludeBookies.addAll(this.getExcludedBookies(ensembleSize, customMetadata));
        return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
    }

    private Set<BookieId> getExcludedBookies(int ensembleSize, Map<String, byte[]> customMetadata) {
        Set<BookieId> excludedBookies;
        Optional<EnsemblePlacementPolicyConfig> ensemblePlacementPolicyConfig = IsolatedBookieEnsemblePlacementPolicy.getEnsemblePlacementPolicyConfig(customMetadata);
        if (ensemblePlacementPolicyConfig.isPresent()) {
            EnsemblePlacementPolicyConfig config = ensemblePlacementPolicyConfig.get();
            Pair<Set<String>, Set<String>> groups = IsolatedBookieEnsemblePlacementPolicy.getIsolationGroup(config);
            excludedBookies = this.getExcludedBookiesWithIsolationGroups(ensembleSize, groups);
        } else {
            excludedBookies = this.getExcludedBookiesWithIsolationGroups(ensembleSize, (Pair<Set<String>, Set<String>>)this.defaultIsolationGroups);
        }
        return excludedBookies;
    }

    private static Optional<EnsemblePlacementPolicyConfig> getEnsemblePlacementPolicyConfig(Map<String, byte[]> customMetadata) {
        byte[] ensemblePlacementPolicyConfigData = customMetadata.get("EnsemblePlacementPolicyConfig");
        if (ensemblePlacementPolicyConfigData != null) {
            try {
                return Optional.ofNullable(EnsemblePlacementPolicyConfig.decode((byte[])ensemblePlacementPolicyConfigData));
            }
            catch (EnsemblePlacementPolicyConfig.ParseEnsemblePlacementPolicyConfigException e) {
                log.error("Failed to parse the ensemble placement policy config from the custom metadata", (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private static Pair<Set<String>, Set<String>> getIsolationGroup(EnsemblePlacementPolicyConfig ensemblePlacementPolicyConfig) {
        MutablePair pair = new MutablePair();
        String className = IsolatedBookieEnsemblePlacementPolicy.class.getName();
        if (ensemblePlacementPolicyConfig.getPolicyClass().getName().equals(className)) {
            Map properties = ensemblePlacementPolicyConfig.getProperties();
            String primaryIsolationGroupString = ConfigurationStringUtil.castToString(properties.getOrDefault(ISOLATION_BOOKIE_GROUPS, ""));
            String secondaryIsolationGroupString = ConfigurationStringUtil.castToString(properties.getOrDefault(SECONDARY_ISOLATION_BOOKIE_GROUPS, ""));
            if (!primaryIsolationGroupString.isEmpty()) {
                pair.setLeft((Object)Sets.newHashSet((Object[])primaryIsolationGroupString.split(",")));
            } else {
                pair.setLeft(Collections.emptySet());
            }
            if (!secondaryIsolationGroupString.isEmpty()) {
                pair.setRight((Object)Sets.newHashSet((Object[])secondaryIsolationGroupString.split(",")));
            } else {
                pair.setRight(Collections.emptySet());
            }
        }
        return pair;
    }

    @VisibleForTesting
    Set<BookieId> getExcludedBookiesWithIsolationGroups(int ensembleSize, Pair<Set<String>, Set<String>> isolationGroups) {
        HashSet<BookieId> excludedBookies;
        block17: {
            excludedBookies = new HashSet<BookieId>();
            if (isolationGroups != null && ((Set)isolationGroups.getLeft()).contains(PULSAR_SYSTEM_TOPIC_ISOLATION_GROUP)) {
                return excludedBookies;
            }
            try {
                if (this.bookieMappingCache == null) break block17;
                ((CompletableFuture)this.bookieMappingCache.get("/bookies").thenAccept(opt -> {
                    this.cachedRackConfiguration = opt.orElse(null);
                })).exceptionally(e -> {
                    log.warn("Failed to update the newest bookies rack config.");
                    return null;
                });
                BookiesRackConfiguration allGroupsBookieMapping = this.cachedRackConfiguration;
                if (allGroupsBookieMapping == null) {
                    log.debug("The bookies rack config is not available at now.");
                    return excludedBookies;
                }
                Set allGroups = allGroupsBookieMapping.keySet();
                if (allGroups.isEmpty()) {
                    return excludedBookies;
                }
                int totalAvailableBookiesInPrimaryGroup = 0;
                Set primaryIsolationGroup = Collections.emptySet();
                Set secondaryIsolationGroup = Collections.emptySet();
                HashSet<BookieId> primaryGroupBookies = new HashSet<BookieId>();
                if (isolationGroups != null) {
                    primaryIsolationGroup = (Set)isolationGroups.getLeft();
                    secondaryIsolationGroup = (Set)isolationGroups.getRight();
                }
                for (String group : allGroups) {
                    Iterator<Object> iterator;
                    Set bookiesInGroup = ((Map)allGroupsBookieMapping.get((Object)group)).keySet();
                    if (!primaryIsolationGroup.contains(group)) {
                        iterator = bookiesInGroup.iterator();
                        while (iterator.hasNext()) {
                            String bookieAddress = (String)iterator.next();
                            excludedBookies.add(BookieId.parse((String)bookieAddress));
                        }
                        continue;
                    }
                    iterator = bookiesInGroup.iterator();
                    while (iterator.hasNext()) {
                        String groupBookie = (String)iterator.next();
                        BookieId bookieId = BookieId.parse((String)groupBookie);
                        if (!primaryGroupBookies.add(bookieId)) continue;
                        totalAvailableBookiesInPrimaryGroup += this.knownBookies.containsKey(bookieId) ? 1 : 0;
                    }
                }
                HashSet<BookieId> otherGroupBookies = new HashSet<BookieId>(excludedBookies);
                HashSet nonRegionBookies = new HashSet(this.knownBookies.keySet());
                nonRegionBookies.removeAll(primaryGroupBookies);
                excludedBookies.addAll(nonRegionBookies);
                for (String group : primaryIsolationGroup) {
                    Map bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                    if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                    for (String bookieAddress : bookieGroup.keySet()) {
                        excludedBookies.remove(BookieId.parse((String)bookieAddress));
                    }
                }
                int totalAvailableBookiesFromPrimaryAndSecondary = totalAvailableBookiesInPrimaryGroup;
                if (totalAvailableBookiesInPrimaryGroup < ensembleSize) {
                    log.info("Not found enough available-bookies from primary isolation group [{}], checking secondary group [{}]", (Object)primaryIsolationGroup, (Object)secondaryIsolationGroup);
                    for (String group : secondaryIsolationGroup) {
                        Map bookieGroup = (Map)allGroupsBookieMapping.get((Object)group);
                        if (bookieGroup == null || bookieGroup.isEmpty()) continue;
                        for (String bookieAddress : bookieGroup.keySet()) {
                            if (!excludedBookies.remove(BookieId.parse((String)bookieAddress))) continue;
                            ++totalAvailableBookiesFromPrimaryAndSecondary;
                        }
                    }
                }
                if (totalAvailableBookiesFromPrimaryAndSecondary < ensembleSize) {
                    log.info("Not found enough available-bookies from primary isolation group [{}] and secondary isolation group [{}], checking from non-region bookies", (Object)primaryIsolationGroup, (Object)secondaryIsolationGroup);
                    nonRegionBookies.removeAll(otherGroupBookies);
                    for (BookieId bookie : nonRegionBookies) {
                        excludedBookies.remove(bookie);
                    }
                }
            }
            catch (Exception e2) {
                log.warn("Error getting bookie isolation info from metadata store: {}", (Object)e2.getMessage());
            }
        }
        return excludedBookies;
    }
}

