/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.naming.AuthenticationException;
import javax.net.ssl.SSLSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.broker.authentication.AuthenticationProvider;
import org.apache.pulsar.broker.authentication.AuthenticationState;
import org.apache.pulsar.broker.authentication.metrics.AuthenticationMetrics;
import org.apache.pulsar.common.api.AuthData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderList
implements AuthenticationProvider {
    private static final Logger log = LoggerFactory.getLogger(AuthenticationProviderList.class);
    private final List<AuthenticationProvider> providers;

    static <T, W> T applyAuthProcessor(List<W> processors, AuthProcessor<T, W> authFunc) throws AuthenticationException {
        AuthenticationException authenticationException = null;
        Object errorCode = ErrorCode.UNKNOWN.name();
        for (W ap : processors) {
            try {
                return authFunc.apply(ap);
            }
            catch (AuthenticationException ae) {
                if (log.isDebugEnabled()) {
                    log.debug("Authentication failed for auth provider " + String.valueOf(ap.getClass()) + ": ", (Throwable)ae);
                }
                authenticationException = ae;
                errorCode = ap.getClass().getSimpleName() + "-INVALID-AUTH";
            }
        }
        if (null == authenticationException) {
            AuthenticationMetrics.authenticateFailure(AuthenticationProviderList.class.getSimpleName(), "authentication-provider-list", ErrorCode.AUTH_REQUIRED);
            throw new AuthenticationException("Authentication required");
        }
        AuthenticationMetrics.authenticateFailure(AuthenticationProviderList.class.getSimpleName(), "authentication-provider-list", (String)errorCode);
        throw authenticationException;
    }

    public AuthenticationProviderList(List<AuthenticationProvider> providers) {
        this.providers = providers;
    }

    public List<AuthenticationProvider> getProviders() {
        return this.providers;
    }

    @Override
    public void initialize(ServiceConfiguration config) throws IOException {
        for (AuthenticationProvider ap : this.providers) {
            ap.initialize(config);
        }
    }

    @Override
    public String getAuthMethodName() {
        return this.providers.get(0).getAuthMethodName();
    }

    @Override
    public CompletableFuture<String> authenticateAsync(AuthenticationDataSource authData) {
        CompletableFuture<String> roleFuture = new CompletableFuture<String>();
        this.authenticateRemainingAuthProviders(roleFuture, authData, null, this.providers.isEmpty() ? -1 : 0);
        return roleFuture;
    }

    private void authenticateRemainingAuthProviders(CompletableFuture<String> roleFuture, AuthenticationDataSource authData, Throwable previousException, int index) {
        if (index < 0 || index >= this.providers.size()) {
            if (previousException == null) {
                previousException = new AuthenticationException("Authentication required");
            }
            AuthenticationMetrics.authenticateFailure(AuthenticationProviderList.class.getSimpleName(), "authentication-provider-list", ErrorCode.AUTH_REQUIRED);
            roleFuture.completeExceptionally(previousException);
            return;
        }
        AuthenticationProvider provider = this.providers.get(index);
        provider.authenticateAsync(authData).whenComplete((role, ex) -> {
            if (ex == null) {
                roleFuture.complete((String)role);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Authentication failed for auth provider " + String.valueOf(provider.getClass()) + ": ", ex);
                }
                this.authenticateRemainingAuthProviders(roleFuture, authData, (Throwable)ex, index + 1);
            }
        });
    }

    @Override
    public String authenticate(AuthenticationDataSource authData) throws AuthenticationException {
        return AuthenticationProviderList.applyAuthProcessor(this.providers, provider -> provider.authenticate(authData));
    }

    @Override
    public AuthenticationState newAuthState(AuthData authData, SocketAddress remoteAddress, SSLSession sslSession) throws AuthenticationException {
        ArrayList<AuthenticationState> states = new ArrayList<AuthenticationState>(this.providers.size());
        AuthenticationException authenticationException = null;
        for (AuthenticationProvider provider : this.providers) {
            try {
                AuthenticationState state = provider.newAuthState(authData, remoteAddress, sslSession);
                states.add(state);
            }
            catch (AuthenticationException ae) {
                if (log.isDebugEnabled()) {
                    log.debug("Authentication failed for auth provider " + String.valueOf(provider.getClass()) + ": ", (Throwable)ae);
                }
                authenticationException = ae;
            }
        }
        if (states.isEmpty()) {
            log.debug("Failed to initialize a new auth state from {}", (Object)remoteAddress, authenticationException);
            if (authenticationException != null) {
                throw authenticationException;
            }
            throw new AuthenticationException("Failed to initialize a new auth state from " + String.valueOf(remoteAddress));
        }
        return new AuthenticationListState(states);
    }

    @Override
    public AuthenticationState newHttpAuthState(HttpServletRequest request) throws AuthenticationException {
        ArrayList<AuthenticationState> states = new ArrayList<AuthenticationState>(this.providers.size());
        AuthenticationException authenticationException = null;
        for (AuthenticationProvider provider : this.providers) {
            try {
                AuthenticationState state = provider.newHttpAuthState(request);
                states.add(state);
            }
            catch (AuthenticationException ae) {
                if (log.isDebugEnabled()) {
                    log.debug("Authentication failed for auth provider " + String.valueOf(provider.getClass()) + ": ", (Throwable)ae);
                }
                authenticationException = ae;
            }
        }
        if (states.isEmpty()) {
            log.debug("Failed to initialize a new http auth state from {}", (Object)request.getRemoteHost(), authenticationException);
            if (authenticationException != null) {
                throw authenticationException;
            }
            throw new AuthenticationException("Failed to initialize a new http auth state from " + request.getRemoteHost());
        }
        return new AuthenticationListState(states);
    }

    @Override
    public boolean authenticateHttpRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Boolean authenticated = AuthenticationProviderList.applyAuthProcessor(this.providers, provider -> {
            try {
                return provider.authenticateHttpRequest(request, response);
            }
            catch (Exception e) {
                if (e instanceof AuthenticationException) {
                    throw (AuthenticationException)e;
                }
                throw new AuthenticationException("Failed to authentication http request");
            }
        });
        return authenticated;
    }

    @Override
    public void close() throws IOException {
        for (AuthenticationProvider provider : this.providers) {
            provider.close();
        }
    }

    private static enum ErrorCode {
        UNKNOWN,
        AUTH_REQUIRED;

    }

    private static interface AuthProcessor<T, W> {
        public T apply(W var1) throws AuthenticationException;
    }

    private static class AuthenticationListState
    implements AuthenticationState {
        private final List<AuthenticationState> states;
        private volatile AuthenticationState authState;

        AuthenticationListState(List<AuthenticationState> states) {
            if (states == null || states.isEmpty()) {
                throw new IllegalArgumentException("Authentication state requires at least one state");
            }
            this.states = states;
            this.authState = states.get(0);
        }

        private AuthenticationState getAuthState() throws AuthenticationException {
            if (this.authState != null) {
                return this.authState;
            }
            throw new AuthenticationException("Authentication state is not initialized");
        }

        @Override
        public String getAuthRole() throws AuthenticationException {
            return this.getAuthState().getAuthRole();
        }

        @Override
        public CompletableFuture<AuthData> authenticateAsync(AuthData authData) {
            CompletableFuture<AuthData> authChallengeFuture = new CompletableFuture<AuthData>();
            this.authState.authenticateAsync(authData).whenComplete((authChallenge, ex) -> {
                if (ex == null) {
                    authChallengeFuture.complete((AuthData)authChallenge);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Authentication failed for auth provider " + String.valueOf(this.authState.getClass()) + ": ", ex);
                    }
                    this.authenticateRemainingAuthStates(authChallengeFuture, authData, (Throwable)ex, this.states.isEmpty() ? -1 : 0);
                }
            });
            return authChallengeFuture;
        }

        private void authenticateRemainingAuthStates(CompletableFuture<AuthData> authChallengeFuture, AuthData clientAuthData, Throwable previousException, int index) {
            if (index < 0 || index >= this.states.size()) {
                if (previousException == null) {
                    previousException = new AuthenticationException("Authentication required");
                }
                AuthenticationMetrics.authenticateFailure(AuthenticationProviderList.class.getSimpleName(), "authentication-provider-list", ErrorCode.AUTH_REQUIRED);
                authChallengeFuture.completeExceptionally(previousException);
                return;
            }
            AuthenticationState state = this.states.get(index);
            if (state == this.authState) {
                this.authenticateRemainingAuthStates(authChallengeFuture, clientAuthData, null, index + 1);
            } else {
                state.authenticateAsync(clientAuthData).whenComplete((authChallenge, ex) -> {
                    if (ex == null) {
                        this.authState = state;
                        authChallengeFuture.complete((AuthData)authChallenge);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Authentication failed for auth provider " + String.valueOf(this.authState.getClass()) + ": ", ex);
                        }
                        this.authenticateRemainingAuthStates(authChallengeFuture, clientAuthData, (Throwable)ex, index + 1);
                    }
                });
            }
        }

        @Override
        public AuthData authenticate(AuthData authData) throws AuthenticationException {
            return AuthenticationProviderList.applyAuthProcessor(this.states, as -> {
                AuthData ad = as.authenticate(authData);
                this.authState = as;
                return ad;
            });
        }

        @Override
        public AuthenticationDataSource getAuthDataSource() {
            return this.authState.getAuthDataSource();
        }

        @Override
        public boolean isComplete() {
            return this.authState.isComplete();
        }

        @Override
        public long getStateId() {
            if (null != this.authState) {
                return this.authState.getStateId();
            }
            return this.states.get(0).getStateId();
        }

        @Override
        public boolean isExpired() {
            return this.authState.isExpired();
        }

        @Override
        public AuthData refreshAuthentication() throws AuthenticationException {
            return this.getAuthState().refreshAuthentication();
        }
    }
}

