/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum BitRateUnit {
    Bit{

        @Override
        public double toBit(double bitRate) {
            return bitRate;
        }

        @Override
        public double toKilobit(double bitRate) {
            return bitRate / 1000.0;
        }

        @Override
        public double toMegabit(double bitRate) {
            return bitRate / Math.pow(1000.0, 2.0);
        }

        @Override
        public double toGigabit(double bitRate) {
            return bitRate / Math.pow(1000.0, 3.0);
        }

        @Override
        public double toByte(double bitRate) {
            return bitRate / 8.0;
        }

        @Override
        public double convert(double bitRate, BitRateUnit bitRateUnit) {
            return bitRateUnit.toBit(bitRate);
        }
    }
    ,
    Kilobit{

        @Override
        public double toBit(double bitRate) {
            return bitRate * 1000.0;
        }

        @Override
        public double toKilobit(double bitRate) {
            return bitRate;
        }

        @Override
        public double toMegabit(double bitRate) {
            return bitRate / 1000.0;
        }

        @Override
        public double toGigabit(double bitRate) {
            return bitRate / Math.pow(1000.0, 2.0);
        }

        @Override
        public double toByte(double bitRate) {
            return bitRate * 1000.0 / 8.0;
        }

        @Override
        public double convert(double bitRate, BitRateUnit bitRateUnit) {
            return bitRateUnit.toKilobit(bitRate);
        }
    }
    ,
    Megabit{

        @Override
        public double toBit(double bitRate) {
            return bitRate * Math.pow(1000.0, 2.0);
        }

        @Override
        public double toKilobit(double bitRate) {
            return bitRate * 1000.0;
        }

        @Override
        public double toMegabit(double bitRate) {
            return bitRate;
        }

        @Override
        public double toGigabit(double bitRate) {
            return bitRate / 1000.0;
        }

        @Override
        public double toByte(double bitRate) {
            return bitRate * Math.pow(1000.0, 2.0) / 8.0;
        }

        @Override
        public double convert(double bitRate, BitRateUnit bitRateUnit) {
            return bitRateUnit.toMegabit(bitRate);
        }
    }
    ,
    Gigabit{

        @Override
        public double toBit(double bitRate) {
            return bitRate * Math.pow(1000.0, 3.0);
        }

        @Override
        public double toKilobit(double bitRate) {
            return bitRate * Math.pow(1000.0, 2.0);
        }

        @Override
        public double toMegabit(double bitRate) {
            return bitRate * 1000.0;
        }

        @Override
        public double toGigabit(double bitRate) {
            return bitRate;
        }

        @Override
        public double toByte(double bitRate) {
            return bitRate * Math.pow(1000.0, 3.0) / 8.0;
        }

        @Override
        public double convert(double bitRate, BitRateUnit bitRateUnit) {
            return bitRateUnit.toGigabit(bitRate);
        }
    }
    ,
    Byte{

        @Override
        public double toBit(double bitRate) {
            return bitRate * 8.0;
        }

        @Override
        public double toKilobit(double bitRate) {
            return bitRate * 8.0 / 1000.0;
        }

        @Override
        public double toMegabit(double bitRate) {
            return bitRate * 8.0 / Math.pow(1000.0, 2.0);
        }

        @Override
        public double toGigabit(double bitRate) {
            return bitRate * 8.0 / Math.pow(1000.0, 3.0);
        }

        @Override
        public double toByte(double bitRate) {
            return bitRate;
        }

        @Override
        public double convert(double bitRate, BitRateUnit bitRateUnit) {
            return bitRateUnit.toByte(bitRate);
        }
    };

    static final int C0 = 1000;
    static final int C1 = 8;

    public double toBit(double bitRate) {
        throw new AbstractMethodError();
    }

    public double toKilobit(double bitRate) {
        throw new AbstractMethodError();
    }

    public double toMegabit(double bitRate) {
        throw new AbstractMethodError();
    }

    public double toGigabit(double bitRate) {
        throw new AbstractMethodError();
    }

    public double toByte(double bitRate) {
        throw new AbstractMethodError();
    }

    public double convert(double bitRate, BitRateUnit bitRateUnit) {
        throw new AbstractMethodError();
    }
}

