/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.transaction.buffer.impl;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerException;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.impl.PositionImpl;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.pulsar.broker.service.BrokerServiceException;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.broker.systopic.SystemTopicClient;
import org.apache.pulsar.broker.transaction.buffer.AbortedTxnProcessor;
import org.apache.pulsar.broker.transaction.buffer.TransactionBuffer;
import org.apache.pulsar.broker.transaction.buffer.TransactionBufferReader;
import org.apache.pulsar.broker.transaction.buffer.TransactionMeta;
import org.apache.pulsar.broker.transaction.buffer.impl.SingleSnapshotAbortedTxnProcessorImpl;
import org.apache.pulsar.broker.transaction.buffer.impl.SnapshotSegmentAbortedTxnProcessorImpl;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferRecoverCallBack;
import org.apache.pulsar.broker.transaction.buffer.impl.TopicTransactionBufferState;
import org.apache.pulsar.broker.transaction.buffer.metadata.TransactionBufferSnapshot;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.transaction.TxnID;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.policies.data.TransactionBufferStats;
import org.apache.pulsar.common.policies.data.TransactionInBufferStats;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.protocol.Markers;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.RecoverTimeRecord;
import org.jctools.queues.MessagePassingQueue;
import org.jctools.queues.SpscArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicTransactionBuffer
extends TopicTransactionBufferState
implements TransactionBuffer,
TimerTask {
    private static final Logger log = LoggerFactory.getLogger(TopicTransactionBuffer.class);
    private final PersistentTopic topic;
    private volatile PositionImpl maxReadPosition;
    private final LinkedMap<TxnID, PositionImpl> ongoingTxns = new LinkedMap();
    private final AtomicLong changeMaxReadPositionCount = new AtomicLong();
    private final LongAdder txnCommittedCounter = new LongAdder();
    private final LongAdder txnAbortedCounter = new LongAdder();
    private final Timer timer;
    private final int takeSnapshotIntervalNumber;
    private final int takeSnapshotIntervalTime;
    private final CompletableFuture<Void> transactionBufferFuture = new CompletableFuture();
    private final ConcurrentHashMap<Long, Long> lowWaterMarks = new ConcurrentHashMap();
    public final RecoverTimeRecord recoverTime = new RecoverTimeRecord();
    private final Semaphore handleLowWaterMark = new Semaphore(1);
    private final AbortedTxnProcessor snapshotAbortedTxnProcessor;
    private final AbortedTxnProcessor.SnapshotType snapshotType;
    private final MaxReadPositionCallBack maxReadPositionCallBack;

    public TopicTransactionBuffer(PersistentTopic topic) {
        super(TopicTransactionBufferState.State.None);
        this.topic = topic;
        this.timer = topic.getBrokerService().getPulsar().getTransactionTimer();
        this.takeSnapshotIntervalNumber = topic.getBrokerService().getPulsar().getConfiguration().getTransactionBufferSnapshotMaxTransactionCount();
        this.takeSnapshotIntervalTime = topic.getBrokerService().getPulsar().getConfiguration().getTransactionBufferSnapshotMinTimeInMillis();
        this.maxReadPosition = (PositionImpl)topic.getManagedLedger().getLastConfirmedEntry();
        if (topic.getBrokerService().getPulsar().getConfiguration().isTransactionBufferSegmentedSnapshotEnabled()) {
            this.snapshotAbortedTxnProcessor = new SnapshotSegmentAbortedTxnProcessorImpl(topic);
            this.snapshotType = AbortedTxnProcessor.SnapshotType.Segment;
        } else {
            this.snapshotAbortedTxnProcessor = new SingleSnapshotAbortedTxnProcessorImpl(topic);
            this.snapshotType = AbortedTxnProcessor.SnapshotType.Single;
        }
        this.maxReadPositionCallBack = topic.getMaxReadPositionCallBack();
        this.recover();
    }

    private void recover() {
        this.recoverTime.setRecoverStartTime(System.currentTimeMillis());
        this.topic.getBrokerService().getPulsar().getTransactionExecutorProvider().getExecutor((Object)this).execute(new TopicTransactionBufferRecover(new TopicTransactionBufferRecoverCallBack(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void recoverComplete() {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    if (TopicTransactionBuffer.this.ongoingTxns.isEmpty()) {
                        TopicTransactionBuffer.this.maxReadPosition = (PositionImpl)TopicTransactionBuffer.this.topic.getManagedLedger().getLastConfirmedEntry();
                    }
                    if (!TopicTransactionBuffer.this.changeToReadyState()) {
                        log.error("[{}]Transaction buffer recover fail, current state: {}", (Object)TopicTransactionBuffer.this.topic.getName(), (Object)TopicTransactionBuffer.this.getState());
                        TopicTransactionBuffer.this.transactionBufferFuture.completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException("Transaction buffer recover failed to change the status to Ready,current state is: " + String.valueOf((Object)TopicTransactionBuffer.this.getState())));
                    } else {
                        TopicTransactionBuffer.this.timer.newTimeout((TimerTask)TopicTransactionBuffer.this, (long)TopicTransactionBuffer.this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
                        TopicTransactionBuffer.this.transactionBufferFuture.complete(null);
                        TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void noNeedToRecover() {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    TopicTransactionBuffer.this.maxReadPosition = (PositionImpl)TopicTransactionBuffer.this.topic.getManagedLedger().getLastConfirmedEntry();
                    if (!TopicTransactionBuffer.this.changeToNoSnapshotState()) {
                        log.error("[{}]Transaction buffer recover fail", (Object)TopicTransactionBuffer.this.topic.getName());
                    } else {
                        TopicTransactionBuffer.this.transactionBufferFuture.complete(null);
                        TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleTxnEntry(Entry entry) {
                ByteBuf metadataAndPayload = entry.getDataBuffer();
                MessageMetadata msgMetadata = Commands.peekMessageMetadata((ByteBuf)metadataAndPayload, (String)"transaction-buffer-sub", (long)-1L);
                if (msgMetadata != null && msgMetadata.hasTxnidMostBits() && msgMetadata.hasTxnidLeastBits()) {
                    TxnID txnID = new TxnID(msgMetadata.getTxnidMostBits(), msgMetadata.getTxnidLeastBits());
                    PositionImpl position = PositionImpl.get((long)entry.getLedgerId(), (long)entry.getEntryId());
                    TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                    synchronized (topicTransactionBuffer) {
                        if (Markers.isTxnMarker((MessageMetadata)msgMetadata)) {
                            if (Markers.isTxnAbortMarker((MessageMetadata)msgMetadata)) {
                                TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.putAbortedTxnAndPosition(txnID, position);
                            }
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                        } else {
                            TopicTransactionBuffer.this.handleTransactionMessage(txnID, (Position)position);
                        }
                    }
                }
            }

            @Override
            public void recoverExceptionally(Throwable e) {
                log.warn("Closing topic {} due to read transaction buffer snapshot while recovering the transaction buffer throw exception", (Object)TopicTransactionBuffer.this.topic.getName(), (Object)e);
                if (e instanceof PulsarClientException) {
                    TopicTransactionBuffer.this.transactionBufferFuture.completeExceptionally(new BrokerServiceException.ServiceUnitNotReadyException(e.getMessage(), e));
                } else {
                    TopicTransactionBuffer.this.transactionBufferFuture.completeExceptionally(e);
                }
                TopicTransactionBuffer.this.recoverTime.setRecoverEndTime(System.currentTimeMillis());
                TopicTransactionBuffer.this.topic.close(true);
            }
        }, this.topic, this, this.snapshotAbortedTxnProcessor));
    }

    @Override
    public CompletableFuture<TransactionMeta> getTransactionMeta(TxnID txnID) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> checkIfTBRecoverCompletely(boolean isTxnEnabled) {
        if (!isTxnEnabled) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.transactionBufferFuture.thenRun(() -> {
            if (this.checkIfNoSnapshot()) {
                ((CompletableFuture)this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition).thenRun(() -> {
                    if (this.changeToReadyStateFromNoSnapshot()) {
                        this.timer.newTimeout((TimerTask)this, (long)this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
                    }
                    completableFuture.complete(null);
                })).exceptionally(exception -> {
                    log.error("Topic {} failed to take snapshot", (Object)this.topic.getName());
                    completableFuture.completeExceptionally((Throwable)exception);
                    return null;
                });
            } else {
                completableFuture.complete(null);
            }
        })).exceptionally(exception -> {
            log.error("Topic {}: TransactionBuffer recover failed", (Object)this.topic.getName(), (Object)exception.getCause());
            completableFuture.completeExceptionally(exception.getCause());
            return null;
        });
        return completableFuture;
    }

    @Override
    public long getOngoingTxnCount() {
        return this.ongoingTxns.size();
    }

    @Override
    public long getAbortedTxnCount() {
        return this.txnAbortedCounter.sum();
    }

    @Override
    public long getCommittedTxnCount() {
        return this.txnCommittedCounter.sum();
    }

    @Override
    public CompletableFuture<Position> appendBufferToTxn(final TxnID txnId, long sequenceId, ByteBuf buffer) {
        final CompletableFuture<Position> completableFuture = new CompletableFuture<Position>();
        Long lowWaterMark = this.lowWaterMarks.get(txnId.getMostSigBits());
        if (lowWaterMark != null && lowWaterMark >= txnId.getLeastSigBits()) {
            completableFuture.completeExceptionally(new BrokerServiceException.NotAllowedException("Transaction [" + String.valueOf(txnId) + "] has been ended. Please use a new transaction to send message."));
            return completableFuture;
        }
        this.topic.getManagedLedger().asyncAddEntry(buffer, new AsyncCallbacks.AddEntryCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                synchronized (topicTransactionBuffer) {
                    TopicTransactionBuffer.this.handleTransactionMessage(txnId, position);
                }
                completableFuture.complete(position);
            }

            public void addFailed(ManagedLedgerException exception, Object ctx) {
                log.error("Failed to append buffer to txn {}", (Object)txnId, (Object)exception);
                completableFuture.completeExceptionally(exception);
            }
        }, null);
        return completableFuture;
    }

    private void handleTransactionMessage(TxnID txnId, Position position) {
        if (!this.ongoingTxns.containsKey((Object)txnId) && !this.snapshotAbortedTxnProcessor.checkAbortedTransaction(txnId)) {
            this.ongoingTxns.put((Object)txnId, (Object)((PositionImpl)position));
            PositionImpl firstPosition = (PositionImpl)this.ongoingTxns.get(this.ongoingTxns.firstKey());
            this.updateMaxReadPosition(((ManagedLedgerImpl)this.topic.getManagedLedger()).getPreviousPosition(firstPosition), false);
        }
    }

    @Override
    public CompletableFuture<TransactionBufferReader> openTransactionBufferReader(TxnID txnID, long startSequenceId) {
        return null;
    }

    @Override
    public CompletableFuture<Void> commitTxn(final TxnID txnID, final long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} commit on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.transactionBufferFuture.thenRun(() -> {
            ByteBuf commitMarker = Markers.newTxnCommitMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits());
            try {
                this.topic.getManagedLedger().asyncAddEntry(commitMarker, new AsyncCallbacks.AddEntryCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                        TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                        synchronized (topicTransactionBuffer) {
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                            TopicTransactionBuffer.this.handleLowWaterMark(txnID, lowWaterMark);
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.trimExpiredAbortedTxns();
                            TopicTransactionBuffer.this.takeSnapshotByChangeTimes();
                        }
                        TopicTransactionBuffer.this.txnCommittedCounter.increment();
                        completableFuture.complete(null);
                    }

                    public void addFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("Failed to commit for txn {}", (Object)txnID, (Object)exception);
                        TopicTransactionBuffer.this.checkAppendMarkerException(exception);
                        completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                    }
                }, null);
            }
            finally {
                commitMarker.release();
            }
        })).exceptionally(exception -> {
            log.error("Transaction {} commit on topic {}.", new Object[]{txnID.toString(), this.topic.getName(), exception.getCause()});
            completableFuture.completeExceptionally(exception.getCause());
            return null;
        });
        return completableFuture;
    }

    @Override
    public CompletableFuture<Void> abortTxn(final TxnID txnID, final long lowWaterMark) {
        if (log.isDebugEnabled()) {
            log.debug("Transaction {} abort on topic {}.", (Object)txnID.toString(), (Object)this.topic.getName());
        }
        final CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        ((CompletableFuture)this.transactionBufferFuture.thenRun(() -> {
            if (!this.checkIfReady()) {
                completableFuture.complete(null);
                return;
            }
            ByteBuf abortMarker = Markers.newTxnAbortMarker((long)-1L, (long)txnID.getMostSigBits(), (long)txnID.getLeastSigBits());
            try {
                this.topic.getManagedLedger().asyncAddEntry(abortMarker, new AsyncCallbacks.AddEntryCallback(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void addComplete(Position position, ByteBuf entryData, Object ctx) {
                        TopicTransactionBuffer topicTransactionBuffer = TopicTransactionBuffer.this;
                        synchronized (topicTransactionBuffer) {
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.putAbortedTxnAndPosition(txnID, (PositionImpl)position);
                            TopicTransactionBuffer.this.removeTxnAndUpdateMaxReadPosition(txnID);
                            TopicTransactionBuffer.this.snapshotAbortedTxnProcessor.trimExpiredAbortedTxns();
                            TopicTransactionBuffer.this.takeSnapshotByChangeTimes();
                            TopicTransactionBuffer.this.txnAbortedCounter.increment();
                            completableFuture.complete(null);
                            TopicTransactionBuffer.this.handleLowWaterMark(txnID, lowWaterMark);
                        }
                    }

                    public void addFailed(ManagedLedgerException exception, Object ctx) {
                        log.error("Failed to abort for txn {}", (Object)txnID, (Object)exception);
                        TopicTransactionBuffer.this.checkAppendMarkerException(exception);
                        completableFuture.completeExceptionally(new BrokerServiceException.PersistenceException(exception));
                    }
                }, null);
            }
            finally {
                abortMarker.release();
            }
        })).exceptionally(exception -> {
            log.error("Transaction {} abort on topic {}.", new Object[]{txnID.toString(), this.topic.getName(), exception.getCause()});
            completableFuture.completeExceptionally(exception.getCause());
            return null;
        });
        return completableFuture;
    }

    private void checkAppendMarkerException(ManagedLedgerException exception) {
        if (exception instanceof ManagedLedgerException.ManagedLedgerAlreadyClosedException) {
            this.topic.getManagedLedger().readyToCreateNewLedger();
        }
    }

    private void handleLowWaterMark(TxnID txnID, long lowWaterMark) {
        this.lowWaterMarks.compute(txnID.getMostSigBits(), (tcId, oldLowWaterMark) -> {
            if (oldLowWaterMark == null || oldLowWaterMark < lowWaterMark) {
                return lowWaterMark;
            }
            return oldLowWaterMark;
        });
        if (this.handleLowWaterMark.tryAcquire()) {
            TxnID firstTxn;
            long tCId;
            Long lowWaterMarkOfFirstTxnId;
            if (!this.ongoingTxns.isEmpty() && (lowWaterMarkOfFirstTxnId = this.lowWaterMarks.get(tCId = (firstTxn = (TxnID)this.ongoingTxns.firstKey()).getMostSigBits())) != null && firstTxn.getLeastSigBits() <= lowWaterMarkOfFirstTxnId) {
                ((CompletableFuture)this.abortTxn(firstTxn, lowWaterMarkOfFirstTxnId).thenRun(() -> {
                    log.warn("Successes to abort low water mark for txn [{}], topic [{}], lowWaterMark [{}]", new Object[]{firstTxn, this.topic.getName(), lowWaterMarkOfFirstTxnId});
                    this.handleLowWaterMark.release();
                })).exceptionally(ex -> {
                    log.warn("Failed to abort low water mark for txn {}, topic [{}], lowWaterMark [{}], ", new Object[]{firstTxn, this.topic.getName(), lowWaterMarkOfFirstTxnId, ex});
                    this.handleLowWaterMark.release();
                    return null;
                });
                return;
            }
            this.handleLowWaterMark.release();
        }
    }

    private void takeSnapshotByChangeTimes() {
        if (this.changeMaxReadPositionCount.get() >= (long)this.takeSnapshotIntervalNumber) {
            this.changeMaxReadPositionCount.set(0L);
            this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition);
        }
    }

    private void takeSnapshotByTimeout() {
        if (this.changeMaxReadPositionCount.get() > 0L) {
            this.changeMaxReadPositionCount.set(0L);
            this.snapshotAbortedTxnProcessor.takeAbortedTxnsSnapshot(this.maxReadPosition);
        }
        this.timer.newTimeout((TimerTask)this, (long)this.takeSnapshotIntervalTime, TimeUnit.MILLISECONDS);
    }

    void removeTxnAndUpdateMaxReadPosition(TxnID txnID) {
        this.ongoingTxns.remove((Object)txnID);
        if (!this.ongoingTxns.isEmpty()) {
            PositionImpl position = (PositionImpl)this.ongoingTxns.get(this.ongoingTxns.firstKey());
            this.updateMaxReadPosition(((ManagedLedgerImpl)this.topic.getManagedLedger()).getPreviousPosition(position), false);
        } else {
            this.updateMaxReadPosition((PositionImpl)this.topic.getManagedLedger().getLastConfirmedEntry(), false);
        }
    }

    void updateMaxReadPosition(PositionImpl newPosition, boolean disableCallback) {
        PositionImpl preMaxReadPosition = this.maxReadPosition;
        this.maxReadPosition = newPosition;
        if (preMaxReadPosition.compareTo(this.maxReadPosition) < 0) {
            if (!this.checkIfNoSnapshot()) {
                this.changeMaxReadPositionCount.getAndIncrement();
            }
            if (!disableCallback) {
                this.maxReadPositionCallBack.maxReadPositionMovedForward(preMaxReadPosition, this.maxReadPosition);
            }
        }
    }

    @Override
    public CompletableFuture<Void> purgeTxns(List<Long> dataLedgers) {
        return null;
    }

    @Override
    public CompletableFuture<Void> clearSnapshot() {
        return this.snapshotAbortedTxnProcessor.clearAbortedTxnSnapshot();
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        this.changeToCloseState();
        return this.snapshotAbortedTxnProcessor.closeAsync();
    }

    @Override
    public synchronized boolean isTxnAborted(TxnID txnID, PositionImpl readPosition) {
        return this.snapshotAbortedTxnProcessor.checkAbortedTransaction(txnID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncMaxReadPositionForNormalPublish(PositionImpl position, boolean isMarkerMessage) {
        TopicTransactionBuffer topicTransactionBuffer = this;
        synchronized (topicTransactionBuffer) {
            if (this.checkIfNoSnapshot()) {
                this.updateMaxReadPosition(position, isMarkerMessage);
            } else if (this.checkIfReady() && this.ongoingTxns.isEmpty()) {
                this.updateMaxReadPosition(position, isMarkerMessage);
            }
        }
    }

    @Override
    public AbortedTxnProcessor.SnapshotType getSnapshotType() {
        return this.snapshotType;
    }

    @Override
    public PositionImpl getMaxReadPosition() {
        if (this.checkIfReady() || this.checkIfNoSnapshot()) {
            return this.maxReadPosition;
        }
        return PositionImpl.EARLIEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionInBufferStats getTransactionInBufferStats(TxnID txnID) {
        TransactionInBufferStats transactionInBufferStats = new TransactionInBufferStats();
        TopicTransactionBuffer topicTransactionBuffer = this;
        synchronized (topicTransactionBuffer) {
            transactionInBufferStats.aborted = this.isTxnAborted(txnID, null);
            if (this.ongoingTxns.containsKey((Object)txnID)) {
                transactionInBufferStats.startPosition = ((PositionImpl)this.ongoingTxns.get((Object)txnID)).toString();
            }
        }
        return transactionInBufferStats;
    }

    @Override
    public TransactionBufferStats getStats(boolean lowWaterMarks, boolean segmentStats) {
        TransactionBufferStats transactionBufferStats = this.snapshotAbortedTxnProcessor.generateSnapshotStats(segmentStats);
        transactionBufferStats.snapshotType = this.snapshotType.toString();
        transactionBufferStats.state = this.getState().name();
        transactionBufferStats.maxReadPosition = this.maxReadPosition.toString();
        if (lowWaterMarks) {
            transactionBufferStats.lowWaterMarks = this.lowWaterMarks;
        }
        transactionBufferStats.ongoingTxnSize = this.ongoingTxns.size();
        transactionBufferStats.recoverStartTime = this.recoverTime.getRecoverStartTime();
        transactionBufferStats.recoverEndTime = this.recoverTime.getRecoverEndTime();
        return transactionBufferStats;
    }

    @Override
    public TransactionBufferStats getStats(boolean lowWaterMarks) {
        return this.getStats(lowWaterMarks, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Timeout timeout) {
        if (this.checkIfReady()) {
            TopicTransactionBuffer topicTransactionBuffer = this;
            synchronized (topicTransactionBuffer) {
                this.takeSnapshotByTimeout();
            }
        }
    }

    public static interface MaxReadPositionCallBack {
        public void maxReadPositionMovedForward(PositionImpl var1, PositionImpl var2);
    }

    @VisibleForTesting
    public static class TopicTransactionBufferRecover
    implements Runnable {
        private final PersistentTopic topic;
        private final TopicTransactionBufferRecoverCallBack callBack;
        private Position startReadCursorPosition = PositionImpl.EARLIEST;
        private final SpscArrayQueue<Entry> entryQueue;
        private final AtomicLong exceptionNumber = new AtomicLong();
        public static final String SUBSCRIPTION_NAME = "transaction-buffer-sub";
        private final TopicTransactionBuffer topicTransactionBuffer;
        private final AbortedTxnProcessor abortedTxnProcessor;

        private TopicTransactionBufferRecover(TopicTransactionBufferRecoverCallBack callBack, PersistentTopic topic, TopicTransactionBuffer transactionBuffer, AbortedTxnProcessor abortedTxnProcessor) {
            this.topic = topic;
            this.callBack = callBack;
            this.entryQueue = new SpscArrayQueue(2000);
            this.topicTransactionBuffer = transactionBuffer;
            this.abortedTxnProcessor = abortedTxnProcessor;
        }

        @Override
        public void run() {
            if (!this.topicTransactionBuffer.changeToInitializingState()) {
                log.warn("TransactionBuffer {} of topic {} can not change state to Initializing", (Object)this, (Object)this.topic.getName());
                return;
            }
            ((CompletableFuture)this.abortedTxnProcessor.recoverFromSnapshot().thenAccept(startReadCursorPosition -> {
                ManagedCursor managedCursor;
                if (startReadCursorPosition == null) {
                    this.callBack.noNeedToRecover();
                    return;
                }
                this.startReadCursorPosition = startReadCursorPosition;
                try {
                    managedCursor = this.topic.getManagedLedger().newNonDurableCursor(this.startReadCursorPosition, SUBSCRIPTION_NAME);
                }
                catch (ManagedLedgerException e) {
                    this.callBack.recoverExceptionally(e);
                    log.error("[{}]Transaction buffer recover fail when open cursor!", (Object)this.topic.getName(), (Object)e);
                    return;
                }
                PositionImpl lastConfirmedEntry = (PositionImpl)this.topic.getManagedLedger().getLastConfirmedEntry();
                PositionImpl currentLoadPosition = (PositionImpl)this.startReadCursorPosition;
                FillEntryQueueCallback fillEntryQueueCallback = new FillEntryQueueCallback(this.entryQueue, managedCursor, this);
                if (lastConfirmedEntry.getEntryId() != -1L) {
                    while (lastConfirmedEntry.compareTo(currentLoadPosition) > 0 && fillEntryQueueCallback.fillQueue()) {
                        Entry entry = (Entry)this.entryQueue.poll();
                        if (entry != null) {
                            try {
                                currentLoadPosition = PositionImpl.get((long)entry.getLedgerId(), (long)entry.getEntryId());
                                this.callBack.handleTxnEntry(entry);
                                continue;
                            }
                            finally {
                                entry.release();
                                continue;
                            }
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                this.closeCursor(SUBSCRIPTION_NAME);
                this.callBack.recoverComplete();
            })).exceptionally(e -> {
                this.callBack.recoverExceptionally(e.getCause());
                log.error("[{}]Transaction buffer failed to recover snapshot!", (Object)this.topic.getName(), e);
                return null;
            });
        }

        private void closeCursor(String subscriptionName) {
            this.topic.getManagedLedger().asyncDeleteCursor(Codec.encode((String)subscriptionName), new AsyncCallbacks.DeleteCursorCallback(){

                public void deleteCursorComplete(Object ctx) {
                    log.info("[{}]Transaction buffer snapshot recover cursor close complete.", (Object)topic.getName());
                }

                public void deleteCursorFailed(ManagedLedgerException exception, Object ctx) {
                    log.error("[{}]Transaction buffer snapshot recover cursor close fail.", (Object)topic.getName());
                }
            }, null);
        }

        private void callBackException(ManagedLedgerException e) {
            log.error("Transaction buffer recover fail when recover transaction entry!", (Throwable)e);
            this.exceptionNumber.getAndIncrement();
        }

        private void closeReader(SystemTopicClient.Reader<TransactionBufferSnapshot> reader) {
            reader.closeAsync().exceptionally(e -> {
                log.error("[{}]Transaction buffer reader close error!", (Object)this.topic.getName(), e);
                return null;
            });
        }
    }

    static class FillEntryQueueCallback
    implements AsyncCallbacks.ReadEntriesCallback {
        private final AtomicLong outstandingReadsRequests = new AtomicLong(0L);
        private final SpscArrayQueue<Entry> entryQueue;
        private final ManagedCursor cursor;
        private final TopicTransactionBufferRecover recover;
        private volatile boolean isReadable = true;
        private static final int NUMBER_OF_PER_READ_ENTRY = 100;

        private FillEntryQueueCallback(SpscArrayQueue<Entry> entryQueue, ManagedCursor cursor, TopicTransactionBufferRecover recover) {
            this.entryQueue = entryQueue;
            this.cursor = cursor;
            this.recover = recover;
        }

        boolean fillQueue() {
            if (this.entryQueue.size() + 100 < this.entryQueue.capacity() && this.outstandingReadsRequests.get() == 0L) {
                if (this.cursor.hasMoreEntries()) {
                    this.outstandingReadsRequests.incrementAndGet();
                    this.cursor.asyncReadEntries(100, (AsyncCallbacks.ReadEntriesCallback)this, (Object)System.nanoTime(), PositionImpl.LATEST);
                } else if (this.entryQueue.size() == 0) {
                    this.isReadable = false;
                }
            }
            return this.isReadable;
        }

        public void readEntriesComplete(final List<Entry> entries, Object ctx) {
            this.entryQueue.fill((MessagePassingQueue.Supplier)new MessagePassingQueue.Supplier<Entry>(){
                private int i = 0;

                public Entry get() {
                    Entry entry = (Entry)entries.get(this.i);
                    ++this.i;
                    return entry;
                }
            }, entries.size());
            this.outstandingReadsRequests.decrementAndGet();
        }

        public void readEntriesFailed(ManagedLedgerException exception, Object ctx) {
            if (this.recover.topic.getManagedLedger().getConfig().isAutoSkipNonRecoverableData() && exception instanceof ManagedLedgerException.NonRecoverableLedgerException || exception instanceof ManagedLedgerException.ManagedLedgerFencedException || exception instanceof ManagedLedgerException.CursorAlreadyClosedException) {
                this.isReadable = false;
            } else {
                this.outstandingReadsRequests.decrementAndGet();
            }
            this.recover.callBackException(exception);
        }
    }
}

