/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.stats.prometheus;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.Collector;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.bookkeeper.stats.NullStatsProvider;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.stats.metrics.ManagedCursorMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerCacheMetrics;
import org.apache.pulsar.broker.stats.metrics.ManagedLedgerMetrics;
import org.apache.pulsar.broker.stats.prometheus.NamespaceStatsAggregator;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricStreams;
import org.apache.pulsar.broker.stats.prometheus.PrometheusMetricsGeneratorUtils;
import org.apache.pulsar.broker.stats.prometheus.PrometheusRawMetricsProvider;
import org.apache.pulsar.broker.stats.prometheus.TransactionAggregator;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.SimpleTextOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsGenerator
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsGenerator.class);
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 0x100000;
    private static final int MINIMUM_FOR_MAX_COMPONENTS = 64;
    private volatile MetricsBuffer metricsBuffer;
    private static AtomicReferenceFieldUpdater<PrometheusMetricsGenerator, MetricsBuffer> metricsBufferFieldUpdater = AtomicReferenceFieldUpdater.newUpdater(PrometheusMetricsGenerator.class, MetricsBuffer.class, "metricsBuffer");
    private volatile boolean closed;
    private final PulsarService pulsar;
    private final boolean includeTopicMetrics;
    private final boolean includeConsumerMetrics;
    private final boolean includeProducerMetrics;
    private final boolean splitTopicAndPartitionIndexLabel;
    private final Clock clock;
    private volatile int initialBufferSize = 0x100000;

    public PrometheusMetricsGenerator(PulsarService pulsar, boolean includeTopicMetrics, boolean includeConsumerMetrics, boolean includeProducerMetrics, boolean splitTopicAndPartitionIndexLabel, Clock clock) {
        this.pulsar = pulsar;
        this.includeTopicMetrics = includeTopicMetrics;
        this.includeConsumerMetrics = includeConsumerMetrics;
        this.includeProducerMetrics = includeProducerMetrics;
        this.splitTopicAndPartitionIndexLabel = splitTopicAndPartitionIndexLabel;
        this.clock = clock;
    }

    protected ByteBuf generateMetrics(List<PrometheusRawMetricsProvider> metricsProviders) {
        ByteBuf buf = this.allocateMultipartCompositeDirectBuffer();
        boolean exceptionHappens = false;
        PrometheusMetricStreams metricStreams = new PrometheusMetricStreams();
        try {
            SimpleTextOutputStream stream = new SimpleTextOutputStream(buf);
            PrometheusMetricsGeneratorUtils.generateSystemMetrics((SimpleTextOutputStream)stream, (String)this.pulsar.getConfiguration().getClusterName());
            NamespaceStatsAggregator.generate(this.pulsar, this.includeTopicMetrics, this.includeConsumerMetrics, this.includeProducerMetrics, this.splitTopicAndPartitionIndexLabel, metricStreams);
            if (this.pulsar.getWorkerServiceOpt().isPresent()) {
                this.pulsar.getWorkerService().generateFunctionsStats(stream);
            }
            if (this.pulsar.getConfiguration().isTransactionCoordinatorEnabled()) {
                TransactionAggregator.generate(this.pulsar, metricStreams, this.includeTopicMetrics);
            }
            metricStreams.flushAllToStream(stream);
            PrometheusMetricsGenerator.generateBrokerBasicMetrics(this.pulsar, stream);
            PrometheusMetricsGenerator.generateManagedLedgerBookieClientMetrics(this.pulsar, stream);
            if (metricsProviders != null) {
                for (PrometheusRawMetricsProvider metricsProvider : metricsProviders) {
                    metricsProvider.generate(stream);
                }
            }
            ByteBuf byteBuf = buf;
            return byteBuf;
        }
        catch (Throwable t) {
            exceptionHappens = true;
            throw t;
        }
        finally {
            metricStreams.releaseAll();
            if (exceptionHappens) {
                buf.release();
            } else {
                this.initialBufferSize = Math.max(0x100000, buf.readableBytes());
            }
        }
    }

    ByteBuf allocateMultipartCompositeDirectBuffer() {
        ByteBuf buf;
        ByteBufAllocator byteBufAllocator = PulsarByteBufAllocator.DEFAULT;
        if (PlatformDependent.hasUnsafe()) {
            int chunkSize = PrometheusMetricsGenerator.resolveChunkSize(byteBufAllocator);
            buf = byteBufAllocator.compositeDirectBuffer(Math.max(64, this.initialBufferSize / chunkSize + 1));
            int totalLen = 0;
            while (totalLen < this.initialBufferSize) {
                buf.capacity(totalLen += chunkSize);
            }
        } else {
            buf = byteBufAllocator.directBuffer(this.initialBufferSize);
        }
        return buf;
    }

    private static int resolveChunkSize(ByteBufAllocator byteBufAllocator) {
        int chunkSize;
        if (byteBufAllocator instanceof PooledByteBufAllocator) {
            PooledByteBufAllocator pooledByteBufAllocator = (PooledByteBufAllocator)byteBufAllocator;
            chunkSize = Math.max(pooledByteBufAllocator.metric().chunkSize(), 0x100000);
        } else {
            chunkSize = 0x100000;
        }
        return chunkSize;
    }

    private static void generateBrokerBasicMetrics(PulsarService pulsar, SimpleTextOutputStream stream) {
        String clusterName = pulsar.getConfiguration().getClusterName();
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerCacheMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        if (pulsar.getConfiguration().isExposeManagedLedgerMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedLedgerMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        if (pulsar.getConfiguration().isExposeManagedCursorMetricsInPrometheus()) {
            PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(new ManagedCursorMetrics(pulsar).generate(), clusterName, Collector.Type.GAUGE, stream);
        }
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(pulsar.getBrokerService().getPulsarStats().getBrokerOperabilityMetrics().getMetrics(), clusterName, Collector.Type.GAUGE, stream);
        PrometheusMetricsGenerator.parseMetricsToPrometheusMetrics(pulsar.getLoadManager().get().getLoadBalancingMetrics(), clusterName, Collector.Type.GAUGE, stream);
    }

    private static void parseMetricsToPrometheusMetrics(Collection<Metrics> metrics, String cluster, Collector.Type metricType, SimpleTextOutputStream stream) {
        HashSet<String> names = new HashSet<String>();
        for (Metrics metrics1 : metrics) {
            for (Map.Entry entry : metrics1.getMetrics().entrySet()) {
                String value;
                block8: {
                    value = null;
                    if (((String)entry.getKey()).contains(".")) {
                        try {
                            String key = (String)entry.getKey();
                            int dotIndex = key.indexOf(".");
                            int nameIndex = key.substring(0, dotIndex).lastIndexOf("_");
                            if (nameIndex == -1) continue;
                            String name = key.substring(0, nameIndex);
                            value = key.substring(nameIndex + 1);
                            if (!names.contains(name)) {
                                stream.write("# TYPE ");
                                PrometheusMetricsGenerator.writeNameReplacingBrkPrefix(stream, name);
                                stream.write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr((Collector.Type)metricType)).write("\n");
                                names.add(name);
                            }
                            PrometheusMetricsGenerator.writeNameReplacingBrkPrefix(stream, name);
                            stream.write("{cluster=\"").write(cluster).write('\"');
                            break block8;
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    String name = (String)entry.getKey();
                    if (!names.contains(name)) {
                        stream.write("# TYPE ");
                        PrometheusMetricsGenerator.writeNameReplacingBrkPrefix(stream, (String)entry.getKey());
                        stream.write(' ').write(PrometheusMetricsGeneratorUtils.getTypeStr((Collector.Type)metricType)).write('\n');
                        names.add(name);
                    }
                    PrometheusMetricsGenerator.writeNameReplacingBrkPrefix(stream, name);
                    stream.write("{cluster=\"").write(cluster).write('\"');
                }
                boolean appendedQuantile = false;
                for (Map.Entry metric : metrics1.getDimensions().entrySet()) {
                    if (((String)metric.getKey()).isEmpty() || "cluster".equals(metric.getKey())) continue;
                    stream.write(", ").write((String)metric.getKey()).write("=\"").write((String)metric.getValue()).write('\"');
                    if (value == null || value.isEmpty() || appendedQuantile) continue;
                    stream.write(", ").write("quantile=\"").write(value).write('\"');
                    appendedQuantile = true;
                }
                stream.write("} ").write(String.valueOf(entry.getValue())).write("\n");
            }
        }
    }

    private static SimpleTextOutputStream writeNameReplacingBrkPrefix(SimpleTextOutputStream stream, String name) {
        if (name.startsWith("brk_")) {
            return stream.write("pulsar_").write((CharSequence)CharBuffer.wrap(name).position("brk_".length()));
        }
        return stream.write(name);
    }

    private static void generateManagedLedgerBookieClientMetrics(PulsarService pulsar, final SimpleTextOutputStream stream) {
        StatsProvider statsProvider = pulsar.getManagedLedgerClientFactory().getStatsProvider();
        if (statsProvider instanceof NullStatsProvider) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                stream.writeByte(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                stream.write(b, off, len);
            }
        }), StandardCharsets.UTF_8);){
            statsProvider.writeAllMetrics((Writer)writer);
        }
        catch (IOException e) {
            log.error("Failed to write managed ledger bookie client metrics", (Throwable)e);
        }
    }

    public MetricsBuffer renderToBuffer(Executor executor, List<PrometheusRawMetricsProvider> metricsProviders) {
        boolean cacheMetricsResponse = this.pulsar.getConfiguration().isMetricsBufferResponse();
        while (!this.closed && !Thread.currentThread().isInterrupted()) {
            long currentTimeSlot = cacheMetricsResponse ? this.calculateCurrentTimeSlot() : 0L;
            MetricsBuffer currentMetricsBuffer = this.metricsBuffer;
            if (currentMetricsBuffer == null || currentMetricsBuffer.getBufferFuture().isCompletedExceptionally() || currentMetricsBuffer.getBufferFuture().isDone() && currentMetricsBuffer.getCreateTimeslot() != 0L && currentTimeSlot > currentMetricsBuffer.getCreateTimeslot()) {
                MetricsBuffer newMetricsBuffer = new MetricsBuffer(currentTimeSlot);
                if (metricsBufferFieldUpdater.compareAndSet(this, currentMetricsBuffer, newMetricsBuffer)) {
                    if (currentMetricsBuffer != null) {
                        currentMetricsBuffer.release();
                    }
                    CompletableFuture<ResponseBuffer> bufferFuture = newMetricsBuffer.getBufferFuture();
                    executor.execute(() -> {
                        try {
                            bufferFuture.complete(new ResponseBuffer(this.generateMetrics(metricsProviders)));
                        }
                        catch (Exception e) {
                            bufferFuture.completeExceptionally(e);
                        }
                        finally {
                            if (currentTimeSlot == 0L) {
                                metricsBufferFieldUpdater.compareAndSet(this, newMetricsBuffer, null);
                                newMetricsBuffer.release();
                            }
                        }
                    });
                    return newMetricsBuffer;
                }
                currentMetricsBuffer = this.metricsBuffer;
            }
            if (currentMetricsBuffer == null || !currentMetricsBuffer.retain()) continue;
            return currentMetricsBuffer;
        }
        return null;
    }

    private long calculateCurrentTimeSlot() {
        long cacheTimeoutMillis = TimeUnit.SECONDS.toMillis(Math.max(1, this.pulsar.getConfiguration().getManagedLedgerStatsPeriodSeconds()));
        long now = this.clock.millis();
        return now / cacheTimeoutMillis;
    }

    @Override
    public void close() {
        this.closed = true;
        MetricsBuffer buffer = metricsBufferFieldUpdater.getAndSet(this, null);
        if (buffer != null) {
            buffer.release();
        }
    }

    public static class MetricsBuffer {
        private final CompletableFuture<ResponseBuffer> bufferFuture;
        private final long createTimeslot;
        private final AtomicInteger refCnt = new AtomicInteger(2);

        MetricsBuffer(long timeslot) {
            this.bufferFuture = new CompletableFuture();
            this.createTimeslot = timeslot;
        }

        public CompletableFuture<ResponseBuffer> getBufferFuture() {
            return this.bufferFuture;
        }

        long getCreateTimeslot() {
            return this.createTimeslot;
        }

        boolean retain() {
            return this.refCnt.updateAndGet(x -> x > 0 ? x + 1 : x) > 0;
        }

        public void release() {
            int newValue = this.refCnt.decrementAndGet();
            if (newValue == 0) {
                this.bufferFuture.whenComplete((byteBuf, throwable) -> {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                });
            }
        }
    }

    public static class ResponseBuffer {
        private final ByteBuf uncompressedBuffer;
        private boolean released = false;
        private CompletableFuture<ByteBuf> compressedBuffer;

        private ResponseBuffer(ByteBuf uncompressedBuffer) {
            this.uncompressedBuffer = uncompressedBuffer;
        }

        public ByteBuf getUncompressedBuffer() {
            return this.uncompressedBuffer;
        }

        public synchronized CompletableFuture<ByteBuf> getCompressedBuffer(Executor executor) {
            if (this.released) {
                throw new IllegalStateException("Already released!");
            }
            if (this.compressedBuffer == null) {
                this.compressedBuffer = new CompletableFuture();
                ByteBuf retainedDuplicate = this.uncompressedBuffer.retainedDuplicate();
                executor.execute(() -> {
                    try {
                        this.compressedBuffer.complete(this.compress(retainedDuplicate));
                    }
                    catch (Exception e) {
                        this.compressedBuffer.completeExceptionally(e);
                    }
                    finally {
                        retainedDuplicate.release();
                    }
                });
            }
            return this.compressedBuffer;
        }

        private ByteBuf compress(ByteBuf uncompressedBuffer) {
            GzipByteBufferWriter gzipByteBufferWriter = new GzipByteBufferWriter(uncompressedBuffer.alloc(), uncompressedBuffer.readableBytes());
            return gzipByteBufferWriter.compress(uncompressedBuffer);
        }

        public synchronized void release() {
            this.released = true;
            this.uncompressedBuffer.release();
            if (this.compressedBuffer != null) {
                this.compressedBuffer.whenComplete((byteBuf, throwable) -> {
                    if (byteBuf != null) {
                        byteBuf.release();
                    }
                });
            }
        }
    }

    private static class GzipByteBufferWriter {
        private static final byte[] GZIP_HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        private final ByteBufAllocator bufAllocator;
        private final Deflater deflater = new Deflater(-1, true);
        private final CRC32 crc = new CRC32();
        private final int bufferSize;
        private final CompositeByteBuf resultBuffer;
        private ByteBuf backingCompressBuffer;
        private ByteBuffer compressBuffer;

        GzipByteBufferWriter(ByteBufAllocator bufAllocator, int readableBytes) {
            this.bufferSize = Math.max(Math.min(PrometheusMetricsGenerator.resolveChunkSize(bufAllocator), readableBytes), 8192);
            this.bufAllocator = bufAllocator;
            this.resultBuffer = bufAllocator.compositeDirectBuffer(readableBytes / this.bufferSize + 2);
            this.allocateCompressBuffer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteBuf compress(ByteBuf uncompressedBuffer) {
            try {
                ByteBuffer[] nioBuffers = uncompressedBuffer.nioBuffers();
                int nioBuffersLength = nioBuffers.length;
                for (int i = 0; i < nioBuffersLength; ++i) {
                    ByteBuffer nioBuffer = nioBuffers[i];
                    this.compressAndAppend(nioBuffer, i == 0, i == nioBuffersLength - 1);
                }
                CompositeByteBuf compositeByteBuf = this.resultBuffer;
                return compositeByteBuf;
            }
            finally {
                this.close();
            }
        }

        private void compressAndAppend(ByteBuffer nioBuffer, boolean isFirst, boolean isLast) {
            if (isFirst) {
                this.compressBuffer.put(GZIP_HEADER);
            }
            nioBuffer.mark();
            this.crc.update(nioBuffer);
            nioBuffer.reset();
            this.deflater.setInput(nioBuffer);
            if (isLast) {
                this.deflater.finish();
            }
            int written = -1;
            while (!isLast && !this.deflater.needsInput() || isLast && !this.deflater.finished()) {
                if (written == 0) {
                    if (this.compressBuffer.position() > 0) {
                        this.appendCompressBufferToResultBuffer();
                        this.allocateCompressBuffer();
                    } else {
                        throw new IllegalStateException("Deflater didn't write any bytes while the compress buffer is empty.");
                    }
                }
                written = this.deflater.deflate(this.compressBuffer);
            }
            if (isLast) {
                if (this.compressBuffer.position() > 0) {
                    this.appendCompressBufferToResultBuffer();
                } else {
                    this.backingCompressBuffer.release();
                }
                this.backingCompressBuffer = null;
                this.compressBuffer = null;
                ByteBuffer trailerBuf = ByteBuffer.allocate(8);
                trailerBuf.order(ByteOrder.LITTLE_ENDIAN);
                trailerBuf.putInt((int)this.crc.getValue());
                trailerBuf.putInt(this.deflater.getTotalIn());
                trailerBuf.flip();
                this.resultBuffer.addComponent(true, Unpooled.wrappedBuffer((ByteBuffer)trailerBuf));
            }
        }

        private void appendCompressBufferToResultBuffer() {
            this.backingCompressBuffer.setIndex(0, this.compressBuffer.position());
            this.resultBuffer.addComponent(true, this.backingCompressBuffer);
        }

        private void allocateCompressBuffer() {
            this.backingCompressBuffer = this.bufAllocator.directBuffer(this.bufferSize);
            this.compressBuffer = this.backingCompressBuffer.nioBuffer(0, this.bufferSize);
        }

        private void close() {
            if (this.deflater != null) {
                this.deflater.end();
            }
            if (this.backingCompressBuffer != null) {
                this.backingCompressBuffer.release();
            }
        }
    }
}

