/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pulsar.broker.service.TopicEventsListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicEventsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(TopicEventsDispatcher.class);
    private final List<TopicEventsListener> topicEventListeners = new CopyOnWriteArrayList<TopicEventsListener>();

    public void addTopicEventListener(TopicEventsListener ... listeners) {
        Objects.requireNonNull(listeners);
        Arrays.stream(listeners).filter(x -> x != null).forEach(this.topicEventListeners::add);
    }

    public void removeTopicEventListener(TopicEventsListener ... listeners) {
        Objects.requireNonNull(listeners);
        Arrays.stream(listeners).filter(x -> x != null).forEach(this.topicEventListeners::remove);
    }

    public void notify(String topic, TopicEventsListener.TopicEvent event, TopicEventsListener.EventStage stage) {
        this.notify(topic, event, stage, null);
    }

    public void notify(String topic, TopicEventsListener.TopicEvent event, TopicEventsListener.EventStage stage, Throwable t) {
        this.topicEventListeners.forEach(listener -> TopicEventsDispatcher.notify(listener, topic, event, stage, t));
    }

    public <T> CompletableFuture<T> notifyOnCompletion(CompletableFuture<T> future, String topic, TopicEventsListener.TopicEvent event) {
        return future.whenComplete((r, ex) -> this.notify(topic, event, ex == null ? TopicEventsListener.EventStage.SUCCESS : TopicEventsListener.EventStage.FAILURE, (Throwable)ex));
    }

    public static void notify(TopicEventsListener[] listeners, String topic, TopicEventsListener.TopicEvent event, TopicEventsListener.EventStage stage, Throwable t) {
        Objects.requireNonNull(listeners);
        for (TopicEventsListener listener : listeners) {
            TopicEventsDispatcher.notify(listener, topic, event, stage, t);
        }
    }

    private static void notify(TopicEventsListener listener, String topic, TopicEventsListener.TopicEvent event, TopicEventsListener.EventStage stage, Throwable t) {
        if (listener == null) {
            return;
        }
        try {
            listener.handleEvent(topic, event, stage, t);
        }
        catch (Throwable ex) {
            log.error("TopicEventsListener {} exception while handling {}_{} for topic {}", new Object[]{listener, event, stage, topic, ex});
        }
    }
}

