/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.manager;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.manager.StateChangeListener;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitDecision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitManager
implements StateChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SplitManager.class);
    private final Map<String, CompletableFuture<Void>> inFlightSplitRequests = new ConcurrentHashMap<String, CompletableFuture<Void>>();
    private final SplitCounter counter;

    public SplitManager(SplitCounter splitCounter) {
        this.counter = splitCounter;
    }

    private void complete(String serviceUnit, Throwable ex) {
        this.inFlightSplitRequests.computeIfPresent(serviceUnit, (__, future) -> {
            if (!future.isDone()) {
                if (ex != null) {
                    future.completeExceptionally(ex);
                } else {
                    future.complete(null);
                }
            }
            return null;
        });
    }

    public CompletableFuture<Void> waitAsync(CompletableFuture<Void> eventPubFuture, String bundle, SplitDecision decision, long timeout, TimeUnit timeoutUnit) {
        return ((CompletableFuture)eventPubFuture.thenCompose(__ -> this.inFlightSplitRequests.computeIfAbsent(bundle, ignore -> {
            log.info("Published the bundle split event for bundle:{}. Waiting the split event to complete. Timeout: {} {}", new Object[]{bundle, timeout, timeoutUnit});
            CompletableFuture future = new CompletableFuture();
            future.orTimeout(timeout, timeoutUnit).whenComplete((v, ex) -> {
                if (ex != null) {
                    this.inFlightSplitRequests.remove(bundle);
                    log.warn("Timed out while waiting for the bundle split event: {}", (Object)bundle, ex);
                }
            });
            return future;
        }))).whenComplete((__, ex) -> {
            if (ex != null) {
                log.error("Failed the bundle split event for bundle:{}", (Object)bundle, ex);
                this.counter.update(SplitDecision.Label.Failure, SplitDecision.Reason.Unknown);
            } else {
                log.info("Completed the bundle split event for bundle:{}", (Object)bundle);
                this.counter.update(decision);
            }
        });
    }

    @Override
    public void handleEvent(String serviceUnit, ServiceUnitStateData data, Throwable t) {
        ServiceUnitState state = ServiceUnitStateData.state(data);
        if (t != null && this.inFlightSplitRequests.containsKey(serviceUnit)) {
            this.complete(serviceUnit, t);
            return;
        }
        switch (state) {
            case Init: {
                this.complete(serviceUnit, t);
                break;
            }
            default: {
                if (!log.isDebugEnabled()) break;
                log.debug("Handling {} for service unit {}", (Object)data, (Object)serviceUnit);
            }
        }
    }

    public void close() {
        this.inFlightSplitRequests.forEach((bundle, future) -> {
            if (!future.isDone()) {
                String msg = String.format("Splitting bundle: %s, but the manager already closed.", bundle);
                log.warn(msg);
                future.completeExceptionally(new IllegalStateException(msg));
            }
        });
        this.inFlightSplitRequests.clear();
    }
}

