/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.LeaderElectionService;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.extensions.BrokerRegistry;
import org.apache.pulsar.broker.loadbalance.extensions.BrokerRegistryImpl;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManager;
import org.apache.pulsar.broker.loadbalance.extensions.ExtensibleLoadManagerWrapper;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContextImpl;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitState;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannel;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateChannelImpl;
import org.apache.pulsar.broker.loadbalance.extensions.channel.ServiceUnitStateData;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLoadData;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLookupData;
import org.apache.pulsar.broker.loadbalance.extensions.data.TopBundlesLoadData;
import org.apache.pulsar.broker.loadbalance.extensions.filter.AntiAffinityGroupPolicyFilter;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerFilter;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerIsolationPoliciesFilter;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerLoadManagerClassFilter;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerMaxTopicCountFilter;
import org.apache.pulsar.broker.loadbalance.extensions.filter.BrokerVersionFilter;
import org.apache.pulsar.broker.loadbalance.extensions.manager.SplitManager;
import org.apache.pulsar.broker.loadbalance.extensions.manager.UnloadManager;
import org.apache.pulsar.broker.loadbalance.extensions.models.AssignCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.Split;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.SplitDecision;
import org.apache.pulsar.broker.loadbalance.extensions.models.Unload;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadCounter;
import org.apache.pulsar.broker.loadbalance.extensions.models.UnloadDecision;
import org.apache.pulsar.broker.loadbalance.extensions.policies.AntiAffinityGroupPolicyHelper;
import org.apache.pulsar.broker.loadbalance.extensions.policies.IsolationPoliciesHelper;
import org.apache.pulsar.broker.loadbalance.extensions.reporter.BrokerLoadDataReporter;
import org.apache.pulsar.broker.loadbalance.extensions.reporter.TopBundleLoadDataReporter;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.LoadManagerScheduler;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.SplitScheduler;
import org.apache.pulsar.broker.loadbalance.extensions.scheduler.UnloadScheduler;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStore;
import org.apache.pulsar.broker.loadbalance.extensions.store.LoadDataStoreFactory;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.BrokerSelectionStrategy;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.BrokerSelectionStrategyFactory;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.LeastResourceUsageWithWeight;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.broker.namespace.LookupOptions;
import org.apache.pulsar.broker.namespace.NamespaceEphemeralData;
import org.apache.pulsar.broker.namespace.NamespaceService;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.common.naming.NamespaceBundle;
import org.apache.pulsar.common.naming.NamespaceBundleSplitAlgorithm;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.metadata.api.coordination.LeaderElectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensibleLoadManagerImpl
implements ExtensibleLoadManager,
BrokerSelectionStrategyFactory {
    private static final Logger log = LoggerFactory.getLogger(ExtensibleLoadManagerImpl.class);
    public static final String BROKER_LOAD_DATA_STORE_TOPIC = TopicName.get((String)TopicDomain.non_persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"loadbalancer-broker-load-data").toString();
    public static final String TOP_BUNDLES_LOAD_DATA_STORE_TOPIC = TopicName.get((String)TopicDomain.non_persistent.value(), (NamespaceName)NamespaceName.SYSTEM_NAMESPACE, (String)"loadbalancer-top-bundles-load-data").toString();
    private static final long MAX_ROLE_CHANGE_RETRY_DELAY_IN_MILLIS = 200L;
    private static final long MONITOR_INTERVAL_IN_MILLIS = 120000L;
    public static final long COMPACTION_THRESHOLD = 0x500000L;
    private static final String ELECTION_ROOT = "/loadbalance/extension/leader";
    public static final Set<String> INTERNAL_TOPICS = Set.of(BROKER_LOAD_DATA_STORE_TOPIC, TOP_BUNDLES_LOAD_DATA_STORE_TOPIC, ServiceUnitStateChannelImpl.TOPIC);
    @VisibleForTesting
    protected PulsarService pulsar;
    private ServiceConfiguration conf;
    private BrokerRegistry brokerRegistry;
    private ServiceUnitStateChannel serviceUnitStateChannel;
    private AntiAffinityGroupPolicyFilter antiAffinityGroupPolicyFilter;
    private AntiAffinityGroupPolicyHelper antiAffinityGroupPolicyHelper;
    private IsolationPoliciesHelper isolationPoliciesHelper;
    private LoadDataStore<BrokerLoadData> brokerLoadDataStore;
    private LoadDataStore<TopBundlesLoadData> topBundlesLoadDataStore;
    private LoadManagerScheduler unloadScheduler;
    private LeaderElectionService leaderElectionService;
    private LoadManagerContext context;
    private final BrokerSelectionStrategy brokerSelectionStrategy;
    private final List<BrokerFilter> brokerFilterPipeline;
    private BrokerLoadDataReporter brokerLoadDataReporter;
    private TopBundleLoadDataReporter topBundleLoadDataReporter;
    private volatile ScheduledFuture brokerLoadDataReportTask;
    private volatile ScheduledFuture topBundlesLoadDataReportTask;
    private volatile ScheduledFuture monitorTask;
    private SplitScheduler splitScheduler;
    private UnloadManager unloadManager;
    private SplitManager splitManager;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INIT);
    private boolean configuredSystemTopics = false;
    private final AssignCounter assignCounter = new AssignCounter();
    private final UnloadCounter unloadCounter = new UnloadCounter();
    private final SplitCounter splitCounter = new SplitCounter();
    private final AtomicLong ignoredSendMsgCount = new AtomicLong();
    private final AtomicLong ignoredAckCount = new AtomicLong();
    private final AtomicReference<List<Metrics>> unloadMetrics = new AtomicReference();
    private final AtomicReference<List<Metrics>> splitMetrics = new AtomicReference();
    private final ConcurrentHashMap<String, CompletableFuture<Optional<BrokerLookupData>>> lookupRequests = new ConcurrentHashMap();
    private final CompletableFuture<Boolean> initWaiter = new CompletableFuture();
    private volatile Role role;

    public CompletableFuture<Set<NamespaceBundle>> getOwnedServiceUnitsAsync() {
        if (this.state.get() == State.INIT) {
            log.warn("Failed to get owned service units, load manager is not started.");
            return CompletableFuture.completedFuture(Collections.emptySet());
        }
        String brokerId = this.brokerRegistry.getBrokerId();
        Set<Map.Entry<String, ServiceUnitStateData>> entrySet = this.serviceUnitStateChannel.getOwnershipEntrySet();
        Set ownedServiceUnits = entrySet.stream().filter(entry -> {
            ServiceUnitStateData stateData = (ServiceUnitStateData)entry.getValue();
            return stateData.state() == ServiceUnitState.Owned && StringUtils.isNotBlank((String)stateData.dstBroker()) && stateData.dstBroker().equals(brokerId);
        }).map(entry -> {
            String bundle = (String)entry.getKey();
            return LoadManagerShared.getNamespaceBundle(this.pulsar, bundle);
        }).collect(Collectors.toSet());
        NamespaceName heartbeatNamespace = NamespaceService.getHeartbeatNamespace(brokerId, this.pulsar.getConfiguration());
        NamespaceName heartbeatNamespaceV2 = NamespaceService.getHeartbeatNamespaceV2(brokerId, this.pulsar.getConfiguration());
        NamespaceName slaMonitorNamespace = NamespaceService.getSLAMonitorNamespace(brokerId, this.pulsar.getConfiguration());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)this.pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(heartbeatNamespace).thenAccept(fullBundle -> ownedServiceUnits.add(fullBundle))).exceptionally(e -> {
            log.warn("Failed to get heartbeat namespace bundle.", e);
            return null;
        })).thenCompose(__ -> this.pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(heartbeatNamespaceV2))).thenAccept(fullBundle -> ownedServiceUnits.add(fullBundle))).exceptionally(e -> {
            log.warn("Failed to get heartbeat namespace V2 bundle.", e);
            return null;
        })).thenCompose(__ -> this.pulsar.getNamespaceService().getNamespaceBundleFactory().getFullBundleAsync(slaMonitorNamespace))).thenAccept(fullBundle -> ownedServiceUnits.add(fullBundle))).exceptionally(e -> {
            log.warn("Failed to get SLA Monitor namespace bundle.", e);
            return null;
        })).thenApply(__ -> ownedServiceUnits);
    }

    @Override
    public BrokerSelectionStrategy createBrokerSelectionStrategy() {
        return new LeastResourceUsageWithWeight();
    }

    public ExtensibleLoadManagerImpl() {
        this.brokerFilterPipeline = new ArrayList<BrokerFilter>();
        this.brokerFilterPipeline.add(new BrokerLoadManagerClassFilter());
        this.brokerFilterPipeline.add(new BrokerMaxTopicCountFilter());
        this.brokerFilterPipeline.add(new BrokerVersionFilter());
        this.brokerSelectionStrategy = this.createBrokerSelectionStrategy();
    }

    public static boolean isLoadManagerExtensionEnabled(PulsarService pulsar) {
        return pulsar.getLoadManager().get() instanceof ExtensibleLoadManagerWrapper;
    }

    public static ExtensibleLoadManagerImpl get(LoadManager loadManager) {
        if (!(loadManager instanceof ExtensibleLoadManagerWrapper)) {
            throw new IllegalArgumentException("The load manager should be 'ExtensibleLoadManagerWrapper'.");
        }
        ExtensibleLoadManagerWrapper loadManagerWrapper = (ExtensibleLoadManagerWrapper)loadManager;
        return loadManagerWrapper.get();
    }

    public static ExtensibleLoadManagerImpl get(PulsarService pulsar) {
        return ExtensibleLoadManagerImpl.get(pulsar.getLoadManager().get());
    }

    public static boolean debug(ServiceConfiguration config, Logger log) {
        return config.isLoadBalancerDebugModeEnabled() || log.isDebugEnabled();
    }

    public static void createSystemTopic(PulsarService pulsar, String topic) throws PulsarServerException {
        try {
            pulsar.getAdminClient().topics().createNonPartitionedTopic(topic);
            log.info("Created topic {}.", (Object)topic);
        }
        catch (PulsarAdminException.ConflictException ex) {
            if (ExtensibleLoadManagerImpl.debug(pulsar.getConfiguration(), log)) {
                log.info("Topic {} already exists.", (Object)topic);
            }
        }
        catch (PulsarAdminException e) {
            throw new PulsarServerException((Throwable)e);
        }
    }

    private static void createSystemTopics(PulsarService pulsar) throws PulsarServerException {
        ExtensibleLoadManagerImpl.createSystemTopic(pulsar, BROKER_LOAD_DATA_STORE_TOPIC);
        ExtensibleLoadManagerImpl.createSystemTopic(pulsar, TOP_BUNDLES_LOAD_DATA_STORE_TOPIC);
    }

    private static boolean configureSystemTopics(PulsarService pulsar) {
        try {
            if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(pulsar) && pulsar.getConfiguration().isSystemTopicAndTopicLevelPoliciesEnabled()) {
                Long threshold = pulsar.getAdminClient().topicPolicies().getCompactionThreshold(ServiceUnitStateChannelImpl.TOPIC);
                if (threshold == null || 0x500000L != threshold) {
                    pulsar.getAdminClient().topicPolicies().setCompactionThreshold(ServiceUnitStateChannelImpl.TOPIC, 0x500000L);
                    log.info("Set compaction threshold: {} bytes for system topic {}.", (Object)0x500000L, (Object)ServiceUnitStateChannelImpl.TOPIC);
                }
            } else {
                log.warn("System topic or topic level policies is disabled. {} compaction threshold follows the broker or namespace policies.", (Object)ServiceUnitStateChannelImpl.TOPIC);
            }
            return true;
        }
        catch (Exception e) {
            log.error("Failed to set compaction threshold for system topic:{}", (Object)ServiceUnitStateChannelImpl.TOPIC, (Object)e);
            return false;
        }
    }

    public static CompletableFuture<Optional<BrokerLookupData>> getAssignedBrokerLookupData(PulsarService pulsar, String topic) {
        ServiceConfiguration config = pulsar.getConfig();
        if (ExtensibleLoadManagerImpl.isLoadManagerExtensionEnabled(pulsar) && config.isLoadBalancerMultiPhaseBundleUnload()) {
            TopicName topicName = TopicName.get((String)topic);
            try {
                return pulsar.getNamespaceService().getBundleAsync(topicName).thenCompose(bundle -> {
                    ExtensibleLoadManagerImpl loadManager = ExtensibleLoadManagerImpl.get(pulsar);
                    Optional<String> assigned = loadManager.getServiceUnitStateChannel().getAssigned(bundle.toString());
                    if (assigned.isPresent()) {
                        return loadManager.getBrokerRegistry().lookupAsync(assigned.get());
                    }
                    return CompletableFuture.completedFuture(Optional.empty());
                });
            }
            catch (Throwable e) {
                log.error("Failed to lookup destination broker for topic:{}", (Object)topic, (Object)e);
                return CompletableFuture.completedFuture(Optional.empty());
            }
        }
        return CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    public void start() throws PulsarServerException {
        if (this.state.get() != State.INIT) {
            return;
        }
        try {
            this.brokerRegistry = this.createBrokerRegistry(this.pulsar);
            this.leaderElectionService = new LeaderElectionService(this.pulsar.getCoordinationService(), this.pulsar.getBrokerId(), this.pulsar.getSafeWebServiceAddress(), ELECTION_ROOT, state -> this.pulsar.runWhenReadyForIncomingRequests(() -> this.pulsar.getLoadManagerExecutor().execute(() -> {
                if (state == LeaderElectionState.Leading) {
                    this.playLeader();
                } else {
                    this.playFollower();
                }
            })));
            this.serviceUnitStateChannel = this.createServiceUnitStateChannel(this.pulsar);
            this.brokerRegistry.start();
            this.splitManager = new SplitManager(this.splitCounter);
            this.unloadManager = new UnloadManager(this.unloadCounter, this.pulsar.getBrokerId());
            this.serviceUnitStateChannel.listen(this.unloadManager);
            this.serviceUnitStateChannel.listen(this.splitManager);
            this.leaderElectionService.start();
            this.antiAffinityGroupPolicyHelper = new AntiAffinityGroupPolicyHelper(this.pulsar, this.serviceUnitStateChannel);
            this.antiAffinityGroupPolicyHelper.listenFailureDomainUpdate();
            this.antiAffinityGroupPolicyFilter = new AntiAffinityGroupPolicyFilter(this.antiAffinityGroupPolicyHelper);
            this.brokerFilterPipeline.add(this.antiAffinityGroupPolicyFilter);
            SimpleResourceAllocationPolicies policies = new SimpleResourceAllocationPolicies(this.pulsar);
            this.isolationPoliciesHelper = new IsolationPoliciesHelper(policies);
            this.brokerFilterPipeline.add(new BrokerIsolationPoliciesFilter(this.isolationPoliciesHelper));
            this.brokerLoadDataStore = LoadDataStoreFactory.create(this.pulsar, BROKER_LOAD_DATA_STORE_TOPIC, BrokerLoadData.class);
            this.topBundlesLoadDataStore = LoadDataStoreFactory.create(this.pulsar, TOP_BUNDLES_LOAD_DATA_STORE_TOPIC, TopBundlesLoadData.class);
            this.context = LoadManagerContextImpl.builder().configuration(this.conf).brokerRegistry(this.brokerRegistry).brokerLoadDataStore(this.brokerLoadDataStore).topBundleLoadDataStore(this.topBundlesLoadDataStore).build();
            this.brokerLoadDataReporter = new BrokerLoadDataReporter(this.pulsar, this.brokerRegistry.getBrokerId(), this.brokerLoadDataStore);
            this.topBundleLoadDataReporter = new TopBundleLoadDataReporter(this.pulsar, this.brokerRegistry.getBrokerId(), this.topBundlesLoadDataStore);
            this.serviceUnitStateChannel.listen(this.brokerLoadDataReporter);
            this.serviceUnitStateChannel.listen(this.topBundleLoadDataReporter);
            this.unloadScheduler = new UnloadScheduler(this.pulsar, this.pulsar.getLoadManagerExecutor(), this.unloadManager, this.context, this.serviceUnitStateChannel, this.unloadCounter, this.unloadMetrics);
            this.splitScheduler = new SplitScheduler(this.pulsar, this.serviceUnitStateChannel, this.splitManager, this.splitCounter, this.splitMetrics, this.context);
            this.pulsar.runWhenReadyForIncomingRequests(() -> {
                try {
                    this.serviceUnitStateChannel.start();
                    int interval = this.conf.getLoadBalancerReportUpdateMinIntervalMillis();
                    this.brokerLoadDataReportTask = this.pulsar.getLoadManagerExecutor().scheduleAtFixedRate(() -> {
                        try {
                            this.brokerLoadDataReporter.reportAsync(false);
                        }
                        catch (Throwable e) {
                            log.error("Failed to run the broker load manager executor job.", e);
                        }
                    }, interval, interval, TimeUnit.MILLISECONDS);
                    this.topBundlesLoadDataReportTask = this.pulsar.getLoadManagerExecutor().scheduleAtFixedRate(() -> {
                        try {
                            this.topBundleLoadDataReporter.reportAsync(false);
                        }
                        catch (Throwable e) {
                            log.error("Failed to run the top bundles load manager executor job.", e);
                        }
                    }, interval, interval, TimeUnit.MILLISECONDS);
                    this.monitorTask = this.pulsar.getLoadManagerExecutor().scheduleAtFixedRate(() -> this.monitor(), 120000L, 120000L, TimeUnit.MILLISECONDS);
                    this.splitScheduler.start();
                    this.initWaiter.complete(true);
                    if (!this.state.compareAndSet(State.INIT, State.RUNNING)) {
                        this.failForUnexpectedState("start");
                    }
                    log.info("Started load manager.");
                }
                catch (Throwable e) {
                    this.failStarting(e);
                }
            });
        }
        catch (Throwable ex) {
            this.failStarting(ex);
        }
    }

    private void failStarting(Throwable throwable) {
        if (this.brokerRegistry != null) {
            try {
                this.brokerRegistry.close();
            }
            catch (PulsarServerException e) {
                log.warn("Failed to close the broker registry: {}", (Object)e.getMessage());
            }
        }
        this.initWaiter.complete(false);
        throw PulsarServerException.toUncheckedException((PulsarServerException)PulsarServerException.from((Throwable)throwable));
    }

    @Override
    public void initialize(PulsarService pulsar) {
        this.pulsar = pulsar;
        this.conf = pulsar.getConfiguration();
    }

    @Override
    public CompletableFuture<Optional<BrokerLookupData>> assign(Optional<ServiceUnitId> topic, ServiceUnitId serviceUnit, LookupOptions options) {
        String bundle = serviceUnit.toString();
        return this.dedupeLookupRequest(bundle, k -> {
            CompletionStage<Optional<String>> owner = topic.isPresent() && ExtensibleLoadManagerImpl.isInternalTopic(((ServiceUnitId)topic.get()).toString()) ? this.serviceUnitStateChannel.getChannelOwnerAsync() : this.getHeartbeatOrSLAMonitorBrokerId(serviceUnit).thenCompose(candidateBrokerId -> {
                if (candidateBrokerId != null) {
                    return CompletableFuture.completedFuture(Optional.of(candidateBrokerId));
                }
                return this.getOrSelectOwnerAsync(serviceUnit, bundle, options).thenApply(Optional::ofNullable);
            });
            return this.getBrokerLookupData((CompletableFuture<Optional<String>>)owner, bundle);
        });
    }

    private CompletableFuture<String> getHeartbeatOrSLAMonitorBrokerId(ServiceUnitId serviceUnit) {
        return this.pulsar.getNamespaceService().getHeartbeatOrSLAMonitorBrokerId(serviceUnit, cb -> this.brokerRegistry.lookupAsync((String)cb).thenApply(Optional::isPresent));
    }

    private CompletableFuture<String> getOrSelectOwnerAsync(ServiceUnitId serviceUnit, String bundle, LookupOptions options) {
        return this.serviceUnitStateChannel.getOwnerAsync(bundle).thenCompose(broker -> {
            if (broker.isEmpty()) {
                return this.selectAsync(serviceUnit, Collections.emptySet(), options).thenCompose(brokerOpt -> {
                    if (brokerOpt.isPresent()) {
                        this.assignCounter.incrementSuccess();
                        log.info("Selected new owner broker: {} for bundle: {}.", brokerOpt.get(), (Object)bundle);
                        return this.serviceUnitStateChannel.publishAssignEventAsync(bundle, (String)brokerOpt.get());
                    }
                    return CompletableFuture.completedFuture(null);
                });
            }
            this.assignCounter.incrementSkip();
            return CompletableFuture.completedFuture((String)broker.get());
        });
    }

    private CompletableFuture<Optional<BrokerLookupData>> getBrokerLookupData(CompletableFuture<Optional<String>> owner, String bundle) {
        return owner.thenCompose(broker -> {
            if (broker.isEmpty()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.getBrokerRegistry().lookupAsync((String)broker.get()).thenCompose(brokerLookupData -> {
                if (brokerLookupData.isEmpty()) {
                    String errorMsg = String.format("Failed to lookup broker:%s for bundle:%s, the broker has not been registered.", broker, bundle);
                    log.error(errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                return CompletableFuture.completedFuture(brokerLookupData);
            });
        });
    }

    public CompletableFuture<NamespaceEphemeralData> tryAcquiringOwnership(NamespaceBundle namespaceBundle) {
        log.info("Try acquiring ownership for bundle: {} - {}.", (Object)namespaceBundle, (Object)this.brokerRegistry.getBrokerId());
        String bundle = namespaceBundle.toString();
        return this.assign(Optional.empty(), namespaceBundle, LookupOptions.builder().readOnly(false).build()).thenApply(brokerLookupData -> {
            if (brokerLookupData.isEmpty()) {
                String errorMsg = String.format("Failed to get the broker lookup data for bundle:%s", bundle);
                log.error(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            return ((BrokerLookupData)brokerLookupData.get()).toNamespaceEphemeralData();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<Optional<BrokerLookupData>> dedupeLookupRequest(String key, Function<String, CompletableFuture<Optional<BrokerLookupData>>> provider) {
        MutableObject newFutureCreated = new MutableObject();
        try {
            CompletableFuture completableFuture = this.lookupRequests.computeIfAbsent(key, k -> {
                CompletableFuture future = (CompletableFuture)provider.apply((String)k);
                newFutureCreated.setValue((Object)future);
                return future;
            });
            return completableFuture;
        }
        finally {
            if (newFutureCreated.getValue() != null) {
                ((CompletableFuture)newFutureCreated.getValue()).whenComplete((v, ex) -> {
                    if (ex != null) {
                        this.assignCounter.incrementFailure();
                    }
                    this.lookupRequests.remove(key);
                });
            }
        }
    }

    public CompletableFuture<Optional<String>> selectAsync(ServiceUnitId bundle, Set<String> excludeBrokerSet, LookupOptions options) {
        if (options.isReadOnly()) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        BrokerRegistry brokerRegistry = this.getBrokerRegistry();
        return brokerRegistry.getAvailableBrokerLookupDataAsync().thenComposeAsync(availableBrokers -> {
            LoadManagerContext context = this.getContext();
            ConcurrentHashMap<String, BrokerLookupData> availableBrokerCandidates = new ConcurrentHashMap<String, BrokerLookupData>((Map<String, BrokerLookupData>)availableBrokers);
            if (!excludeBrokerSet.isEmpty()) {
                for (String exclude : excludeBrokerSet) {
                    availableBrokerCandidates.remove(exclude);
                }
            }
            List<BrokerFilter> filterPipeline = this.getBrokerFilterPipeline();
            ArrayList<CompletableFuture<Map<String, BrokerLookupData>>> futures = new ArrayList<CompletableFuture<Map<String, BrokerLookupData>>>(filterPipeline.size());
            for (BrokerFilter filter : filterPipeline) {
                CompletableFuture<Map<String, BrokerLookupData>> future = filter.filterAsync(availableBrokerCandidates, bundle, context);
                futures.add(future);
            }
            return ((CompletableFuture)FutureUtil.waitForAll(futures).exceptionally(e -> {
                log.error("Failed to filter out brokers when select bundle: {}", (Object)bundle, e);
                return null;
            })).thenApply(__ -> {
                if (availableBrokerCandidates.isEmpty()) {
                    return Optional.empty();
                }
                Set<String> candidateBrokers = availableBrokerCandidates.keySet();
                return this.getBrokerSelectionStrategy().select(candidateBrokers, bundle, context);
            });
        });
    }

    @Override
    public CompletableFuture<Boolean> checkOwnershipAsync(Optional<ServiceUnitId> topic, ServiceUnitId bundleUnit) {
        return this.getOwnershipAsync(topic, bundleUnit).thenApply(broker -> this.brokerRegistry.getBrokerId().equals(broker.orElse(null)));
    }

    public CompletableFuture<Optional<String>> getOwnershipAsync(Optional<ServiceUnitId> topic, ServiceUnitId serviceUnit) {
        String bundle = serviceUnit.toString();
        if (topic.isPresent() && ExtensibleLoadManagerImpl.isInternalTopic(topic.get().toString())) {
            return this.serviceUnitStateChannel.getChannelOwnerAsync();
        }
        return this.getHeartbeatOrSLAMonitorBrokerId(serviceUnit).thenCompose(candidateBroker -> {
            if (candidateBroker != null) {
                return CompletableFuture.completedFuture(Optional.of(candidateBroker));
            }
            return this.serviceUnitStateChannel.getOwnerAsync(bundle);
        });
    }

    public CompletableFuture<Optional<BrokerLookupData>> getOwnershipWithLookupDataAsync(ServiceUnitId bundleUnit) {
        return this.getOwnershipAsync(Optional.empty(), bundleUnit).thenCompose(broker -> {
            if (broker.isEmpty()) {
                return CompletableFuture.completedFuture(Optional.empty());
            }
            return this.getBrokerRegistry().lookupAsync((String)broker.get());
        });
    }

    public CompletableFuture<Void> unloadNamespaceBundleAsync(ServiceUnitId bundle, Optional<String> destinationBroker, boolean force, long timeout, TimeUnit timeoutUnit) {
        if (this.state.get() == State.INIT) {
            return CompletableFuture.completedFuture(null);
        }
        if (NamespaceService.isSLAOrHeartbeatNamespace(bundle.getNamespaceObject().toString())) {
            log.info("Skip unloading namespace bundle: {}.", (Object)bundle);
            return CompletableFuture.completedFuture(null);
        }
        return this.getOwnershipAsync(Optional.empty(), bundle).thenCompose(brokerOpt -> {
            if (brokerOpt.isEmpty()) {
                String msg = String.format("Namespace bundle: %s is not owned by any broker.", bundle);
                log.warn(msg);
                throw new IllegalStateException(msg);
            }
            String sourceBroker = (String)brokerOpt.get();
            if (destinationBroker.isPresent() && sourceBroker.endsWith((String)destinationBroker.get())) {
                String msg = String.format("Namespace bundle: %s own by %s, cannot be transfer to same broker.", bundle, sourceBroker);
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            Unload unload = new Unload(sourceBroker, bundle.toString(), destinationBroker, force);
            UnloadDecision unloadDecision = new UnloadDecision(unload, UnloadDecision.Label.Success, UnloadDecision.Reason.Admin);
            return this.unloadAsync(unloadDecision, timeout, timeoutUnit);
        });
    }

    private CompletableFuture<Void> unloadAsync(UnloadDecision unloadDecision, long timeout, TimeUnit timeoutUnit) {
        Unload unload = unloadDecision.getUnload();
        CompletableFuture<Void> future = this.serviceUnitStateChannel.publishUnloadEventAsync(unload);
        return this.unloadManager.waitAsync(future, unload.serviceUnit(), unloadDecision, timeout, timeoutUnit).thenRun(() -> this.unloadCounter.updateUnloadBrokerCount(1));
    }

    public CompletableFuture<Void> splitNamespaceBundleAsync(ServiceUnitId bundle, NamespaceBundleSplitAlgorithm splitAlgorithm, List<Long> boundaries) {
        if (NamespaceService.isSLAOrHeartbeatNamespace(bundle.getNamespaceObject().toString())) {
            log.info("Skip split namespace bundle: {}.", (Object)bundle);
            return CompletableFuture.completedFuture(null);
        }
        String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(bundle.toString());
        String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(bundle.toString());
        NamespaceBundle namespaceBundle = this.pulsar.getNamespaceService().getNamespaceBundleFactory().getBundle(namespaceName, bundleRange);
        return this.pulsar.getNamespaceService().getSplitBoundary(namespaceBundle, splitAlgorithm, boundaries).thenCompose(splitBundlesPair -> {
            if (splitBundlesPair == null) {
                String msg = String.format("Bundle %s not found under namespace", namespaceBundle);
                log.error(msg);
                return FutureUtil.failedFuture((Throwable)new IllegalStateException(msg));
            }
            return this.getOwnershipAsync(Optional.empty(), bundle).thenCompose(brokerOpt -> {
                if (brokerOpt.isEmpty()) {
                    String msg = String.format("Namespace bundle: %s is not owned by any broker.", bundle);
                    log.warn(msg);
                    throw new IllegalStateException(msg);
                }
                String sourceBroker = (String)brokerOpt.get();
                SplitDecision splitDecision = new SplitDecision();
                List splitBundles = (List)splitBundlesPair.getRight();
                HashMap<String, Optional<String>> splitServiceUnitToDestBroker = new HashMap<String, Optional<String>>();
                splitBundles.forEach(splitBundle -> splitServiceUnitToDestBroker.put(splitBundle.getBundleRange(), Optional.empty()));
                splitDecision.setSplit(new Split(bundle.toString(), sourceBroker, splitServiceUnitToDestBroker));
                splitDecision.setLabel(SplitDecision.Label.Success);
                splitDecision.setReason(SplitDecision.Reason.Admin);
                return this.splitAsync(splitDecision, this.conf.getNamespaceBundleUnloadingTimeoutMs(), TimeUnit.MILLISECONDS);
            });
        });
    }

    private CompletableFuture<Void> splitAsync(SplitDecision decision, long timeout, TimeUnit timeoutUnit) {
        Split split = decision.getSplit();
        CompletableFuture<Void> future = this.serviceUnitStateChannel.publishSplitEventAsync(split);
        return this.splitManager.waitAsync(future, decision.getSplit().serviceUnit(), decision, timeout, timeoutUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws PulsarServerException {
        if (this.state.get() == State.INIT) {
            return;
        }
        try {
            this.stopLoadDataReportTasks();
            this.unloadScheduler.close();
            this.splitScheduler.close();
            return;
        }
        finally {
            try {
                this.brokerRegistry.close();
            }
            finally {
                try {
                    this.serviceUnitStateChannel.close();
                }
                finally {
                    this.unloadManager.close();
                    try {
                        this.leaderElectionService.close();
                    }
                    catch (Exception e) {
                        throw new PulsarServerException((Throwable)e);
                    }
                    finally {
                        this.state.set(State.INIT);
                    }
                }
            }
        }
    }

    private void stopLoadDataReportTasks() {
        if (this.brokerLoadDataReportTask != null) {
            this.brokerLoadDataReportTask.cancel(true);
        }
        if (this.topBundlesLoadDataReportTask != null) {
            this.topBundlesLoadDataReportTask.cancel(true);
        }
        if (this.monitorTask != null) {
            this.monitorTask.cancel(true);
        }
        try {
            this.brokerLoadDataStore.shutdown();
        }
        catch (IOException e) {
            log.warn("Failed to shutdown brokerLoadDataStore", (Throwable)e);
        }
        try {
            this.topBundlesLoadDataStore.shutdown();
        }
        catch (IOException e) {
            log.warn("Failed to shutdown topBundlesLoadDataStore", (Throwable)e);
        }
    }

    public static boolean isInternalTopic(String topic) {
        return INTERNAL_TOPICS.contains(topic) || topic.startsWith(ServiceUnitStateChannelImpl.TOPIC) || topic.startsWith(BROKER_LOAD_DATA_STORE_TOPIC) || topic.startsWith(TOP_BUNDLES_LOAD_DATA_STORE_TOPIC);
    }

    private boolean handleNoChannelOwnerError(Throwable e) {
        if (FutureUtil.unwrapCompletionException((Throwable)e).getMessage().contains("no channel owner now")) {
            LeaderElectionService leaderElectionService = this.getLeaderElectionService();
            log.warn("No channel owner is found. Trying to start LeaderElectionService again.");
            leaderElectionService.start();
            Optional<String> channelOwner = this.serviceUnitStateChannel.getChannelOwnerAsync().join();
            if (channelOwner.isEmpty()) {
                log.error("Still no Leader is found even after LeaderElectionService restarted.");
                return false;
            }
            log.info("Successfully started LeaderElectionService. The new channel owner is {}", channelOwner);
            return true;
        }
        return false;
    }

    @VisibleForTesting
    synchronized void playLeader() {
        log.info("This broker:{} is setting the role from {} to {}", new Object[]{this.pulsar.getBrokerId(), this.role, Role.Leader});
        int retry = 0;
        boolean becameFollower = false;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!this.initWaiter.get().booleanValue() || this.disabled()) {
                    return;
                }
                try {
                    if (!this.serviceUnitStateChannel.isChannelOwner()) {
                        becameFollower = true;
                        break;
                    }
                }
                catch (Throwable e) {
                    if (this.handleNoChannelOwnerError(e)) continue;
                    throw e;
                }
                if (this.disabled()) {
                    return;
                }
                ExtensibleLoadManagerImpl.createSystemTopics(this.pulsar);
                this.brokerLoadDataStore.init();
                this.topBundlesLoadDataStore.init();
                this.unloadScheduler.start();
                this.serviceUnitStateChannel.scheduleOwnershipMonitor();
                break;
            }
            catch (Throwable e) {
                if (this.disabled()) {
                    log.warn("The broker:{} failed to set the role but exit because it's disabled", (Object)this.pulsar.getBrokerId(), (Object)e);
                    return;
                }
                log.warn("The broker:{} failed to set the role. Retrying {} th ...", new Object[]{this.pulsar.getBrokerId(), ++retry, e});
                try {
                    Thread.sleep(Math.min((long)(retry * 10), 200L));
                }
                catch (InterruptedException ex) {
                    log.warn("Interrupted while sleeping.");
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.disabled()) {
            return;
        }
        if (becameFollower) {
            log.warn("The broker:{} became follower while initializing leader role.", (Object)this.pulsar.getBrokerId());
            this.playFollower();
            return;
        }
        this.role = Role.Leader;
        log.info("This broker:{} plays the leader now.", (Object)this.pulsar.getBrokerId());
        this.brokerLoadDataReporter.reportAsync(true);
        this.topBundleLoadDataReporter.reportAsync(true);
    }

    @VisibleForTesting
    synchronized void playFollower() {
        log.info("This broker:{} is setting the role from {} to {}", new Object[]{this.pulsar.getBrokerId(), this.role, Role.Follower});
        int retry = 0;
        boolean becameLeader = false;
        while (!Thread.currentThread().isInterrupted()) {
            try {
                if (!this.initWaiter.get().booleanValue() || this.disabled()) {
                    return;
                }
                try {
                    if (this.serviceUnitStateChannel.isChannelOwner()) {
                        becameLeader = true;
                        break;
                    }
                }
                catch (Throwable e) {
                    if (this.handleNoChannelOwnerError(e)) continue;
                    throw e;
                }
                if (this.disabled()) {
                    return;
                }
                this.unloadScheduler.close();
                this.serviceUnitStateChannel.cancelOwnershipMonitor();
                this.closeInternalTopics();
                this.brokerLoadDataStore.init();
                this.topBundlesLoadDataStore.close();
                this.topBundlesLoadDataStore.startProducer();
                break;
            }
            catch (Throwable e) {
                if (this.disabled()) {
                    log.warn("The broker:{} failed to set the role but exit because it's disabled", (Object)this.pulsar.getBrokerId(), (Object)e);
                    return;
                }
                log.warn("The broker:{} failed to set the role. Retrying {} th ...", new Object[]{this.pulsar.getBrokerId(), ++retry, e});
                try {
                    Thread.sleep(Math.min((long)(retry * 10), 200L));
                }
                catch (InterruptedException ex) {
                    log.warn("Interrupted while sleeping.");
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.disabled()) {
            return;
        }
        if (becameLeader) {
            log.warn("This broker:{} became leader while initializing follower role.", (Object)this.pulsar.getBrokerId());
            this.playLeader();
            return;
        }
        this.role = Role.Follower;
        log.info("This broker:{} plays a follower now.", (Object)this.pulsar.getBrokerId());
        this.brokerLoadDataReporter.reportAsync(true);
        this.topBundleLoadDataReporter.reportAsync(true);
    }

    public List<Metrics> getMetrics() {
        ArrayList<Metrics> metricsCollection = new ArrayList<Metrics>();
        if (this.brokerLoadDataReporter != null) {
            metricsCollection.addAll(this.brokerLoadDataReporter.generateLoadData().toMetrics(this.pulsar.getAdvertisedAddress()));
        }
        if (this.unloadMetrics.get() != null) {
            metricsCollection.addAll((Collection)this.unloadMetrics.get());
        }
        if (this.splitMetrics.get() != null) {
            metricsCollection.addAll((Collection)this.splitMetrics.get());
        }
        metricsCollection.addAll(this.assignCounter.toMetrics(this.pulsar.getAdvertisedAddress()));
        metricsCollection.addAll(this.serviceUnitStateChannel.getMetrics());
        metricsCollection.addAll(this.getIgnoredCommandMetrics(this.pulsar.getAdvertisedAddress()));
        return metricsCollection;
    }

    private List<Metrics> getIgnoredCommandMetrics(String advertisedBrokerAddress) {
        Map<String, String> dimensions = Map.of("broker", advertisedBrokerAddress, "metric", "bundleUnloading");
        Metrics metric = Metrics.create(dimensions);
        metric.put("brk_lb_ignored_ack_total", (Object)this.ignoredAckCount.get());
        metric.put("brk_lb_ignored_send_total", (Object)this.ignoredSendMsgCount.get());
        return List.of(metric);
    }

    @VisibleForTesting
    protected void monitor() {
        try {
            if (!this.initWaiter.get().booleanValue()) {
                return;
            }
            this.validateBrokerRegistry();
            boolean isChannelOwner = false;
            try {
                isChannelOwner = this.serviceUnitStateChannel.isChannelOwner();
            }
            catch (Throwable e) {
                if (this.handleNoChannelOwnerError(e)) {
                    this.monitor();
                }
                throw e;
            }
            if (isChannelOwner) {
                if (!this.configuredSystemTopics) {
                    this.configuredSystemTopics = ExtensibleLoadManagerImpl.configureSystemTopics(this.pulsar);
                }
                if (this.role != Role.Leader) {
                    log.warn("Current role:{} does not match with the channel ownership:{}. Playing the leader role.", (Object)this.role, (Object)isChannelOwner);
                    this.playLeader();
                }
            } else if (this.role != Role.Follower) {
                log.warn("Current role:{} does not match with the channel ownership:{}. Playing the follower role.", (Object)this.role, (Object)isChannelOwner);
                this.playFollower();
            }
        }
        catch (Throwable e) {
            log.error("Failed to monitor load manager state", e);
        }
    }

    public void disableBroker() throws Exception {
        if (!this.state.compareAndSet(State.RUNNING, State.DISABLED)) {
            this.failForUnexpectedState("disableBroker");
        }
        this.stopLoadDataReportTasks();
        this.serviceUnitStateChannel.cleanOwnerships();
        this.brokerRegistry.unregister();
        this.leaderElectionService.close();
        List<String> availableBrokers = this.brokerRegistry.getAvailableBrokersAsync().get(this.conf.getMetadataStoreOperationTimeoutSeconds(), TimeUnit.SECONDS);
        if (availableBrokers.isEmpty()) {
            this.close();
        }
        this.closeInternalTopics();
    }

    private void closeInternalTopics() {
        ArrayList futures = new ArrayList();
        for (String name : INTERNAL_TOPICS) {
            this.pulsar.getBrokerService().getTopicReference(name).ifPresent(topic -> futures.add(topic.close(true).exceptionally(__ -> {
                log.warn("Failed to close internal topic:{}", (Object)name);
                return null;
            })));
        }
        try {
            FutureUtil.waitForAll(futures).get(this.pulsar.getConfiguration().getNamespaceBundleUnloadingTimeoutMs(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            log.warn("Failed to wait for closing internal topics", e);
        }
    }

    @VisibleForTesting
    protected BrokerRegistry createBrokerRegistry(PulsarService pulsar) {
        return new BrokerRegistryImpl(pulsar);
    }

    @VisibleForTesting
    protected ServiceUnitStateChannel createServiceUnitStateChannel(PulsarService pulsar) {
        return new ServiceUnitStateChannelImpl(pulsar);
    }

    private void failForUnexpectedState(String msg) {
        throw new IllegalStateException("Failed to " + msg + ", state: " + String.valueOf((Object)this.state.get()));
    }

    boolean running() {
        return this.state.get() == State.RUNNING;
    }

    private boolean disabled() {
        return this.state.get() == State.DISABLED;
    }

    private void validateBrokerRegistry() throws ExecutionException, InterruptedException, TimeoutException {
        int timeout = this.pulsar.getConfiguration().getMetadataStoreOperationTimeoutSeconds();
        Optional<BrokerLookupData> lookup = this.brokerRegistry.lookupAsync(this.brokerRegistry.getBrokerId()).get(timeout, TimeUnit.SECONDS);
        if (lookup.isEmpty()) {
            log.warn("Found this broker:{} has not registered yet. Trying to register it", (Object)this.brokerRegistry.getBrokerId());
            this.brokerRegistry.registerAsync().get(timeout, TimeUnit.SECONDS);
        }
    }

    public BrokerRegistry getBrokerRegistry() {
        return this.brokerRegistry;
    }

    public ServiceUnitStateChannel getServiceUnitStateChannel() {
        return this.serviceUnitStateChannel;
    }

    public AntiAffinityGroupPolicyHelper getAntiAffinityGroupPolicyHelper() {
        return this.antiAffinityGroupPolicyHelper;
    }

    public IsolationPoliciesHelper getIsolationPoliciesHelper() {
        return this.isolationPoliciesHelper;
    }

    public LoadDataStore<BrokerLoadData> getBrokerLoadDataStore() {
        return this.brokerLoadDataStore;
    }

    public LoadDataStore<TopBundlesLoadData> getTopBundlesLoadDataStore() {
        return this.topBundlesLoadDataStore;
    }

    public LeaderElectionService getLeaderElectionService() {
        return this.leaderElectionService;
    }

    public LoadManagerContext getContext() {
        return this.context;
    }

    public BrokerSelectionStrategy getBrokerSelectionStrategy() {
        return this.brokerSelectionStrategy;
    }

    public List<BrokerFilter> getBrokerFilterPipeline() {
        return this.brokerFilterPipeline;
    }

    public UnloadCounter getUnloadCounter() {
        return this.unloadCounter;
    }

    public AtomicLong getIgnoredSendMsgCount() {
        return this.ignoredSendMsgCount;
    }

    public AtomicLong getIgnoredAckCount() {
        return this.ignoredAckCount;
    }

    public Role getRole() {
        return this.role;
    }

    static enum State {
        INIT,
        RUNNING,
        DISABLED;

    }

    public static enum Role {
        Leader,
        Follower;

    }
}

