/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.bucket;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.util.Futures;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.pulsar.broker.delayed.bucket.Bucket;
import org.apache.pulsar.broker.delayed.bucket.BucketDelayedDeliveryTracker;
import org.apache.pulsar.broker.delayed.bucket.BucketDelayedMessageIndexStats;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotPersistenceException;
import org.apache.pulsar.broker.delayed.bucket.BucketSnapshotStorage;
import org.apache.pulsar.broker.delayed.proto.DelayedIndex;
import org.apache.pulsar.broker.delayed.proto.SnapshotSegment;
import org.apache.pulsar.broker.delayed.proto.SnapshotSegmentMetadata;
import org.apache.pulsar.common.util.FutureUtil;
import org.roaringbitmap.InvalidRoaringFormat;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImmutableBucket
extends Bucket {
    private static final Logger log = LoggerFactory.getLogger(ImmutableBucket.class);
    private List<SnapshotSegment> snapshotSegments;
    boolean merging = false;
    List<Long> firstScheduleTimestamps = new ArrayList<Long>();

    ImmutableBucket(String dispatcherName, ManagedCursor cursor, FutureUtil.Sequencer<Void> sequencer, BucketSnapshotStorage storage, long startLedgerId, long endLedgerId) {
        super(dispatcherName, cursor, sequencer, storage, startLedgerId, endLedgerId);
    }

    public Optional<List<SnapshotSegment>> getSnapshotSegments() {
        return Optional.ofNullable(this.snapshotSegments);
    }

    CompletableFuture<List<DelayedIndex>> asyncLoadNextBucketSnapshotEntry() {
        return this.asyncLoadNextBucketSnapshotEntry(false, null);
    }

    CompletableFuture<List<DelayedIndex>> asyncRecoverBucketSnapshotEntry(Supplier<Long> cutoffTimeSupplier) {
        return this.asyncLoadNextBucketSnapshotEntry(true, cutoffTimeSupplier);
    }

    private CompletableFuture<List<DelayedIndex>> asyncLoadNextBucketSnapshotEntry(boolean isRecover, Supplier<Long> cutoffTimeSupplier) {
        CompletionStage<Integer> loadMetaDataFuture;
        long bucketId = this.getAndUpdateBucketId();
        if (isRecover) {
            long cutoffTime = cutoffTimeSupplier.get();
            String bucketKey = this.bucketKey();
            loadMetaDataFuture = Futures.executeWithRetry(() -> this.bucketSnapshotStorage.getBucketSnapshotMetadata(bucketId).whenComplete((___, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to get bucket snapshot metadata, bucketKey: {}, bucketId: {}", new Object[]{this.dispatcherName, bucketKey, bucketId, ex});
                }
            }), BucketSnapshotPersistenceException.class, (int)3).thenApply(snapshotMetadata -> {
                int nextSnapshotEntryIndex;
                List<SnapshotSegmentMetadata> metadataList = snapshotMetadata.getMetadataListList();
                for (nextSnapshotEntryIndex = 0; nextSnapshotEntryIndex < metadataList.size() && metadataList.get(nextSnapshotEntryIndex).getMaxScheduleTimestamp() <= cutoffTime; ++nextSnapshotEntryIndex) {
                }
                this.setLastSegmentEntryId(metadataList.size());
                this.recoverDelayedIndexBitMapAndNumber(nextSnapshotEntryIndex, metadataList);
                List<Long> firstScheduleTimestamps = metadataList.stream().map(SnapshotSegmentMetadata::getMinScheduleTimestamp).toList();
                this.setFirstScheduleTimestamps(firstScheduleTimestamps);
                return nextSnapshotEntryIndex + 1;
            });
        } else {
            loadMetaDataFuture = CompletableFuture.completedFuture(this.currentSegmentEntryId + 1);
        }
        return loadMetaDataFuture.thenCompose(nextSegmentEntryId -> {
            if (nextSegmentEntryId > this.lastSegmentEntryId) {
                return CompletableFuture.completedFuture(null);
            }
            return Futures.executeWithRetry(() -> this.bucketSnapshotStorage.getBucketSnapshotSegment(bucketId, nextSegmentEntryId.intValue(), nextSegmentEntryId.intValue()).whenComplete((___, ex) -> {
                if (ex != null) {
                    log.warn("[{}] Failed to get bucket snapshot segment. bucketKey: {}, bucketId: {}, segmentEntryId: {}", new Object[]{this.dispatcherName, this.bucketKey(), bucketId, nextSegmentEntryId, ex});
                }
            }), BucketSnapshotPersistenceException.class, (int)3).thenApply(bucketSnapshotSegments -> {
                if (CollectionUtils.isEmpty((Collection)bucketSnapshotSegments)) {
                    return Collections.emptyList();
                }
                SnapshotSegment snapshotSegment = (SnapshotSegment)bucketSnapshotSegments.get(0);
                List<DelayedIndex> indexList = snapshotSegment.getIndexesList();
                this.setCurrentSegmentEntryId((int)nextSegmentEntryId);
                if (isRecover) {
                    this.asyncUpdateSnapshotLength();
                }
                return indexList;
            });
        });
    }

    private void recoverDelayedIndexBitMapAndNumber(int startSnapshotIndex, List<SnapshotSegmentMetadata> segmentMetaList) {
        this.delayedIndexBitMap.clear();
        MutableLong numberMessages = new MutableLong(0L);
        for (int i = startSnapshotIndex; i < segmentMetaList.size(); ++i) {
            for (Map.Entry<Long, ByteString> entry : segmentMetaList.get(i).getDelayedIndexBitMapMap().entrySet()) {
                Long ledgerId = entry.getKey();
                ByteString bs = entry.getValue();
                RoaringBitmap sbm = new RoaringBitmap();
                try {
                    sbm.deserialize(bs.asReadOnlyByteBuffer());
                }
                catch (IOException e) {
                    throw new InvalidRoaringFormat(e.getMessage());
                }
                numberMessages.add((long)sbm.getCardinality());
                this.delayedIndexBitMap.compute(ledgerId, (lId, bm) -> {
                    if (bm == null) {
                        return sbm;
                    }
                    bm.or(sbm);
                    return bm;
                });
            }
        }
        this.delayedIndexBitMap.values().forEach(RoaringBitmap::runOptimize);
        this.setNumberBucketDelayedMessages(numberMessages.getValue());
    }

    CompletableFuture<List<SnapshotSegment>> getRemainSnapshotSegment() {
        int nextSegmentEntryId = this.currentSegmentEntryId + 1;
        if (nextSegmentEntryId > this.lastSegmentEntryId) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        return Futures.executeWithRetry(() -> this.bucketSnapshotStorage.getBucketSnapshotSegment(this.getAndUpdateBucketId(), nextSegmentEntryId, this.lastSegmentEntryId).whenComplete((__, ex) -> {
            if (ex != null) {
                log.warn("[{}] Failed to get remain bucket snapshot segment, bucketKey: {}, nextSegmentEntryId: {}, lastSegmentEntryId: {}", new Object[]{this.dispatcherName, this.bucketKey(), nextSegmentEntryId, this.lastSegmentEntryId, ex});
            }
        }), BucketSnapshotPersistenceException.class, (int)3);
    }

    CompletableFuture<Void> asyncDeleteBucketSnapshot(BucketDelayedMessageIndexStats stats) {
        long deleteStartTime = System.currentTimeMillis();
        stats.recordTriggerEvent(BucketDelayedMessageIndexStats.Type.delete);
        String bucketKey = this.bucketKey();
        long bucketId = this.getAndUpdateBucketId();
        return ((CompletableFuture)Futures.executeWithRetry(() -> this.bucketSnapshotStorage.deleteBucketSnapshot(bucketId), BucketSnapshotPersistenceException.class, (int)3).whenComplete((__, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to delete bucket snapshot, bucketId: {}, bucketKey: {}", new Object[]{this.dispatcherName, bucketId, bucketKey, ex});
                stats.recordFailEvent(BucketDelayedMessageIndexStats.Type.delete);
            } else {
                log.info("[{}] Delete bucket snapshot finish, bucketId: {}, bucketKey: {}", new Object[]{this.dispatcherName, bucketId, bucketKey});
                stats.recordSuccessEvent(BucketDelayedMessageIndexStats.Type.delete, System.currentTimeMillis() - deleteStartTime);
            }
        })).thenCompose(__ -> this.removeBucketCursorProperty(bucketKey));
    }

    CompletableFuture<Void> clear(BucketDelayedMessageIndexStats stats) {
        this.delayedIndexBitMap.clear();
        return ((CompletableFuture)this.getSnapshotCreateFuture().orElse(BucketDelayedDeliveryTracker.NULL_LONG_PROMISE).exceptionally(e -> null)).thenCompose(__ -> this.asyncDeleteBucketSnapshot(stats));
    }

    protected CompletableFuture<Long> asyncUpdateSnapshotLength() {
        long bucketId = this.getAndUpdateBucketId();
        return this.bucketSnapshotStorage.getBucketSnapshotLength(bucketId).whenComplete((length, ex) -> {
            if (ex != null) {
                log.error("[{}] Failed to get snapshot length, bucketId: {}, bucketKey: {}", new Object[]{this.dispatcherName, bucketId, this.bucketKey(), ex});
            } else {
                this.setSnapshotLength((long)length);
            }
        });
    }

    public void setSnapshotSegments(List<SnapshotSegment> snapshotSegments) {
        this.snapshotSegments = snapshotSegments;
    }

    public void setFirstScheduleTimestamps(List<Long> firstScheduleTimestamps) {
        this.firstScheduleTimestamps = firstScheduleTimestamps;
    }
}

