/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.stub.StreamObserver;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.pool.TypePool;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.functions.WindowConfig;
import org.apache.pulsar.common.nar.NarClassLoader;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceCache;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.proto.InstanceCommunication;
import org.apache.pulsar.functions.proto.InstanceControlGrpc;
import org.apache.pulsar.functions.runtime.Runtime;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntime;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.secretsprovider.ClearTextSecretsProvider;
import org.apache.pulsar.functions.secretsprovider.SecretsProvider;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheManager;
import org.apache.pulsar.functions.utils.functioncache.FunctionCacheManagerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class JavaInstanceStarter
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JavaInstanceStarter.class);
    @CommandLine.Option(names={"--function_details"}, description={"Function details json\n"}, required=true)
    public String functionDetailsJsonString;
    @CommandLine.Option(names={"--jar"}, description={"Path to Jar\n"})
    public String jarFile;
    @CommandLine.Option(names={"--transform_function_jar"}, description={"Path to Transform Function Jar\n"})
    public String transformFunctionJarFile;
    @CommandLine.Option(names={"--instance_id"}, description={"Instance Id\n"}, required=true)
    public int instanceId;
    @CommandLine.Option(names={"--function_id"}, description={"Function Id\n"}, required=true)
    public String functionId;
    @CommandLine.Option(names={"--function_version"}, description={"Function Version\n"}, required=true)
    public String functionVersion;
    @CommandLine.Option(names={"--pulsar_serviceurl"}, description={"Pulsar Service Url\n"}, required=true)
    public String pulsarServiceUrl;
    @CommandLine.Option(names={"--transform_function_id"}, description={"Transform Function Id\n"})
    public String transformFunctionId;
    @CommandLine.Option(names={"--client_auth_plugin"}, description={"Client auth plugin name\n"})
    public String clientAuthenticationPlugin;
    @CommandLine.Option(names={"--client_auth_params"}, description={"Client auth param\n"})
    public String clientAuthenticationParameters;
    @CommandLine.Option(names={"--use_tls"}, description={"Use tls connection\n"})
    public String useTls = Boolean.FALSE.toString();
    @CommandLine.Option(names={"--tls_allow_insecure"}, description={"Allow insecure tls connection\n"})
    public String tlsAllowInsecureConnection = Boolean.FALSE.toString();
    @CommandLine.Option(names={"--hostname_verification_enabled"}, description={"Enable hostname verification"})
    public String tlsHostNameVerificationEnabled = Boolean.FALSE.toString();
    @CommandLine.Option(names={"--tls_trust_cert_path"}, description={"tls trust cert file path"})
    public String tlsTrustCertFilePath;
    @CommandLine.Option(names={"--state_storage_impl_class"}, description={"State Storage Service Implementation class\n"}, required=false)
    public String stateStorageImplClass;
    @CommandLine.Option(names={"--state_storage_serviceurl"}, description={"State Storage Service Url\n"}, required=false)
    public String stateStorageServiceUrl;
    @CommandLine.Option(names={"--port"}, description={"Port to listen on\n"}, required=true)
    public int port;
    @CommandLine.Option(names={"--metrics_port"}, description={"Port metrics will be exposed on\n"}, required=true)
    public int metricsPort;
    @CommandLine.Option(names={"--max_buffered_tuples"}, description={"Maximum number of tuples to buffer\n"}, required=true)
    public int maxBufferedTuples;
    @CommandLine.Option(names={"--expected_healthcheck_interval"}, description={"Expected interval in seconds between healtchecks"}, required=true)
    public int expectedHealthCheckInterval;
    @CommandLine.Option(names={"--secrets_provider"}, description={"The classname of the secrets provider"}, required=false)
    public String secretsProviderClassName;
    @CommandLine.Option(names={"--secrets_provider_config"}, description={"The config that needs to be passed to secrets provider"}, required=false)
    public String secretsProviderConfig;
    @CommandLine.Option(names={"--cluster_name"}, description={"The name of the cluster this instance is running on"}, required=true)
    public String clusterName;
    @CommandLine.Option(names={"--nar_extraction_directory"}, description={"The directory where extraction of nar packages happen"}, required=false)
    public String narExtractionDirectory = NarClassLoader.DEFAULT_NAR_EXTRACTION_DIR;
    @CommandLine.Option(names={"--pending_async_requests"}, description={"Max pending async requests per instance"}, required=false)
    public int maxPendingAsyncRequests = 1000;
    @CommandLine.Option(names={"--web_serviceurl"}, description={"Pulsar Web Service Url"}, required=false)
    public String webServiceUrl = null;
    @CommandLine.Option(names={"--expose_pulsaradmin"}, description={"Whether the pulsar admin client exposed to function context, default is disabled."}, required=false)
    public Boolean exposePulsarAdminClientEnabled = false;
    @CommandLine.Option(names={"--ignore_unknown_config_fields"}, description={"Whether to ignore unknown properties when deserializing the connector configuration."}, required=false)
    public Boolean ignoreUnknownConfigFields = false;
    private Server server;
    private RuntimeSpawner runtimeSpawner;
    private ThreadRuntimeFactory containerFactory;
    private Long lastHealthCheckTs = null;
    private HTTPServer metricsServer;
    private ScheduledFuture healthCheckTimer;

    public void start(String[] args, ClassLoader functionInstanceClassLoader, ClassLoader rootClassLoader) throws Exception {
        SecretsProvider secretsProvider;
        Thread.currentThread().setContextClassLoader(functionInstanceClassLoader);
        CommandLine jcommander = new CommandLine((Object)this);
        jcommander.parseArgs(args);
        InstanceConfig instanceConfig = new InstanceConfig();
        instanceConfig.setFunctionId(this.functionId);
        instanceConfig.setTransformFunctionId(this.transformFunctionId);
        instanceConfig.setFunctionVersion(this.functionVersion);
        instanceConfig.setInstanceId(this.instanceId);
        instanceConfig.setMaxBufferedTuples(this.maxBufferedTuples);
        instanceConfig.setClusterName(this.clusterName);
        instanceConfig.setMaxPendingAsyncRequests(this.maxPendingAsyncRequests);
        instanceConfig.setExposePulsarAdminClientEnabled(this.exposePulsarAdminClientEnabled.booleanValue());
        instanceConfig.setIgnoreUnknownConfigFields(this.ignoreUnknownConfigFields.booleanValue());
        Function.FunctionDetails.Builder functionDetailsBuilder = Function.FunctionDetails.newBuilder();
        if (this.functionDetailsJsonString.charAt(0) == '\'') {
            this.functionDetailsJsonString = this.functionDetailsJsonString.substring(1);
        }
        if (this.functionDetailsJsonString.charAt(this.functionDetailsJsonString.length() - 1) == '\'') {
            this.functionDetailsJsonString = this.functionDetailsJsonString.substring(0, this.functionDetailsJsonString.length() - 1);
        }
        JsonFormat.parser().merge(this.functionDetailsJsonString, (Message.Builder)functionDetailsBuilder);
        FunctionCacheManagerImpl fnCache = new FunctionCacheManagerImpl(rootClassLoader);
        ClassLoader functionClassLoader = ThreadRuntime.loadJars(this.jarFile, instanceConfig, this.functionId, functionDetailsBuilder.getName(), this.narExtractionDirectory, (FunctionCacheManager)fnCache);
        this.inferringMissingTypeClassName(functionDetailsBuilder, functionClassLoader);
        Function.FunctionDetails functionDetails = functionDetailsBuilder.build();
        instanceConfig.setFunctionDetails(functionDetails);
        instanceConfig.setPort(this.port);
        instanceConfig.setMetricsPort(this.metricsPort);
        Map secretsProviderConfigMap = null;
        if (!StringUtils.isEmpty((CharSequence)this.secretsProviderConfig)) {
            if (this.secretsProviderConfig.charAt(0) == '\'') {
                this.secretsProviderConfig = this.secretsProviderConfig.substring(1);
            }
            if (this.secretsProviderConfig.charAt(this.secretsProviderConfig.length() - 1) == '\'') {
                this.secretsProviderConfig = this.secretsProviderConfig.substring(0, this.secretsProviderConfig.length() - 1);
            }
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            secretsProviderConfigMap = (Map)new Gson().fromJson(this.secretsProviderConfig, type);
        }
        if (StringUtils.isEmpty((CharSequence)this.secretsProviderClassName)) {
            this.secretsProviderClassName = ClearTextSecretsProvider.class.getName();
        }
        try {
            secretsProvider = (SecretsProvider)Reflections.createInstance((String)this.secretsProviderClassName, (ClassLoader)functionInstanceClassLoader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        secretsProvider.init(secretsProviderConfigMap);
        FunctionCollectorRegistry collectorRegistry = FunctionCollectorRegistry.getDefaultImplementation();
        RuntimeUtils.registerDefaultCollectors(collectorRegistry);
        this.containerFactory = new ThreadRuntimeFactory("LocalRunnerThreadGroup", this.pulsarServiceUrl, this.stateStorageImplClass, this.stateStorageServiceUrl, AuthenticationConfig.builder().clientAuthenticationPlugin(this.clientAuthenticationPlugin).clientAuthenticationParameters(this.clientAuthenticationParameters).useTls(JavaInstanceStarter.isTrue(this.useTls)).tlsAllowInsecureConnection(JavaInstanceStarter.isTrue(this.tlsAllowInsecureConnection)).tlsHostnameVerificationEnable(JavaInstanceStarter.isTrue(this.tlsHostNameVerificationEnabled)).tlsTrustCertsFilePath(this.tlsTrustCertFilePath).build(), secretsProvider, collectorRegistry, this.narExtractionDirectory, rootClassLoader, this.exposePulsarAdminClientEnabled, this.webServiceUrl, (FunctionCacheManager)fnCache);
        this.runtimeSpawner = new RuntimeSpawner(instanceConfig, this.jarFile, null, this.transformFunctionJarFile, null, this.containerFactory, this.expectedHealthCheckInterval * 1000);
        this.server = ServerBuilder.forPort((int)this.port).addService((BindableService)new InstanceControlImpl(this.runtimeSpawner)).build().start();
        log.info("JavaInstance Server started, listening on " + this.port);
        java.lang.Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }));
        log.info("Starting runtimeSpawner");
        this.runtimeSpawner.start();
        log.info("Starting metrics server on port {}", (Object)this.metricsPort);
        this.metricsServer = new HTTPServer(new InetSocketAddress(this.metricsPort), (CollectorRegistry)collectorRegistry, true);
        if (this.expectedHealthCheckInterval > 0) {
            this.healthCheckTimer = InstanceCache.getInstanceCache().getScheduledExecutorService().scheduleAtFixedRate(() -> {
                try {
                    if (System.currentTimeMillis() - this.lastHealthCheckTs > (long)(3 * this.expectedHealthCheckInterval * 1000)) {
                        log.info("Haven't received health check from spawner in a while. Stopping instance...");
                        this.close();
                    }
                }
                catch (Exception e) {
                    log.error("Error occurred when checking for latest health check", (Throwable)e);
                }
            }, this.expectedHealthCheckInterval * 1000, this.expectedHealthCheckInterval * 1000, TimeUnit.MILLISECONDS);
        }
        this.runtimeSpawner.join();
        log.info("RuntimeSpawner quit, shutting down JavaInstance");
        this.close();
    }

    private static boolean isTrue(String param) {
        return Boolean.TRUE.toString().equals(param);
    }

    @Override
    public void close() {
        try {
            if (this.server != null) {
                this.server.shutdown();
            }
            if (this.runtimeSpawner != null) {
                this.runtimeSpawner.close();
            }
            if (this.healthCheckTimer != null) {
                this.healthCheckTimer.cancel(false);
            }
            if (this.containerFactory != null) {
                this.containerFactory.close();
            }
            if (this.metricsServer != null) {
                this.metricsServer.stop();
            }
            InstanceCache.shutdown();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    private void inferringMissingTypeClassName(Function.FunctionDetails.Builder functionDetailsBuilder, ClassLoader classLoader) {
        TypePool typePool = TypePool.Default.of((ClassFileLocator)ClassFileLocator.ForClassLoader.of((ClassLoader)classLoader));
        switch (functionDetailsBuilder.getComponentType()) {
            case FUNCTION: {
                if ((!functionDetailsBuilder.hasSource() || !functionDetailsBuilder.getSource().getTypeClassName().isEmpty()) && (!functionDetailsBuilder.hasSink() || !functionDetailsBuilder.getSink().getTypeClassName().isEmpty())) break;
                Map userConfigs = (Map)new Gson().fromJson(functionDetailsBuilder.getUserConfig(), new TypeToken<Map<String, Object>>(){}.getType());
                boolean isWindowConfigPresent = userConfigs != null && userConfigs.containsKey("__WINDOWCONFIGS__");
                String className = functionDetailsBuilder.getClassName();
                if (isWindowConfigPresent) {
                    WindowConfig windowConfig = (WindowConfig)new Gson().fromJson(new Gson().toJson(userConfigs.get("__WINDOWCONFIGS__")), WindowConfig.class);
                    className = windowConfig.getActualWindowFunctionClassName();
                }
                TypeDefinition[] typeArgs = FunctionCommon.getFunctionTypes((TypeDefinition)typePool.describe(className).resolve(), (boolean)isWindowConfigPresent);
                if (functionDetailsBuilder.hasSource() && functionDetailsBuilder.getSource().getTypeClassName().isEmpty() && typeArgs[0] != null) {
                    Function.SourceSpec.Builder sourceBuilder = functionDetailsBuilder.getSource().toBuilder();
                    sourceBuilder.setTypeClassName(typeArgs[0].asErasure().getTypeName());
                    functionDetailsBuilder.setSource(sourceBuilder.build());
                }
                if (!functionDetailsBuilder.hasSink() || !functionDetailsBuilder.getSink().getTypeClassName().isEmpty() || typeArgs[1] == null) break;
                Function.SinkSpec.Builder sinkBuilder = functionDetailsBuilder.getSink().toBuilder();
                sinkBuilder.setTypeClassName(typeArgs[1].asErasure().getTypeName());
                functionDetailsBuilder.setSink(sinkBuilder.build());
                break;
            }
            case SINK: {
                if (!functionDetailsBuilder.hasSink() || !functionDetailsBuilder.getSink().getTypeClassName().isEmpty()) break;
                String typeArg = FunctionCommon.getSinkType((String)functionDetailsBuilder.getSink().getClassName(), (TypePool)typePool).asErasure().getTypeName();
                Function.SinkSpec.Builder sinkBuilder = Function.SinkSpec.newBuilder((Function.SinkSpec)functionDetailsBuilder.getSink());
                sinkBuilder.setTypeClassName(typeArg);
                functionDetailsBuilder.setSink(sinkBuilder);
                Function.SourceSpec sourceSpec = functionDetailsBuilder.getSource();
                if (null != sourceSpec && !StringUtils.isEmpty((CharSequence)sourceSpec.getTypeClassName())) break;
                Function.SourceSpec.Builder sourceBuilder = Function.SourceSpec.newBuilder((Function.SourceSpec)sourceSpec);
                sourceBuilder.setTypeClassName(typeArg);
                functionDetailsBuilder.setSource(sourceBuilder);
                break;
            }
            case SOURCE: {
                if (!functionDetailsBuilder.hasSource() || !functionDetailsBuilder.getSource().getTypeClassName().isEmpty()) break;
                String typeArg = FunctionCommon.getSourceType((String)functionDetailsBuilder.getSource().getClassName(), (TypePool)typePool).asErasure().getTypeName();
                Function.SourceSpec.Builder sourceBuilder = Function.SourceSpec.newBuilder((Function.SourceSpec)functionDetailsBuilder.getSource());
                sourceBuilder.setTypeClassName(typeArg);
                functionDetailsBuilder.setSource(sourceBuilder);
                Function.SinkSpec sinkSpec = functionDetailsBuilder.getSink();
                if (null != sinkSpec && !StringUtils.isEmpty((CharSequence)sinkSpec.getTypeClassName())) break;
                Function.SinkSpec.Builder sinkBuilder = Function.SinkSpec.newBuilder((Function.SinkSpec)sinkSpec);
                sinkBuilder.setTypeClassName(typeArg);
                functionDetailsBuilder.setSink(sinkBuilder);
            }
        }
    }

    class InstanceControlImpl
    extends InstanceControlGrpc.InstanceControlImplBase {
        private RuntimeSpawner runtimeSpawner;

        public InstanceControlImpl(RuntimeSpawner runtimeSpawner) {
            this.runtimeSpawner = runtimeSpawner;
            JavaInstanceStarter.this.lastHealthCheckTs = System.currentTimeMillis();
        }

        public void getFunctionStatus(Empty request, StreamObserver<InstanceCommunication.FunctionStatus> responseObserver) {
            try {
                InstanceCommunication.FunctionStatus response = this.runtimeSpawner.getFunctionStatus(this.runtimeSpawner.getInstanceConfig().getInstanceId()).get();
                responseObserver.onNext((Object)response);
                responseObserver.onCompleted();
            }
            catch (Exception e) {
                log.error("Exception in JavaInstance doing getFunctionStatus", (Throwable)e);
                throw new RuntimeException(e);
            }
        }

        public void getAndResetMetrics(Empty request, StreamObserver<InstanceCommunication.MetricsData> responseObserver) {
            Runtime runtime = this.runtimeSpawner.getRuntime();
            if (runtime != null) {
                try {
                    InstanceCommunication.MetricsData metrics = runtime.getAndResetMetrics().get();
                    responseObserver.onNext((Object)metrics);
                    responseObserver.onCompleted();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Exception in JavaInstance doing getAndResetMetrics", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public void getMetrics(Empty request, StreamObserver<InstanceCommunication.MetricsData> responseObserver) {
            Runtime runtime = this.runtimeSpawner.getRuntime();
            if (runtime != null) {
                try {
                    InstanceCommunication.MetricsData metrics = runtime.getMetrics(JavaInstanceStarter.this.instanceId).get();
                    responseObserver.onNext((Object)metrics);
                    responseObserver.onCompleted();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Exception in JavaInstance doing getAndResetMetrics", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public void resetMetrics(Empty request, StreamObserver<Empty> responseObserver) {
            Runtime runtime = this.runtimeSpawner.getRuntime();
            if (runtime != null) {
                try {
                    runtime.resetMetrics().get();
                    responseObserver.onNext((Object)Empty.getDefaultInstance());
                    responseObserver.onCompleted();
                }
                catch (InterruptedException | ExecutionException e) {
                    log.error("Exception in JavaInstance doing resetMetrics", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }

        public void healthCheck(Empty request, StreamObserver<InstanceCommunication.HealthCheckResult> responseObserver) {
            log.debug("Received health check request...");
            InstanceCommunication.HealthCheckResult healthCheckResult = InstanceCommunication.HealthCheckResult.newBuilder().setSuccess(true).build();
            responseObserver.onNext((Object)healthCheckResult);
            responseObserver.onCompleted();
            JavaInstanceStarter.this.lastHealthCheckTs = System.currentTimeMillis();
        }
    }
}

