/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.FunctionDefinition;
import org.apache.pulsar.common.functions.Utils;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.io.SourceConfig;
import org.apache.pulsar.common.nar.FileUtils;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.Reflections;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.instance.InstanceConfig;
import org.apache.pulsar.functions.instance.stats.FunctionCollectorRegistry;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.RuntimeFactory;
import org.apache.pulsar.functions.runtime.RuntimeSpawner;
import org.apache.pulsar.functions.runtime.RuntimeUtils;
import org.apache.pulsar.functions.runtime.process.ProcessRuntimeFactory;
import org.apache.pulsar.functions.runtime.thread.ThreadRuntimeFactory;
import org.apache.pulsar.functions.secretsprovider.ClearTextSecretsProvider;
import org.apache.pulsar.functions.secretsprovider.SecretsProvider;
import org.apache.pulsar.functions.secretsproviderconfigurator.DefaultSecretsProviderConfigurator;
import org.apache.pulsar.functions.secretsproviderconfigurator.NameAndConfigBasedSecretsProviderConfigurator;
import org.apache.pulsar.functions.secretsproviderconfigurator.SecretsProviderConfigurator;
import org.apache.pulsar.functions.utils.FunctionCommon;
import org.apache.pulsar.functions.utils.FunctionConfigUtils;
import org.apache.pulsar.functions.utils.FunctionRuntimeCommon;
import org.apache.pulsar.functions.utils.LoadedFunctionPackage;
import org.apache.pulsar.functions.utils.SinkConfigUtils;
import org.apache.pulsar.functions.utils.SourceConfigUtils;
import org.apache.pulsar.functions.utils.ValidatableFunctionPackage;
import org.apache.pulsar.functions.utils.functions.FunctionArchive;
import org.apache.pulsar.functions.utils.functions.FunctionUtils;
import org.apache.pulsar.functions.utils.io.Connector;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

public class LocalRunner
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LocalRunner.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final List<RuntimeSpawner> spawners = new LinkedList<RuntimeSpawner>();
    private final String narExtractionDirectory;
    private final File narExtractionDirectoryCreated;
    private final String connectorsDir;
    private final String functionsDir;
    private final Thread shutdownHook;
    private final int instanceLivenessCheck;
    private UserCodeClassLoader userCodeClassLoader;
    private UserCodeClassLoader transformFunctionCodeClassLoader;
    private RuntimeFactory runtimeFactory;
    private HTTPServer metricsServer;
    @CommandLine.Option(names={"--functionConfig"}, description={"The json representation of FunctionConfig"}, hidden=true, converter={FunctionConfigConverter.class})
    protected FunctionConfig functionConfig;
    @CommandLine.Option(names={"--sourceConfig"}, description={"The json representation of SourceConfig"}, hidden=true, converter={SourceConfigConverter.class})
    protected SourceConfig sourceConfig;
    @CommandLine.Option(names={"--sinkConfig"}, description={"The json representation of SinkConfig"}, hidden=true, converter={SinkConfigConverter.class})
    protected SinkConfig sinkConfig;
    @CommandLine.Option(names={"--stateStorageImplClass"}, description={"The implemenatation class state storage service (by default Apache BookKeeper)"}, hidden=true, required=false)
    protected String stateStorageImplClass;
    @CommandLine.Option(names={"--stateStorageServiceUrl"}, description={"The URL for the state storage service (by default Apache BookKeeper)"}, hidden=true)
    protected String stateStorageServiceUrl;
    @CommandLine.Option(names={"--brokerServiceUrl"}, description={"The URL for the Pulsar broker"}, hidden=true)
    protected String brokerServiceUrl;
    @CommandLine.Option(names={"--webServiceUrl"}, description={"The URL for the Pulsar web service"}, hidden=true)
    protected String webServiceUrl = null;
    @CommandLine.Option(names={"--clientAuthPlugin"}, description={"Client authentication plugin using which function-process can connect to broker"}, hidden=true)
    protected String clientAuthPlugin;
    @CommandLine.Option(names={"--clientAuthParams"}, description={"Client authentication param"}, hidden=true)
    protected String clientAuthParams;
    @CommandLine.Option(names={"--useTls"}, description={"Use tls connection\n"}, hidden=true, arity="1")
    protected boolean useTls;
    @CommandLine.Option(names={"--tlsAllowInsecureConnection"}, description={"Allow insecure tls connection\n"}, hidden=true, arity="1")
    protected boolean tlsAllowInsecureConnection;
    @CommandLine.Option(names={"--tlsHostNameVerificationEnabled"}, description={"Enable hostname verification"}, hidden=true, arity="1")
    protected boolean tlsHostNameVerificationEnabled;
    @CommandLine.Option(names={"--tlsTrustCertFilePath"}, description={"tls trust cert file path"}, hidden=true)
    protected String tlsTrustCertFilePath;
    @CommandLine.Option(names={"--instanceIdOffset"}, description={"Start the instanceIds from this offset"}, hidden=true)
    protected int instanceIdOffset = 0;
    @CommandLine.Option(names={"--runtime"}, description={"Function runtime to use (Thread/Process)"}, hidden=true, converter={RuntimeConverter.class})
    protected RuntimeEnv runtimeEnv;
    @CommandLine.Option(names={"--secretsProviderClassName"}, description={"Whats the classname of secrets provider"}, hidden=true)
    protected String secretsProviderClassName;
    @CommandLine.Option(names={"--secretsProviderConfig"}, description={"Whats the config for the secrets provider"}, hidden=true)
    protected String secretsProviderConfig;
    @CommandLine.Option(names={"--metricsPortStart"}, description={"The starting port range for metrics server. When running instances as threads, one metrics server is used to host the stats for all instances."}, hidden=true)
    protected Integer metricsPortStart;
    @CommandLine.Option(names={"--exitOnError"}, description={"The starting port range for metrics server. When running instances as threads, one metrics server is used to host the stats for all instances."}, hidden=true)
    protected boolean exitOnError;
    private static final String DEFAULT_SERVICE_URL = "pulsar://localhost:6650";
    private static final String DEFAULT_WEB_SERVICE_URL = "http://localhost:8080";

    public static void main(String[] args) throws Exception {
        LocalRunner localRunner = LocalRunner.builder().build();
        CommandLine jcommander = new CommandLine((Object)localRunner);
        jcommander.setCommandName("LocalRunner");
        jcommander.parseArgs(args);
        try {
            localRunner.start(true);
        }
        catch (Exception e) {
            log.error("Encountered error starting localrunner", (Throwable)e);
            localRunner.close();
        }
    }

    public LocalRunner(FunctionConfig functionConfig, SourceConfig sourceConfig, SinkConfig sinkConfig, String stateStorageImplClass, String stateStorageServiceUrl, String brokerServiceUrl, String clientAuthPlugin, String clientAuthParams, boolean useTls, boolean tlsAllowInsecureConnection, boolean tlsHostNameVerificationEnabled, String tlsTrustCertFilePath, int instanceIdOffset, RuntimeEnv runtimeEnv, String secretsProviderClassName, String secretsProviderConfig, String narExtractionDirectory, String connectorsDirectory, String functionsDirectory, Integer metricsPortStart, boolean exitOnError) {
        this.functionConfig = functionConfig;
        this.sourceConfig = sourceConfig;
        this.sinkConfig = sinkConfig;
        this.stateStorageImplClass = stateStorageImplClass;
        this.stateStorageServiceUrl = stateStorageServiceUrl;
        this.brokerServiceUrl = brokerServiceUrl;
        this.clientAuthPlugin = clientAuthPlugin;
        this.clientAuthParams = clientAuthParams;
        this.useTls = useTls;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostNameVerificationEnabled = tlsHostNameVerificationEnabled;
        this.tlsTrustCertFilePath = tlsTrustCertFilePath;
        this.instanceIdOffset = instanceIdOffset;
        this.runtimeEnv = runtimeEnv;
        this.secretsProviderClassName = secretsProviderClassName;
        this.secretsProviderConfig = secretsProviderConfig;
        if (narExtractionDirectory != null) {
            this.narExtractionDirectoryCreated = null;
            this.narExtractionDirectory = narExtractionDirectory;
        } else {
            this.narExtractionDirectoryCreated = LocalRunner.createNarExtractionTempDirectory();
            this.narExtractionDirectory = this.narExtractionDirectoryCreated.getAbsolutePath();
        }
        this.connectorsDir = connectorsDirectory != null ? connectorsDirectory : LocalRunner.getPulsarDirectory("connectors");
        this.functionsDir = functionsDirectory != null ? functionsDirectory : LocalRunner.getPulsarDirectory("functions");
        this.metricsPortStart = metricsPortStart;
        this.exitOnError = exitOnError;
        this.instanceLivenessCheck = exitOnError ? 0 : 30000;
        this.shutdownHook = new Thread(() -> {
            try {
                this.close();
            }
            catch (Exception exception) {
                log.warn("Encountered exception when closing localrunner", (Throwable)exception);
            }
        });
    }

    private static String getPulsarDirectory(String directory) {
        Path directoryPath = System.getenv("PULSAR_HOME") != null ? Path.of(System.getenv("PULSAR_HOME"), directory) : Path.of(directory, new String[0]);
        return directoryPath.toAbsolutePath().normalize().toString();
    }

    private static File createNarExtractionTempDirectory() {
        try {
            return Files.createTempDirectory("pulsar_localrunner_nars_", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot create temp directory", e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.stop();
        }
        finally {
            if (this.narExtractionDirectoryCreated != null && this.narExtractionDirectoryCreated.exists()) {
                FileUtils.deleteFile((File)this.narExtractionDirectoryCreated, (boolean)true);
            }
        }
    }

    public synchronized void stop() {
        if (this.running.compareAndSet(true, false)) {
            this.notify();
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (this.metricsServer != null) {
                this.metricsServer.stop();
            }
            for (RuntimeSpawner spawner : this.spawners) {
                spawner.close();
            }
            this.spawners.clear();
            if (this.runtimeFactory != null) {
                this.runtimeFactory.close();
                this.runtimeFactory = null;
            }
            LocalRunner.closeClassLoaderIfneeded(this.userCodeClassLoader);
            this.userCodeClassLoader = null;
            LocalRunner.closeClassLoaderIfneeded(this.transformFunctionCodeClassLoader);
            this.transformFunctionCodeClassLoader = null;
        }
    }

    private static void closeClassLoaderIfneeded(UserCodeClassLoader userCodeClassLoader) {
        if (userCodeClassLoader != null && userCodeClassLoader.isClassLoaderCreated() && userCodeClassLoader.getClassLoader() instanceof Closeable) {
            try {
                ((Closeable)((Object)userCodeClassLoader.getClassLoader())).close();
            }
            catch (IOException e) {
                log.warn("Error closing classloader", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(boolean blocking) throws Exception {
        LinkedList<RuntimeSpawner> local = new LinkedList<RuntimeSpawner>();
        Object object = this;
        synchronized (object) {
            String userCodeFile;
            int parallelism;
            if (!this.running.compareAndSet(false, true)) {
                throw new IllegalArgumentException("Pulsar Function local run already started!");
            }
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            Function.FunctionDetails functionDetails = null;
            String transformFunctionFile = null;
            if (this.functionConfig != null) {
                FunctionConfigUtils.inferMissingArguments((FunctionConfig)this.functionConfig, (boolean)true);
                parallelism = this.functionConfig.getParallelism();
                if (this.functionConfig.getRuntime() == FunctionConfig.Runtime.JAVA) {
                    userCodeFile = this.functionConfig.getJar();
                    this.userCodeClassLoader = this.extractClassLoader(userCodeFile, Function.FunctionDetails.ComponentType.FUNCTION, this.functionConfig.getClassName());
                    validatableFunctionPackage = new LoadedFunctionPackage(this.getCurrentOrUserCodeClassLoader(), FunctionDefinition.class);
                    functionDetails = FunctionConfigUtils.convert((FunctionConfig)this.functionConfig, (FunctionConfigUtils.ExtractedFunctionDetails)FunctionConfigUtils.validateJavaFunction((FunctionConfig)this.functionConfig, (ValidatableFunctionPackage)validatableFunctionPackage));
                } else if (this.functionConfig.getRuntime() == FunctionConfig.Runtime.GO) {
                    userCodeFile = this.functionConfig.getGo();
                } else if (this.functionConfig.getRuntime() == FunctionConfig.Runtime.PYTHON) {
                    userCodeFile = this.functionConfig.getPy();
                } else {
                    throw new UnsupportedOperationException();
                }
                if (functionDetails == null) {
                    validatableFunctionPackage = new LoadedFunctionPackage(this.getCurrentOrUserCodeClassLoader(), FunctionDefinition.class);
                    functionDetails = FunctionConfigUtils.convert((FunctionConfig)this.functionConfig, (ValidatableFunctionPackage)validatableFunctionPackage);
                }
            } else if (this.sourceConfig != null) {
                Utils.inferMissingArguments((SourceConfig)this.sourceConfig);
                userCodeFile = this.sourceConfig.getArchive();
                parallelism = this.sourceConfig.getParallelism();
                this.userCodeClassLoader = this.extractClassLoader(userCodeFile, Function.FunctionDetails.ComponentType.SOURCE, this.sourceConfig.getClassName());
                validatableFunctionPackage = new LoadedFunctionPackage(this.getCurrentOrUserCodeClassLoader(), ConnectorDefinition.class);
                functionDetails = SourceConfigUtils.convert((SourceConfig)this.sourceConfig, (SourceConfigUtils.ExtractedSourceDetails)SourceConfigUtils.validateAndExtractDetails((SourceConfig)this.sourceConfig, (ValidatableFunctionPackage)validatableFunctionPackage, (boolean)true));
            } else if (this.sinkConfig != null) {
                Utils.inferMissingArguments((SinkConfig)this.sinkConfig);
                userCodeFile = this.sinkConfig.getArchive();
                transformFunctionFile = this.sinkConfig.getTransformFunction();
                parallelism = this.sinkConfig.getParallelism();
                this.userCodeClassLoader = this.extractClassLoader(userCodeFile, Function.FunctionDetails.ComponentType.SINK, this.sinkConfig.getClassName());
                validatableFunctionPackage = new LoadedFunctionPackage(this.getCurrentOrUserCodeClassLoader(), ConnectorDefinition.class);
                if (StringUtils.isNotEmpty((CharSequence)this.sinkConfig.getTransformFunction())) {
                    this.transformFunctionCodeClassLoader = this.extractClassLoader(this.sinkConfig.getTransformFunction(), Function.FunctionDetails.ComponentType.FUNCTION, this.sinkConfig.getTransformFunctionClassName());
                }
                ClassLoader functionClassLoader = null;
                LoadedFunctionPackage validatableTransformFunction = null;
                if (this.transformFunctionCodeClassLoader != null) {
                    functionClassLoader = this.transformFunctionCodeClassLoader.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : this.transformFunctionCodeClassLoader.getClassLoader();
                    validatableTransformFunction = new LoadedFunctionPackage(functionClassLoader, FunctionDefinition.class);
                }
                functionDetails = SinkConfigUtils.convert((SinkConfig)this.sinkConfig, (SinkConfigUtils.ExtractedSinkDetails)SinkConfigUtils.validateAndExtractDetails((SinkConfig)this.sinkConfig, (ValidatableFunctionPackage)validatableFunctionPackage, validatableTransformFunction, (boolean)true));
            } else {
                throw new IllegalArgumentException("Must specify Function, Source or Sink config");
            }
            if (System.getProperty("pulsar.functions.java.instance.jar") == null) {
                System.setProperty("pulsar.functions.java.instance.jar", LocalRunner.class.getProtectionDomain().getCodeSource().getLocation().getFile());
            }
            AuthenticationConfig authConfig = AuthenticationConfig.builder().clientAuthenticationPlugin(this.clientAuthPlugin).clientAuthenticationParameters(this.clientAuthParams).useTls(this.useTls).tlsAllowInsecureConnection(this.tlsAllowInsecureConnection).tlsHostnameVerificationEnable(this.tlsHostNameVerificationEnabled).tlsTrustCertsFilePath(this.tlsTrustCertFilePath).build();
            String serviceUrl = DEFAULT_SERVICE_URL;
            if (this.brokerServiceUrl != null) {
                serviceUrl = this.brokerServiceUrl;
            }
            if (this.webServiceUrl == null) {
                this.webServiceUrl = DEFAULT_WEB_SERVICE_URL;
            }
            if (!(this.sourceConfig == null && this.sinkConfig == null && this.functionConfig.getRuntime() != FunctionConfig.Runtime.JAVA || this.runtimeEnv != null && this.runtimeEnv != RuntimeEnv.THREAD)) {
                this.startThreadedMode(functionDetails, parallelism, this.instanceIdOffset, serviceUrl, this.stateStorageServiceUrl, authConfig, userCodeFile, transformFunctionFile);
            } else {
                this.startProcessMode(functionDetails, parallelism, this.instanceIdOffset, serviceUrl, this.stateStorageServiceUrl, authConfig, userCodeFile, transformFunctionFile);
            }
            local.addAll(this.spawners);
        }
        if (blocking) {
            if (this.exitOnError) {
                for (RuntimeSpawner spawner : local) {
                    spawner.join();
                    log.info("RuntimeSpawner quit because of", spawner.getRuntime().getDeathException());
                }
                this.close();
            } else {
                object = this;
                synchronized (object) {
                    while (this.running.get()) {
                        this.wait();
                    }
                }
            }
        }
    }

    private ClassLoader getCurrentOrUserCodeClassLoader() {
        return this.userCodeClassLoader == null || this.userCodeClassLoader.getClassLoader() == null ? Thread.currentThread().getContextClassLoader() : this.userCodeClassLoader.getClassLoader();
    }

    private UserCodeClassLoader extractClassLoader(String userCodeFile, Function.FunctionDetails.ComponentType componentType, String className) throws IOException, URISyntaxException {
        ClassLoader classLoader = userCodeFile != null ? this.isBuiltIn(userCodeFile, componentType) : null;
        boolean classLoaderCreated = false;
        if (classLoader == null) {
            if (userCodeFile != null && Utils.isFunctionPackageUrlSupported((String)userCodeFile)) {
                File file = FunctionCommon.extractFileFromPkgURL((String)userCodeFile);
                classLoader = FunctionRuntimeCommon.getClassLoaderFromPackage((Function.FunctionDetails.ComponentType)componentType, (String)className, (File)file, (String)this.narExtractionDirectory);
                classLoaderCreated = true;
            } else if (userCodeFile != null) {
                File file = new File(userCodeFile);
                if (!file.exists()) {
                    throw new RuntimeException((switch (componentType) {
                        case Function.FunctionDetails.ComponentType.FUNCTION -> "User jar";
                        case Function.FunctionDetails.ComponentType.SOURCE -> "Source archive";
                        case Function.FunctionDetails.ComponentType.SINK -> "Sink archive";
                        default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(componentType));
                    }) + " (" + userCodeFile + ") does not exist");
                }
                classLoader = FunctionRuntimeCommon.getClassLoaderFromPackage((Function.FunctionDetails.ComponentType)componentType, (String)className, (File)file, (String)this.narExtractionDirectory);
                classLoaderCreated = true;
            } else if (this.runtimeEnv != null && this.runtimeEnv != RuntimeEnv.THREAD) {
                throw new IllegalStateException(switch (componentType) {
                    case Function.FunctionDetails.ComponentType.FUNCTION -> "The jar property must be specified in FunctionConfig.";
                    case Function.FunctionDetails.ComponentType.SOURCE -> "The archive property must be specified in SourceConfig.";
                    case Function.FunctionDetails.ComponentType.SINK -> "The archive property must be specified in SinkConfig.";
                    default -> throw new IllegalStateException("Unexpected ComponentType: " + String.valueOf(componentType));
                });
            }
        }
        return new UserCodeClassLoader(classLoader, classLoaderCreated);
    }

    private void startProcessMode(Function.FunctionDetails functionDetails, int parallelism, int instanceIdOffset, String serviceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String userCodeFile, String transformFunctionFile) throws Exception {
        SecretsProviderConfigurator secretsProviderConfigurator = this.getSecretsProviderConfigurator();
        this.runtimeFactory = new ProcessRuntimeFactory(serviceUrl, this.webServiceUrl, stateStorageServiceUrl, authConfig, null, null, null, null, this.narExtractionDirectory, secretsProviderConfigurator, false, Optional.empty(), Optional.empty());
        for (int i = 0; i < parallelism; ++i) {
            InstanceConfig instanceConfig = new InstanceConfig();
            instanceConfig.setFunctionDetails(functionDetails);
            instanceConfig.setFunctionVersion(UUID.randomUUID().toString());
            instanceConfig.setFunctionId(UUID.randomUUID().toString());
            instanceConfig.setInstanceId(i + instanceIdOffset);
            instanceConfig.setMaxBufferedTuples(1024);
            instanceConfig.setPort(FunctionCommon.findAvailablePort());
            if (this.metricsPortStart != null) {
                int metricsPort = this.metricsPortStart + i;
                if (this.metricsPortStart < 0 || this.metricsPortStart > 65535) {
                    throw new IllegalArgumentException("Metrics port need to be within the range of 0 and 65535");
                }
                instanceConfig.setMetricsPort(metricsPort);
            } else {
                instanceConfig.setMetricsPort(FunctionCommon.findAvailablePort());
            }
            instanceConfig.setClusterName("local");
            if (this.functionConfig != null) {
                instanceConfig.setMaxPendingAsyncRequests(this.functionConfig.getMaxPendingAsyncRequests().intValue());
                if (this.functionConfig.getExposePulsarAdminClientEnabled() != null) {
                    instanceConfig.setExposePulsarAdminClientEnabled(this.functionConfig.getExposePulsarAdminClientEnabled().booleanValue());
                }
            }
            RuntimeSpawner runtimeSpawner = new RuntimeSpawner(instanceConfig, userCodeFile, null, transformFunctionFile, null, this.runtimeFactory, (long)this.instanceLivenessCheck);
            this.spawners.add(runtimeSpawner);
            runtimeSpawner.start();
        }
        Timer statusCheckTimer = new Timer();
        statusCheckTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                CompletableFuture[] futures = new CompletableFuture[LocalRunner.this.spawners.size()];
                int index = 0;
                for (RuntimeSpawner spawner : LocalRunner.this.spawners) {
                    futures[index] = spawner.getFunctionStatusAsJson(index);
                    ++index;
                }
                try {
                    CompletableFuture.allOf(futures).get(5L, TimeUnit.SECONDS);
                    for (index = 0; index < futures.length; ++index) {
                        String json = (String)futures[index].get();
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        log.info(gson.toJson(JsonParser.parseString((String)json)));
                    }
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    log.error("Could not get status from all local instances");
                }
            }
        }, 30000L, 30000L);
        Runtime.getRuntime().addShutdownHook(new Thread(statusCheckTimer::cancel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreadedMode(Function.FunctionDetails functionDetails, int parallelism, int instanceIdOffset, String serviceUrl, String stateStorageServiceUrl, AuthenticationConfig authConfig, String userCodeFile, String transformFunctionFile) throws Exception {
        ClearTextSecretsProvider secretsProvider;
        if (this.metricsPortStart != null && (this.metricsPortStart < 0 || this.metricsPortStart > 65535)) {
            throw new IllegalArgumentException("Metrics port need to be within the range of 0 and 65535");
        }
        if (this.secretsProviderClassName != null) {
            secretsProvider = (SecretsProvider)Reflections.createInstance((String)this.secretsProviderClassName, (ClassLoader)ClassLoader.getSystemClassLoader());
            Map config = null;
            if (this.secretsProviderConfig != null) {
                config = (Map)new Gson().fromJson(this.secretsProviderConfig, Map.class);
            }
            secretsProvider.init(config);
        } else {
            secretsProvider = new ClearTextSecretsProvider();
        }
        boolean exposePulsarAdminClientEnabled = false;
        if (this.functionConfig != null && this.functionConfig.getExposePulsarAdminClientEnabled() != null) {
            exposePulsarAdminClientEnabled = this.functionConfig.getExposePulsarAdminClientEnabled();
        }
        FunctionCollectorRegistry collectorRegistry = FunctionCollectorRegistry.getDefaultImplementation();
        RuntimeUtils.registerDefaultCollectors((FunctionCollectorRegistry)collectorRegistry);
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (this.userCodeClassLoader != null && this.userCodeClassLoader.getClassLoader() != null) {
                Thread.currentThread().setContextClassLoader(this.userCodeClassLoader.getClassLoader());
            }
            this.runtimeFactory = new ThreadRuntimeFactory("LocalRunnerThreadGroup", serviceUrl, this.stateStorageImplClass, stateStorageServiceUrl, authConfig, (SecretsProvider)secretsProvider, collectorRegistry, this.narExtractionDirectory, null, exposePulsarAdminClientEnabled, this.webServiceUrl);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        for (int i = 0; i < parallelism; ++i) {
            InstanceConfig instanceConfig = new InstanceConfig();
            instanceConfig.setFunctionDetails(functionDetails);
            instanceConfig.setFunctionVersion(UUID.randomUUID().toString());
            instanceConfig.setFunctionId(UUID.randomUUID().toString());
            instanceConfig.setTransformFunctionId(UUID.randomUUID().toString());
            instanceConfig.setInstanceId(i + instanceIdOffset);
            instanceConfig.setMaxBufferedTuples(1024);
            if (this.metricsPortStart != null) {
                instanceConfig.setMetricsPort(this.metricsPortStart.intValue());
            }
            instanceConfig.setClusterName("local");
            if (this.functionConfig != null) {
                instanceConfig.setMaxPendingAsyncRequests(this.functionConfig.getMaxPendingAsyncRequests().intValue());
                if (this.functionConfig.getExposePulsarAdminClientEnabled() != null) {
                    instanceConfig.setExposePulsarAdminClientEnabled(this.functionConfig.getExposePulsarAdminClientEnabled().booleanValue());
                }
            }
            RuntimeSpawner runtimeSpawner = new RuntimeSpawner(instanceConfig, userCodeFile, null, transformFunctionFile, null, this.runtimeFactory, (long)this.instanceLivenessCheck);
            this.spawners.add(runtimeSpawner);
            runtimeSpawner.start();
        }
        if (this.metricsPortStart != null) {
            log.info("Starting metrics server on port {}", (Object)this.metricsPortStart);
            this.metricsServer = new HTTPServer(new InetSocketAddress(this.metricsPortStart), (CollectorRegistry)collectorRegistry, true);
        }
    }

    private ClassLoader isBuiltIn(String component, Function.FunctionDetails.ComponentType componentType) throws IOException {
        switch (componentType) {
            case FUNCTION: {
                return this.isBuiltInFunction(component);
            }
            case SOURCE: {
                return this.isBuiltInSource(component);
            }
            case SINK: {
                return this.isBuiltInSink(component);
            }
        }
        throw new IllegalStateException("Unexpected ComponentType: " + String.valueOf(componentType));
    }

    private ClassLoader isBuiltInFunction(String functionType) throws IOException {
        String functionName;
        TreeMap<String, FunctionArchive> functions = this.getFunctions();
        FunctionArchive function = functions.get(functionName = functionType.replaceFirst("^builtin://", ""));
        if (function != null && function.getFunctionDefinition().getFunctionClass() != null) {
            return function.getFunctionPackage().getClassLoader();
        }
        return null;
    }

    private ClassLoader isBuiltInSource(String sourceType) throws IOException {
        String source;
        TreeMap<String, Connector> connectors = this.getConnectors();
        Connector connector = connectors.get(source = sourceType.replaceFirst("^builtin://", ""));
        if (connector != null && connector.getConnectorDefinition().getSourceClass() != null) {
            return connector.getConnectorFunctionPackage().getClassLoader();
        }
        return null;
    }

    private ClassLoader isBuiltInSink(String sinkType) throws IOException {
        String sink;
        TreeMap<String, Connector> connectors = this.getConnectors();
        Connector connector = connectors.get(sink = sinkType.replaceFirst("^builtin://", ""));
        if (connector != null && connector.getConnectorDefinition().getSinkClass() != null) {
            return connector.getConnectorFunctionPackage().getClassLoader();
        }
        return null;
    }

    private TreeMap<String, FunctionArchive> getFunctions() throws IOException {
        return FunctionUtils.searchForFunctions((String)this.functionsDir, (String)this.narExtractionDirectory, (boolean)true);
    }

    private TreeMap<String, Connector> getConnectors() throws IOException {
        return ConnectorUtils.searchForConnectors((String)this.connectorsDir, (String)this.narExtractionDirectory, (boolean)true);
    }

    private SecretsProviderConfigurator getSecretsProviderConfigurator() {
        DefaultSecretsProviderConfigurator secretsProviderConfigurator;
        if (this.secretsProviderClassName != null) {
            Map config = null;
            if (this.secretsProviderConfig != null) {
                config = (Map)new Gson().fromJson(this.secretsProviderConfig, Map.class);
            }
            secretsProviderConfigurator = new NameAndConfigBasedSecretsProviderConfigurator(this.secretsProviderClassName, config);
        } else {
            secretsProviderConfigurator = new DefaultSecretsProviderConfigurator();
        }
        return secretsProviderConfigurator;
    }

    public static LocalRunnerBuilder builder() {
        return new LocalRunnerBuilder();
    }

    public static class LocalRunnerBuilder {
        private FunctionConfig functionConfig;
        private SourceConfig sourceConfig;
        private SinkConfig sinkConfig;
        private String stateStorageImplClass;
        private String stateStorageServiceUrl;
        private String brokerServiceUrl;
        private String clientAuthPlugin;
        private String clientAuthParams;
        private boolean useTls;
        private boolean tlsAllowInsecureConnection;
        private boolean tlsHostNameVerificationEnabled;
        private String tlsTrustCertFilePath;
        private int instanceIdOffset;
        private RuntimeEnv runtimeEnv;
        private String secretsProviderClassName;
        private String secretsProviderConfig;
        private String narExtractionDirectory;
        private String connectorsDirectory;
        private String functionsDirectory;
        private Integer metricsPortStart;
        private boolean exitOnError;

        LocalRunnerBuilder() {
        }

        public LocalRunnerBuilder functionConfig(FunctionConfig functionConfig) {
            this.functionConfig = functionConfig;
            return this;
        }

        public LocalRunnerBuilder sourceConfig(SourceConfig sourceConfig) {
            this.sourceConfig = sourceConfig;
            return this;
        }

        public LocalRunnerBuilder sinkConfig(SinkConfig sinkConfig) {
            this.sinkConfig = sinkConfig;
            return this;
        }

        public LocalRunnerBuilder stateStorageImplClass(String stateStorageImplClass) {
            this.stateStorageImplClass = stateStorageImplClass;
            return this;
        }

        public LocalRunnerBuilder stateStorageServiceUrl(String stateStorageServiceUrl) {
            this.stateStorageServiceUrl = stateStorageServiceUrl;
            return this;
        }

        public LocalRunnerBuilder brokerServiceUrl(String brokerServiceUrl) {
            this.brokerServiceUrl = brokerServiceUrl;
            return this;
        }

        public LocalRunnerBuilder clientAuthPlugin(String clientAuthPlugin) {
            this.clientAuthPlugin = clientAuthPlugin;
            return this;
        }

        public LocalRunnerBuilder clientAuthParams(String clientAuthParams) {
            this.clientAuthParams = clientAuthParams;
            return this;
        }

        public LocalRunnerBuilder useTls(boolean useTls) {
            this.useTls = useTls;
            return this;
        }

        public LocalRunnerBuilder tlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
            this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
            return this;
        }

        public LocalRunnerBuilder tlsHostNameVerificationEnabled(boolean tlsHostNameVerificationEnabled) {
            this.tlsHostNameVerificationEnabled = tlsHostNameVerificationEnabled;
            return this;
        }

        public LocalRunnerBuilder tlsTrustCertFilePath(String tlsTrustCertFilePath) {
            this.tlsTrustCertFilePath = tlsTrustCertFilePath;
            return this;
        }

        public LocalRunnerBuilder instanceIdOffset(int instanceIdOffset) {
            this.instanceIdOffset = instanceIdOffset;
            return this;
        }

        public LocalRunnerBuilder runtimeEnv(RuntimeEnv runtimeEnv) {
            this.runtimeEnv = runtimeEnv;
            return this;
        }

        public LocalRunnerBuilder secretsProviderClassName(String secretsProviderClassName) {
            this.secretsProviderClassName = secretsProviderClassName;
            return this;
        }

        public LocalRunnerBuilder secretsProviderConfig(String secretsProviderConfig) {
            this.secretsProviderConfig = secretsProviderConfig;
            return this;
        }

        public LocalRunnerBuilder narExtractionDirectory(String narExtractionDirectory) {
            this.narExtractionDirectory = narExtractionDirectory;
            return this;
        }

        public LocalRunnerBuilder connectorsDirectory(String connectorsDirectory) {
            this.connectorsDirectory = connectorsDirectory;
            return this;
        }

        public LocalRunnerBuilder functionsDirectory(String functionsDirectory) {
            this.functionsDirectory = functionsDirectory;
            return this;
        }

        public LocalRunnerBuilder metricsPortStart(Integer metricsPortStart) {
            this.metricsPortStart = metricsPortStart;
            return this;
        }

        public LocalRunnerBuilder exitOnError(boolean exitOnError) {
            this.exitOnError = exitOnError;
            return this;
        }

        public LocalRunner build() {
            return new LocalRunner(this.functionConfig, this.sourceConfig, this.sinkConfig, this.stateStorageImplClass, this.stateStorageServiceUrl, this.brokerServiceUrl, this.clientAuthPlugin, this.clientAuthParams, this.useTls, this.tlsAllowInsecureConnection, this.tlsHostNameVerificationEnabled, this.tlsTrustCertFilePath, this.instanceIdOffset, this.runtimeEnv, this.secretsProviderClassName, this.secretsProviderConfig, this.narExtractionDirectory, this.connectorsDirectory, this.functionsDirectory, this.metricsPortStart, this.exitOnError);
        }

        public String toString() {
            return "LocalRunner.LocalRunnerBuilder(functionConfig=" + String.valueOf(this.functionConfig) + ", sourceConfig=" + String.valueOf(this.sourceConfig) + ", sinkConfig=" + String.valueOf(this.sinkConfig) + ", stateStorageImplClass=" + this.stateStorageImplClass + ", stateStorageServiceUrl=" + this.stateStorageServiceUrl + ", brokerServiceUrl=" + this.brokerServiceUrl + ", clientAuthPlugin=" + this.clientAuthPlugin + ", clientAuthParams=" + this.clientAuthParams + ", useTls=" + this.useTls + ", tlsAllowInsecureConnection=" + this.tlsAllowInsecureConnection + ", tlsHostNameVerificationEnabled=" + this.tlsHostNameVerificationEnabled + ", tlsTrustCertFilePath=" + this.tlsTrustCertFilePath + ", instanceIdOffset=" + this.instanceIdOffset + ", runtimeEnv=" + String.valueOf((Object)this.runtimeEnv) + ", secretsProviderClassName=" + this.secretsProviderClassName + ", secretsProviderConfig=" + this.secretsProviderConfig + ", narExtractionDirectory=" + this.narExtractionDirectory + ", connectorsDirectory=" + this.connectorsDirectory + ", functionsDirectory=" + this.functionsDirectory + ", metricsPortStart=" + this.metricsPortStart + ", exitOnError=" + this.exitOnError + ")";
        }
    }

    public static enum RuntimeEnv {
        THREAD,
        PROCESS;

    }

    private static final class UserCodeClassLoader {
        private final ClassLoader classLoader;
        private final boolean classLoaderCreated;

        public UserCodeClassLoader(ClassLoader classLoader, boolean classLoaderCreated) {
            this.classLoader = classLoader;
            this.classLoaderCreated = classLoaderCreated;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public boolean isClassLoaderCreated() {
            return this.classLoaderCreated;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserCodeClassLoader)) {
                return false;
            }
            UserCodeClassLoader other = (UserCodeClassLoader)o;
            if (this.isClassLoaderCreated() != other.isClassLoaderCreated()) {
                return false;
            }
            ClassLoader this$classLoader = this.getClassLoader();
            ClassLoader other$classLoader = other.getClassLoader();
            return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isClassLoaderCreated() ? 79 : 97);
            ClassLoader $classLoader = this.getClassLoader();
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            return result;
        }

        public String toString() {
            return "LocalRunner.UserCodeClassLoader(classLoader=" + String.valueOf(this.getClassLoader()) + ", classLoaderCreated=" + this.isClassLoaderCreated() + ")";
        }
    }

    public static class RuntimeConverter
    implements CommandLine.ITypeConverter<RuntimeEnv> {
        public RuntimeEnv convert(String value) {
            return RuntimeEnv.valueOf(value);
        }
    }

    public static class SinkConfigConverter
    implements CommandLine.ITypeConverter<SinkConfig> {
        public SinkConfig convert(String value) {
            try {
                return (SinkConfig)ObjectMapperFactory.getMapper().reader().readValue(value, SinkConfig.class);
            }
            catch (IOException e) {
                throw new CommandLine.TypeConversionException(e.getMessage());
            }
        }
    }

    public static class SourceConfigConverter
    implements CommandLine.ITypeConverter<SourceConfig> {
        public SourceConfig convert(String value) {
            try {
                return (SourceConfig)ObjectMapperFactory.getMapper().reader().readValue(value, SourceConfig.class);
            }
            catch (IOException e) {
                throw new CommandLine.TypeConversionException(e.getMessage());
            }
        }
    }

    public static class FunctionConfigConverter
    implements CommandLine.ITypeConverter<FunctionConfig> {
        public FunctionConfig convert(String value) {
            try {
                return (FunctionConfig)ObjectMapperFactory.getMapper().reader().readValue(value, FunctionConfig.class);
            }
            catch (IOException e) {
                throw new CommandLine.TypeConversionException(e.getMessage());
            }
        }
    }
}

