/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.authentication;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.naming.AuthenticationException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaslRoleTokenSigner {
    private static final Logger log = LoggerFactory.getLogger(SaslRoleTokenSigner.class);
    private static final String SIGNATURE = "&s=";
    private byte[] secret;

    public SaslRoleTokenSigner(byte[] secret) {
        if (secret == null) {
            throw new IllegalArgumentException("secret cannot be NULL");
        }
        this.secret = (byte[])secret.clone();
    }

    public String sign(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("NULL or empty string to sign");
        }
        String signature = this.computeSignature(str);
        return str + SIGNATURE + signature;
    }

    public String verifyAndExtract(String signedStr) throws AuthenticationException {
        int index = signedStr.lastIndexOf(SIGNATURE);
        if (index == -1) {
            throw new AuthenticationException("Invalid signed text: " + signedStr);
        }
        String originalSignature = signedStr.substring(index + SIGNATURE.length());
        String rawValue = signedStr.substring(0, index);
        String currentSignature = this.computeSignature(rawValue);
        if (!MessageDigest.isEqual(originalSignature.getBytes(), currentSignature.getBytes())) {
            throw new AuthenticationException("Invalid signature");
        }
        return rawValue;
    }

    protected String computeSignature(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-512");
            md.update(str.getBytes());
            md.update(this.secret);
            byte[] digest = md.digest();
            return new Base64(0).encodeToString(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException("It should not happen, " + ex.getMessage(), ex);
        }
    }
}

