/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetrics;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.semconv.ResourceAttributes;
import java.io.Closeable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.opentelemetry.OpenTelemetryAttributes;

public class OpenTelemetryService
implements Closeable {
    public static final String OTEL_SDK_DISABLED_KEY = "otel.sdk.disabled";
    static final int MAX_CARDINALITY_LIMIT = 10000;
    private final AtomicReference<OpenTelemetrySdk> openTelemetrySdkReference = new AtomicReference();
    private final AtomicReference<RuntimeMetrics> runtimeMetricsReference = new AtomicReference();

    public OpenTelemetryService(String clusterName, String serviceName, String serviceVersion, @VisibleForTesting Consumer<AutoConfiguredOpenTelemetrySdkBuilder> builderCustomizer) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)clusterName), (Object)"Cluster name cannot be empty");
        AutoConfiguredOpenTelemetrySdkBuilder sdkBuilder = AutoConfiguredOpenTelemetrySdk.builder();
        sdkBuilder.addPropertiesSupplier(() -> Map.of(OTEL_SDK_DISABLED_KEY, "true", "otel.experimental.metrics.cardinality.limit", Integer.toString(10001)));
        sdkBuilder.addResourceCustomizer((resource, __) -> {
            ResourceBuilder resourceBuilder = Resource.builder();
            if (resource.getAttribute(OpenTelemetryAttributes.PULSAR_CLUSTER) == null) {
                resourceBuilder.put(OpenTelemetryAttributes.PULSAR_CLUSTER, (Object)clusterName);
            }
            if (StringUtils.isNotBlank((CharSequence)serviceName) && Objects.equals(Resource.getDefault().getAttribute(ResourceAttributes.SERVICE_NAME), resource.getAttribute(ResourceAttributes.SERVICE_NAME))) {
                resourceBuilder.put(ResourceAttributes.SERVICE_NAME, (Object)serviceName);
            }
            if (StringUtils.isNotBlank((CharSequence)serviceVersion) && resource.getAttribute(ResourceAttributes.SERVICE_VERSION) == null) {
                resourceBuilder.put(ResourceAttributes.SERVICE_VERSION, (Object)serviceVersion);
            }
            return resource.merge(resourceBuilder.build());
        });
        if (builderCustomizer != null) {
            builderCustomizer.accept(sdkBuilder);
        }
        this.openTelemetrySdkReference.set(sdkBuilder.build().getOpenTelemetrySdk());
        this.runtimeMetricsReference.set(RuntimeMetrics.builder((OpenTelemetry)((OpenTelemetry)this.openTelemetrySdkReference.get())).disableAllFeatures().enableExperimentalJmxTelemetry().build());
    }

    public OpenTelemetry getOpenTelemetry() {
        return (OpenTelemetry)this.openTelemetrySdkReference.get();
    }

    @Override
    public void close() {
        OpenTelemetrySdk openTelemetrySdk;
        RuntimeMetrics runtimeMetrics = this.runtimeMetricsReference.getAndSet(null);
        if (runtimeMetrics != null) {
            runtimeMetrics.close();
        }
        if ((openTelemetrySdk = (OpenTelemetrySdk)this.openTelemetrySdkReference.getAndSet(null)) != null) {
            openTelemetrySdk.close();
        }
    }

    public static OpenTelemetryServiceBuilder builder() {
        return new OpenTelemetryServiceBuilder();
    }

    public static class OpenTelemetryServiceBuilder {
        private String clusterName;
        private String serviceName;
        private String serviceVersion;
        private Consumer<AutoConfiguredOpenTelemetrySdkBuilder> builderCustomizer;

        OpenTelemetryServiceBuilder() {
        }

        public OpenTelemetryServiceBuilder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public OpenTelemetryServiceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public OpenTelemetryServiceBuilder serviceVersion(String serviceVersion) {
            this.serviceVersion = serviceVersion;
            return this;
        }

        public OpenTelemetryServiceBuilder builderCustomizer(Consumer<AutoConfiguredOpenTelemetrySdkBuilder> builderCustomizer) {
            this.builderCustomizer = builderCustomizer;
            return this;
        }

        public OpenTelemetryService build() {
            return new OpenTelemetryService(this.clusterName, this.serviceName, this.serviceVersion, this.builderCustomizer);
        }

        public String toString() {
            return "OpenTelemetryService.OpenTelemetryServiceBuilder(clusterName=" + this.clusterName + ", serviceName=" + this.serviceName + ", serviceVersion=" + this.serviceVersion + ", builderCustomizer=" + String.valueOf(this.builderCustomizer) + ")";
        }
    }
}

